/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.chart.box;

import com.scudata.ide.spl.chart.box.FontStyleDialog;
import com.scudata.ide.spl.chart.box.FontStyleIcon;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class FontStyleEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -7339854682489514547L;
    protected Object editingVal = null;
    private FontStyleDialog dialog;
    private JButton button = new JButton();
    private FontStyleIcon icon = new FontStyleIcon();

    public FontStyleEditor(Dialog owner) {
        super(new JCheckBox());
        this.button.setIcon(this.icon);
        this.button.setHorizontalAlignment(0);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontStyleEditor.this.clicked();
            }
        });
        this.dialog = new FontStyleDialog(owner);
    }

    protected void clicked() {
        int style = (Integer)this.editingVal;
        this.dialog.setFontStyle(style);
        Point p = this.button.getLocationOnScreen();
        this.dialog.setLocation(p.x, p.y + this.button.getHeight());
        this.dialog.setVisible(true);
        if (this.dialog.getOption() == 0) {
            this.editingVal = new Integer(this.dialog.getFontStyle());
            this.icon.setFontStyle(this.dialog.getFontStyle());
            this.stopCellEditing();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingVal = value;
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        this.icon.setFontStyle((Integer)value);
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editingVal;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

