/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.CellLocation;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.ToolBarPropertyBase;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CellEditingListener
implements KeyListener {
    protected SplControl control;
    protected ContentPanel cp;
    protected boolean isCtrlDown = false;

    public CellEditingListener(SplControl control, ContentPanel panel) {
        this.control = control;
        this.cp = panel;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.isCtrlDown = false;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        boolean isMatching = this.isMatching();
        switch (key) {
            case 10: {
                if (!GV.isCellEditing) {
                    this.stopMatch();
                    return;
                }
                if (e.isAltDown()) {
                    this.stopMatch();
                    if (GVSpl.appSheet == null || !(GVSpl.appSheet instanceof SheetSpl)) break;
                    ((SheetSpl)GVSpl.appSheet).calcActiveCell(false);
                    break;
                }
                if (e.isControlDown()) {
                    this.stopMatch();
                    JTextComponent ta = this.getSource(e);
                    int c = ta.getCaretPosition();
                    try {
                        String head = ta.getText(0, c);
                        String end = ta.getText(c, ta.getText().length() - c);
                        this.cp.setEditorText(String.valueOf(head) + "\n" + end);
                        ta.requestFocus();
                        ta.setCaretPosition(c + 1);
                    }
                    catch (BadLocationException head) {
                    }
                    catch (IllegalArgumentException head) {}
                    break;
                }
                if (e.isShiftDown()) {
                    this.stopMatch();
                    if (GVSpl.appSheet == null || !(GVSpl.appSheet instanceof SheetSpl)) break;
                    ((SheetSpl)GVSpl.appSheet).calcActiveCell();
                    break;
                }
                if (isMatching) {
                    this.keyPressed(key);
                    break;
                }
                CellSetParser parser = new CellSetParser(this.control.cellSet);
                int nextCol = -1;
                CellLocation cl = this.control.getActiveCell();
                if (cl == null) {
                    return;
                }
                int curRow = cl.getRow();
                int curCol = cl.getCol();
                int c = curCol + 1;
                while (c <= this.control.cellSet.getColCount()) {
                    PgmNormalCell cell;
                    if (parser.isColVisible(c) && !this.isSkipCell(cell = this.control.cellSet.getPgmNormalCell(curRow, c), parser, curRow, c)) {
                        nextCol = c;
                        break;
                    }
                    ++c;
                }
                if (nextCol > 0) {
                    this.control.getContentPanel().submitEditor();
                    this.control.getContentPanel().revalidate();
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(curRow, nextCol), true));
                } else {
                    PgmCellSet ics;
                    if (this.control.getActiveCell() != null && curRow == (ics = this.control.getCellSet()).getRowCount()) {
                        this.control.getContentPanel().submitEditor();
                        this.control.getContentPanel().revalidate();
                        this.appendOneRow();
                    }
                    this.control.scrollToArea(this.control.toDownCell());
                }
                if (GVSpl.panelValue == null) break;
                GVSpl.panelValue.tableValue.setLocked(false);
                break;
            }
            case 27: {
                if (this.control.getActiveCell() == null) break;
                if (isMatching) {
                    this.stopMatch();
                    e.consume();
                    break;
                }
                JTextComponent ta = this.getSource(e);
                NormalCell nc = (NormalCell)this.control.getCellSet().getCell(this.control.getActiveCell().getRow(), this.control.getActiveCell().getCol());
                String value = nc.getExpString();
                value = value == null ? GCSpl.NULL : value;
                ta.setText(value);
                this.control.getContentPanel().reloadEditorText();
                this.control.fireEditorInputing(value);
                this.cp.requestFocus();
                break;
            }
            case 9: {
                PgmCellSet ics;
                int curCol;
                if (e.isShiftDown()) {
                    if (isMatching) {
                        this.stopMatch();
                    }
                    this.control.scrollToArea(this.control.toLeftCell());
                    break;
                }
                if (e.isControlDown()) {
                    if (isMatching) {
                        this.stopMatch();
                    }
                    if (GVSpl.appFrame != null && GVSpl.appFrame instanceof IDEBase) {
                        this.showNextSheet();
                    }
                    this.isCtrlDown = true;
                    break;
                }
                if (isMatching) break;
                if (this.control.getActiveCell() != null) {
                    this.control.getContentPanel().submitEditor();
                }
                if ((curCol = this.control.getActiveCell().getCol()) == (ics = this.control.getCellSet()).getColCount()) {
                    this.control.getContentPanel().submitEditor();
                    this.appendOneCol();
                }
                this.control.scrollToArea(this.control.toRightCell());
                break;
            }
            case 39: {
                JTextComponent tar = this.getSource(e);
                if (tar.getText() == null || tar.getText().equals("")) {
                    this.control.scrollToArea(this.control.toRightCell());
                    break;
                }
                return;
            }
            case 37: {
                JTextComponent tal = this.getSource(e);
                if (tal.getText() == null || tal.getText().equals("")) {
                    this.control.scrollToArea(this.control.toLeftCell());
                    break;
                }
                return;
            }
            case 38: {
                if (isMatching) {
                    this.keyPressed(key);
                    break;
                }
                if (e.isAltDown()) {
                    if (e.getSource() == GV.toolBarProperty.getWindowEditor()) {
                        e.consume();
                    }
                    return;
                }
                JTextComponent tau = this.getSource(e);
                if (tau.getText() == null || tau.getText().equals("")) {
                    this.control.scrollToArea(this.control.toUpCell());
                    break;
                }
                return;
            }
            case 40: {
                if (isMatching) {
                    this.keyPressed(key);
                    break;
                }
                if (e.isAltDown()) {
                    if (e.getSource() == GV.toolBarProperty.getWindowEditor()) {
                        e.consume();
                    }
                    return;
                }
                JTextComponent tad = this.getSource(e);
                if (tad.getText() == null || tad.getText().equals("")) {
                    this.control.scrollToArea(this.control.toDownCell());
                    break;
                }
                return;
            }
            case 113: {
                if (this.control.getActiveCell() == null) break;
                if (isMatching) {
                    this.stopMatch();
                }
                if (GVSpl.toolBarProperty == null) break;
                GVSpl.toolBarProperty.getWindowEditor().requestFocus();
                break;
            }
            case 47: {
                JTextComponent ta;
                String exp;
                if (!e.isControlDown()) break;
                if (isMatching) {
                    this.stopMatch();
                }
                exp = (exp = (ta = this.getSource(e)).getText()) != null && exp.startsWith("//") ? (exp.length() > 3 ? (exp.charAt(2) == '*' ? "/" + exp : exp.substring(2)) : exp.substring(2)) : "/" + exp;
                ta.setText(exp);
                GVSpl.toolBarProperty.setTextEditorText(exp);
                e.consume();
                break;
            }
            case 90: {
                if (!e.isControlDown() || this.control.getActiveCell() == null) break;
                if (isMatching) {
                    this.stopMatch();
                }
                this.control.getContentPanel().undoEditor();
                break;
            }
            default: {
                SplEditor editor = ControlUtils.extractSplEditor(this.control);
                if (e.getKeyCode() == 67 && e.isAltDown() && !e.isControlDown()) {
                    if (e.isShiftDown()) {
                        if (editor != null && editor.canCopyPresent()) {
                            editor.copyPresent();
                            break;
                        }
                    } else {
                        if (editor == null) break;
                        editor.altC();
                        break;
                    }
                }
                if (e.getKeyCode() == 86 && e.isAltDown() && !e.isControlDown() && !e.isShiftDown()) {
                    if (!GM.canPaste() || editor == null) break;
                    editor.altV();
                    break;
                }
                return;
            }
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected boolean isSkipCell(PgmNormalCell cell, CellSetParser parser, int curRow, int c) {
        return cell.isNoteBlock() || cell.isNoteCell() || !StringUtils.isValidString(parser.getDispText(curRow, c));
    }

    protected void showNextSheet() {
        GVSpl.appFrame.showNextSheet(this.isCtrlDown);
    }

    protected JTextComponent getSource(KeyEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            return (JTextComponent)src;
        }
        if (src instanceof ToolBarPropertyBase) {
            return ((ToolBarPropertyBase)src).getWindowEditor();
        }
        return null;
    }

    protected boolean isMatching() {
        return false;
    }

    protected void keyPressed(int keyCode) {
    }

    protected void stopMatch() {
    }

    protected void appendOneRow() {
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        if (editor != null) {
            editor.appendRows(1);
        }
    }

    protected void appendOneCol() {
        SplEditor editor = ControlUtils.extractSplEditor(this.control);
        if (editor != null) {
            editor.appendCols(1);
        }
    }
}

