/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.IColCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ColHeaderListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    private SplControl control;
    private int startSelectedCol;
    private int resizeStartX;
    private int resizeStartCol;
    private float oldCellWidth;
    private int tmpWidth;
    private boolean editable = true;
    private transient CellLocation activeCell = null;
    protected boolean supportMultiSelect = true;

    public ColHeaderListener(SplControl control) {
        this(control, true);
    }

    public ColHeaderListener(SplControl control, boolean editable) {
        this.control = control;
        this.editable = editable;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        this.control.getColumnHeader().getView().requestFocus();
        int col = ControlUtils.lookupHeaderIndex(e.getX(), this.control.cellX, this.control.cellW);
        if (col < 0) {
            return;
        }
        boolean colIsSelected = false;
        if (this.control.m_selectedCols.size() > 0) {
            int i = 0;
            while (i < this.control.m_selectedCols.size()) {
                Integer c = this.control.m_selectedCols.get(i);
                if (c == col) {
                    colIsSelected = true;
                    break;
                }
                ++i;
            }
        }
        if (e.getButton() == 1 || !colIsSelected) {
            if (this.control.status != 4 || e.getButton() != 1) {
                this.resizeStartCol = 0;
                if (!e.isControlDown() || !this.supportMultiSelect) {
                    this.control.clearSelectedArea();
                    this.control.m_selectedCols.clear();
                }
                this.control.m_selectedRows.clear();
                int firstRow = this.control.getContentPanel().drawStartRow;
                if (firstRow < 1 || firstRow > this.control.cellSet.getRowCount()) {
                    firstRow = 1;
                }
                this.control.setActiveCell(new CellLocation(firstRow, col), false);
                this.control.m_cornerSelected = false;
                if (e.isShiftDown() && this.startSelectedCol > 0) {
                    this.control.m_selectedCols.clear();
                    int start = col < this.startSelectedCol ? col : this.startSelectedCol;
                    int end = col < this.startSelectedCol ? this.startSelectedCol : col;
                    int i = start;
                    while (i <= end) {
                        this.control.addSelectedCol(new Integer(i));
                        ++i;
                    }
                    this.control.addSelectedArea(new Area(1, start, this.control.cellSet.getRowCount(), end), true);
                } else {
                    this.startSelectedCol = col;
                    this.control.addSelectedCol(new Integer(col));
                    this.control.addSelectedArea(new Area(1, col, this.control.cellSet.getRowCount(), col), false);
                }
                this.control.repaint();
                this.control.fireRegionSelect(true);
            } else if (e.getButton() == 1) {
                this.control.getContentPanel().submitEditor();
                this.resizeStartX = e.getX();
                this.resizeStartCol = ControlUtils.lookupHeaderIndex(this.resizeStartX, this.control.cellX, this.control.cellW);
                this.oldCellWidth = (float)this.control.cellW[col] / this.control.scale;
                this.tmpWidth = this.control.cellW[col];
            }
        }
        this.showPopup(e);
        this.activeCell = this.control.getActiveCell();
        this.control.setActiveCell(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (this.activeCell != null && this.activeCell.getCol() == col) {
            this.control.setActiveCell(this.activeCell, false);
        }
        if (this.control.status == 4) {
            if (this.resizeStartCol > 0) {
                IColCell cc;
                if (col != this.resizeStartCol) {
                    col = this.resizeStartCol;
                }
                Vector<Integer> willResizeCols = new Vector<Integer>();
                willResizeCols.add(new Integer(col));
                if (this.control.m_selectedCols.size() > 0) {
                    int c1 = this.control.m_selectedCols.get(0);
                    int c2 = this.control.m_selectedCols.get(this.control.m_selectedCols.size() - 1);
                    int selectedStartCol = Math.min(c1, c2);
                    int selectedEndCol = Math.max(c1, c2);
                    if (col >= selectedStartCol && col <= selectedEndCol) {
                        willResizeCols = this.control.m_selectedCols;
                    }
                }
                if ((cc = this.control.cellSet.getColCell(col)) != null) {
                    cc.setWidth(this.oldCellWidth);
                    this.resizeColWidth(willResizeCols, (float)this.tmpWidth / this.control.scale);
                }
            }
        } else {
            this.control.fireRegionSelect(true);
            this.control.status = 0;
        }
        final MouseEvent me = e;
        Thread t = new Thread(){

            @Override
            public void run() {
                ColHeaderListener.this.showPopup(me);
            }
        };
        SwingUtilities.invokeLater(t);
    }

    protected void resizeColWidth(Vector<Integer> willResizeCols, float newWidth) {
        this.control.fireColHeaderResized(willResizeCols, newWidth);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            int col;
            int x = e.getX();
            if (x >= this.control.cellX[col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW)] + this.control.cellW[col] - 2 && x <= this.control.cellX[col] + this.control.cellW[col]) {
                Vector<Integer> cols = new Vector<Integer>();
                cols.add(new Integer(col));
                SplEditor editor = ControlUtils.extractSplEditor(this.control);
                if (editor != null) {
                    editor.selectedCols = cols;
                    editor.adjustColWidth();
                }
            } else {
                this.mouseDoubleClicked(e, col);
            }
        }
    }

    public void mouseDoubleClicked(MouseEvent e, int col) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (this.control.status == 0) {
            int end;
            if (col < 0) {
                return;
            }
            int start = this.startSelectedCol < col ? this.startSelectedCol : col;
            int n = end = this.startSelectedCol > col ? this.startSelectedCol : col;
            if (start <= 0) {
                return;
            }
            this.control.m_selectedCols.clear();
            int i = start;
            while (i <= end) {
                this.control.addSelectedCol(new Integer(i));
                ++i;
            }
            this.control.addSelectedArea(new Area(1, start, this.control.cellSet.getRowCount(), end), true);
            if (ControlUtils.scrollToVisible(this.control.getColumnHeader(), this.control, 0, col)) {
                Point p1 = this.control.getColumnHeader().getViewPosition();
                Point p2 = this.control.getViewport().getViewPosition();
                p2.x = p1.x;
                this.control.getViewport().setViewPosition(p2);
            }
            this.control.repaint();
            this.control.fireRegionSelect(true);
        }
        if (this.control.status == 4 && this.resizeStartCol > 0) {
            if (col != this.resizeStartCol) {
                col = this.resizeStartCol;
            }
            this.tmpWidth = this.tmpWidth + x - this.resizeStartX;
            this.resizeStartX = x;
            if (this.tmpWidth < 1) {
                this.tmpWidth = 1;
            }
            float newWidth = (float)this.tmpWidth / this.control.scale;
            IColCell cc = this.control.cellSet.getColCell(col);
            if (cc != null) {
                cc.setWidth(newWidth);
            }
            this.control.getColumnHeader().getView().repaint();
            this.control.getViewport().getView().repaint();
            ControlUtilsBase.clearWrapBuffer();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        int x = e.getX();
        int col = ControlUtils.lookupHeaderIndex(x, this.control.cellX, this.control.cellW);
        if (col < 0) {
            this.control.status = 0;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (x >= this.control.cellX[col] + this.control.cellW[col] - 2 && x <= this.control.cellX[col] + this.control.cellW[col]) {
            this.control.status = 4;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.control.status = 0;
            this.control.getColumnHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 4);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        int key = e.getKeyCode();
        switch (key) {
            case 39: {
                if (!e.isShiftDown()) {
                    this.control.toRightCell();
                    e.consume();
                    return;
                }
                int start = this.control.m_selectedCols.get(0);
                int end = this.control.m_selectedCols.get(this.control.m_selectedCols.size() - 1);
                if (this.startSelectedCol == start) {
                    ++end;
                } else {
                    ++start;
                }
                if (end > this.control.cellSet.getColCount()) {
                    end = this.control.cellSet.getColCount();
                }
                if (start < 1) {
                    start = 1;
                }
                this.control.m_selectedRows.clear();
                this.control.m_cornerSelected = false;
                this.control.m_selectedCols.clear();
                int i = start;
                while (i <= end) {
                    this.control.addSelectedCol(new Integer(i));
                    ++i;
                }
                this.control.addSelectedArea(new Area(1, start, this.control.cellSet.getRowCount(), end), true);
                if (ControlUtils.scrollToVisible(this.control.getColumnHeader(), this.control, 0, end)) {
                    Point p1 = this.control.getColumnHeader().getViewPosition();
                    Point p2 = this.control.getViewport().getViewPosition();
                    p2.x = p1.x;
                    this.control.getViewport().setViewPosition(p2);
                }
                this.control.repaint();
                this.control.fireRegionSelect(true);
                e.consume();
                break;
            }
            case 37: {
                if (!e.isShiftDown()) {
                    this.control.toLeftCell();
                    e.consume();
                    return;
                }
                int start = this.control.m_selectedCols.get(0);
                int end = this.control.m_selectedCols.get(this.control.m_selectedCols.size() - 1);
                if (this.startSelectedCol == end) {
                    --start;
                } else {
                    --end;
                }
                if (end > this.control.cellSet.getColCount()) {
                    end = this.control.cellSet.getColCount();
                }
                if (start < 1) {
                    start = 1;
                }
                this.control.m_selectedRows.clear();
                this.control.m_cornerSelected = false;
                this.control.m_selectedCols.clear();
                int i = start;
                while (i <= end) {
                    this.control.addSelectedCol(new Integer(i));
                    ++i;
                }
                this.control.addSelectedArea(new Area(1, start, this.control.cellSet.getRowCount(), end), true);
                if (ControlUtils.scrollToVisible(this.control.getColumnHeader(), this.control, 0, start)) {
                    Point p1 = this.control.getColumnHeader().getViewPosition();
                    Point p2 = this.control.getViewport().getViewPosition();
                    p2.x = p1.x;
                    this.control.getViewport().setViewPosition(p2);
                }
                this.control.repaint();
                e.consume();
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

