/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.common.StringUtils;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JPanel;

public class ColHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected SplControl control;
    protected boolean editable = true;
    protected CellSetParser parser;

    public ColHeaderPanel(SplControl control) {
        this(control, true);
    }

    public ColHeaderPanel(SplControl control, boolean editable) {
        this.control = control;
        this.editable = editable;
        this.parser = new CellSetParser(control.cellSet);
        this.initCoords();
        int h = (int)(20.0f * control.scale);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), h + 1));
    }

    protected void initCoords() {
        int cols = this.control.cellSet.getColCount() + 1;
        if (this.control.cellX == null || cols != this.control.cellX.length) {
            this.control.cellX = new int[cols];
            this.control.cellW = new int[cols];
        }
        int i = 1;
        while (i < cols) {
            this.control.cellX[i] = i == 1 ? 1 : this.control.cellX[i - 1] + this.control.cellW[i - 1];
            this.control.cellW[i] = !this.parser.isColVisible(i) ? 0 : this.parser.getColWidth(i, this.control.scale);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        ControlUtils.setGraphicsRenderingHints(g);
        int h = (int)(20.0f * this.control.scale);
        g.clearRect(0, 0, 999999, h + 1);
        int cols = this.control.cellSet.getColCount() + 1;
        if (cols != this.control.cellX.length) {
            this.control.cellX = new int[cols];
            this.control.cellW = new int[cols];
        }
        Rectangle r = this.control.getViewport().getViewRect();
        HashSet<Integer> selectedCols = ControlUtils.listSelectedCols(this.control.getSelectedAreas());
        int i = 1;
        while (i < cols) {
            this.control.cellX[i] = i == 1 ? 1 : this.control.cellX[i - 1] + this.control.cellW[i - 1];
            this.control.cellW[i] = !this.parser.isColVisible(i) ? 0 : this.parser.getColWidth(i, this.control.scale);
            if (this.control.cellX[i] + this.control.cellW[i] > r.x) {
                if (this.control.cellX[i] >= r.x + r.width) break;
                Color bkColor = Color.lightGray;
                String label = this.getColLabel(i);
                byte flag = 0;
                if (selectedCols.contains(new Integer(i))) {
                    flag = 1;
                }
                int k = 0;
                while (k < this.control.m_selectedCols.size()) {
                    if (i == this.control.m_selectedCols.get(k)) {
                        flag = 4;
                        break;
                    }
                    ++k;
                }
                int x = this.control.cellX[i];
                int w = this.control.cellW[i];
                if (i > 1) {
                    ++x;
                    --w;
                }
                if (w > 0) {
                    ControlUtils.drawHeader(g, x, 0, w, h, label, this.control.scale, bkColor, flag, this.editable);
                }
            }
            ++i;
        }
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), h + 1));
        g.dispose();
    }

    protected String getColLabel(int col) {
        return StringUtils.toExcelLabel(col);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int col = 1;
        while (col <= this.control.cellSet.getColCount()) {
            if (this.parser.isColVisible(col)) {
                width += this.parser.getColWidth(col, this.control.scale);
            }
            ++col;
        }
        int h = (int)(20.0f * this.control.scale);
        return new Dimension(width + 2, h + 1);
    }
}

