/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.RowHeaderPanel;
import com.scudata.ide.spl.control.SplControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class CornerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SplControl control;
    private boolean editable = true;

    public CornerPanel(SplControl control) {
        this(control, true);
    }

    public CornerPanel(SplControl control, boolean editable) {
        this.control = control;
        this.editable = editable;
        int w = RowHeaderPanel.getW(control);
        int h = (int)(20.0f * control.scale);
        this.setPreferredSize(new Dimension(w + 1, h + 1));
    }

    @Override
    public void paint(Graphics g) {
        int w = RowHeaderPanel.getW(this.control);
        int h = (int)(20.0f * this.control.scale);
        g.clearRect(0, 0, w + 1, h + 1);
        Color c = Color.lightGray;
        if (this.control.m_cornerSelected) {
            c = new Color(153, 153, 102);
        }
        if (this.editable) {
            ControlUtils.gradientPaint(g, 0, 0, w, h, c);
        } else {
            g.clearRect(0, 0, w, h);
        }
        g.setColor(new Color(236, 236, 236));
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, 0, 0, h);
        g.setColor(Color.darkGray);
        g.drawLine(w, h, 0, h);
        g.drawLine(w, h, w, 0);
        g.dispose();
    }
}

