/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.CellSet;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.control.CellSelectListener;
import com.scudata.ide.spl.control.ColHeaderListener;
import com.scudata.ide.spl.control.ColHeaderPanel;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.CornerListener;
import com.scudata.ide.spl.control.CornerPanel;
import com.scudata.ide.spl.control.EditDropListener;
import com.scudata.ide.spl.control.RowHeaderListener;
import com.scudata.ide.spl.control.RowHeaderPanel;
import com.scudata.ide.spl.control.SplControl;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

public class EditControl
extends SplControl {
    private static final long serialVersionUID = 1L;
    private boolean editable = true;
    protected ContentPanel contentPanel;
    private ScaleListener mouseWheelListener = null;

    public EditControl(int rows, int cols) {
        super(rows, cols);
    }

    @Override
    JPanel createCorner() {
        CornerPanel panel = new CornerPanel(this, this.editable);
        CornerListener listener = new CornerListener(this, this.editable);
        panel.addMouseListener(listener);
        panel.addMouseWheelListener(this.getMouseWheelListener());
        return panel;
    }

    @Override
    JPanel createColHeaderView() {
        this.headerPanel = new ColHeaderPanel(this, this.editable);
        ColHeaderListener listener = new ColHeaderListener(this, this.editable);
        this.headerPanel.addMouseListener(listener);
        this.headerPanel.addMouseMotionListener(listener);
        this.headerPanel.addKeyListener(listener);
        this.headerPanel.addMouseWheelListener(this.getMouseWheelListener());
        return this.headerPanel;
    }

    @Override
    JPanel createRowHeaderView() {
        RowHeaderPanel panel = new RowHeaderPanel(this, this.editable);
        RowHeaderListener listener = new RowHeaderListener(this, this.editable);
        panel.addMouseListener(listener);
        panel.addMouseMotionListener(listener);
        panel.addKeyListener(listener);
        panel.addMouseWheelListener(this.getMouseWheelListener());
        return panel;
    }

    @Override
    ContentPanel createContentView() {
        this.contentPanel = this.newContentPanel(this.cellSet);
        CellSelectListener listener = new CellSelectListener(this, this.contentPanel, this.editable);
        this.contentPanel.addMouseListener(listener);
        this.contentPanel.addMouseMotionListener(listener);
        this.contentPanel.addKeyListener(listener);
        this.contentPanel.addMouseWheelListener(this.getMouseWheelListener());
        DropTarget target = new DropTarget(this.contentPanel, new EditDropListener());
        this.contentPanel.setDropTarget(target);
        this.contentPanel.setFocusTraversalKeysEnabled(false);
        return this.contentPanel;
    }

    protected synchronized ScaleListener getMouseWheelListener() {
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = new ScaleListener();
            this.mouseWheelListener.setMouseWheelListeners(this.getMouseWheelListeners());
        }
        return this.mouseWheelListener;
    }

    protected ContentPanel newContentPanel(CellSet cellSet) {
        return new ContentPanel(cellSet, 1, cellSet.getRowCount(), 1, cellSet.getColCount(), true, true, this);
    }

    public void acceptText() {
        this.contentView.submitEditor();
    }

    class ScaleListener
    implements MouseWheelListener {
        MouseWheelListener[] listeners;

        public void setMouseWheelListeners(MouseWheelListener[] listeners) {
            this.listeners = listeners;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int newPercent;
            if (!e.isControlDown()) {
                if (this.listeners != null) {
                    MouseWheelListener[] mouseWheelListenerArray = this.listeners;
                    int n = this.listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MouseWheelListener mwl = mouseWheelListenerArray[n2];
                        mwl.mouseWheelMoved(e);
                        ++n2;
                    }
                }
                return;
            }
            int percent = (int)(EditControl.this.scale * 100.0f);
            int wr = e.getWheelRotation();
            if (wr < 0) {
                newPercent = GCSpl.DEFAULT_SCALES[GCSpl.DEFAULT_SCALES.length - 1];
                int i = 0;
                while (i < GCSpl.DEFAULT_SCALES.length) {
                    if (percent < GCSpl.DEFAULT_SCALES[i] - 7) {
                        newPercent = GCSpl.DEFAULT_SCALES[i];
                        break;
                    }
                    ++i;
                }
            } else {
                newPercent = GCSpl.DEFAULT_SCALES[0];
                int i = GCSpl.DEFAULT_SCALES.length - 1;
                while (i >= 0) {
                    if (percent > GCSpl.DEFAULT_SCALES[i] + 7) {
                        newPercent = GCSpl.DEFAULT_SCALES[i];
                        break;
                    }
                    --i;
                }
            }
            if (newPercent != percent) {
                EditControl.this.setScale(new Float(newPercent).floatValue() / 100.0f);
                if (GVSpl.splEditor != null) {
                    GVSpl.splEditor.setDataChanged(true);
                }
            }
            e.consume();
        }
    }
}

