/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.control.TransferableObject;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class EditDropListener
implements DropTargetListener {
    private CellLocation oldPos = new CellLocation(0, 0);

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        ContentPanel cp = (ContentPanel)dtde.getDropTargetContext().getComponent();
        cp.submitEditor();
        cp.setEditorVisible(false);
        cp.getControl().setActiveCell(null);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        ContentPanel cp = (ContentPanel)dtde.getDropTargetContext().getComponent();
        cp.setEditorVisible(false);
        CellLocation pos = ControlUtils.lookupCellPosition(p.x, p.y, cp);
        if (pos == null) {
            return;
        }
        EditControl control = (EditControl)cp.getControl();
        int row = pos.getRow();
        int col = pos.getCol();
        if (row == this.oldPos.getRow() && col == this.oldPos.getCol()) {
            return;
        }
        this.oldPos = pos;
        control.setActiveCell(null);
        control.addSelectedArea(new Area(row, col, row, col), true);
        control.m_cornerSelected = false;
        control.m_selectedCols.clear();
        control.m_selectedRows.clear();
        control.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point p = dtde.getLocation();
        ContentPanel cp = (ContentPanel)dtde.getDropTargetContext().getComponent();
        CellLocation pos = ControlUtils.lookupCellPosition(p.x, p.y, cp);
        if (pos == null) {
            return;
        }
        EditControl control = (EditControl)cp.jsp;
        Object data = null;
        try {
            data = dtde.getTransferable().getTransferData(TransferableObject.objectFlavor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data == null) {
            return;
        }
        NormalCell nc = (NormalCell)control.getCellSet().getCell(pos.getRow(), pos.getCol());
        AtomicCell ac = new AtomicCell((SplControl)control, nc);
        if (StringUtils.isValidString(data) && ((String)data).startsWith("=")) {
            String exp = GM.getOptionTrimChar0String((String)data);
            ac.setProperty((byte)1);
            ac.setValue(exp);
        } else {
            ac.setProperty((byte)0);
            ac.setValue(GM.getOptionTrimChar0Value(data));
        }
        SplEditor editor = ControlUtils.extractSplEditor(control);
        if (editor != null) {
            editor.executeCmd(ac);
        }
        control.setActiveCell(pos);
        control.setSelectedArea(new Area(pos.getRow(), pos.getCol(), pos.getRow(), pos.getCol()));
        control.m_selectedCols.clear();
        control.m_selectedRows.clear();
        control.m_cornerSelected = false;
        control.fireRegionSelect(true);
        control.repaint();
        GMSpl.enableSave();
    }
}

