/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.CellLocation;
import com.scudata.dm.Context;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.common.swing.RSyntaxTextAreaEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.GVSplSE;
import com.scudata.ide.spl.ToolBarProperty;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.FuncListener;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.text.JTextComponent;

public class FuncListenerIDE
extends FuncListener {
    public FuncListenerIDE(JTextComponent jtext) {
        super(jtext);
        this.setHotKeyEnabled(false);
    }

    @Override
    public JTextComponent getJText() {
        if (GV.isCellEditing) {
            EditControl control;
            ContentPanel cp;
            if (GVSplSE.splEditor != null && (cp = (control = GVSplSE.splEditor.control).getContentPanel()).getEditor() instanceof JTextComponent) {
                JTextComponent jtext = (JTextComponent)cp.getEditor();
                return jtext;
            }
        } else if (GVSpl.toolBarProperty != null) {
            RSyntaxTextAreaEx jtext = GVSpl.toolBarProperty.getWindowEditor();
            return jtext;
        }
        return null;
    }

    @Override
    protected void updateToolBarText() {
        EditControl control;
        ContentPanel cp;
        if (GVSpl.toolBarProperty != null && GVSplSE.splEditor != null && (cp = (control = GVSplSE.splEditor.control).getContentPanel()).getEditor() instanceof JTextComponent) {
            JTextComponent jtext = (JTextComponent)cp.getEditor();
            String newText = jtext.getText();
            ((ToolBarProperty)GVSpl.toolBarProperty).setTextEditorText(newText, false);
        }
    }

    @Override
    protected boolean isFuncEnabled() {
        return ConfigOptions.bFuncNotice;
    }

    @Override
    public int[] getPosition(JTextComponent jtext, int w, int h) {
        int editorWidth;
        int p = jtext.getCaretPosition();
        int x = GM.getAbsolutePos(jtext, true);
        int y = GM.getAbsolutePos(jtext, false);
        FontMetrics fmText = jtext.getFontMetrics(jtext.getFont());
        String preStr = jtext.getText().substring(0, p);
        int dx = jtext.getVisibleRect().x;
        int dy = jtext.getVisibleRect().y;
        if (GV.isCellEditing) {
            EditControl control = GVSpl.splEditor.control;
            CellLocation activeCell = control.getActiveCell();
            int cellW = control.cellW[activeCell.getCol()];
            if (ConfigOptions.bDispOutCell.booleanValue()) {
                cellW = control.contentView.getPaintableWidth(activeCell.getRow(), activeCell.getCol(), control.scale);
            }
            editorWidth = cellW;
        } else {
            editorWidth = jtext.getWidth();
        }
        int rowHeight = fmText.getHeight();
        ArrayList<String> rows = ControlUtilsBase.wrapString(preStr, fmText, editorWidth);
        y += rows.size() * rowHeight;
        x += fmText.stringWidth(String.valueOf(rows.get(rows.size() - 1)) + ".");
        x -= dx;
        y -= dy;
        y += 2;
        Dimension d = GV.appFrame.getSize();
        int maxX = d.width;
        int maxY = d.height;
        if ((x += 2) + w > maxX) {
            x = x > w ? (x -= w) : maxX - w;
        }
        if (y + h > maxY) {
            y -= y + h - maxY + 15;
        }
        return new int[]{x, y};
    }

    @Override
    public String getCellText(JTextComponent jtext) {
        return jtext.getText();
    }

    @Override
    public PgmCellSet getCellSet() {
        EditControl control = GVSpl.splEditor.control;
        if (control == null) {
            return null;
        }
        return control.getCellSet();
    }

    @Override
    public int getCaretPosition(JTextComponent jtext) {
        return jtext.getCaretPosition();
    }

    @Override
    public Context getContext() {
        return null;
    }
}

