/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.IRowCell;
import com.scudata.common.Area;
import com.scudata.common.CellLocation;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.RowHeaderPanel;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class RowHeaderListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    private SplControl control;
    private int startSelectedRow;
    private int resizeStartY;
    private int resizeStartRow;
    private float oldCellHeight;
    private int tmpHeight;
    private boolean editable = true;
    private transient CellLocation activeCell = null;
    protected boolean supportMultiSelect = true;

    public RowHeaderListener(SplControl control) {
        this(control, true);
    }

    public RowHeaderListener(SplControl control, boolean editable) {
        this.control = control;
        this.editable = editable;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        this.control.getRowHeader().getView().requestFocus();
        int row = ControlUtils.lookupHeaderIndex(e.getY(), this.control.cellY, this.control.cellH);
        if (row < 0) {
            return;
        }
        boolean rowIsSelected = false;
        if (!this.control.m_selectedRows.isEmpty()) {
            int i = 0;
            while (i < this.control.m_selectedRows.size()) {
                Integer r = this.control.m_selectedRows.get(i);
                if (r == row) {
                    rowIsSelected = true;
                    break;
                }
                ++i;
            }
        }
        if (e.getButton() == 1 || !rowIsSelected) {
            if (this.control.status != 4 || e.getButton() != 1) {
                this.resizeStartRow = 0;
                if (!e.isControlDown() || !this.supportMultiSelect) {
                    this.control.clearSelectedArea();
                    this.control.m_selectedRows.clear();
                }
                this.control.m_selectedCols.clear();
                int firstCol = this.control.getContentPanel().drawStartCol;
                if (firstCol < 1 || firstCol > this.control.cellSet.getColCount()) {
                    firstCol = 1;
                }
                this.control.setActiveCell(new CellLocation(row, firstCol), false);
                this.control.m_cornerSelected = false;
                if (e.isShiftDown() && this.startSelectedRow > 0) {
                    this.control.m_selectedRows = new Vector();
                    int start = row < this.startSelectedRow ? row : this.startSelectedRow;
                    int end = row < this.startSelectedRow ? this.startSelectedRow : row;
                    int i = start;
                    while (i <= end) {
                        this.control.addSelectedRow(new Integer(i));
                        ++i;
                    }
                    this.control.addSelectedArea(new Area(start, 1, end, this.control.cellSet.getColCount()), false);
                } else {
                    this.startSelectedRow = row;
                    this.control.addSelectedRow(new Integer(row));
                    this.control.addSelectedArea(new Area(row, 1, row, this.control.cellSet.getColCount()), false);
                }
                this.control.repaint();
                this.control.fireRegionSelect(true);
            } else if (e.getButton() == 1) {
                this.control.getContentPanel().submitEditor();
                this.resizeStartY = e.getY();
                this.resizeStartRow = ControlUtils.lookupHeaderIndex(this.resizeStartY, this.control.cellY, this.control.cellH);
                this.oldCellHeight = (float)this.control.cellH[row] / this.control.scale;
                this.tmpHeight = this.control.cellH[row];
            }
        }
        this.showPopup(e);
        this.activeCell = this.control.getActiveCell();
        this.control.setActiveCell(null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.editable) {
            this.showPopup(e);
            return;
        }
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (this.activeCell != null && this.control.m_selectedRows != null && this.control.m_selectedRows.contains(this.activeCell.getRow())) {
            this.control.setActiveCell(this.activeCell, false);
        }
        if (this.control.status == 4) {
            if (this.resizeStartRow > 0) {
                IRowCell rc;
                if (row != this.resizeStartRow) {
                    row = this.resizeStartRow;
                }
                Vector<Integer> willResizeRows = new Vector<Integer>();
                willResizeRows.add(new Integer(row));
                if (!this.control.m_selectedRows.isEmpty()) {
                    int r1 = this.control.m_selectedRows.get(0);
                    int r2 = this.control.m_selectedRows.get(this.control.m_selectedRows.size() - 1);
                    int selectedStartRow = Math.min(r1, r2);
                    int selectedEndRow = Math.max(r1, r2);
                    if (row >= selectedStartRow && row <= selectedEndRow) {
                        willResizeRows = this.control.m_selectedRows;
                    }
                }
                if ((rc = this.control.cellSet.getRowCell(row)) != null) {
                    rc.setHeight(this.oldCellHeight);
                    this.control.fireRowHeaderResized(willResizeRows, (float)this.tmpHeight / this.control.scale);
                }
            }
        } else {
            SplEditor editor;
            if (e.getX() > RowHeaderPanel.getHeaderW(this.control) && e.getButton() == 1 && (editor = ControlUtils.extractSplEditor(this.control)) != null && editor.expandRow(row)) {
                this.control.contentView.initCellLocations();
                ((RowHeaderPanel)this.control.getRowHeaderPanel()).initRowLocations();
                Vector<Object> newAreas = new Vector<Object>();
                newAreas.add(new Area(row, 1, row, (short)this.control.cellSet.getColCount()));
                editor.setSelectedAreas(newAreas);
                editor.resetEditor();
                this.control.setActiveCell(new CellLocation(row, 1));
                this.control.getContentPanel().revalidate();
                this.control.getRowHeaderPanel().revalidate();
                this.control.getColHeaderPanel().revalidate();
                this.control.repaint();
                return;
            }
            this.control.fireRegionSelect(true);
            this.control.status = 0;
        }
        final MouseEvent me = e;
        Thread t = new Thread(){

            @Override
            public void run() {
                RowHeaderListener.this.showPopup(me);
            }
        };
        SwingUtilities.invokeLater(t);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            SplEditor editor;
            int y = e.getY();
            int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
            if (row < 1) {
                return;
            }
            if (y >= this.control.cellY[row] + this.control.cellH[row] - 2 && y <= this.control.cellY[row] + this.control.cellH[row] && (editor = ControlUtils.extractSplEditor(this.control)) != null) {
                Vector<Integer> rows = new Vector<Integer>();
                rows.add(new Integer(row));
                editor.selectedRows = rows;
                editor.adjustRowHeight();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (this.control.status == 0) {
            if (row < 0) {
                return;
            }
            int start = Math.min(this.startSelectedRow, row);
            int end = Math.max(this.startSelectedRow, row);
            if (start <= 0) {
                return;
            }
            this.control.m_selectedRows.clear();
            int i = start;
            while (i <= end) {
                this.control.addSelectedRow(new Integer(i));
                ++i;
            }
            this.control.addSelectedArea(new Area(start, 1, end, this.control.cellSet.getColCount()), true);
            if (ControlUtils.scrollToVisible(this.control.getRowHeader(), this.control, row, 0)) {
                Point p1 = this.control.getRowHeader().getViewPosition();
                Point p2 = this.control.getViewport().getViewPosition();
                p2.y = p1.y;
                this.control.getViewport().setViewPosition(p2);
            }
            this.control.repaint();
            this.control.fireRegionSelect(true);
        }
        if (this.control.status == 4 && this.resizeStartRow > 0) {
            if (row != this.resizeStartRow) {
                row = this.resizeStartRow;
            }
            this.tmpHeight = this.tmpHeight + y - this.resizeStartY;
            this.resizeStartY = y;
            if (this.tmpHeight < 1) {
                this.tmpHeight = 1;
            }
            float newHeight = (float)this.tmpHeight / this.control.scale;
            IRowCell rc = this.control.cellSet.getRowCell(row);
            if (rc != null) {
                rc.setHeight(newHeight);
            }
            this.control.getRowHeader().getView().repaint();
            this.control.getViewport().getView().repaint();
            ControlUtilsBase.clearWrapBuffer();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        int y = e.getY();
        int row = ControlUtils.lookupHeaderIndex(y, this.control.cellY, this.control.cellH);
        if (row < 0) {
            this.control.status = 0;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (y >= this.control.cellY[row] + this.control.cellH[row] - 2 && y <= this.control.cellY[row] + this.control.cellH[row]) {
            this.control.status = 4;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.control.status = 0;
            this.control.getRowHeader().getView().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.control.fireRightClicked(e, 3);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        int key = e.getKeyCode();
        switch (key) {
            case 40: {
                if (!e.isShiftDown()) {
                    this.control.toDownCell();
                    e.consume();
                    return;
                }
                int start = this.control.m_selectedRows.get(0);
                int end = this.control.m_selectedRows.get(this.control.m_selectedRows.size() - 1);
                if (this.startSelectedRow == start) {
                    ++end;
                } else {
                    ++start;
                }
                if (end > this.control.cellSet.getRowCount()) {
                    end = this.control.cellSet.getRowCount();
                }
                if (start < 1) {
                    start = 1;
                }
                this.control.m_selectedCols.clear();
                this.control.m_cornerSelected = false;
                this.control.m_selectedRows.clear();
                int i = start;
                while (i <= end) {
                    this.control.addSelectedRow(new Integer(i));
                    ++i;
                }
                this.control.addSelectedArea(new Area(start, 1, end, this.control.cellSet.getColCount()), true);
                if (ControlUtils.scrollToVisible(this.control.getRowHeader(), this.control, end, 0)) {
                    Point p1 = this.control.getRowHeader().getViewPosition();
                    Point p2 = this.control.getViewport().getViewPosition();
                    p2.y = p1.y;
                    this.control.getViewport().setViewPosition(p2);
                }
                this.control.repaint();
                this.control.fireRegionSelect(true);
                e.consume();
                break;
            }
            case 38: {
                if (!e.isShiftDown()) {
                    this.control.toUpCell();
                    e.consume();
                    return;
                }
                int start = this.control.m_selectedRows.get(0);
                int end = this.control.m_selectedRows.get(this.control.m_selectedRows.size() - 1);
                if (this.startSelectedRow == end) {
                    --start;
                } else {
                    --end;
                }
                if (end > this.control.cellSet.getRowCount()) {
                    end = this.control.cellSet.getRowCount();
                }
                if (start < 1) {
                    start = 1;
                }
                this.control.m_selectedCols.clear();
                this.control.m_cornerSelected = false;
                this.control.m_selectedRows.clear();
                int i = start;
                while (i <= end) {
                    this.control.addSelectedRow(new Integer(i));
                    ++i;
                }
                this.control.addSelectedArea(new Area(start, 1, end, this.control.cellSet.getColCount()), true);
                if (ControlUtils.scrollToVisible(this.control.getRowHeader(), this.control, start, 0)) {
                    Point p1 = this.control.getRowHeader().getViewPosition();
                    Point p2 = this.control.getViewport().getViewPosition();
                    p2.y = p1.y;
                    this.control.getViewport().setViewPosition(p2);
                }
                this.control.repaint();
                this.control.fireRegionSelect(true);
                e.consume();
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

