/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.ide.common.GM;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.SplControl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import javax.swing.JPanel;

public class RowHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected SplControl control;
    protected boolean editable = true;
    protected CellSetParser parser;
    protected final int ICON_SIZE = 12;
    static final BufferedImage BI = new BufferedImage(5, 5, 1);
    private static final int LEVEL_WIDTH = 14;

    public RowHeaderPanel(SplControl control) {
        this(control, true);
    }

    public RowHeaderPanel(SplControl control, boolean editable) {
        this.control = control;
        this.editable = editable;
        this.parser = new CellSetParser(control.cellSet);
        this.initCoords();
        int w = RowHeaderPanel.getW(control);
        this.setPreferredSize(new Dimension(w + 1, (int)this.getPreferredSize().getHeight()));
    }

    public void initRowLocations() {
        int rows = this.control.cellSet.getRowCount() + 1;
        this.initRowLocations(rows);
    }

    public void initRowLocations(int rows) {
        this.control.cellY = new int[rows];
        this.control.cellH = new int[rows];
    }

    protected void initCoords() {
        int rows = this.control.cellSet.getRowCount() + 1;
        if (this.control.cellY == null || rows != this.control.cellY.length) {
            this.initRowLocations(rows);
        }
        int i = 1;
        while (i < rows) {
            this.control.cellY[i] = i == 1 ? 1 : this.control.cellY[i - 1] + this.control.cellH[i - 1];
            this.control.cellH[i] = !this.parser.isRowVisible(i) ? 0 : (int)this.control.cellSet.getRowCell(i).getHeight();
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        ControlUtils.setGraphicsRenderingHints(g);
        int w = RowHeaderPanel.getW(this.control);
        int levelWidth = RowHeaderPanel.getLevelWidth(this.control);
        int headWidth = w - levelWidth;
        g.clearRect(0, 0, w + 1, 999999);
        int rows = this.control.cellSet.getRowCount() + 1;
        if (rows != this.control.cellY.length) {
            this.initRowLocations(rows);
        }
        Rectangle r = this.control.getViewport().getViewRect();
        HashSet<Integer> selectedRows = ControlUtils.listSelectedRows(this.control.getSelectedAreas());
        float scale = this.control.scale;
        int i = 1;
        while (i < rows) {
            this.control.cellY[i] = i == 1 ? 1 : this.control.cellY[i - 1] + this.control.cellH[i - 1];
            if (!this.parser.isRowVisible(i)) {
                this.control.cellH[i] = 0;
            } else {
                this.control.cellH[i] = this.parser.getRowHeight(i, scale);
                if (this.control.cellY[i] + this.control.cellH[i] > r.y) {
                    if (this.control.cellY[i] >= r.y + r.height) break;
                    Color bkColor = Color.lightGray;
                    String label = String.valueOf(i);
                    byte flag = 0;
                    if (selectedRows.contains(new Integer(i))) {
                        flag = 1;
                    }
                    int k = 0;
                    while (k < this.control.m_selectedRows.size()) {
                        if (i == this.control.m_selectedRows.get(k)) {
                            flag = 3;
                            break;
                        }
                        ++k;
                    }
                    int y = this.control.cellY[i];
                    int h = this.control.cellH[i];
                    if (i > 1) {
                        ++y;
                        --h;
                    }
                    ControlUtils.drawHeader(g, 0, y, w, h, label, this.control.scale, bkColor, flag, this.editable);
                    int subEnd = this.parser.getSubEnd(i);
                    String imgPath = "";
                    if (subEnd > i && i + 1 < rows) {
                        imgPath = String.valueOf(imgPath) + "/com/scudata/ide/common/resources/";
                        imgPath = this.parser.isSubExpand(i, subEnd) ? String.valueOf(imgPath) + "rowshrink.gif" : String.valueOf(imgPath) + "rowexpand.gif";
                        Image img = GM.getImageIcon(imgPath).getImage();
                        g.drawImage(img, headWidth + (levelWidth - 12) / 2, y + (h - 12) / 2, 12, 12, null);
                    }
                    if (this.control.isBreakPointRow(i)) {
                        Image image = GM.getMenuImageIcon("program.breakpoints").getImage();
                        g.drawImage(image, 0, y + h / 2 - 8, 16, 16, null);
                    }
                }
            }
            ++i;
        }
        this.setPreferredSize(new Dimension(w + 1, this.getH()));
        g.dispose();
    }

    public static int getW(SplControl control) {
        return RowHeaderPanel.getHeaderW(control) + RowHeaderPanel.getLevelWidth(control);
    }

    public static int getHeaderW(SplControl control) {
        Graphics g = BI.getGraphics();
        String label = String.valueOf(control.cellSet.getRowCount());
        int w1 = g.getFontMetrics(g.getFont()).stringWidth(label) + 5;
        int w2 = (int)(40.0f * control.scale);
        int w = Math.max(w1, w2);
        return (int)((float)w * control.scale);
    }

    private static int getLevelWidth(SplControl control) {
        return (int)(14.0f * control.scale);
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.getH();
        int w = RowHeaderPanel.getW(this.control);
        return new Dimension(w + 1, height);
    }

    private int getH() {
        int height = 0;
        if (this.control != null && this.control.getContentPanel() != null) {
            Dimension d = this.control.getContentPanel().getPreferredSize();
            if (d != null) {
                height = d.height;
            } else {
                int row = 1;
                while (row <= this.parser.getRowCount()) {
                    if (this.parser.isRowVisible(row)) {
                        height += this.parser.getRowHeight(row, this.control.scale);
                    }
                    ++row;
                }
                height += 2;
            }
        }
        return height;
    }
}

