/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Area;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.ControlBase;
import com.scudata.ide.common.control.ControlUtilsBase;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ColHeaderPanel;
import com.scudata.ide.spl.control.ContentPanel;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditorListener;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

public abstract class SplControl
extends ControlBase {
    private static final long serialVersionUID = 1L;
    public PgmCellSet cellSet;
    public Vector<Object> m_selectedAreas = new Vector();
    public CellLocation m_activeCell;
    public CellLocation stepPosition;
    protected ArrayList<CellLocation> breakPoints = new ArrayList();
    protected CellLocation calcPos;
    int status;
    Vector<Integer> m_selectedCols = new Vector();
    Vector<Integer> m_selectedRows = new Vector();
    boolean m_cornerSelected = false;
    ArrayList<EditorListener> m_editorListener = new ArrayList();
    public ContentPanel contentView = null;
    int[] cellX;
    int[] cellY;
    int[] cellW;
    int[] cellH;
    public float scale = 1.0f;
    public boolean isSelectingCell = false;
    public JPanel rowHeaderView = null;
    public JPanel colHeaderView = null;
    public ColHeaderPanel headerPanel = null;
    protected SheetSpl sheet;

    public SplControl() {
        this(1, 1);
    }

    public SplControl(int rows, int cols) {
        this.getHorizontalScrollBar().setUnitIncrement(10);
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.cellSet = new PgmCellSet(rows, cols);
    }

    public void setSheet(SheetSpl sheet) {
        this.sheet = sheet;
    }

    public SheetSpl getSheet() {
        return this.sheet;
    }

    public void setSplScrollBarListener() {
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SplControl.this.contentView.repaint();
            }
        });
        this.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SplControl.this.contentView.repaint();
            }
        });
    }

    public void setSelectCell(boolean isSelect) {
        this.isSelectingCell = isSelect;
    }

    public ContentPanel getContentPanel() {
        return this.contentView;
    }

    public JPanel getRowHeaderPanel() {
        return this.rowHeaderView;
    }

    public JPanel getColHeaderPanel() {
        return this.colHeaderView;
    }

    public void setBreakPoints(ArrayList<CellLocation> breakPoints) {
        this.breakPoints = breakPoints;
    }

    public ArrayList<CellLocation> getBreakPoints() {
        return this.breakPoints;
    }

    public boolean isBreakPointRow(int row) {
        for (CellLocation cp : this.breakPoints) {
            if (cp.getRow() != row) continue;
            return true;
        }
        return false;
    }

    public void removeRowBreakPoints(int row) {
        int i = this.breakPoints.size() - 1;
        while (i >= 0) {
            CellLocation cp = this.breakPoints.get(i);
            if (cp.getRow() == row) {
                this.breakPoints.remove(i);
            } else if (cp.getRow() > row) {
                cp.setRow(cp.getRow() - 1);
            }
            --i;
        }
    }

    public void removeColBreakPoints(int col) {
        int i = this.breakPoints.size() - 1;
        while (i >= 0) {
            CellLocation cp = this.breakPoints.get(i);
            if (cp.getCol() == col) {
                this.breakPoints.remove(i);
            } else if (cp.getCol() > col) {
                cp.setCol(cp.getCol() - 1);
            }
            --i;
        }
    }

    public void setBreakPoint() {
        CellLocation cp = this.getActiveCell();
        if (cp == null) {
            return;
        }
        if (this.breakPoints.contains(cp)) {
            this.breakPoints.remove(cp);
        } else {
            this.breakPoints.add(cp);
        }
        this.repaint();
    }

    public boolean isBreakPointCell(int row, int col) {
        for (CellLocation cp : this.breakPoints) {
            if (cp.getRow() != row || cp.getCol() != col) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectingCell() {
        return this.isSelectingCell;
    }

    public CellLocation getActiveCell() {
        return this.m_activeCell;
    }

    public void setStepPosition(CellLocation cp) {
        this.stepPosition = cp;
    }

    public CellLocation getStepPosition() {
        return this.stepPosition;
    }

    public void setCalcPosition(CellLocation cp) {
        this.calcPos = cp;
    }

    public CellLocation getCalcPosition() {
        return this.calcPos;
    }

    public void reloadEditorText() {
        this.contentView.reloadEditorText();
    }

    public Point[] getCellPoint(int row, int col) {
        Point[] p = new Point[2];
        int x1 = this.cellX[col];
        int y1 = this.cellY[row];
        int x2 = x1 + this.cellW[col];
        int y2 = y1 + this.cellH[row];
        p[0] = new Point(x1, y1);
        p[1] = new Point(x2, y2);
        return p;
    }

    public Area setActiveCell(CellLocation pos) {
        return this.setActiveCell(pos, true);
    }

    public Area setActiveCell(CellLocation pos, boolean clearSelection) {
        return this.setActiveCell(pos, clearSelection, true);
    }

    public Area setActiveCell(CellLocation pos, boolean clearSelection, boolean scrollToVisible) {
        Area a;
        if ((pos = ControlUtilsBase.checkPosition(pos, this.getCellSet())) == null) {
            this.contentView.submitEditor();
            this.m_activeCell = null;
            this.contentView.setEditorVisible(false);
            a = null;
        } else {
            int row = pos.getRow();
            int col = pos.getCol();
            a = new Area(row, col, row, col);
            this.contentView.rememberedRow = row;
            this.contentView.rememberedCol = col;
            if (clearSelection) {
                this.m_selectedRows.clear();
                this.m_selectedCols.clear();
                this.m_cornerSelected = false;
            }
            this.contentView.submitEditor();
            this.m_activeCell = pos;
            if (scrollToVisible) {
                ControlUtils.scrollToVisible(this.getViewport(), this, pos.getRow(), pos.getCol());
            }
            this.repaint();
            this.contentView.initEditor((byte)2);
            this.contentView.requestFocus();
        }
        return a;
    }

    /*
     * Unable to fully structure code
     */
    public Area toUpCell() {
        if (this.m_activeCell == null) {
            return null;
        }
        parser = new CellSetParser(this.cellSet);
        row = this.m_activeCell.getRow();
        col = this.m_activeCell.getCol();
        if (--row >= 1) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            if (--row >= 1) continue;
            return null;
lbl10:
            // 2 sources

            ** while (!parser.isRowVisible((int)row))
        }
lbl11:
        // 1 sources

        if (row < 1) {
            return null;
        }
        return this.setActiveCell(new CellLocation(row, col));
    }

    /*
     * Unable to fully structure code
     */
    public Area toDownCell() {
        if (this.m_activeCell == null) {
            return null;
        }
        parser = new CellSetParser(this.cellSet);
        row = this.m_activeCell.getRow();
        col = this.m_activeCell.getCol();
        if (++row <= this.cellSet.getRowCount()) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            if (++row <= this.contentView.cellSet.getRowCount()) continue;
            return null;
lbl10:
            // 2 sources

            ** while (!parser.isRowVisible((int)row))
        }
lbl11:
        // 1 sources

        if (row > this.contentView.cellSet.getRowCount()) {
            return null;
        }
        return this.setActiveCell(new CellLocation(row, col));
    }

    public Area toLeftCell() {
        if (this.m_activeCell == null) {
            return null;
        }
        int row = this.m_activeCell.getRow();
        int col = this.m_activeCell.getCol();
        if (--col < 1) {
            return null;
        }
        CellSetParser parser = new CellSetParser(this.cellSet);
        while (!parser.isColVisible(col)) {
            if (--col >= 1) continue;
            return null;
        }
        if (col < 1) {
            return null;
        }
        return this.setActiveCell(new CellLocation(row, col));
    }

    /*
     * Unable to fully structure code
     */
    public Area toRightCell() {
        if (this.m_activeCell == null) {
            return null;
        }
        row = this.m_activeCell.getRow();
        col = this.m_activeCell.getCol();
        parser = new CellSetParser(this.cellSet);
        if (++col <= this.contentView.cellSet.getColCount()) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            if (++col <= this.contentView.cellSet.getColCount()) continue;
            return null;
lbl10:
            // 2 sources

            ** while (!parser.isColVisible((int)col))
        }
lbl11:
        // 1 sources

        if (col > this.contentView.cellSet.getColCount()) {
            return null;
        }
        this.updateCoords();
        return this.setActiveCell(new CellLocation(row, col));
    }

    protected void updateCoords() {
        int cols = this.cellSet.getColCount() + 1;
        if (this.cellX == null || cols != this.cellX.length) {
            this.cellX = new int[cols];
            this.cellW = new int[cols];
        }
        CellSetParser parser = new CellSetParser(this.cellSet);
        int i = 1;
        while (i < cols) {
            this.cellX[i] = i == 1 ? 1 : this.cellX[i - 1] + this.cellW[i - 1];
            this.cellW[i] = !parser.isColVisible(i) ? 0 : (int)this.cellSet.getColCell(i).getWidth();
            ++i;
        }
    }

    public void selectToArea(Area region) {
        this.addSelectedArea(region, true);
        this.m_selectedCols.clear();
        this.m_selectedRows.clear();
        this.m_cornerSelected = false;
        this.fireRegionSelect(true);
        ControlUtils.scrollToVisible(this.getViewport(), this, region.getBeginRow(), region.getEndCol());
        this.repaint();
        this.contentView.requestFocus();
    }

    /*
     * Unable to fully structure code
     */
    public void selectToDownCell(CellLocation tarPos) {
        block9: {
            block10: {
                block8: {
                    region = this.getSelectedArea(-1);
                    startRow = region.getBeginRow();
                    endRow = region.getEndRow();
                    startCol = region.getBeginCol();
                    endCol = region.getEndCol();
                    row = this.m_activeCell.getRow();
                    parser = new CellSetParser(this.cellSet);
                    if (tarPos == null) break block8;
                    tarRow = tarPos.getRow();
                    if (startRow < row) {
                        if (tarRow > row) {
                            startRow = row;
                            endRow = tarRow;
                        } else {
                            startRow = tarRow;
                        }
                    } else {
                        endRow = tarRow;
                    }
                    break block9;
                }
                if (startRow >= row) break block10;
                nextRow = startRow;
                do {
                    tempRow = nextRow;
                    hasCellCrossRows = false;
                } while (nextRow <= this.contentView.cellSet.getRowCount() && (hasCellCrossRows || (nextRow = tempRow + 1) <= this.contentView.cellSet.getRowCount() && !parser.isRowVisible(nextRow)));
                if (nextRow > row) {
                    nextRow = row;
                    ++endRow;
                }
                startRow = nextRow;
                break block9;
            }
            if (++endRow <= this.contentView.cellSet.getRowCount()) ** GOTO lbl36
            return;
lbl-1000:
            // 1 sources

            {
                if (++endRow <= this.contentView.cellSet.getRowCount()) continue;
                return;
lbl36:
                // 2 sources

                ** while (!parser.isRowVisible((int)endRow))
            }
        }
        if (endRow > this.contentView.cellSet.getRowCount() || !parser.isRowVisible(endRow)) {
            return;
        }
        region = new Area(startRow, startCol, endRow, endCol);
        this.addSelectedArea(region, true);
        this.m_selectedCols.clear();
        this.m_selectedRows.clear();
        this.m_cornerSelected = false;
        this.fireRegionSelect(true);
        ControlUtils.scrollToVisible(this.getViewport(), this, region.getEndRow(), region.getEndCol());
        this.repaint();
        this.contentView.requestFocus();
    }

    /*
     * Unable to fully structure code
     */
    void selectToUpCell(CellLocation tarPos) {
        block9: {
            block10: {
                block8: {
                    region = this.getSelectedArea(-1);
                    startRow = region.getBeginRow();
                    endRow = region.getEndRow();
                    startCol = region.getBeginCol();
                    endCol = region.getEndCol();
                    row = this.m_activeCell.getRow();
                    parser = new CellSetParser(this.cellSet);
                    if (tarPos == null) break block8;
                    tarRow = tarPos.getRow();
                    if (endRow > row) {
                        if (tarRow < row) {
                            startRow = tarRow;
                            endRow = row;
                        } else {
                            endRow = tarRow;
                        }
                    } else {
                        startRow = tarRow;
                    }
                    break block9;
                }
                if (endRow <= row) break block10;
                nextRow = endRow;
                do {
                    tempRow = nextRow;
                    hasCellCrossRows = false;
                } while (nextRow >= 1 && (hasCellCrossRows || (nextRow = tempRow - 1) >= 1 && !parser.isRowVisible(nextRow)));
                if (nextRow < row) {
                    nextRow = row;
                    --startRow;
                }
                endRow = nextRow;
                break block9;
            }
            if (--startRow >= 1) ** GOTO lbl36
            return;
lbl-1000:
            // 1 sources

            {
                if (--startRow >= 1) continue;
                return;
lbl36:
                // 2 sources

                ** while (!parser.isRowVisible((int)startRow))
            }
        }
        if (startRow < 1 || !parser.isRowVisible(startRow)) {
            return;
        }
        region = new Area(startRow, startCol, endRow, endCol);
        this.addSelectedArea(region, true);
        this.m_selectedCols.clear();
        this.m_selectedRows.clear();
        this.m_cornerSelected = false;
        this.fireRegionSelect(true);
        ControlUtils.scrollToVisible(this.getViewport(), this, region.getBeginRow(), region.getEndCol());
        this.repaint();
        this.contentView.requestFocus();
    }

    void selectToRightCell(CellLocation tarPos) {
        Area region = this.getSelectedArea(-1);
        int startRow = region.getBeginRow();
        int endRow = region.getEndRow();
        int startCol = region.getBeginCol();
        int endCol = region.getEndCol();
        int col = this.m_activeCell.getCol();
        if (tarPos != null) {
            int tarCol = tarPos.getCol();
            if (startCol < col) {
                if (tarCol > col) {
                    startCol = col;
                    endCol = tarCol;
                } else {
                    startCol = tarCol;
                }
            } else {
                endCol = tarCol;
            }
        } else if (startCol < col) {
            int nextCol;
            block11: {
                int tempCol;
                boolean hasCellCrossCols;
                nextCol = startCol;
                do {
                    tempCol = nextCol;
                    hasCellCrossCols = false;
                    if (nextCol > this.contentView.cellSet.getColCount()) break block11;
                } while (hasCellCrossCols);
                nextCol = tempCol + 1;
            }
            if (nextCol > col) {
                nextCol = col;
                ++endCol;
            }
            startCol = nextCol;
        } else {
            ++endCol;
        }
        if (endCol > this.contentView.cellSet.getColCount()) {
            return;
        }
        region = new Area(startRow, startCol, endRow, endCol);
        this.addSelectedArea(region, true);
        this.m_selectedCols.clear();
        this.m_selectedRows.clear();
        this.m_cornerSelected = false;
        this.fireRegionSelect(true);
        ControlUtils.scrollToVisible(this.getViewport(), this, region.getEndRow(), region.getEndCol());
        this.repaint();
        this.contentView.requestFocus();
    }

    void selectToLeftCell(CellLocation tarPos) {
        Area region = this.getSelectedArea(-1);
        int startRow = region.getBeginRow();
        int endRow = region.getEndRow();
        int startCol = region.getBeginCol();
        int endCol = region.getEndCol();
        int col = this.m_activeCell.getCol();
        if (tarPos != null) {
            int tarCol = tarPos.getCol();
            if (endCol > col) {
                if (tarCol < col) {
                    startCol = tarCol;
                    endCol = col;
                } else {
                    endCol = tarCol;
                }
            } else {
                startCol = tarCol;
            }
        } else if (endCol > col) {
            int nextCol;
            block11: {
                int tempCol;
                boolean hasCellCrossCols;
                nextCol = endCol;
                do {
                    tempCol = nextCol;
                    hasCellCrossCols = false;
                    if (nextCol < 1) break block11;
                } while (hasCellCrossCols);
                nextCol = tempCol - 1;
            }
            if (nextCol < col) {
                nextCol = col;
                --startCol;
            }
            endCol = nextCol;
        } else {
            --startCol;
        }
        if (startCol < 1) {
            return;
        }
        region = new Area(startRow, startCol, endRow, endCol);
        this.addSelectedArea(region, true);
        this.m_selectedCols.clear();
        this.m_selectedRows.clear();
        this.m_cornerSelected = false;
        this.fireRegionSelect(true);
        ControlUtils.scrollToVisible(this.getViewport(), this, region.getBeginRow(), region.getBeginCol());
        this.repaint();
        this.contentView.requestFocus();
    }

    public void addSelectedCol(Integer c) {
        if (this.m_selectedCols.contains(c)) {
            return;
        }
        this.m_selectedCols.add(c);
    }

    public void addSelectedRow(Integer r) {
        if (this.m_selectedRows.contains(r)) {
            return;
        }
        this.m_selectedRows.add(r);
    }

    public void clearSelectedArea() {
        this.m_selectedAreas.clear();
    }

    public Vector<Object> getSelectedAreas() {
        return this.m_selectedAreas;
    }

    public void setSelectedAreas(Vector<Object> newAreas) {
        this.m_selectedAreas = newAreas;
    }

    public Area getSelectedArea(int index) {
        if (this.m_selectedAreas.isEmpty()) {
            return null;
        }
        if (index < 0) {
            index = this.m_selectedAreas.size() - 1;
        }
        return (Area)this.m_selectedAreas.get(index);
    }

    public void setSelectedArea(Area a) {
        if (a == null) {
            return;
        }
        this.clearSelectedArea();
        this.m_selectedAreas.add(a);
    }

    public void selectAll() {
        this.m_cornerSelected = true;
        int rows = this.cellSet.getRowCount();
        int cols = this.cellSet.getColCount();
        this.m_selectedCols.clear();
        int i = 1;
        while (i <= cols) {
            this.m_selectedCols.add(new Integer(i));
            ++i;
        }
        this.m_selectedRows.clear();
        i = 1;
        while (i <= rows) {
            this.m_selectedRows.add(new Integer(i));
            ++i;
        }
        this.setSelectedArea(new Area(1, 1, rows, cols));
        this.repaint();
        this.fireRegionSelect(true);
    }

    public void addSelectedArea(Area a, boolean removeLast) {
        if (a == null || this.m_selectedAreas.contains(a)) {
            return;
        }
        if (removeLast && !this.m_selectedAreas.isEmpty()) {
            this.m_selectedAreas.remove(this.m_selectedAreas.size() - 1);
        }
        this.m_selectedAreas.add(a);
    }

    public void draw() {
        JPanel corner = this.createCorner();
        if (corner != null) {
            this.setCorner("UPPER_LEFT_CORNER", corner);
        }
        this.colHeaderView = this.createColHeaderView();
        if (this.colHeaderView != null) {
            JViewport colHeader = new JViewport();
            this.setColumnHeader(colHeader);
            this.setColumnHeaderView(this.colHeaderView);
        }
        this.rowHeaderView = this.createRowHeaderView();
        if (this.rowHeaderView != null) {
            JViewport rowHeader = new JViewport();
            this.setRowHeader(rowHeader);
            this.setRowHeaderView(this.rowHeaderView);
        }
        this.contentView = this.createContentView();
        if (this.contentView != null) {
            this.getViewport().setView(this.contentView);
            this.getViewport().setAutoscrolls(true);
        }
    }

    public void scrollToArea(Area newArea) {
        if (newArea == null) {
            return;
        }
        this.setSelectedArea(newArea);
        if (ControlUtils.scrollToVisible(this.getViewport(), this, newArea.getBeginRow(), newArea.getBeginCol())) {
            ContentPanel cp = this.getContentPanel();
            JScrollBar hBar = this.getHorizontalScrollBar();
            JScrollBar vBar = this.getVerticalScrollBar();
            hBar.setValue(cp.getColOffset(newArea.getBeginCol(), this.scale));
            vBar.setValue(cp.getRowOffset(newArea.getBeginRow(), this.scale));
        }
        this.fireRegionSelect(true);
    }

    abstract JPanel createCorner();

    abstract JPanel createColHeaderView();

    abstract JPanel createRowHeaderView();

    abstract ContentPanel createContentView();

    public void setCellSet(PgmCellSet cellSet) {
        Object scaleObj;
        this.cellSet = cellSet;
        this.scale = 1.0f;
        ByteMap bm = cellSet.getCustomPropMap();
        if (bm != null && (scaleObj = bm.get((byte)21)) != null) {
            this.scale = ((Number)scaleObj).floatValue();
        }
        this.draw();
    }

    public PgmCellSet getCellSet() {
        return this.cellSet;
    }

    @Override
    public ICellSet getICellSet() {
        return this.cellSet;
    }

    public void addEditorListener(EditorListener listener) {
        this.m_editorListener.add(listener);
    }

    void fireRowHeaderResized(Vector<Integer> vectHeader, float newHeight) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.rowHeightChange(vectHeader, newHeight);
            ++i;
        }
        Point hp = this.getRowHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getRowHeader().setView(this.rowHeaderView == null ? this.createRowHeaderView() : this.rowHeaderView);
        this.getRowHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
        this.contentView.requestFocus();
        this.repaint();
    }

    void fireColHeaderResized(Vector<Integer> vectHeader, float newWidth) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.columnWidthChange(vectHeader, newWidth);
            ++i;
        }
        Point hp = this.getColumnHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getColumnHeader().setView(this.colHeaderView == null ? this.createColHeaderView() : this.colHeaderView);
        this.getColumnHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
        this.contentView.requestFocus();
        this.repaint();
    }

    void fireRegionMove() {
    }

    void fireRegionPaste() {
    }

    void fireRegionSelect(boolean keyEvent) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.regionsSelect(this.m_selectedAreas, this.m_selectedRows, this.m_selectedCols, this.m_cornerSelected, keyEvent);
            ++i;
        }
    }

    public void fireCellTextInput(CellLocation pos, String text) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.cellTextInput(pos.getRow(), pos.getCol(), text);
            ++i;
        }
    }

    void fireEditorInputing(String text) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.editorInputing(text);
            ++i;
        }
    }

    void fireMouseMove(int row, int col) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.mouseMove(row, col);
            ++i;
        }
    }

    void fireRightClicked(MouseEvent e, int clickPlace) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.rightClicked(e, clickPlace);
            ++i;
        }
    }

    void fireDoubleClicked(MouseEvent e) {
        int i = 0;
        while (i < this.m_editorListener.size()) {
            EditorListener listener = this.m_editorListener.get(i);
            listener.doubleClicked(e);
            ++i;
        }
    }

    public List<NormalCell> insertColumn(int col, int count) {
        if (col > this.cellSet.getColCount() || col < 0) {
            col = this.cellSet.getColCount();
        }
        List<NormalCell> cells = this.insertCol(this.cellSet, col, count);
        this.resetControlWidth();
        return cells;
    }

    protected List<NormalCell> insertCol(PgmCellSet cellSet, int col, int count) {
        return cellSet.insertCol(col, count);
    }

    public void addColumn(int count) {
        this.addCol(this.cellSet, count);
        this.resetControlWidth();
    }

    protected void addCol(PgmCellSet cellSet, int count) {
        cellSet.addCol(count);
    }

    protected void resetControlWidth() {
        Point hp = this.getColumnHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getColumnHeader().setView(this.createColHeaderView());
        this.getColumnHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
        this.contentView.requestFocus();
        this.repaint();
    }

    protected void resetControlHeight() {
        Point hp = this.getRowHeader().getViewPosition();
        Point p = this.getViewport().getViewPosition();
        this.getRowHeader().setView(this.createRowHeaderView());
        this.getRowHeader().setViewPosition(hp);
        this.getViewport().setViewPosition(p);
        this.contentView.requestFocus();
        this.repaint();
    }

    public List<NormalCell> removeColumn(int col, int count) {
        List<NormalCell> adjustCells = null;
        if (col <= this.cellSet.getColCount() && col > 0) {
            int activeCellStartCol;
            adjustCells = this.removeCol(this.cellSet, col, count);
            if (this.getActiveCell() != null && col <= (activeCellStartCol = this.getActiveCell().getCol())) {
                if ((activeCellStartCol -= count) < 1) {
                    activeCellStartCol = 1;
                }
                this.getActiveCell().setCol(activeCellStartCol);
            }
        }
        return adjustCells;
    }

    protected List<NormalCell> removeCol(PgmCellSet cellSet, int col, int count) {
        return cellSet.removeCol(col, count);
    }

    public List<NormalCell> insertRow(int row, int count) {
        if (row > this.cellSet.getRowCount() || row < 0) {
            row = this.cellSet.getRowCount();
        }
        List<NormalCell> cells = this.insertRow(this.cellSet, row, count);
        this.resetControlHeight();
        return cells;
    }

    protected List<NormalCell> insertRow(PgmCellSet cellSet, int row, int count) {
        return cellSet.insertRow(row, count);
    }

    public void setDisplayScale(int ratio) {
        Point p = this.getViewport().getViewPosition();
        p.x = (int)((float)p.x / this.scale);
        p.y = (int)((float)p.y / this.scale);
        this.scale = (float)ratio / 100.0f;
        this.getColumnHeader().setView(this.createColHeaderView());
        this.getRowHeader().setView(this.createRowHeaderView());
        this.contentView = this.createContentView();
        this.getViewport().setView(this.contentView);
        p.x = (int)((float)p.x * this.scale);
        p.y = (int)((float)p.y * this.scale);
        this.getViewport().setViewPosition(p);
        this.getColumnHeader().setViewPosition(new Point(p.x, 0));
        this.getRowHeader().setViewPosition(new Point(0, p.y));
        this.repaint();
    }

    public float getDisplayScale() {
        return this.scale;
    }

    public void addRow(int count) {
        this.addRow(this.cellSet, count);
        this.resetControlHeight();
    }

    protected void addRow(PgmCellSet cellSet, int count) {
        cellSet.addRow(count);
    }

    public List<NormalCell> removeRow(int row, int count) {
        List<NormalCell> adjustCells = null;
        if (row <= this.cellSet.getRowCount() && row > 0) {
            int activeCellStartRow;
            adjustCells = this.removeRow(this.cellSet, row, count);
            if (this.getActiveCell() != null && row <= (activeCellStartRow = this.getActiveCell().getRow())) {
                if ((activeCellStartRow -= count) < 1) {
                    activeCellStartRow = 1;
                }
                this.getActiveCell().setRow(activeCellStartRow);
            }
        }
        return adjustCells;
    }

    protected List<NormalCell> removeRow(PgmCellSet cellSet, int row, int count) {
        return cellSet.removeRow(row, count);
    }

    public void clearSelectedAreas() {
        this.clearSelectedArea();
        this.m_selectedRows.clear();
        this.m_selectedCols.clear();
        this.fireRegionSelect(false);
    }

    public JTextComponent getEditor() {
        if (this.contentView == null) {
            return null;
        }
        JComponent textEditor = this.contentView.getEditor();
        if (textEditor == null || !(textEditor instanceof JTextComponent)) {
            return null;
        }
        return (JTextComponent)textEditor;
    }

    public void setSearchedCell(int row, int col, boolean searchInSelectedCells) {
        this.setActiveCell(new CellLocation(row, col));
        ControlUtils.scrollToVisible(this.getViewport(), this, row, col);
        if (!searchInSelectedCells) {
            this.setSelectedArea(new Area(row, col, row, col));
            this.fireRegionSelect(true);
        }
        GV.appSheet.refresh();
    }

    public void dispose() {
        this.cellSet = null;
        this.m_selectedAreas = null;
        this.m_selectedCols = null;
        this.m_selectedRows = null;
        this.m_editorListener = null;
        if (this.contentView != null) {
            this.contentView.dispose();
        }
        this.cellX = null;
        this.cellY = null;
        this.cellW = null;
        this.cellH = null;
    }

    public void setScale(float newScale) {
        ByteMap bm;
        float oldScale = this.scale;
        this.scale = newScale;
        if (this.colHeaderView != null) {
            Point pCol = this.getViewport().getViewPosition();
            pCol.setLocation(pCol.getX() * (double)this.scale / (double)oldScale, pCol.getY() * (double)this.scale / (double)oldScale);
            this.setColumnHeaderView(this.colHeaderView);
            this.getColumnHeader().setViewPosition(pCol);
        }
        if (this.rowHeaderView != null) {
            Point pRow = this.getViewport().getViewPosition();
            pRow.setLocation(pRow.getX() * (double)this.scale / (double)oldScale, pRow.getY() * (double)this.scale / (double)oldScale);
            this.setRowHeaderView(this.rowHeaderView);
            this.getRowHeader().setViewPosition(pRow);
        }
        if (this.contentView != null) {
            Point pContent = this.getViewport().getViewPosition();
            pContent.setLocation(pContent.getX() * (double)this.scale / (double)oldScale, pContent.getY() * (double)this.scale / (double)oldScale);
            this.getViewport().setView(this.contentView);
            this.getViewport().setViewPosition(pContent);
        }
        if ((bm = this.cellSet.getCustomPropMap()) == null) {
            bm = new ByteMap();
            this.cellSet.setCustomPropMap(bm);
        }
        bm.put((byte)21, Float.valueOf(this.scale));
    }
}

