/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.cellset.IColCell;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.IRowCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.ColCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.cellset.datamodel.RowCell;
import com.scudata.common.Area;
import com.scudata.common.ByteMap;
import com.scudata.common.CellLocation;
import com.scudata.common.Escape;
import com.scudata.common.IByteMap;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.CellSelection;
import com.scudata.ide.common.control.IEditorListener;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.AtomicSpl;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSpl;
import com.scudata.ide.spl.UndoManager;
import com.scudata.ide.spl.chart.DialogPlotEdit;
import com.scudata.ide.spl.control.CellSelectListener;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.ControlUtils;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplControlListener;
import com.scudata.ide.spl.dialog.DialogCopyPresent;
import com.scudata.ide.spl.dialog.DialogTextEditor;
import com.scudata.ide.spl.dialog.DialogZoom;
import com.scudata.ide.spl.etl.DialogFuncEdit;
import com.scudata.ide.spl.etl.ObjectElement;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.util.CellSetUtil;
import java.awt.Color;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SplEditor {
    public static final byte HK_CTRL_ENTER = 0;
    public static final byte HK_CTRL_INSERT = 2;
    public static final byte HK_ALT_INSERT = 3;
    public static final byte PASTE_OPTION_NORMAL = 0;
    public static final byte PASTE_OPTION_INSERT_ROW = 1;
    public static final byte PASTE_OPTION_INSERT_COL = 2;
    public static final byte PASTE_OPTION_PUSH_BOTTOM = 3;
    public static final byte PASTE_OPTION_PUSH_RIGHT = 4;
    protected EditControl control;
    public UndoManager undoManager;
    private IEditorListener listener;
    public byte selectState = 1;
    private MessageManager mm = IdeSplMessage.get();
    private boolean isDataChanged = false;
    public Vector<CellRect> selectedRects = new Vector();
    public Vector<Integer> selectedCols = new Vector();
    public Vector<Integer> selectedRows = new Vector();
    protected SheetSpl sheet;
    public static final byte CLEAR = 0;
    public static final byte CLEAR_EXP = 1;
    public static final byte CLEAR_VAL = 2;
    private Vector<Object> selectedAreas;

    public SplEditor(SheetSpl sheet) {
        this.sheet = sheet;
        this.control = this.newEditControl(ConfigOptions.iRowCount, ConfigOptions.iColCount);
        SplEditor.initDefaultProperty(this.control.cellSet);
        this.control.draw();
        SplControlListener qcl = new SplControlListener(this);
        this.control.addEditorListener(qcl);
        this.undoManager = new UndoManager(this);
    }

    public static void initDefaultProperty(CellSet cs) {
        int rows = cs.getRowCount();
        int cols = cs.getColCount();
        int r = 1;
        while (r <= rows) {
            IRowCell rc = cs.getRowCell(r);
            SplEditor.initDefaultCell(rc);
            ++r;
        }
        int c = 1;
        while (c <= cols) {
            IColCell cc = cs.getColCell(c);
            SplEditor.initDefaultCell(cc);
            ++c;
        }
    }

    private static void initDefaultCell(Object ic) {
        if (ic instanceof RowCell) {
            RowCell rc = (RowCell)ic;
            rc.setHeight(ConfigOptions.fRowHeight.floatValue());
        } else if (ic instanceof ColCell) {
            ColCell cc = (ColCell)ic;
            cc.setWidth(ConfigOptions.fColWidth.floatValue());
        }
    }

    protected EditControl newEditControl(int rows, int cols) {
        EditControl control = new EditControl(rows, cols);
        control.setSheet(this.sheet);
        return control;
    }

    public void setDataChanged(boolean isDataChanged) {
        this.isDataChanged = isDataChanged;
        GMSpl.enableSave(isDataChanged);
    }

    public boolean isDataChanged() {
        return this.isDataChanged;
    }

    public boolean setCellSet(PgmCellSet cellSet) throws Exception {
        this.control.setCellSet(cellSet);
        this.control.draw();
        return true;
    }

    public void selectFirstCell() {
        if (this.control.cellSet.getRowCount() < 1 || this.control.cellSet.getColCount() < 1) {
            return;
        }
        this.selectState = 1;
        CellRect rect = new CellRect(1, 1, 1, 1);
        this.selectedRects.clear();
        this.selectedRects.add(rect);
        this.selectedCols.clear();
        this.selectedRows.clear();
        this.control.m_selectedCols.clear();
        this.control.m_selectedRows.clear();
        this.control.m_cornerSelected = false;
        this.control.contentView.rememberedRow = 1;
        this.control.contentView.rememberedCol = 1;
        this.control.setActiveCell(new CellLocation(1, 1));
        this.control.setSelectedArea(new Area(1, 1, 1, 1));
    }

    public void selectCell(int row, int col) {
        if (this.control.cellSet.getRowCount() < row || this.control.cellSet.getColCount() < col) {
            return;
        }
        this.selectState = 1;
        CellRect rect = new CellRect(row, col, 1, 1);
        this.selectedRects.clear();
        this.selectedRects.add(rect);
        this.selectedCols.clear();
        this.selectedRows.clear();
        this.control.m_selectedCols.clear();
        this.control.m_selectedRows.clear();
        this.control.m_cornerSelected = false;
        this.control.contentView.rememberedRow = row;
        this.control.contentView.rememberedCol = col;
        this.control.setActiveCell(new CellLocation(row, col));
        this.control.setSelectedArea(new Area(row, col, row, col));
    }

    public void addSplListener(IEditorListener listener) {
        this.listener = listener;
    }

    public IEditorListener getSplListener() {
        return this.listener;
    }

    public SplControl getComponent() {
        return this.control;
    }

    public boolean executeCmd(Vector<IAtomicCmd> cmds) {
        this.undoManager.doing(cmds);
        this.control.getContentPanel().initEditor((byte)2);
        return true;
    }

    public boolean executeCmd(IAtomicCmd aCell) {
        this.undoManager.doing(aCell);
        this.control.getContentPanel().initEditor((byte)2);
        return true;
    }

    public boolean undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
            return true;
        }
        return false;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
            return true;
        }
        return false;
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void setEditingText(String text) {
        this.control.getContentPanel().setEditorText(text);
    }

    public void dialogChartEditor() {
        int col;
        if (this.isNothingSelected()) {
            return;
        }
        CellRect cr = this.selectedRects.get(0);
        int row = cr.getBeginRow();
        NormalCell nc = (NormalCell)this.control.cellSet.getCell(row, col = cr.getBeginCol());
        String exp = nc.getExpString();
        if (exp == null) {
            exp = "";
        }
        List<String> gNames = this.getCanvasNames();
        DialogPlotEdit dpe = new DialogPlotEdit((Frame)GV.appFrame, exp, gNames);
        dpe.setVisible(true);
        if (dpe.getOption() != 0) {
            return;
        }
        exp = "=" + dpe.getPlotFunction();
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        Vector<CellLocation> cells = ControlUtils.listSelectedCells(this.selectedRects);
        int i = 0;
        while (i < cells.size()) {
            CellLocation cp = cells.get(i);
            nc = (NormalCell)this.control.cellSet.getCell(cp.getRow(), cp.getCol());
            AtomicCell ac = new AtomicCell((SplControl)this.control, nc);
            ac.setProperty((byte)1);
            ac.setValue(exp);
            cmds.add(ac);
            ac = SplControlListener.getCellHeightCmd(this.control, cp.getRow(), cp.getCol(), exp);
            if (ac != null) {
                cmds.add(ac);
            }
            ++i;
        }
        this.executeCmd(cmds);
    }

    private List<String> getCanvasNames() {
        ArrayList<String> gNames = new ArrayList<String>();
        PgmCellSet cellSet = this.control.cellSet;
        Pattern p = Pattern.compile("\\s*(\\S*\\s*=)?\\s*canvas\\s*\\(\\s*\\)\\s*");
        CellRect cr = this.selectedRects.get(0);
        int row = cr.getBeginRow();
        int col = cellSet.getColCount();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        int r = 1;
        int rowCount = row;
        while (r <= rowCount) {
            int c = 1;
            int colCount = col;
            while (c <= colCount) {
                block8: {
                    byte cellType;
                    PgmNormalCell cell = (PgmNormalCell)cellSet.getCell(r, c);
                    String exp = cell.getExpString();
                    if (exp != null && (cellType = parser.getCellDispType(r, c)) != 1) {
                        String paramName;
                        if (r == rowCount && c == cr.getBeginCol()) break;
                        switch (cell.getType()) {
                            case 1: 
                            case 4: {
                                exp = exp.substring(1);
                                break;
                            }
                            case 2: 
                            case 8: {
                                exp = exp.substring(2);
                                break;
                            }
                            default: {
                                break block8;
                            }
                        }
                        exp = exp.trim();
                        Matcher m = p.matcher(exp);
                        if (m.matches() && !gNames.contains(paramName = !StringUtils.isValidString(paramName = m.group(1)) ? cell.getCellId() : paramName.substring(0, paramName.length() - 1))) {
                            gNames.add(paramName);
                        }
                    }
                }
                ++c;
            }
            ++r;
        }
        return gNames;
    }

    private ObjectElement getFuncObj(int row, int col, HashMap<String, ObjectElement> oes) {
        INormalCell nc = this.control.cellSet.getCell(row, col);
        return ObjectElement.parseString(nc.getExpString(), oes);
    }

    public boolean isObjectElementSelected() {
        int col;
        if (this.isNothingSelected()) {
            return false;
        }
        CellRect cr = this.selectedRects.get(0);
        int row = cr.getBeginRow();
        ObjectElement oe = this.getFuncObj(row, col = cr.getBeginCol(), this.getObjectElementMap());
        return oe != null;
    }

    public void dialogFuncEditor() {
        if (this.isNothingSelected()) {
            return;
        }
        CellRect cr = this.selectedRects.get(0);
        int row = cr.getBeginRow();
        int col = cr.getBeginCol();
        HashMap<String, ObjectElement> elementMap = this.getObjectElementMap();
        ObjectElement oe = this.getFuncObj(row, col, elementMap);
        DialogFuncEdit dfe = new DialogFuncEdit(elementMap, oe);
        dfe.setVisible(true);
        if (dfe.getOption() != 0) {
            return;
        }
        oe = dfe.getObjectElement();
        String exp = null;
        try {
            exp = oe.toExpressionString();
        }
        catch (Exception x) {
            GM.showException(GV.appFrame, x);
            return;
        }
        INormalCell nc = this.control.cellSet.getCell(row, col);
        AtomicCell ac = new AtomicCell((SplControl)this.control, nc);
        ac.setProperty((byte)1);
        ac.setValue(exp);
        this.executeCmd(ac);
    }

    public void dialogZoom() {
        DialogZoom dz = new DialogZoom();
        dz.setScale(this.control.scale);
        dz.setVisible(true);
        if (dz.getOption() == 0) {
            this.control.setScale(dz.getScale());
            if (GVSpl.splEditor != null) {
                GVSpl.splEditor.setDataChanged(true);
            }
        }
    }

    private HashMap<String, ObjectElement> getObjectElementMap() {
        HashMap<String, ObjectElement> elementMap = new HashMap<String, ObjectElement>();
        PgmCellSet cellSet = this.control.cellSet;
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        CellRect cr = this.selectedRects.get(0);
        int row = cr.getBeginRow();
        int col = cellSet.getColCount();
        int r = 1;
        int rowCount = row;
        while (r <= rowCount) {
            int c = 1;
            int colCount = col;
            while (c <= colCount) {
                byte cellType = parser.getCellDispType(r, c);
                if (cellType != 1) {
                    if (r == rowCount && c == cr.getBeginCol()) break;
                    ObjectElement oe = this.getFuncObj(r, c, elementMap);
                    if (oe != null && oe.getReturnType() != 0) {
                        INormalCell cell = cellSet.getCell(r, c);
                        String cellName = cell.getCellId();
                        elementMap.put(cellName, oe);
                    }
                }
                ++c;
            }
            ++r;
        }
        return elementMap;
    }

    public boolean insertRow(boolean insertBefore) {
        CellRect rect;
        int cc = this.control.cellSet.getColCount();
        if (this.isNothingSelected()) {
            rect = new CellRect(1, 1, 1, cc);
        } else {
            if (this.isMultiRectSelected()) {
                GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.insertmore"));
                return false;
            }
            rect = this.getSelectedRect();
        }
        return this.insertRow(rect, insertBefore);
    }

    public boolean insertRow(CellRect rect, boolean insertBefore) {
        this.executeCmd(this.getInsertRow(insertBefore, rect));
        if (insertBefore) {
            ArrayList<CellLocation> breaks = this.control.getBreakPoints();
            int i = 0;
            while (i < breaks.size()) {
                CellLocation cp = breaks.get(i);
                if (cp.getRow() >= rect.getBeginRow()) {
                    cp.setRow(cp.getRow() + rect.getRowCount());
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isMultiRectSelected() {
        return this.selectedRects.size() > 1;
    }

    public CellRect getSelectedRect() {
        if (this.selectedRects == null || this.selectedRects.isEmpty()) {
            return null;
        }
        return this.selectedRects.get(0);
    }

    public Vector<CellRect> getSelectedRects() {
        return this.selectedRects;
    }

    public AtomicSpl getInsertRow(boolean insertBefore, CellRect rect) {
        AtomicSpl aq = new AtomicSpl(this.control);
        if (insertBefore) {
            aq.setType((byte)1);
        } else {
            aq.setType((byte)5);
        }
        ArrayList<RowCell> oneRowCells = this.getApprCopiedRowCells(rect.getBeginRow());
        aq.setValue(oneRowCells);
        aq.setRect(rect);
        return aq;
    }

    private ArrayList<RowCell> getApprCopiedRowCells(int row) {
        ArrayList<RowCell> oneRowCells = new ArrayList<RowCell>();
        RowCell rc = (RowCell)this.control.cellSet.getRowCell(row).deepClone();
        oneRowCells.add(rc);
        return oneRowCells;
    }

    private boolean isNothingSelected() {
        return this.selectedRects.isEmpty();
    }

    public boolean setProperty(byte type, byte property, Object value) {
        if (this.isNothingSelected()) {
            return false;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        Vector<CellLocation> cells = ControlUtils.listSelectedCells(this.selectedRects);
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        switch (type) {
            case 1: 
            case 2: {
                int i = 0;
                while (i < cells.size()) {
                    CellLocation cp = cells.get(i);
                    if (!this.isCellIgnoreable(parser, cp)) {
                        AtomicCell ac = new AtomicCell((SplControl)this.control, this.control.cellSet.getCell(cp.getRow(), cp.getCol()));
                        ac.setProperty(property);
                        ac.setValue(value);
                        cmds.add(ac);
                        if ((property == 1 || property == 0) && (ac = SplControlListener.getCellHeightCmd(this.control, cp.getRow(), cp.getCol(), String.valueOf(value))) != null) {
                            cmds.add(ac);
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int r = 0;
                while (r < this.selectedRows.size()) {
                    IRowCell cell = this.control.getCellSet().getRowCell(this.selectedRows.get(r));
                    if (cell != null) {
                        AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                        ac.setProperty(property);
                        ac.setValue(value);
                        cmds.add(ac);
                    }
                    ++r;
                }
                break;
            }
            case 4: {
                int c = 0;
                while (c < this.selectedCols.size()) {
                    IColCell cell = this.control.getCellSet().getColCell(this.selectedCols.get(c));
                    if (cell != null) {
                        AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                        ac.setProperty(property);
                        ac.setValue(value);
                        cmds.add(ac);
                    }
                    ++c;
                }
                break;
            }
        }
        this.executeCmd(cmds);
        return true;
    }

    public IByteMap getProperty() {
        IByteMap bm = null;
        switch (this.selectState) {
            case 1: {
                bm = this.cloneAMap(this.getCellByteMap((byte)1));
                break;
            }
            case 3: {
                bm = this.cloneAMap(this.getCellByteMap((byte)1));
                if (bm == null) break;
                bm.putAll(this.getCellByteMap((byte)3));
                break;
            }
            case 4: {
                bm = this.cloneAMap(this.getCellByteMap((byte)1));
                if (bm == null) break;
                bm.putAll(this.getCellByteMap((byte)4));
                break;
            }
            case 2: {
                bm = this.cloneAMap(this.getCellByteMap((byte)1));
                if (bm == null) break;
                bm.putAll(this.getCellByteMap((byte)3));
                bm.putAll(this.getCellByteMap((byte)4));
            }
        }
        return bm;
    }

    public boolean insertCol(CellRect rect, boolean insertBefore) {
        this.executeCmd(this.getInsertCol(insertBefore, rect));
        if (insertBefore) {
            ArrayList<CellLocation> breaks = this.control.getBreakPoints();
            int i = 0;
            while (i < breaks.size()) {
                CellLocation cp = breaks.get(i);
                if (cp.getCol() >= rect.getBeginCol()) {
                    cp.setCol(cp.getCol() + rect.getColCount());
                }
                ++i;
            }
        }
        this.control.getHorizontalScrollBar().setValue(this.control.getHorizontalScrollBar().getValue());
        this.control.getHorizontalScrollBar().repaint();
        return true;
    }

    public void appendCols(int cols) {
        this.insertCol(new CellRect(1, this.control.cellSet.getColCount(), 1, cols), false);
    }

    public IAtomicCmd getAppendCols(int cols) {
        return this.getInsertCol(false, new CellRect(1, this.control.cellSet.getColCount(), 1, cols));
    }

    public void appendRows(int rows) {
        this.executeCmd(this.getAppendRows(rows));
    }

    public IAtomicCmd getAppendRows(int rows) {
        return this.getInsertRow(false, new CellRect(this.control.cellSet.getRowCount(), 1, rows, 1));
    }

    public void setColumnWidth(float newWidth) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        int c = 0;
        while (c < this.selectedCols.size()) {
            int col = this.selectedCols.get(c);
            if (parser.isColVisible(col)) {
                ColCell cell = (ColCell)this.control.getCellSet().getColCell(col);
                AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                ac.setProperty((byte)100);
                ac.setValue(new Float(newWidth));
                cmds.add(ac);
            }
            ++c;
        }
        SheetSpl sheet = null;
        if (GVSpl.appSheet instanceof SheetSpl) {
            sheet = (SheetSpl)GVSpl.appSheet;
        }
        if (sheet != null) {
            sheet.scrollActiveCellToVisible = false;
        }
        this.executeCmd(cmds);
    }

    public void setColumnVisible(boolean visible) {
        if (this.selectedCols == null || this.selectedCols.size() == 0) {
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (visible && this.selectedCols.size() == 1) {
            int endCol;
            int col = ((Number)this.selectedCols.get(0)).intValue();
            if (col > 1) {
                boolean allHideBefore = true;
                int i = 1;
                while (i < col) {
                    ColCell cc = (ColCell)this.control.cellSet.getColCell(i);
                    if (cc.getVisible() != 1) {
                        allHideBefore = false;
                        break;
                    }
                    ++i;
                }
                if (allHideBefore) {
                    i = 1;
                    while (i < col) {
                        list.add(i);
                        ++i;
                    }
                }
            }
            if (col < (endCol = this.control.cellSet.getColCount())) {
                boolean allHideBehind = true;
                int i = col + 1;
                while (i <= endCol) {
                    ColCell cc = (ColCell)this.control.cellSet.getColCell(i);
                    if (cc.getVisible() != 1) {
                        allHideBehind = false;
                        break;
                    }
                    ++i;
                }
                if (allHideBehind) {
                    i = col + 1;
                    while (i <= endCol) {
                        list.add(i);
                        ++i;
                    }
                }
            }
        }
        int c = 0;
        while (c < this.selectedCols.size()) {
            int col = ((Number)this.selectedCols.get(c)).intValue();
            list.add(col);
            ++c;
        }
        this.setColumnsVisible(list, visible);
    }

    public void setColumnsVisible(ArrayList<Integer> columns, boolean visible) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int i = 0;
        while (i < columns.size()) {
            int col = columns.get(i);
            ColCell cell = (ColCell)this.control.getCellSet().getColCell(col);
            AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
            ac.setProperty((byte)103);
            ac.setValue(new Boolean(visible));
            cmds.add(ac);
            ++i;
        }
        this.executeCmd(cmds);
        this.control.getColumnHeader().revalidate();
        this.control.repaint();
    }

    public void setRowHeight(float newHeight) {
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int r = 0;
        while (r < this.selectedRows.size()) {
            int row = ((Number)this.selectedRows.get(r)).intValue();
            if (parser.isRowVisible(row)) {
                RowCell cell = (RowCell)this.control.getCellSet().getRowCell(row);
                AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                ac.setProperty((byte)101);
                ac.setValue(new Float(newHeight));
                cmds.add(ac);
            }
            ++r;
        }
        SheetSpl sheet = null;
        if (GVSpl.appSheet instanceof SheetSpl) {
            sheet = (SheetSpl)GVSpl.appSheet;
        }
        if (sheet != null) {
            sheet.scrollActiveCellToVisible = false;
        }
        this.executeCmd(cmds);
    }

    public void adjustRowHeight() {
        if (this.selectedRows == null || this.selectedRows.size() == 0) {
            return;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        int i = 0;
        while (i < this.selectedRows.size()) {
            int row = ((Number)this.selectedRows.get(i)).intValue();
            if (parser.isRowVisible(row)) {
                float height = GMSpl.getMaxRowHeight(this.control.getCellSet(), row, this.control.scale);
                RowCell cell = (RowCell)this.control.getCellSet().getRowCell(row);
                AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                ac.setProperty((byte)101);
                ac.setValue(new Float(height));
                cmds.add(ac);
            }
            ++i;
        }
        this.executeCmd(cmds);
    }

    public void adjustColWidth() {
        if (this.selectedCols == null || this.selectedCols.size() == 0) {
            return;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        int i = 0;
        while (i < this.selectedCols.size()) {
            int col = ((Number)this.selectedCols.get(i)).intValue();
            if (parser.isColVisible(col)) {
                float width = GMSpl.getMaxColWidth(this.control.getCellSet(), col, this.control.scale);
                ColCell cell = (ColCell)this.control.getCellSet().getColCell(col);
                AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                ac.setProperty((byte)100);
                ac.setValue(new Float(width));
                cmds.add(ac);
            }
            ++i;
        }
        this.executeCmd(cmds);
    }

    public void setRowVisible(boolean visible) {
        if (this.selectedRows == null || this.selectedRows.size() == 0) {
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (visible && this.selectedRows.size() == 1) {
            int endRow;
            int row = ((Number)this.selectedRows.get(0)).intValue();
            if (row > 1) {
                boolean allHideBefore = true;
                int i = 1;
                while (i < row) {
                    RowCell rc = (RowCell)this.control.cellSet.getRowCell(i);
                    if (rc.getVisible() != 1) {
                        allHideBefore = false;
                        break;
                    }
                    ++i;
                }
                if (allHideBefore) {
                    i = 1;
                    while (i < row) {
                        list.add(i);
                        ++i;
                    }
                }
            }
            if (row < (endRow = this.control.cellSet.getRowCount())) {
                boolean allHideBehind = true;
                int i = row + 1;
                while (i <= endRow) {
                    RowCell rc = (RowCell)this.control.cellSet.getRowCell(i);
                    if (rc.getVisible() != 1) {
                        allHideBehind = false;
                        break;
                    }
                    ++i;
                }
                if (allHideBehind) {
                    i = row + 1;
                    while (i <= endRow) {
                        list.add(i);
                        ++i;
                    }
                }
            }
        }
        int i = 0;
        while (i < this.selectedRows.size()) {
            int row = ((Number)this.selectedRows.get(i)).intValue();
            list.add(row);
            ++i;
        }
        this.setRowsVisible(list, visible);
    }

    public void setRowsVisible(ArrayList<Integer> rows, boolean visible) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int i = 0;
        while (i < rows.size()) {
            int row = rows.get(i);
            RowCell cell = (RowCell)this.control.getCellSet().getRowCell(row);
            AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
            ac.setProperty((byte)104);
            ac.setValue(new Boolean(visible));
            cmds.add(ac);
            ++i;
        }
        this.executeCmd(cmds);
        this.control.getRowHeader().revalidate();
        this.control.repaint();
    }

    public void hotKeyInsert(byte key) {
        CellLocation activeCell = this.control.getActiveCell();
        if (activeCell == null) {
            return;
        }
        CellRect rect = null;
        if (this.control.getSelectedAreas().size() > 0) {
            Area a = this.control.getSelectedArea(0);
            rect = new CellRect(a);
        }
        this.hotKeyInsert(key, rect);
    }

    private void hotKeyInsert(byte key, CellRect rect) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int curCol = rect.getBeginCol();
        int curRow = rect.getBeginRow();
        PgmCellSet ics = this.control.getCellSet();
        switch (key) {
            case 0: {
                int newRow = -1;
                if (curCol == 1) {
                    newRow = curRow + rect.getRowCount();
                    cmds.add(this.getInsertRow(true, new CellRect(curRow, curCol, rect.getRowCount(), 1)));
                } else {
                    if (curRow < ics.getRowCount()) {
                        cmds.add(this.getInsertRow(true, new CellRect(curRow + 1, curCol, 1, 1)));
                    } else {
                        cmds.add(this.getInsertRow(false, new CellRect(curRow, curCol, 1, 1)));
                    }
                    int colCount = ics.getColCount();
                    CellRect srcRect = new CellRect(curRow, curCol, 1, colCount - curCol + 1);
                    CellRect tarRect = new CellRect(curRow + 1, curCol, 1, colCount - curCol + 1);
                    Vector<IAtomicCmd> tmp = GMSpl.getMoveRectCmd(this, srcRect, tarRect);
                    if (tmp != null) {
                        cmds.addAll(tmp);
                    }
                }
                AtomicCell ac = new AtomicCell((SplControl)this.control, curRow + 1);
                ac.setProperty((byte)101);
                ac.setValue(new Float(this.control.cellSet.getRowCell(curRow).getHeight()));
                cmds.add(ac);
                this.executeCmd(cmds);
                ArrayList<CellLocation> breaks = this.control.getBreakPoints();
                int i = breaks.size();
                while (i < breaks.size()) {
                    CellLocation cp = breaks.get(i);
                    if (cp.getRow() >= rect.getBeginRow()) {
                        cp.setRow(cp.getRow() + rect.getRowCount());
                    }
                    ++i;
                }
                if (newRow > 0) {
                    this.control.scrollToArea(this.control.setActiveCell(new CellLocation(newRow, this.control.getActiveCell().getCol())));
                    break;
                }
                this.control.scrollToArea(this.control.toDownCell());
                break;
            }
            case 3: {
                int maxUsedRow = 0;
                int c = rect.getBeginCol();
                while (c <= rect.getEndCol()) {
                    int usedRow = this.getCellSelectListener().getUsedRows(c);
                    if (usedRow > maxUsedRow) {
                        maxUsedRow = usedRow;
                    }
                    ++c;
                }
                if (maxUsedRow < rect.getBeginRow()) break;
                CellRect srcRect = new CellRect(rect.getBeginRow(), rect.getBeginCol(), maxUsedRow - rect.getBeginRow() + 1, rect.getColCount());
                CellRect tarRect = new CellRect(rect.getEndRow() + 1, rect.getBeginCol(), maxUsedRow - rect.getBeginRow() + 1, rect.getColCount());
                this.getCellSelectListener().moveRect(srcRect, tarRect, false);
                break;
            }
            case 2: {
                int maxUsedCol = 0;
                int r = rect.getBeginRow();
                while (r <= rect.getEndRow()) {
                    int usedCol = this.getCellSelectListener().getUsedCols(r);
                    if (usedCol > maxUsedCol) {
                        maxUsedCol = usedCol;
                    }
                    ++r;
                }
                if (maxUsedCol < rect.getBeginCol()) break;
                CellRect srcRect = new CellRect(rect.getBeginRow(), rect.getBeginCol(), rect.getRowCount(), maxUsedCol - rect.getBeginCol() + 1);
                CellRect tarRect = new CellRect(rect.getBeginRow(), rect.getEndCol() + 1, rect.getRowCount(), maxUsedCol - rect.getBeginCol() + 1);
                this.getCellSelectListener().moveRect(srcRect, tarRect, false);
            }
        }
    }

    public void moveCopy(short key) {
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.copymore"));
            return;
        }
        CellLocation activeCell = this.control.getActiveCell();
        if (activeCell == null) {
            return;
        }
        this.control.getContentPanel().submitEditor();
        PgmCellSet ics = this.control.getCellSet();
        CellSetParser parser = new CellSetParser(ics);
        CellRect rect = this.getSelectedRect();
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        switch (key) {
            case 1175: {
                boolean hasPreRow = false;
                int r = rect.getBeginRow() - 1;
                while (r >= 1) {
                    if (parser.isRowVisible(r)) {
                        hasPreRow = true;
                        break;
                    }
                    --r;
                }
                if (hasPreRow) break;
                return;
            }
            case 1176: {
                boolean hasNextRow = false;
                int r = rect.getEndRow() + 1;
                while (r <= ics.getRowCount()) {
                    if (parser.isRowVisible(r)) {
                        hasNextRow = true;
                        break;
                    }
                    ++r;
                }
                if (hasNextRow) break;
                cmds.add(this.getAppendRows(1));
                break;
            }
            case 1177: {
                boolean hasPreCol = false;
                int c = rect.getBeginCol() - 1;
                while (c >= 1) {
                    if (parser.isColVisible(c)) {
                        hasPreCol = true;
                        break;
                    }
                    --c;
                }
                if (hasPreCol) break;
                return;
            }
            case 1178: {
                boolean hasNextCol = false;
                int c = rect.getEndCol() + 1;
                while (c <= ics.getColCount()) {
                    if (parser.isColVisible(c)) {
                        hasNextCol = true;
                        break;
                    }
                    ++c;
                }
                if (hasNextCol) break;
                return;
            }
        }
        CellSelection cs = new CellSelection(null, rect, this.control.cellSet);
        AtomicSpl ad = new AtomicSpl(this.control);
        ad.setType((byte)15);
        ad.setRect(rect);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CELL_SELECTION", cs);
        map.put("MOVE_TYPE", key);
        ad.setValue(map);
        cmds.add(ad);
        this.executeCmd(cmds);
    }

    private CellSelectListener getCellSelectListener() {
        return (CellSelectListener)this.control.getContentPanel().getMouseListeners()[0];
    }

    public boolean insertCol(boolean insertBefore) {
        CellRect rect;
        if (this.isNothingSelected()) {
            rect = new CellRect(1, 1, this.control.cellSet.getRowCount(), 1);
        } else {
            if (this.isMultiRectSelected()) {
                GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.insertmore"));
                return false;
            }
            rect = this.getSelectedRect();
        }
        return this.insertCol(rect, insertBefore);
    }

    public void dupRow(boolean isAdjust) {
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.insertmore"));
            return;
        }
        CellRect rect = this.getSelectedRect();
        if (rect == null) {
            return;
        }
        Matrix matrix = GMSpl.getMatrixCells(this.control.cellSet, new CellRect(rect.getBeginRow(), 1, rect.getRowCount(), this.control.cellSet.getColCount()), true);
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        AtomicSpl insertCmd = new AtomicSpl(this.control);
        if (rect.getEndRow() != this.control.cellSet.getRowCount()) {
            insertCmd.setType((byte)1);
        } else {
            insertCmd.setType((byte)5);
        }
        CellRect newRect = new CellRect(rect.getEndRow() + 1, 1, rect.getRowCount(), this.control.cellSet.getColCount());
        ArrayList<RowCell> oneRowCells = this.getApprCopiedRowCells(rect.getBeginRow());
        insertCmd.setValue(oneRowCells);
        insertCmd.setRect(newRect);
        cmds.add(insertCmd);
        AtomicSpl setCmd = new AtomicSpl(this.control);
        setCmd.setType((byte)12);
        setCmd.setRect(rect);
        CellSelection cs = new CellSelection(matrix, newRect, this.control.cellSet);
        cs.setAdjustSelf(isAdjust);
        setCmd.setValue(cs);
        cmds.add(setCmd);
        this.executeCmd(cmds);
    }

    public void showCellValue() {
        CellRect cr = this.getSelectedRect();
        if (cr == null) {
            return;
        }
        NormalCell nc = (NormalCell)this.control.cellSet.getCell(cr.getBeginRow(), cr.getBeginCol());
        if (nc != null) {
            Object value = nc.getValue();
            GVSpl.panelValue.tableValue.setValue1(value, nc.getCellId());
            GVSpl.panelValue.tableValue.setLocked(true);
        }
    }

    public IAtomicCmd getInsertCol(boolean insertBefore, CellRect rect) {
        AtomicSpl aq = new AtomicSpl(this.control);
        if (insertBefore) {
            aq.setType((byte)2);
        } else {
            aq.setType((byte)6);
        }
        aq.setRect(rect);
        ArrayList<ColCell> oneColCells = this.getApprCopiedColCells(rect.getBeginCol());
        aq.setValue(oneColCells);
        return aq;
    }

    private ArrayList<ColCell> getApprCopiedColCells(int col) {
        ArrayList<ColCell> oneColCells = new ArrayList<ColCell>();
        PgmCellSet ics = this.control.cellSet;
        ColCell cc = (ColCell)ics.getColCell(col).deepClone();
        oneColCells.add(cc);
        return oneColCells;
    }

    private IByteMap cloneAMap(IByteMap aMap) {
        if (aMap == null) {
            return null;
        }
        return (IByteMap)aMap.deepClone();
    }

    private IByteMap getCellByteMap(byte type) {
        ByteMap bm = new ByteMap();
        switch (type) {
            case 1: {
                NormalCell nc = this.getDisplayCell();
                if (nc == null) {
                    return null;
                }
                bm.put((byte)0, nc.getValue());
                bm.put((byte)1, nc.getExpString());
                break;
            }
            case 4: {
                if (this.selectedCols.isEmpty()) break;
                ColCell cc = (ColCell)this.control.cellSet.getColCell(this.selectedCols.get(0));
                bm.put((byte)100, new Float(cc.getWidth()));
                break;
            }
            case 3: {
                if (this.selectedRows.isEmpty()) break;
                RowCell rc = (RowCell)this.control.cellSet.getRowCell(this.selectedRows.get(0));
                bm.put((byte)101, new Float(rc.getHeight()));
            }
        }
        return bm;
    }

    public NormalCell getDisplayCell() {
        if (this.isNothingSelected()) {
            return null;
        }
        NormalCell nc = null;
        if (this.control != null) {
            CellLocation cl = this.control.getActiveCell();
            try {
                nc = (NormalCell)this.control.cellSet.getCell(cl.getRow(), cl.getCol());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nc != null) {
                return nc;
            }
        }
        CellRect cr = this.selectedRects.get(0);
        int r = cr.getBeginRow();
        while (r <= cr.getEndRow()) {
            int c = cr.getBeginCol();
            while (c <= cr.getEndCol()) {
                try {
                    nc = (NormalCell)this.control.cellSet.getCell(r, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nc != null) {
                    return nc;
                }
                ++c;
            }
            ++r;
        }
        return null;
    }

    public boolean delete(short cmd) {
        PgmCellSet cellSet = this.control.cellSet;
        int TOTAL_ROWS = cellSet.getRowCount();
        int TOTAL_COLS = cellSet.getColCount();
        if (cmd == 1165) {
            if (TOTAL_COLS == this.selectedCols.size()) {
                GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.notdelallcol"), this.mm.getMessage("public.prompt"), 2);
                return false;
            }
        } else if (cmd == 1164 && TOTAL_ROWS == this.selectedRows.size()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.notdelallrow"), this.mm.getMessage("public.prompt"), 2);
            return false;
        }
        this.deleteRowOrCol(cmd);
        return true;
    }

    public void textEditor() {
        this.control.getContentPanel().submitEditor();
        NormalCell cell = this.getDisplayCell();
        String exp = cell.getExpString();
        DialogTextEditor dte = new DialogTextEditor(GV.appFrame);
        dte.setText(exp);
        try {
            dte.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dte.getOption() == 0) {
            exp = dte.getText();
            AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
            ac.setProperty((byte)1);
            ac.setValue(exp);
            this.executeCmd(ac);
        }
    }

    public boolean note() {
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.notemore"), this.mm.getMessage("public.prompt"), 2);
            return false;
        }
        this.control.getContentPanel().submitEditor();
        CellRect rect = this.getSelectedRect();
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int row = rect.getBeginRow();
        while (row <= rect.getEndRow()) {
            int col = rect.getBeginCol();
            while (col <= rect.getEndCol()) {
                INormalCell cell = this.control.cellSet.getCell(row, col);
                AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                ac.setProperty((byte)1);
                String exp = cell.getExpString();
                if (exp != null) {
                    exp = exp != null && exp.startsWith("//") ? (exp.length() > 3 ? (exp.charAt(2) == '*' ? "/" + exp : exp.substring(2)) : exp.substring(2)) : "/" + exp;
                    ac.setValue(exp);
                    cmds.add(ac);
                }
                ++col;
            }
            ++row;
        }
        if (cmds.isEmpty()) {
            return false;
        }
        return this.executeCmd(cmds);
    }

    public void setTips() {
        Vector<CellRect> rects = this.getSelectedRects();
        if (rects == null) {
            return;
        }
        this.control.getContentPanel().submitEditor();
        DialogInputText dit = new DialogInputText(true);
        dit.setText(this.getDisplayCell().getTip());
        dit.setTitle(this.mm.getMessage("dfxeditor.tip"));
        dit.setVisible(true);
        if (dit.getOption() != 0) {
            return;
        }
        String tips = dit.getText();
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int i = 0;
        while (i < rects.size()) {
            CellRect rect = rects.get(i);
            int row = rect.getBeginRow();
            while (row <= rect.getEndRow()) {
                int col = rect.getBeginCol();
                while (col <= rect.getEndCol()) {
                    INormalCell cell = this.control.cellSet.getCell(row, col);
                    AtomicCell ac = new AtomicCell((SplControl)this.control, cell);
                    ac.setProperty((byte)2);
                    ac.setValue(tips);
                    cmds.add(ac);
                    ++col;
                }
                ++row;
            }
            ++i;
        }
        this.executeCmd(cmds);
    }

    public boolean cut() {
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.cutmore"), this.mm.getMessage("public.prompt"), 2);
            return false;
        }
        return this.copy(true, false);
    }

    public boolean copy() {
        return this.copy(false, false);
    }

    public boolean copy(boolean isCutStatus, boolean valueCopy) {
        Clipboard cb;
        if (this.isNothingSelected()) {
            return false;
        }
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.copymore"));
            return false;
        }
        CellRect cr = this.getSelectedRect();
        Matrix matrix = this.getSelectedMatrix(cr);
        GVSpl.cellSelection = new CellSelection(matrix, cr, this.control.getCellSet(), valueCopy);
        PgmCellSet cellSet = this.control.cellSet;
        ArrayList<IRowCell> rowHeaders = new ArrayList<IRowCell>();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        if (this.selectState == 3) {
            int r = cr.getBeginRow();
            while (r <= cr.getEndRow()) {
                if (parser.isRowVisible(r)) {
                    rowHeaders.add(cellSet.getRowCell(r));
                }
                ++r;
            }
            GVSpl.cellSelection.rowHeaderList = rowHeaders;
        }
        ArrayList<IColCell> colHeaders = new ArrayList<IColCell>();
        if (this.selectState == 4) {
            int c = cr.getBeginCol();
            while (c <= cr.getEndCol()) {
                if (parser.isColVisible(c)) {
                    colHeaders.add(cellSet.getColCell(c));
                }
                ++c;
            }
            GVSpl.cellSelection.colHeaderList = colHeaders;
        }
        if (isCutStatus) {
            GVSpl.cellSelection.setCutStatus();
        }
        GVSpl.cellSelection.setSelectState(this.selectState);
        try {
            cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            cb = null;
        }
        String strCS = GMSpl.getCellSelectionString(matrix, valueCopy);
        if (cb != null) {
            cb.setContents(new StringSelection(strCS), null);
        }
        GVSpl.cellSelection.systemClip = strCS;
        this.control.resetCellSelection(GVSpl.cellSelection);
        return true;
    }

    public boolean canCopyPresent() {
        if (this.isNothingSelected()) {
            return false;
        }
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.copymore"));
            return false;
        }
        CellRect cr = this.getSelectedRect();
        return cr.getRowCount() != 0 && cr.getColCount() != 0;
    }

    public boolean copyPresentDialog() {
        if (!this.canCopyPresent()) {
            return false;
        }
        DialogCopyPresent dcp = new DialogCopyPresent();
        dcp.setVisible(true);
        if (dcp.getOption() != 0) {
            return false;
        }
        return this.copyPresent();
    }

    public boolean copyPresent() {
        String str = this.getCopyPresentString();
        if (!StringUtils.isValidString(str)) {
            return false;
        }
        GM.clipBoard(str);
        return true;
    }

    public String getCopyPresentString() {
        CellRect cr = this.getSelectedRect();
        CellSetParser parser = new CellSetParser(this.control.cellSet);
        String LINE_SEP = GM.getLineSeparator();
        boolean copyHeader = ConfigOptions.bCopyPresentHeader;
        StringBuffer buf = new StringBuffer();
        if (ConfigOptions.iCopyPresentType == 0) {
            int headerWidth = this.control.getRowHeaderPanel().getWidth();
            int headerHeight = this.control.getColHeaderPanel().getHeight();
            int headerFontSize = 12;
            String COL_SEP = "\t";
            boolean isFirstRow = true;
            buf.append("<table class=\"table\">");
            if (copyHeader) {
                buf.append(LINE_SEP);
                buf.append("\t<tr height=" + headerHeight + "px>");
                buf.append(LINE_SEP);
                buf.append("\t\t<td");
                buf.append(" width=" + headerWidth + "px");
                buf.append(" bgcolor=" + this.color2Html(Color.lightGray));
                buf.append(">");
                buf.append("</td>");
                int col = cr.getBeginCol();
                while (col <= cr.getEndCol()) {
                    buf.append(LINE_SEP);
                    buf.append("\t\t<td");
                    buf.append(" width=" + parser.getColWidth(col, this.control.scale) + "px");
                    buf.append(" align=\"center\"");
                    buf.append(" valign=\"center\"");
                    buf.append(" bgcolor=" + this.color2Html(Color.lightGray));
                    buf.append(" style=\"font-size:12px");
                    buf.append(";color:" + this.color2Html(Color.BLACK));
                    buf.append("\">");
                    buf.append(StringUtils.toExcelLabel(col));
                    buf.append("</td>");
                    ++col;
                }
                buf.append(LINE_SEP);
                buf.append("\t</tr>");
                isFirstRow = false;
            }
            int row = cr.getBeginRow();
            while (row <= cr.getEndRow()) {
                if (parser.isRowVisible(row)) {
                    buf.append(LINE_SEP);
                    buf.append("\t<tr height=" + parser.getRowHeight(row, this.control.scale) + "px>");
                    if (copyHeader) {
                        buf.append(LINE_SEP);
                        buf.append("\t\t<td");
                        if (isFirstRow) {
                            buf.append(" width=" + headerWidth + "px");
                        }
                        buf.append(" align=\"center\"");
                        buf.append(" valign=\"center\"");
                        buf.append(" bgcolor=" + this.color2Html(Color.lightGray));
                        buf.append(" style=\"font-size:12px");
                        buf.append(";color:" + this.color2Html(Color.BLACK));
                        buf.append("\">");
                        buf.append(row);
                        buf.append("</td>");
                    }
                    int col = cr.getBeginCol();
                    while (col <= cr.getEndCol()) {
                        if (parser.isColVisible(col)) {
                            buf.append(LINE_SEP);
                            buf.append("\t\t<td");
                            if (isFirstRow) {
                                buf.append(" width=" + parser.getColWidth(col, this.control.scale) + "px");
                            }
                            byte halign = parser.getHAlign(row, col);
                            buf.append(" align=");
                            if (halign == 0) {
                                buf.append("\"left\"");
                            } else if (halign == 4) {
                                buf.append("\"right\"");
                            } else {
                                buf.append("\"center\"");
                            }
                            byte valign = parser.getVAlign(row, col);
                            buf.append(" valign=");
                            if (valign == 8) {
                                buf.append("\"top\"");
                            } else if (valign == 32) {
                                buf.append("\"bottom\"");
                            } else {
                                buf.append("\"center\"");
                            }
                            Color bc = parser.getBackColor(row, col);
                            Color fc = parser.getForeColor(row, col);
                            buf.append(" bgcolor=" + this.color2Html(bc));
                            buf.append(" style=\"font-size:" + GC.font.getSize() + "px");
                            buf.append(";color:" + this.color2Html(fc));
                            buf.append("\">");
                            String text = parser.getDispText(row, col);
                            boolean isBold = parser.isBold(row, col);
                            boolean isItalic = parser.isItalic(row, col);
                            boolean isUnderline = parser.isUnderline(row, col);
                            if (isBold) {
                                buf.append("<b>");
                            }
                            if (isItalic) {
                                buf.append("<i>");
                            }
                            if (isUnderline) {
                                buf.append("<u>");
                            }
                            if (text == null) {
                                buf.append("");
                            } else {
                                buf.append(text);
                            }
                            if (isBold) {
                                buf.append("</b>");
                            }
                            if (isItalic) {
                                buf.append("</i>");
                            }
                            if (isUnderline) {
                                buf.append("</u>");
                            }
                            buf.append("</td>");
                        }
                        ++col;
                    }
                    if (isFirstRow) {
                        isFirstRow = false;
                    }
                    buf.append(LINE_SEP);
                    buf.append("\t</tr>");
                }
                ++row;
            }
            buf.append(LINE_SEP);
            buf.append("</table>");
        } else {
            String COL_SEP = ConfigOptions.sCopyPresentSep;
            if (copyHeader) {
                buf.append("");
                int col = cr.getBeginCol();
                while (col <= cr.getEndCol()) {
                    buf.append(COL_SEP);
                    buf.append(StringUtils.toExcelLabel(col));
                    ++col;
                }
                buf.append(LINE_SEP);
            }
            int row = cr.getBeginRow();
            while (row <= cr.getEndRow()) {
                if (parser.isRowVisible(row)) {
                    if (copyHeader) {
                        buf.append(row);
                        buf.append(COL_SEP);
                    }
                    int col = cr.getBeginCol();
                    while (col <= cr.getEndCol()) {
                        if (parser.isColVisible(col)) {
                            String text;
                            if (col > cr.getBeginCol()) {
                                buf.append(COL_SEP);
                            }
                            if ((text = parser.getDispText(row, col)) == null) {
                                buf.append("");
                            } else {
                                buf.append(text);
                            }
                        }
                        ++col;
                    }
                    if (row < cr.getEndRow()) {
                        buf.append(LINE_SEP);
                    }
                }
                ++row;
            }
        }
        return buf.toString();
    }

    private String color2Html(Color color) {
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        if (R.length() == 1) {
            R = "0" + R;
        }
        if (G.length() == 1) {
            G = "0" + G;
        }
        if (B.length() == 1) {
            B = "0" + B;
        }
        return "#" + R + G + B;
    }

    public boolean codeCopy() {
        CellRect cr;
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.copymore"));
            return false;
        }
        CellSetParser parser = new CellSetParser(this.control.cellSet);
        if (this.isNothingSelected()) {
            int rc = parser.getRowCount();
            int cc = parser.getColCount();
            int minRow = rc;
            int minCol = cc;
            int maxRow = 1;
            int maxCol = 1;
            int row = 1;
            while (row <= rc) {
                if (parser.isRowVisible(row)) {
                    int col = 1;
                    while (col <= cc) {
                        NormalCell cell = parser.getCell(row, col);
                        if (StringUtils.isValidString(cell.getExpString())) {
                            minRow = Math.min(minRow, row);
                            minCol = Math.min(minCol, col);
                            maxRow = Math.max(maxRow, row);
                            maxCol = Math.max(maxCol, col);
                        }
                        ++col;
                    }
                }
                ++row;
            }
            cr = new CellRect(minRow, minCol, maxRow - minRow + 1, maxCol - minCol + 1);
        } else {
            cr = this.getSelectedRect();
        }
        PgmCellSet fromCellSet = this.control.cellSet;
        PgmCellSet toCellSet = new PgmCellSet(cr.getRowCount(), cr.getColCount());
        int i = 0;
        while (i < cr.getRowCount()) {
            int j = 0;
            while (j < cr.getColCount()) {
                PgmNormalCell fromCell = fromCellSet.getPgmNormalCell(cr.getBeginRow() + i, cr.getBeginCol() + j);
                PgmNormalCell toCell = toCellSet.getPgmNormalCell(i + 1, j + 1);
                toCell.setExpString(fromCell.getExpString());
                ++j;
            }
            ++i;
        }
        String expStr = CellSetUtil.toString(toCellSet);
        if (!expStr.startsWith("#")) {
            if (cr.getRowCount() > 1 || cr.getColCount() > 1) {
                expStr = "=" + expStr;
            } else if (!(expStr.startsWith("=") || expStr.startsWith(">") || expStr.startsWith("$"))) {
                expStr = "=" + expStr;
            }
        }
        GM.clipBoard(Escape.addEscAndQuote(expStr));
        return true;
    }

    private Matrix getSelectedMatrix(CellRect rect) {
        return GMSpl.getMatrixCells(this.control.cellSet, rect);
    }

    public boolean expandRow(int row) {
        CellSetParser parser = new CellSetParser(this.control.cellSet);
        int subEnd = parser.getSubEnd(row);
        if (subEnd <= row) {
            return false;
        }
        boolean isExpand = parser.isSubExpand(row, subEnd);
        int r = row + 1;
        while (r <= subEnd) {
            RowCell rc = (RowCell)this.control.cellSet.getRowCell(r);
            rc.setVisible(isExpand ? (byte)1 : 0);
            ++r;
        }
        this.setDataChanged(true);
        return true;
    }

    public boolean paste(boolean isAdjustSelf) {
        return this.paste(isAdjustSelf, (byte)0);
    }

    public boolean paste(boolean isAdjustSelf, byte pasteOption) {
        Object clip;
        int curRow = 1;
        int curCol = 1;
        if (pasteOption != 0) {
            CellRect cr = this.getSelectedRect();
            this.selectedRects.clear();
            curRow = cr.getBeginRow();
            curCol = cr.getBeginCol();
            this.selectedRects.add(new CellRect(curRow, curCol, 1, 1));
        }
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.pastemore"));
            return false;
        }
        CellRect targetArea = new CellRect(curRow, curCol, 1, 1);
        Vector<IAtomicCmd> cmds = null;
        String sysclip = GM.clipBoard(false);
        if (GVSpl.cellSelection != null && GVSpl.cellSelection.srcCellSet instanceof PgmCellSet && (clip = GVSpl.cellSelection.systemClip).equals(sysclip)) {
            if (pasteOption != 0) {
                targetArea.setRowCount(GVSpl.cellSelection.matrix.getRowSize());
                targetArea.setColCount(GVSpl.cellSelection.matrix.getColSize());
                try {
                    cmds = this.executePasteOption(targetArea, pasteOption);
                }
                catch (Exception e) {
                    GM.messageDialog(GV.appFrame, e.getMessage());
                    return false;
                }
            }
            return this.pasteCell(isAdjustSelf, cmds);
        }
        if (StringUtils.isValidString(sysclip)) {
            String data;
            if (pasteOption != 0 && StringUtils.isValidString(data = sysclip)) {
                Matrix matrix = GMSpl.string2Matrix(data);
                targetArea.setRowCount(matrix.getRowSize());
                targetArea.setColCount(matrix.getColSize());
                try {
                    cmds = this.executePasteOption(targetArea, pasteOption);
                }
                catch (Exception e) {
                    GM.messageDialog(GV.appFrame, e.getMessage());
                    return false;
                }
            }
            return this.pasteValue(cmds);
        }
        return false;
    }

    private Vector<IAtomicCmd> executePasteOption(CellRect rect, byte option) throws Exception {
        CellSelection cs = GV.cellSelection;
        switch (option) {
            case 1: {
                Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
                cmds.add(this.getInsertRow(true, new CellRect(rect.getBeginRow(), rect.getBeginCol(), rect.getRowCount(), 1)));
                return cmds;
            }
            case 2: {
                Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
                cmds.add(this.getInsertCol(true, new CellRect(rect.getBeginRow(), rect.getBeginCol(), 1, rect.getColCount())));
                return cmds;
            }
            case 4: {
                try {
                    this.hotKeyInsert((byte)2, rect);
                    break;
                }
                catch (Exception x) {
                    throw new RQException(this.mm.getMessage("dfxeditor.notenoughrows"));
                }
            }
            case 3: {
                try {
                    this.hotKeyInsert((byte)3, rect);
                    break;
                }
                catch (Exception x) {
                    throw new RQException(this.mm.getMessage("dfxeditor.notenoughcols"));
                }
            }
        }
        this.control.resetCellSelection(cs);
        return null;
    }

    private boolean pasteCell(boolean isAdjustSelf, Vector<IAtomicCmd> cmds) {
        boolean isCut;
        CellRect targetRect;
        if (cmds == null) {
            cmds = new Vector();
        }
        if ((targetRect = this.getSelectedRect()) == null) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.notselecttarget"));
            return false;
        }
        CellSelection cs = GVSpl.cellSelection;
        if (cs == null) {
            return false;
        }
        if (cs.isCutStatus() && cs.srcCellSet != this.control.getCellSet()) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("spleditor.notcutothersheet"));
            return false;
        }
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        cs.setAdjustSelf(isAdjustSelf);
        targetRect.setColCount(cs.matrix.getColSize());
        targetRect.setRowCount(cs.matrix.getRowSize());
        boolean bl = isCut = cs.srcCellSet == this.control.getCellSet() && cs.isCutStatus();
        if (isCut) {
            cmds = GMSpl.getMoveRectCmd(this, cs.rect, targetRect);
            GM.clipBoard(null);
        } else {
            Area area;
            int hideRowCount = 0;
            int r = targetRect.getBeginRow();
            while (r <= this.control.cellSet.getRowCount()) {
                if (!parser.isRowVisible(r)) {
                    ++hideRowCount;
                }
                ++r;
            }
            if (targetRect.getEndRow() + hideRowCount > this.control.cellSet.getRowCount()) {
                int addRowCount = targetRect.getEndRow() + hideRowCount - this.control.cellSet.getRowCount();
                cmds.add(this.getAppendRows(addRowCount));
            }
            int hideColCount = 0;
            int c = targetRect.getBeginCol();
            while (c <= this.control.cellSet.getColCount()) {
                if (!parser.isColVisible(c)) {
                    ++hideColCount;
                }
                ++c;
            }
            if (targetRect.getEndCol() + hideColCount > this.control.cellSet.getColCount()) {
                int addColCount = targetRect.getEndCol() + hideColCount - this.control.cellSet.getColCount();
                cmds.add(this.getAppendCols(addColCount));
            }
            if ((area = this.control.getSelectedArea(0)).getEndRow() == area.getBeginRow() && area.getBeginCol() == area.getEndCol()) {
                int endRow = targetRect.getEndRow();
                int rc = 0;
                int r2 = targetRect.getBeginRow();
                while (r2 <= this.control.cellSet.getRowCount()) {
                    if (parser.isRowVisible(r2) && ++rc >= targetRect.getRowCount()) {
                        endRow = r2;
                        break;
                    }
                    ++r2;
                }
                int endCol = targetRect.getEndCol();
                int cc = 0;
                int c2 = targetRect.getBeginCol();
                while (c2 <= this.control.cellSet.getColCount()) {
                    if (parser.isColVisible(c2) && ++cc >= targetRect.getColCount()) {
                        endCol = c2;
                        break;
                    }
                    ++c2;
                }
                area = new Area(targetRect.getBeginRow(), targetRect.getBeginCol(), endRow, endCol);
                targetRect = new CellRect(area);
            } else if (this.selectState == cs.selectState && (this.selectState == 3 && this.selectedRows.size() == 1 || this.selectState == 4 && this.selectedCols.size() == 1)) {
                area = new Area(targetRect.getBeginRow(), targetRect.getBeginCol(), targetRect.getEndRow(), targetRect.getEndCol());
                targetRect = new CellRect(area);
            }
            AtomicSpl ar = new AtomicSpl(this.control);
            ar.setType((byte)13);
            ar.setRect(targetRect);
            ar.setValue(cs);
            cmds.add(ar);
        }
        this.executeCmd(cmds);
        if (!isCut) {
            this.control.resetCellSelection(cs);
        } else {
            this.moveRect();
        }
        return true;
    }

    protected void moveRect() {
    }

    private boolean isCellIgnoreable(CellSetParser parser, CellLocation cp) {
        if (!parser.isRowVisible(cp.getRow()) || !parser.isColVisible(cp.getCol())) {
            return true;
        }
        INormalCell cell = this.control.getCellSet().getCell(cp.getRow(), cp.getCol());
        return cell == null;
    }

    private boolean pasteValue(Vector<IAtomicCmd> cmds) {
        CellRect targetRect = this.getSelectedRect();
        if (targetRect == null) {
            GM.messageDialog(GV.appFrame, this.mm.getMessage("dfxeditor.notselecttarget"));
            return false;
        }
        Matrix matrix = GM.getClipboardMatrix();
        if (matrix == null) {
            return false;
        }
        targetRect.setColCount(matrix.getColSize());
        targetRect.setRowCount(matrix.getRowSize());
        CellSetParser parser = new CellSetParser(this.control.cellSet);
        int rc = 0;
        int r = targetRect.getBeginRow();
        while (r <= this.control.cellSet.getRowCount()) {
            if (parser.isRowVisible(r)) {
                ++rc;
            }
            if (rc >= matrix.getRowSize()) break;
            ++r;
        }
        if (rc < matrix.getRowSize()) {
            int addRowCount = matrix.getRowSize() - rc;
            this.appendRows(addRowCount);
        }
        int cc = 0;
        int c = targetRect.getBeginCol();
        while (c <= this.control.cellSet.getColCount()) {
            if (parser.isColVisible(c)) {
                ++cc;
            }
            if (cc >= matrix.getColSize()) break;
            ++c;
        }
        if (cc < matrix.getColSize()) {
            int addColCount = matrix.getColSize() - cc;
            this.appendCols(addColCount);
        }
        if (cmds == null) {
            cmds = new Vector();
        }
        AtomicSpl ar = new AtomicSpl(this.control);
        ar.setType((byte)14);
        ar.setRect(targetRect);
        ar.setValue(matrix);
        cmds.add(ar);
        this.executeCmd(cmds);
        return true;
    }

    public boolean clear(byte clearType) {
        if (this.isNothingSelected()) {
            return false;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int i = 0;
        while (i < this.selectedRects.size()) {
            CellRect rect = this.selectedRects.get(i);
            Vector<IAtomicCmd> tmp = this.getClearRectCmds(rect, clearType);
            if (tmp != null) {
                cmds.addAll(tmp);
            }
            ++i;
        }
        this.executeCmd(cmds);
        this.control.getContentPanel().initEditor((byte)2);
        return true;
    }

    public Vector<IAtomicCmd> getClearRectCmds(CellRect rect, byte clearType) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        switch (clearType) {
            case 0: {
                cmds.addAll(this.getClearCmds(rect, (byte)1));
                cmds.addAll(this.getClearCmds(rect, (byte)0));
                cmds.addAll(this.getClearCmds(rect, (byte)2));
                break;
            }
            case 1: {
                cmds.addAll(this.getClearCmds(rect, (byte)1));
                break;
            }
            case 2: {
                cmds.addAll(this.getClearCmds(rect, (byte)0));
            }
        }
        return cmds;
    }

    private Vector<IAtomicCmd> getClearCmds(CellRect rect, byte cmdType) {
        PgmCellSet cs = this.control.cellSet;
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int r = rect.getBeginRow();
        while (r <= rect.getEndRow()) {
            int c = rect.getBeginCol();
            while (c <= rect.getEndCol()) {
                NormalCell nc = (NormalCell)cs.getCell(r, c);
                AtomicCell ac = new AtomicCell((SplControl)this.control, nc);
                ac.setProperty(cmdType);
                ac.setValue(null);
                cmds.add(ac);
                ++c;
            }
            ++r;
        }
        return cmds;
    }

    private void deleteRowOrCol(short cmd) {
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        int i = 0;
        while (i < this.selectedRects.size()) {
            CellRect rect = this.selectedRects.get(i);
            switch (cmd) {
                case 1164: {
                    AtomicSpl aqr = new AtomicSpl(this.control);
                    aqr.setType((byte)3);
                    aqr.setRect(rect);
                    cmds.add(aqr);
                    int r = rect.getBeginRow();
                    while (r <= rect.getEndRow()) {
                        this.control.removeRowBreakPoints(r);
                        ++r;
                    }
                    break;
                }
                case 1165: {
                    AtomicSpl aqc = new AtomicSpl(this.control);
                    aqc.setType((byte)4);
                    aqc.setRect(rect);
                    cmds.add(aqc);
                    int c = rect.getBeginCol();
                    while (c <= rect.getEndCol()) {
                        this.control.removeColBreakPoints(c);
                        ++c;
                    }
                    break;
                }
            }
            ++i;
        }
        this.executeCmd(cmds);
        CellRect rect = this.getSelectedRect();
        if (rect != null) {
            PgmCellSet cs = this.control.getCellSet();
            if (rect.getEndRow() > cs.getRowCount() || rect.getEndCol() > cs.getColCount()) {
                this.control.clearSelectedAreas();
            }
        }
    }

    public void setSelectedAreas(Vector<Object> selectedAreas) {
        this.selectedAreas = selectedAreas;
    }

    public void resetSelectedAreas() {
        this.control.setSelectedAreas(this.selectedAreas);
        if (this.selectedAreas != null && !this.selectedAreas.isEmpty()) {
            Area area;
            int i = 0;
            while (i < this.selectedAreas.size()) {
                area = (Area)this.selectedAreas.get(i);
                if (area.getEndRow() > this.control.cellSet.getRowCount()) {
                    this.selectedAreas.clear();
                    int endRow = this.control.cellSet.getRowCount();
                    if (this.selectState == 3) {
                        this.selectedAreas.add(new Area(endRow, 1, endRow, this.control.cellSet.getColCount()));
                        break;
                    }
                    if (this.selectState != 1) break;
                    this.selectedAreas.add(new Area(endRow, area.getBeginCol(), endRow, area.getEndCol()));
                    break;
                }
                if (area.getEndCol() > this.control.cellSet.getColCount()) {
                    this.selectedAreas.clear();
                    int endCol = this.control.cellSet.getColCount();
                    if (this.selectState == 4) {
                        this.selectedAreas.add(new Area(1, endCol, this.control.cellSet.getRowCount(), endCol));
                        break;
                    }
                    if (this.selectState != 1) break;
                    this.selectedAreas.add(new Area(area.getBeginRow(), endCol, area.getEndRow(), endCol));
                    break;
                }
                ++i;
            }
            if (!this.selectedAreas.isEmpty()) {
                int r;
                int i2;
                if (this.selectState == 3) {
                    this.selectedRows.clear();
                    i2 = 0;
                    while (i2 < this.selectedAreas.size()) {
                        area = (Area)this.selectedAreas.get(i2);
                        int bc = area.getBeginCol();
                        int ec = area.getEndCol();
                        if (bc == 1 && ec == this.control.cellSet.getColCount()) {
                            r = area.getBeginRow();
                            while (r <= area.getEndRow()) {
                                this.selectedRows.add(new Integer(r));
                                ++r;
                            }
                        }
                        ++i2;
                    }
                } else if (this.selectState == 4) {
                    this.selectedCols.clear();
                    i2 = 0;
                    while (i2 < this.selectedAreas.size()) {
                        area = (Area)this.selectedAreas.get(i2);
                        int br = area.getBeginRow();
                        int er = area.getEndRow();
                        if (br == 1 && er == this.control.cellSet.getRowCount()) {
                            r = area.getBeginCol();
                            while (r <= area.getEndCol()) {
                                this.selectedCols.add(new Integer(r));
                                ++r;
                            }
                        }
                        ++i2;
                    }
                }
                this.selectedRects.clear();
                i = 0;
                while (i < this.selectedAreas.size()) {
                    this.selectedRects.add(new CellRect((Area)this.selectedAreas.get(i)));
                    ++i;
                }
            }
        }
        if (this.selectedAreas == null || this.selectedAreas.isEmpty()) {
            this.selectedRects.clear();
            this.selectedRows.clear();
            this.selectedCols.clear();
            this.control.m_activeCell = null;
            this.setSelectState((byte)0);
        }
    }

    public void resetEditor() {
        this.resetSelectedAreas();
        this.redrawRowHeader();
        this.resetActiveCell();
    }

    public void resetActiveCell() {
        NormalCell cell = this.getDisplayCell();
        if (cell != null) {
            CellSetParser parser = new CellSetParser(this.control.cellSet);
            int row = cell.getRow();
            int col = cell.getCol();
            int rc = this.control.cellSet.getRowCount();
            int cc = this.control.cellSet.getColCount();
            if (cell != null && row <= rc && col <= cc) {
                PgmNormalCell cellNew = this.control.cellSet.getPgmNormalCell(row, col);
                if (cellNew != cell) {
                    this.control.setActiveCell(new CellLocation(cell.getRow(), cell.getCol()), false);
                }
                if (!parser.isRowVisible(row) || ((ColCell)this.control.cellSet.getColCell(col)).getVisible() == 1) {
                    this.control.setActiveCell(null, false);
                }
            }
        }
    }

    public void redrawRowHeader() {
        this.control.getRowHeader().updateUI();
    }

    private void setSelectState(byte state) {
        this.selectState = state;
        ((SheetSpl)GVSpl.appSheet).selectState = state;
    }

    public void selectAreas(boolean scrollActiveCellToVisible) {
        if (this.selectedAreas != null && !this.selectedAreas.isEmpty()) {
            Area area = (Area)this.selectedAreas.get(0);
            CellLocation pos = this.control.getActiveCell();
            CellSetParser parser = new CellSetParser(this.control.cellSet);
            int row = area.getBeginRow();
            int col = area.getBeginCol();
            if (pos == null || pos.getRow() != row || pos.getCol() != col) {
                if (!parser.isRowVisible(row) || !parser.isColVisible(col)) {
                    this.control.m_activeCell = null;
                    this.setSelectState((byte)0);
                } else {
                    this.control.setActiveCell(new CellLocation(row, col), false, scrollActiveCellToVisible);
                    if (this.selectState == 0) {
                        if (this.selectedRows != null && !this.selectedRows.isEmpty()) {
                            this.setSelectState((byte)3);
                        } else if (this.selectedCols != null && !this.selectedCols.isEmpty()) {
                            this.setSelectState((byte)4);
                        } else {
                            this.setSelectState((byte)1);
                        }
                    }
                    GVSpl.toolBarProperty.refresh(this.selectState, this.getProperty());
                }
            }
        }
    }

    protected void altC() {
    }

    protected void altV() {
    }

    public void ctrlBackSpace() {
        CellLocation activeCell = this.control.getActiveCell();
        if (activeCell == null) {
            return;
        }
        int curCol = activeCell.getCol();
        int curRow = activeCell.getRow();
        PgmCellSet ics = this.control.getCellSet();
        if (curCol > 1) {
            int moveCols = ics.getColCount() - curCol + 1;
            CellRect srcRect = new CellRect(curRow, curCol, 1, moveCols);
            CellRect tarRect = new CellRect(curRow, curCol - 1, 1, moveCols);
            this.moveRect(srcRect, tarRect);
        } else if (curRow > 1) {
            int topUsedCols = this.getUsedCols(ics, curRow - 1);
            this.connectRowUpTo(curRow, topUsedCols + 1);
        }
    }

    public void ctrlDelete() {
        CellLocation activeCell;
        Area a = null;
        CellRect rect = null;
        if (this.control.getSelectedAreas().size() > 0) {
            a = this.control.getSelectedArea(0);
            rect = new CellRect(a);
        }
        if ((activeCell = this.control.getActiveCell()) == null) {
            return;
        }
        PgmCellSet ics = this.control.getCellSet();
        int curCol = activeCell.getCol();
        int curRow = activeCell.getRow();
        int usedCols = this.getUsedCols(ics, curRow);
        if (a.getBeginRow() == a.getEndRow() && a.getBeginCol() == a.getEndCol() && usedCols <= curCol && curRow < ics.getRowCount()) {
            this.connectRowUpTo(curRow + 1, curCol);
        } else {
            int moveCols = ics.getColCount() - a.getEndCol();
            CellRect srcRect = new CellRect(a.getBeginRow(), a.getEndCol() + 1, rect.getRowCount(), moveCols);
            CellRect tarRect = new CellRect(a.getBeginRow(), a.getBeginCol(), rect.getRowCount(), moveCols);
            this.moveRect(srcRect, tarRect);
        }
        this.control.contentView.reloadEditorText();
    }

    private boolean moveRect(CellRect srcRect, CellRect tarRect) {
        return this.moveRect(srcRect, tarRect, true);
    }

    private boolean moveRect(CellRect srcRect, CellRect tarRect, boolean scrollToTarget) {
        Vector<IAtomicCmd> cmds = GMSpl.getMoveRectCmd(this, srcRect, tarRect);
        if (cmds == null) {
            return false;
        }
        this.executeCmd(cmds);
        if (scrollToTarget) {
            this.control.scrollToArea(this.control.setActiveCell(new CellLocation(tarRect.getBeginRow(), tarRect.getBeginCol())));
        }
        return true;
    }

    private void connectRowUpTo(int connectRow, int upCol) {
        CellRect tarRect;
        CellRect srcRect;
        Vector<IAtomicCmd> cmds;
        PgmCellSet cellSet = this.control.getCellSet();
        int usedCols = this.getUsedCols(cellSet, connectRow);
        if (usedCols == 0) {
            usedCols = 1;
        }
        if ((cmds = GMSpl.getMoveRectCmd(this, srcRect = new CellRect(connectRow, 1, 1, usedCols), tarRect = new CellRect(connectRow - 1, upCol, 1, usedCols))) != null && !cmds.isEmpty()) {
            AtomicSpl cmd = new AtomicSpl(this.control);
            cmd.setType((byte)3);
            CellRect rect = new CellRect(connectRow, 1, 1, cellSet.getColCount());
            cmd.setRect(rect);
            cmds.add(cmd);
            this.executeCmd(cmds);
            this.control.scrollToArea(this.control.setActiveCell(new CellLocation(tarRect.getBeginRow(), tarRect.getBeginCol())));
        }
    }

    private int getUsedCols(CellSet ics, int row) {
        int colCount = ics.getColCount();
        return colCount - this.getEmptyColumns(ics, row);
    }

    private int getEmptyColumns(CellSet ics, int row) {
        int colCount;
        int c = colCount = ics.getColCount();
        while (c >= 1) {
            INormalCell nc = ics.getCell(row, c);
            if (StringUtils.isValidString(nc.getExpString())) {
                return colCount - c;
            }
            --c;
        }
        return colCount;
    }
}

