/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.control;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.Area;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.CellLocation;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.excel.ExcelApi;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAtomicCmd;
import com.scudata.ide.common.control.CellRect;
import com.scudata.ide.common.control.CellSelection;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.AtomicCell;
import com.scudata.ide.spl.AtomicSpl;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.SheetSplSE;
import com.scudata.ide.spl.control.CellSetParser;
import com.scudata.ide.spl.control.EditControl;
import com.scudata.ide.spl.control.EditControlSE;
import com.scudata.ide.spl.control.SplControl;
import com.scudata.ide.spl.control.SplEditor;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.ide.spl.resources.IdeSplSEMessage;
import com.scudata.resources.EngineMessage;
import java.lang.reflect.Field;
import java.security.Key;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.swing.JOptionPane;

public class SplEditorSE
extends SplEditor {
    private static final String COL_SEP = "\t";
    private static final String ROW_SEP = "\n";
    private static final int EXCEL_EXP_LENGTH = 240;
    private static long serialNo = 64L;
    public static final int P_MODEL = 0;
    public static final int P_RPT = 1;
    public static final int P_CALC = 3;
    public static final int P_SPLDES = 4;
    public static final int P_SPLSTD = 5;
    public static final int P_SPLENT = 6;
    public static final int P_SPLPRO = 7;
    public static final int T_TRAIL = 2;
    public static final int T_SUBS = 1;
    public static final int T_SALE = 3;
    public static final int T_FREE = 0;
    public static int[] productIds = null;

    public SplEditorSE(SheetSplSE sheet) {
        super(sheet);
    }

    @Override
    protected EditControl newEditControl(int rows, int cols) {
        EditControlSE control = new EditControlSE((SheetSplSE)this.sheet, rows, cols);
        control.setSheet(this.sheet);
        return control;
    }

    protected boolean checkSN() {
        return GMSplSE.checkSerialNo();
    }

    public boolean excelCopy() {
        if (!this.checkSN()) {
            return false;
        }
        try {
            this.control.getContentPanel().submitEditor();
            PgmCellSet cellSet = this.control.cellSet;
            int startRow = 1;
            int startCol = 1;
            int endRow = cellSet.getRowCount();
            int endCol = cellSet.getColCount();
            int r = cellSet.getRowCount();
            while (r >= 1) {
                if (!this.isUselessRow(r)) {
                    endRow = r;
                    break;
                }
                --r;
            }
            int c = cellSet.getColCount();
            while (c >= 1) {
                if (!this.isUselessCol(c)) {
                    endCol = c;
                    break;
                }
                --c;
            }
            ArrayList<String> params = new ArrayList<String>();
            ArrayList<String> usedParams = new ArrayList<String>();
            ParamList pl = cellSet.getParamList();
            if (pl != null) {
                int i = 0;
                while (i < pl.count()) {
                    params.add(pl.get(i).getName());
                    ++i;
                }
            }
            StringBuffer buf = new StringBuffer();
            int r2 = startRow;
            while (r2 <= endRow) {
                if (r2 > startRow) {
                    buf.append(ROW_SEP);
                }
                int c2 = startCol;
                while (c2 <= endCol) {
                    String cellExpStr;
                    PgmNormalCell cell;
                    if (c2 > startCol) {
                        buf.append(COL_SEP);
                    }
                    if (!this.isUselessCell(cell = cellSet.getPgmNormalCell(r2, c2)) && StringUtils.isValidString(cellExpStr = cell.getExpString())) {
                        if (!cell.isConstCell()) {
                            cellExpStr = this.replaceCopyParam(cellExpStr, params, usedParams);
                        }
                        buf.append(cellExpStr);
                    }
                    ++c2;
                }
                ++r2;
            }
            String spl = buf.toString();
            spl = this.addEscAndQuote(spl, '\"');
            String[] spls = SplEditorSE.splitExcelSpl(spl);
            buf = new StringBuffer();
            String funcName = GMSplSE.getExcelAddinFuncName();
            buf.append("=" + funcName + "(");
            int i = 0;
            while (i < spls.length) {
                if (i > 0) {
                    buf.append(",\"");
                }
                buf.append(spls[i]);
                if (i < spls.length - 1) {
                    buf.append("\\");
                    buf.append("\"");
                }
                ++i;
            }
            if (!usedParams.isEmpty()) {
                for (String pname : usedParams) {
                    buf.append(",");
                    pname = Escape.removeEscAndQuote(pname);
                    buf.append(pname);
                }
            }
            buf.append(")");
            GM.clipBoard(buf.toString());
        }
        catch (Exception ex) {
            GM.showException(GV.appFrame, ex);
            return false;
        }
        return true;
    }

    private String addEscAndQuote(String str, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] sb = new char[2 * len + 2];
        sb[0] = 34;
        int j = 1;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    sb[j++] = escapeChar;
                    sb[j++] = 34;
                    break;
                }
                default: {
                    sb[j++] = ch;
                }
            }
            ++i;
        }
        sb[j++] = 34;
        return new String(sb, 0, j);
    }

    private boolean isUselessRow(int r) {
        int c = 1;
        while (c <= this.control.cellSet.getColCount()) {
            if (!this.isUselessCell(this.control.cellSet.getPgmNormalCell(r, c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private boolean isUselessCol(int c) {
        int r = 1;
        while (r <= this.control.cellSet.getRowCount()) {
            if (!this.isUselessCell(this.control.cellSet.getPgmNormalCell(r, c))) {
                return false;
            }
            ++r;
        }
        return true;
    }

    private boolean isUselessCell(PgmNormalCell cell) {
        if (cell == null) {
            return true;
        }
        return cell.isBlankCell() || cell.isNoteCell() || cell.isNoteBlock();
    }

    private String replaceCopyParam(String expStr, List<String> params, List<String> usedParams) {
        if (expStr == null) {
            return null;
        }
        int len = expStr.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            int index;
            int match;
            char c = expStr.charAt(i);
            if (c == '\"' || c == '\'') {
                int match2 = Sentence.scanQuotation(expStr, i);
                if (match2 == -1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
                }
                String arg = null;
                if (c == '\'') {
                    String name = expStr.substring(i, match2 + 1);
                    boolean isParam = params.contains(name);
                    if (!isParam) {
                        if (name != null) {
                            name = Escape.removeEscAndQuote(name);
                        }
                        if (!(isParam = params.contains(name)) && GMSplSE.isExcelName(name)) {
                            isParam = true;
                        }
                    }
                    if (isParam) {
                        int pIndex = usedParams.indexOf(name);
                        if (pIndex < 0) {
                            usedParams.add(name);
                            pIndex = usedParams.size() - 1;
                        }
                        arg = "?" + (pIndex + 1);
                    }
                }
                if (arg != null) {
                    buf.append(arg);
                } else {
                    buf.append(expStr.substring(i, match2 + 1));
                }
                i = ++match2;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                buf.append(c);
                ++i;
                continue;
            }
            String id = AppUtil.scanId(expStr, i);
            if (id.equals("$") && AppUtil.isNextChar('[', expStr, i) && (match = Sentence.scanBracket(expStr, index = expStr.indexOf(91, i))) != -1) {
                buf.append(expStr.substring(i, match));
                i = match + 1;
                continue;
            }
            String arg = null;
            if (params.contains(id) && (i == 0 || '.' != expStr.charAt(i - 1))) {
                boolean needTrans = true;
                if (GMSplSE.isExcelCellName(id)) {
                    try {
                        CellLocation cl = CellLocation.parse(id);
                        if (this.control.cellSet.getRowCount() >= cl.getRow() && this.control.cellSet.getColCount() >= cl.getCol()) {
                            needTrans = false;
                        }
                    }
                    catch (Exception cl) {
                        // empty catch block
                    }
                }
                if (needTrans) {
                    int pIndex = usedParams.indexOf(id);
                    if (pIndex < 0) {
                        usedParams.add(id);
                        pIndex = usedParams.size() - 1;
                    }
                    arg = "?" + (pIndex + 1);
                }
            }
            if (arg != null) {
                buf.append(arg);
            } else {
                buf.append(id);
            }
            i += id.length();
        }
        return buf.toString();
    }

    private static String[] splitExcelSpl(String spl) {
        ArrayList<String> spls = new ArrayList<String>();
        while (spl.length() > 240) {
            int endIndex = 240;
            if (spl.charAt(endIndex) == '\"' && spl.charAt(endIndex - 1) == '\"') {
                int i = endIndex - 1;
                while (i >= 0) {
                    if (spl.charAt(i) != '\"') {
                        endIndex = i;
                        break;
                    }
                    --i;
                }
            }
            if (endIndex <= 1) {
                endIndex = 240;
            }
            spls.add(spl.substring(0, endIndex));
            spl = spl.substring(endIndex);
        }
        spls.add(spl);
        return spls.toArray(new String[spls.size()]);
    }

    public static void setSerialNo(String s) throws Exception {
        long n = SplEditorSE.dec(s);
        long check = n >>> 16 & 0xFFFFL;
        serialNo = n;
    }

    public static int getType() {
        return (int)(serialNo & 3L);
    }

    public static int getProduct() {
        return (int)(serialNo >>> 3 & 7L);
    }

    public static int getTimeout() {
        return (int)(serialNo >>> 6 & 0x3FFL);
    }

    public static long getExpiration() {
        int n = SplEditorSE.getTimeout();
        if (n <= 0) {
            return 0L;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(2020, 0, 1, 0, 0, 0);
        gc.add(2, n);
        return gc.getTimeInMillis();
    }

    public static int getCheck() {
        return (int)(serialNo >>> 16 & 0xFFFFL);
    }

    public static int getFPs() {
        return (int)(serialNo >>> 56 & 0xFFL);
    }

    public static boolean getFP(int p) {
        return (serialNo >>> 56 + p & 1L) == 1L;
    }

    public static int getNo() {
        return (int)(serialNo >>> 32 & 0xFFFFFFL);
    }

    private static long dec(String s) throws Exception {
        byte[] pwd = "(A3+&7)~".getBytes("utf-8");
        DESKeySpec dks = new DESKeySpec(pwd);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
        SecretKey key = skf.generateSecret(dks);
        byte[] iv = "12345678".getBytes("utf-8");
        IvParameterSpec ips = new IvParameterSpec(iv);
        long v = SplEditorSE.toLong(s);
        byte[] input = SplEditorSE.toBytes(v);
        Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
        cipher.init(2, (Key)key, ips);
        byte[] output = cipher.doFinal(input);
        return SplEditorSE.toLong(output);
    }

    private static byte[] toBytes(long v) {
        byte[] buf = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return buf;
    }

    private static long toLong(byte[] buf) {
        return ((long)buf[0] << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + (long)((buf[5] & 0xFF) << 16) + (long)((buf[6] & 0xFF) << 8) + (long)((buf[7] & 0xFF) << 0);
    }

    private static String toStr(long ll) {
        String map = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456";
        StringBuilder sb = new StringBuilder(13);
        int i = 12;
        while (i >= 0) {
            long x = ll >>> 5 * i;
            sb.append(map.charAt((int)(x &= 0x1FL)));
            --i;
        }
        return sb.toString();
    }

    private static long toLong(String s) {
        String map = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456";
        long ll = 0L;
        if (s.length() != 13) {
            throw new RuntimeException("invalid serial number length");
        }
        int i = 0;
        while (i < 13) {
            char ch = s.charAt(i);
            long pos = map.indexOf(ch);
            if (pos < 0L) {
                throw new RuntimeException("invalid char");
            }
            ll += (pos <<= (12 - i) * 5);
            ++i;
        }
        return ll;
    }

    public static void deleteSN() {
        serialNo = 64L;
    }

    public static boolean isFree() {
        try {
            SplEditorSE.checkSerialNo();
            return SplEditorSE.getType() == 0;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static boolean isTrial() {
        return SplEditorSE.getType() == 2;
    }

    public static boolean isSubs() {
        return SplEditorSE.getType() == 1;
    }

    public static boolean isSale() {
        return SplEditorSE.getType() == 3;
    }

    public static void setSerialNo(int[] productIds, String serialNoStr) throws Exception {
        SplEditorSE.productIds = productIds;
        if (!StringUtils.isValidString(serialNoStr)) {
            throw new Exception(SplEditorSE.getNoSNMessage());
        }
        serialNoStr = serialNoStr.trim();
        long oldSerialNo = serialNo;
        try {
            SplEditorSE.setSerialNo(serialNoStr);
        }
        catch (Exception ex) {
            throw new Exception(SplEditorSE.getNoSNMessage());
        }
        try {
            SplEditorSE.checkSerialNo();
        }
        catch (Exception ex) {
            serialNo = oldSerialNo;
            throw ex;
        }
    }

    public static boolean isValidSerialNo() {
        try {
            SplEditorSE.checkSerialNo();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getNoSNMessage() {
        boolean isEnt = false;
        if (productIds != null) {
            int[] nArray = productIds;
            int n = productIds.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                if (6 == pid || 7 == pid) {
                    isEnt = true;
                }
                ++n2;
            }
        }
        if (isEnt) {
            return IdeSplSEMessage.get().getMessage("sn.novalidsn");
        }
        return IdeSplSEMessage.get().getMessage("sn.nosn");
    }

    public static void checkSerialNo() throws Exception {
        int snProductId = SplEditorSE.getProduct();
        boolean isValidProduct = false;
        if (productIds != null) {
            int[] nArray = productIds;
            int n = productIds.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                if (snProductId == pid) {
                    isValidProduct = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isValidProduct) {
            throw new Exception(String.valueOf(IdeCommonMessage.get().getMessage("cloudclient.snproduct")) + ROW_SEP + SplEditorSE.getNoSNMessage());
        }
        if (SplEditorSE.getCheck() != 0) {
            throw new Exception(SplEditorSE.getNoSNMessage());
        }
        long expTime = SplEditorSE.getExpiration();
        if (expTime > 0L) {
            long now;
            if (!SplEditorSE.isSale() && (now = System.currentTimeMillis()) > expTime) {
                throw new Exception(String.valueOf(IdeCommonMessage.get().getMessage("sn.exp")) + ROW_SEP + SplEditorSE.getNoSNMessage());
            }
            long releaseDate = SplEditorSE.getReleaseDate();
            if (releaseDate > expTime) {
                throw new Exception(String.valueOf(IdeCommonMessage.get().getMessage("sn.serviceexp")) + ROW_SEP + SplEditorSE.getNoSNMessage());
            }
        }
    }

    public static boolean isNoIDE() {
        try {
            return SplEditorSE.getFP(0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEncrypt() {
        try {
            return SplEditorSE.getFP(1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isColumn() {
        try {
            return SplEditorSE.getFP(2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDQL() {
        try {
            return SplEditorSE.getFP(3);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNodes() {
        try {
            return SplEditorSE.getFP(4);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCloud() {
        try {
            return SplEditorSE.getFP(5);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkNoIDE() {
        if (SplEditorSE.isNoIDE()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.noide"));
        }
    }

    public static void checkEncrypt() {
        if (!SplEditorSE.isEncrypt()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.noencrypt"));
        }
    }

    public static void checkColumn() {
        if (!SplEditorSE.isColumn()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.nocolumn"));
        }
    }

    public static void checkDQL() {
        if (!SplEditorSE.isDQL()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.nodql"));
        }
    }

    public static void checkNodes() {
        if (!SplEditorSE.isNodes()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.nonodes"));
        }
    }

    public static void checkCloud() {
        if (!SplEditorSE.isCloud()) {
            throw new RQException(IdeSplSEMessage.get().getMessage("sn.nocloud"));
        }
    }

    public static boolean forceUpdate() {
        return SplEditorSE.isFree() || SplEditorSE.isTrial();
    }

    public static boolean forceConnect() {
        return SplEditorSE.isFree() || SplEditorSE.isTrial();
    }

    private static long getReleaseDate() {
        String sReleaseDate = "2026-01-07";
        boolean isEnt = false;
        boolean isSE = false;
        boolean isDesk = false;
        if (productIds != null) {
            int[] nArray = productIds;
            int n = productIds.length;
            int n2 = 0;
            while (n2 < n) {
                int pid = nArray[n2];
                if (6 == pid || 7 == pid) {
                    isEnt = true;
                    break;
                }
                if (4 == pid) {
                    isDesk = true;
                } else if (5 == pid) {
                    isSE = true;
                }
                ++n2;
            }
        }
        if (isEnt) {
            try {
                Class<?> clazz = Class.forName("com.scudata.ide.spl.EsprocEE");
                Field field = clazz.getDeclaredField("RELEASE_DATE");
                field.setAccessible(true);
                sReleaseDate = (String)field.get(null);
            }
            catch (Exception clazz) {}
        } else if (isSE) {
            try {
                Class<?> clazz = Class.forName("com.scudata.ide.spl.SPL");
                Field field = clazz.getDeclaredField("RELEASE_DATE");
                field.setAccessible(true);
                sReleaseDate = (String)field.get(null);
            }
            catch (Exception clazz) {}
        } else if (isDesk) {
            try {
                Class<?> clazz = Class.forName("com.scudata.ide.spl.EsprocDesk");
                Field field = clazz.getDeclaredField("RELEASE_DATE");
                field.setAccessible(true);
                sReleaseDate = (String)field.get(null);
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(sReleaseDate);
        }
        catch (ParseException e) {
            return 0L;
        }
        return date.getTime();
    }

    public boolean excelPaste() {
        String spl;
        ArrayList<String> args;
        Vector<IAtomicCmd> cmds;
        block23: {
            if (!this.checkSN()) {
                return false;
            }
            this.control.getContentPanel().submitEditor();
            String expStr = GM.clipBoard(false);
            if (!StringUtils.isValidString(expStr)) {
                return false;
            }
            if ((expStr = expStr.trim()).toLowerCase().startsWith("=spl(") && expStr.endsWith(")")) {
                expStr = expStr.substring("=spl(".length(), expStr.length() - 1).trim();
            } else if (expStr.toUpperCase().startsWith("=SPL.X(") && expStr.endsWith(")")) {
                expStr = expStr.substring("=SPL.X(".length(), expStr.length() - 1).trim();
            } else {
                JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditor.errorexcelspl", GMSplSE.getExcelAddinFuncName()));
                return false;
            }
            cmds = this.getClearRectCmds(new CellRect(1, 1, this.control.cellSet.getRowCount(), this.control.cellSet.getColCount()), (byte)0);
            ParamList pl = new ParamList();
            if (!StringUtils.isValidString(expStr)) {
                this.addParamCmd(cmds, pl);
                this.executeCmd(cmds);
                this.control.getContentPanel().initEditor((byte)2);
                return true;
            }
            if (!(expStr = expStr.trim()).startsWith("\"")) {
                JOptionPane.showMessageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditor.errorexcelspl", GMSplSE.getExcelAddinFuncName()));
                return false;
            }
            args = new ArrayList<String>();
            List<String> splAndArgs = this.parseExcelSpl(expStr);
            spl = splAndArgs.get(0);
            int i = 1;
            while (i < splAndArgs.size()) {
                Object arg = splAndArgs.get(i);
                if (!StringUtils.isValidString(arg)) {
                    arg = "arg" + i;
                }
                args.add((String)arg);
                ++i;
            }
            if (!args.isEmpty()) {
                for (String arg : args) {
                    pl.add(new Param(arg, 0, null));
                }
                this.addParamCmd(cmds, pl);
            }
            if (StringUtils.isValidString(spl)) break block23;
            this.executeCmd(cmds);
            this.control.getContentPanel().initEditor((byte)2);
            this.setDataChanged(true);
            return true;
        }
        try {
            PgmCellSet cellSet = ExcelApi.excelSplToCellSet(spl, true);
            boolean isAdd = false;
            if (this.control.cellSet.getRowCount() < cellSet.getRowCount()) {
                cmds.add(this.getAppendRows(cellSet.getRowCount() - this.control.cellSet.getRowCount()));
                isAdd = true;
            }
            if (this.control.cellSet.getColCount() < cellSet.getColCount()) {
                cmds.add(this.getAppendCols(cellSet.getColCount() - this.control.cellSet.getColCount()));
                isAdd = true;
            }
            if (isAdd) {
                this.executeCmd(cmds);
                cmds.clear();
            }
            int r = 1;
            while (r <= cellSet.getRowCount()) {
                int c = 1;
                while (c <= cellSet.getColCount()) {
                    PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                    if (cell != null) {
                        String cellExpStr = cell.getExpString();
                        if (cellExpStr != null) {
                            cellExpStr = cellExpStr.trim();
                        }
                        if (!args.isEmpty()) {
                            cellExpStr = SplEditorSE.replacePasteParam(cellExpStr, args, cell.getCellId());
                        }
                        PgmNormalCell toCell = this.control.cellSet.getPgmNormalCell(r, c);
                        AtomicCell ac = new AtomicCell((SplControl)this.control, toCell);
                        ac.setProperty((byte)1);
                        ac.setValue(cellExpStr);
                        cmds.add(ac);
                    }
                    ++c;
                }
                ++r;
            }
            this.executeCmd(cmds);
            this.control.getContentPanel().initEditor((byte)2);
            this.setDataChanged(true);
        }
        catch (Exception ex) {
            GM.showException(GV.appFrame, ex);
            return false;
        }
        return true;
    }

    private List<String> parseExcelSpl(String expStr) {
        ArrayList<String> list = new ArrayList<String>();
        expStr = expStr.trim();
        int len = expStr.length();
        StringBuffer buf = new StringBuffer();
        int lastIndex = 0;
        int argStart = -1;
        boolean isMatched = false;
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '\"') {
                if (i != 0) {
                    lastIndex = i + 1;
                }
                int j = i + 1;
                while (j < len) {
                    c = expStr.charAt(j);
                    if (c == '\"') {
                        if (++j >= len - 1) {
                            isMatched = true;
                            buf.append(expStr.substring(lastIndex, j));
                            break;
                        }
                        c = expStr.charAt(j);
                        if (c != '\"') {
                            int index;
                            if (expStr.charAt(j - 2) != "\\".charAt(0)) {
                                argStart = j;
                                isMatched = true;
                                buf.append(expStr.substring(lastIndex, j));
                                break;
                            }
                            if (!AppUtil.isNextChar(',', expStr, j)) {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
                            }
                            buf.append(expStr.substring(lastIndex, j - 2));
                            i = index = expStr.indexOf(44, j);
                            break;
                        }
                    }
                    ++j;
                }
                if (isMatched) break;
            }
            ++i;
        }
        if (!isMatched) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"" + mm.getMessage("Expression.illMatched"));
        }
        String spl = buf.toString();
        list.add(spl.trim());
        if (argStart != -1) {
            String args = expStr.substring(argStart);
            args = args.trim().substring(1);
            ArgumentTokenizer at = new ArgumentTokenizer(args);
            while (at.hasMoreTokens()) {
                String arg = at.nextToken();
                if (arg != null) {
                    arg = arg.trim();
                }
                list.add(arg);
            }
        }
        return list;
    }

    private void addParamCmd(Vector<IAtomicCmd> cmds, ParamList pl) {
        AtomicSpl as = new AtomicSpl(this.control);
        as.setType((byte)7);
        as.setValue(pl);
        cmds.add(as);
    }

    private static String replacePasteParam(String expStr, List<String> args, String cellId) {
        if (expStr == null) {
            return null;
        }
        int len = expStr.length();
        StringBuffer buf = new StringBuffer();
        int argIndex = 0;
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '\"' || c == '\'') {
                int match = Sentence.scanQuotation(expStr, i);
                if (match == -1) {
                    MessageManager mm = EngineMessage.get();
                    Logger.error(String.valueOf(cellId) + ": \"" + mm.getMessage("Expression.illMatched"));
                    return expStr;
                }
                buf.append(expStr.subSequence(i, match + 1));
                i = ++match;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                buf.append(c);
                ++i;
                continue;
            }
            String id = AppUtil.scanId(expStr, i);
            if (id.equals("$") && AppUtil.isNextChar('[', expStr, i)) {
                int index = expStr.indexOf(91, i);
                int match = Sentence.scanBracket(expStr, index);
                if (match == -1) continue;
                buf.append(expStr.subSequence(i, match));
                i = match + 1;
                continue;
            }
            if (KeyWord.isArg(id)) {
                String arg = null;
                if ("?".equals(id)) {
                    arg = args.get(argIndex);
                    ++argIndex;
                } else {
                    String sNum = id.substring("?".length());
                    try {
                        int num = Integer.parseInt(sNum);
                        if (num > 0) {
                            if (args.size() < num) {
                                Logger.error(String.valueOf(cellId) + ": " + IdeSplMessage.get().getMessage("spleditor.excelparamnotmatch", id));
                                return expStr;
                            }
                            arg = args.get(num - 1);
                            argIndex = num;
                        }
                    }
                    catch (Exception ex) {
                        Logger.error(IdeSplMessage.get().getMessage("spleditor.excelparamnumerror", cellId, id), ex);
                        return expStr;
                    }
                }
                if (arg != null) {
                    buf.append(Escape.addEscAndQuote(arg, false));
                } else {
                    buf.append(id);
                }
                i += id.length();
                continue;
            }
            buf.append(id);
            i += id.length();
        }
        return buf.toString();
    }

    @Override
    protected void altC() {
        this.excelCopy();
    }

    @Override
    protected void altV() {
        this.excelPaste();
    }

    public boolean swapCell() {
        CellRect targetRect = this.getSelectedRect();
        if (targetRect == null) {
            GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("dfxeditor.notselecttarget"));
            return false;
        }
        CellSelection cs = GVSpl.cellSelection;
        if (cs == null) {
            GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditorse.noswapcell"));
            return false;
        }
        if (cs.isCutStatus()) {
            if (cs.srcCellSet != this.control.getCellSet()) {
                GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditorse.notswapothersheet"));
                return false;
            }
        } else {
            GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditorse.swapneedcut"));
            return false;
        }
        if (this.isMultiRectSelected()) {
            GM.messageDialog(GV.appFrame, IdeSplSEMessage.get().getMessage("spleditorse.swapmore"));
            return false;
        }
        targetRect.setColCount(cs.matrix.getColSize());
        targetRect.setRowCount(cs.matrix.getRowSize());
        Area srcArea = cs.getSelectArea();
        if (this.isOverlapArea(srcArea, targetRect.getArea())) {
            GM.messageDialog(GV.appFrame, IdeSplMessage.get().getMessage("spleditorse.swapcrossarea"));
            return false;
        }
        Vector<IAtomicCmd> cmds = new Vector<IAtomicCmd>();
        CellSetParser parser = new CellSetParser(this.control.getCellSet());
        int hideRowCount = 0;
        int r = targetRect.getBeginRow();
        while (r <= this.control.cellSet.getRowCount()) {
            if (!parser.isRowVisible(r)) {
                ++hideRowCount;
            }
            ++r;
        }
        if (targetRect.getEndRow() + hideRowCount > this.control.cellSet.getRowCount()) {
            int addRowCount = targetRect.getEndRow() + hideRowCount - this.control.cellSet.getRowCount();
            cmds.add(this.getAppendRows(addRowCount));
        }
        int hideColCount = 0;
        int c = targetRect.getBeginCol();
        while (c <= this.control.cellSet.getColCount()) {
            if (!parser.isColVisible(c)) {
                ++hideColCount;
            }
            ++c;
        }
        if (targetRect.getEndCol() + hideColCount > this.control.cellSet.getColCount()) {
            int addColCount = targetRect.getEndCol() + hideColCount - this.control.cellSet.getColCount();
            cmds.add(this.getAppendCols(addColCount));
        }
        cs.setAdjustSelf(true);
        Area area = targetRect.getArea();
        if (area.getEndRow() == area.getBeginRow() && area.getBeginCol() == area.getEndCol()) {
            int endRow = targetRect.getEndRow();
            int rc = 0;
            int r2 = targetRect.getBeginRow();
            while (r2 <= this.control.cellSet.getRowCount()) {
                if (parser.isRowVisible(r2) && ++rc >= targetRect.getRowCount()) {
                    endRow = r2;
                    break;
                }
                ++r2;
            }
            int endCol = targetRect.getEndCol();
            int cc = 0;
            int c2 = targetRect.getBeginCol();
            while (c2 <= this.control.cellSet.getColCount()) {
                if (parser.isColVisible(c2) && ++cc >= targetRect.getColCount()) {
                    endCol = c2;
                    break;
                }
                ++c2;
            }
            area = new Area(targetRect.getBeginRow(), targetRect.getBeginCol(), endRow, endCol);
            targetRect = new CellRect(area);
        } else if (this.selectState == cs.selectState && (this.selectState == 3 && this.selectedRows.size() == 1 || this.selectState == 4 && this.selectedCols.size() == 1)) {
            area = new Area(targetRect.getBeginRow(), targetRect.getBeginCol(), targetRect.getEndRow(), targetRect.getEndCol());
            targetRect = new CellRect(area);
        }
        AtomicSpl ar = new AtomicSpl(this.control);
        ar.setType((byte)16);
        ar.setRect(targetRect);
        ar.setValue(cs);
        cmds.add(ar);
        this.executeCmd(cmds);
        return true;
    }

    private boolean isOverlapArea(Area area1, Area area2) {
        if (area1 == null || area2 == null) {
            return false;
        }
        int row1 = area1.getBeginRow();
        int row2 = area1.getEndRow();
        if (area2.getBeginRow() >= row1 && area2.getEndRow() <= row2) {
            int col1 = area1.getBeginCol();
            int col2 = area1.getEndCol();
            if (area2.getBeginCol() >= col1 && area2.getEndCol() <= col2) {
                return true;
            }
        }
        return false;
    }
}

