/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.chart.Engine;
import com.scudata.common.AnimatedGifEncoder;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Canvas;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.ChartParam;
import com.scudata.expression.Expression;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.chart.auto.DialogGraphEdit;
import com.scudata.ide.spl.chart.auto.JComboBoxGraph;
import com.scudata.ide.spl.resources.ChartMessage;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGDocument;

public class DialogDisplayChart
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static String SUM = "sum";
    public static String COUNT = "count";
    public static String AVG = "avg";
    public static String MAX = "max";
    public static String MIN = "min";
    private Engine engine = null;
    private Engine animateEngine = null;
    private ImageIcon ii = null;
    private byte[] imageBytes = null;
    private Component imageDisplay;
    private JButton close;
    private JButton saveAs;
    private JButton copy;
    private JLabel labelGraphType = new JLabel("\u56fe\u7c7b\u578b");
    private JComboBoxGraph cbGraphType = new JComboBoxGraph();
    private JLabel labelCategory = new JLabel("\u5206\u7c7b\u5b57\u6bb5");
    private JComboBox<String> cbCategory = new JComboBox();
    private JLabel labelSeries = new JLabel("\u7cfb\u5217\u5b57\u6bb5");
    private JComboBox<String> cbSeries = new JComboBox();
    private JLabel labelValue = new JLabel("\u6570\u503c\u5b57\u6bb5");
    private JComboBox<String> cbValue = new JComboBox();
    private JLabel labelAccumulate = new JLabel("\u805a\u5408\u51fd\u6570");
    private JComboBoxEx cbAccumulate = new JComboBoxEx();
    private JButton settings = new JButton("\u8bbe\u7f6e");
    private Table data = null;
    int sliderScale = 1;
    private HashMap<String, Object> properties = new HashMap();
    MessageManager splMM = IdeSplMessage.get();
    MessageManager mm = ChartMessage.get();
    private JLabel labelFrameCount = new JLabel("\u52a8\u753b\u5e27\u6570");
    int defCount = 24;
    private JSpinner spFrameCount = new JSpinner(new SpinnerNumberModel(this.defCount, 2, 10240, 1));
    private JLabel labelFrameDelay = new JLabel("\u5e27\u95f4\u5ef6\u65f6(\u6beb\u79d2)");
    private JSpinner spFrameDelay = new JSpinner(new SpinnerNumberModel(100, 10, 10000, 10));
    private JCheckBox cbLoop = new JCheckBox("\u5faa\u73af");
    JSlider slider = new JSlider(0, 1, this.defCount, 1);
    private JButton play = new JButton("\u64ad\u653e");
    boolean stop = false;

    public DialogDisplayChart(byte[] imageBytes) {
        super(GV.appFrame, "Chart Display", true);
        try {
            if (imageBytes.length < 10) {
                throw new Exception("Invalid image bytes. length=" + imageBytes.length);
            }
            this.imageBytes = imageBytes;
            this.ii = new ImageIcon(imageBytes);
            this.init();
            this.setResizable(true);
        }
        catch (Exception x) {
            GM.showException(this, x);
            new Thread(){

                @Override
                public void run() {
                    DialogDisplayChart.this.closeDialog();
                }
            }.start();
        }
    }

    public DialogDisplayChart(Canvas canvas) {
        super(GV.appFrame, "Chart Display", true);
        try {
            this.engine = new Engine(canvas.getChartElements());
            if (this.engine.isAnimate()) {
                this.animateEngine = this.engine;
                this.initAnimate();
            }
            this.init();
        }
        catch (Exception x) {
            GM.showException(this, x);
            new Thread(){

                @Override
                public void run() {
                    DialogDisplayChart.this.closeDialog();
                }
            }.start();
        }
    }

    public DialogDisplayChart(Table data) {
        super(GV.appFrame, "Chart Display", true);
        try {
            this.data = data;
            this.initTable();
            this.init();
            this.setCategory();
            this.setValue();
            this.refresh();
        }
        catch (Exception x) {
            GM.showException(this, x);
            new Thread(){

                @Override
                public void run() {
                    DialogDisplayChart.this.closeDialog();
                }
            }.start();
        }
    }

    private void closeDialog() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    private void resetLangText() {
        String svgTip = "";
        if (!this.copy.isEnabled()) {
            svgTip = "";
        }
        this.setTitle(this.splMM.getMessage("dialogdisplaychart.title", svgTip));
        this.close.setText(this.splMM.getMessage("button.close"));
        this.saveAs.setText(this.splMM.getMessage("button.saveas"));
        this.copy.setText(this.splMM.getMessage("button.copy"));
        this.labelGraphType.setText(this.splMM.getMessage("dialogdisplaychart.graphType"));
        this.labelCategory.setText(this.splMM.getMessage("dialogdisplaychart.category"));
        this.labelSeries.setText(this.splMM.getMessage("dialogdisplaychart.series"));
        this.labelValue.setText(this.splMM.getMessage("dialogdisplaychart.value"));
        this.labelAccumulate.setText(this.splMM.getMessage("dialogdisplaychart.accumulate"));
        this.settings.setText(this.splMM.getMessage("dialogdisplaychart.settings"));
        this.labelFrameCount.setText(this.splMM.getMessage("dialogdisplaychart.framecount"));
        this.labelFrameDelay.setText(this.splMM.getMessage("dialogdisplaychart.frameDelay"));
        this.cbLoop.setText(this.splMM.getMessage("dialogdisplaychart.loop"));
        this.play.setText(this.splMM.getMessage("dialogdisplaychart.play"));
    }

    public String getGraphName() {
        byte graphType = this.cbGraphType.getValue();
        switch (graphType) {
            case 7: {
                return "GraphColumn";
            }
            case 12: {
                return "GraphLine";
            }
            case 13: {
                return "GraphPie";
            }
        }
        return null;
    }

    private void refresh() {
        this.refreshEngine();
        this.imageDisplay.repaint();
    }

    private void refreshAnimate() {
        int frameCount = (Integer)this.spFrameCount.getValue();
        int frameIndex = this.slider.getValue() - 1;
        this.engine = this.animateEngine.getFrameEngine(frameCount, frameIndex);
        this.imageDisplay.repaint();
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> properties) {
        this.properties = properties;
        this.refresh();
    }

    private void refreshEngine() {
        this.engine = null;
        Sequence elements = new Sequence();
        Sequence graph = new Sequence();
        graph.add(new ChartParam(this.getGraphName(), null));
        String categoryCol = (String)this.cbCategory.getSelectedItem();
        int categoryIndex = -1;
        String seriesCol = (String)this.cbSeries.getSelectedItem();
        int seriesIndex = -1;
        String valueCol = (String)this.cbValue.getSelectedItem();
        int valueIndex = -1;
        if (!StringUtils.isValidString(valueCol)) {
            return;
        }
        Table tmpData = this.data;
        if (this.isNeedAccumulate()) {
            String groupExp = this.getAccumulateExp();
            String accumuExp = String.valueOf((String)this.cbAccumulate.x_getSelectedItem()) + "(" + valueCol + "):" + valueCol;
            String sexp = "A.groups(" + groupExp + ";" + accumuExp + ")";
            Sequence tmpSeq = (Sequence)this.calculate(sexp);
            tmpData = tmpSeq.derive("o");
        }
        int rows = tmpData.length();
        Sequence categoryData = new Sequence();
        Sequence valueData = new Sequence();
        BaseRecord rec = tmpData.getRecord(1);
        categoryIndex = rec.getFieldIndex(categoryCol);
        seriesIndex = rec.getFieldIndex(seriesCol);
        valueIndex = rec.getFieldIndex(valueCol);
        int r = 1;
        while (r <= rows) {
            rec = tmpData.getRecord(r);
            Object catVal = rec.getFieldValue(categoryIndex);
            if (seriesIndex > -1) {
                Object seriesVal = rec.getFieldValue(seriesIndex);
                catVal = catVal + "," + seriesVal;
            }
            Object valVal = rec.getFieldValue(valueIndex);
            categoryData.add(catVal);
            valueData.add(valVal);
            ++r;
        }
        ChartParam cp = new ChartParam("categories", categoryData);
        graph.add(cp);
        cp = new ChartParam("values", valueData);
        graph.add(cp);
        for (String key : this.properties.keySet()) {
            Object val = this.properties.get(key);
            cp = new ChartParam(key, val);
            graph.add(cp);
        }
        elements.add(graph);
        this.engine = new Engine(elements);
    }

    private Component getCenter() throws Exception {
        if (this.engine != null || this.data != null) {
            this.imageDisplay = new JPanel(){
                private static final long serialVersionUID = 1598380962917135629L;

                @Override
                public void paint(Graphics g) {
                    int w = DialogDisplayChart.this.imageDisplay.getWidth();
                    int h = DialogDisplayChart.this.imageDisplay.getHeight();
                    g.clearRect(0, 0, w, h);
                    if (DialogDisplayChart.this.engine != null) {
                        DialogDisplayChart.this.engine.draw((Graphics2D)g, 0, 0, w, h, null);
                    }
                }
            };
            if (this.engine != null && this.engine.isAnimate()) {
                JPanel top = new JPanel(new BorderLayout());
                JPanel tmp = new JPanel(new GridBagLayout());
                tmp.add((Component)this.labelFrameCount, GM.getGBC(1, 1));
                tmp.add((Component)this.spFrameCount, GM.getGBC(1, 2, true));
                tmp.add((Component)this.labelFrameDelay, GM.getGBC(1, 3));
                tmp.add((Component)this.spFrameDelay, GM.getGBC(1, 4, true));
                tmp.add((Component)this.cbLoop, GM.getGBC(1, 5));
                GridBagConstraints gbc = GM.getGBC(2, 1, true);
                gbc.gridwidth = 5;
                tmp.add((Component)this.slider, gbc);
                top.add((Component)tmp, "North");
                top.add(this.imageDisplay, "Center");
                return top;
            }
            if (this.data != null) {
                JPanel top = new JPanel(new BorderLayout());
                JPanel tmp = new JPanel(new GridBagLayout());
                tmp.add((Component)this.labelGraphType, GM.getGBC(1, 1));
                tmp.add((Component)this.cbGraphType, GM.getGBC(1, 2, true));
                tmp.add((Component)this.labelCategory, GM.getGBC(1, 3));
                tmp.add(this.cbCategory, GM.getGBC(1, 4, true));
                tmp.add((Component)this.labelSeries, GM.getGBC(1, 5));
                tmp.add(this.cbSeries, GM.getGBC(1, 6, true));
                tmp.add((Component)this.labelValue, GM.getGBC(2, 3));
                tmp.add(this.cbValue, GM.getGBC(2, 4, true));
                tmp.add((Component)this.labelAccumulate, GM.getGBC(2, 5));
                tmp.add((Component)this.cbAccumulate, GM.getGBC(2, 6, true));
                top.add((Component)tmp, "North");
                top.add(this.imageDisplay, "Center");
                return top;
            }
            return this.imageDisplay;
        }
        if (this.ii.getIconWidth() != -1) {
            JLabel centerLabel = new JLabel(this.ii);
            if (this.ii.getIconWidth() > 700 || this.ii.getIconHeight() > 570) {
                JScrollPane jsp = new JScrollPane(centerLabel);
                return jsp;
            }
            return centerLabel;
        }
        JSVGCanvas svgCanvas = new JSVGCanvas();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(null);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.imageBytes);
        SVGDocument svgDocument = factory.createSVGDocument(null, (InputStream)bais);
        SVGAnimatedLength sw = svgDocument.getRootElement().getWidth();
        int w = (int)sw.getBaseVal().getValue();
        SVGAnimatedLength sh = svgDocument.getRootElement().getHeight();
        int h = (int)sh.getBaseVal().getValue();
        svgCanvas.setSVGDocument(svgDocument);
        svgCanvas.setEnableImageZoomInteractor(true);
        svgCanvas.setEnableZoomInteractor(true);
        svgCanvas.setEnableResetTransformInteractor(true);
        svgCanvas.setSize(w, h);
        svgCanvas.repaint(0, 0, w, h);
        return svgCanvas;
    }

    private Component getEast() {
        JPanel panelEast = new JPanel(new VFlowLayout());
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.closeDialog();
            }
        });
        panelEast.add(this.close);
        this.saveAs = new JButton("Save as");
        this.saveAs.setMnemonic('a');
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File saveFile;
                String fileExt;
                if (DialogDisplayChart.this.engine != null) {
                    fileExt = "svg,jpg,png,gif";
                } else if (DialogDisplayChart.this.ii.getIconWidth() != -1) {
                    try {
                        fileExt = GM.getImageType(DialogDisplayChart.this.imageBytes);
                    }
                    catch (IOException e1) {
                        GM.showException(DialogDisplayChart.this, e1);
                        fileExt = "jpg,png,gif";
                    }
                } else {
                    fileExt = "svg";
                }
                String txt = DialogDisplayChart.this.saveAs.getText();
                int p = txt.indexOf("(");
                if (p > 0) {
                    txt = txt.substring(0, p);
                }
                if ((saveFile = GM.dialogSelectFile(DialogDisplayChart.this, fileExt, GV.lastDirectory, txt, "")) == null) {
                    return;
                }
                String sfile = saveFile.getAbsolutePath();
                GV.lastDirectory = saveFile.getParent();
                if (!GM.canSaveAsFile(DialogDisplayChart.this, sfile)) {
                    return;
                }
                byte[] streamBytes = null;
                if (DialogDisplayChart.this.engine == null) {
                    streamBytes = DialogDisplayChart.this.imageBytes;
                } else {
                    if (DialogDisplayChart.this.animateEngine != null) {
                        AnimatedGifEncoder age = new AnimatedGifEncoder();
                        int delay = (Integer)DialogDisplayChart.this.spFrameDelay.getValue();
                        if (DialogDisplayChart.this.cbLoop.isSelected()) {
                            age.setRepeat(delay);
                        }
                        try {
                            FileOutputStream fos = new FileOutputStream(saveFile);
                            age.start(fos);
                            age.setDelay(delay);
                            int count = DialogDisplayChart.this.slider.getMaximum();
                            int i = 0;
                            while (i <= count) {
                                Engine tmpe = DialogDisplayChart.this.animateEngine.getFrameEngine(count, i);
                                BufferedImage bi = tmpe.calcBufferedImage(DialogDisplayChart.this.imageDisplay.getWidth(), DialogDisplayChart.this.imageDisplay.getHeight(), (byte)1);
                                age.addFrame(bi);
                                ++i;
                            }
                            age.finish();
                            GM.showException(DialogDisplayChart.this, DialogDisplayChart.this.splMM.getMessage("dialogdisplaychart.saveinfo", saveFile));
                        }
                        catch (Exception x) {
                            GM.showException(DialogDisplayChart.this, x);
                        }
                        return;
                    }
                    fileExt = sfile.substring(sfile.length() - 3);
                    byte imageFmt = 3;
                    if (fileExt.equalsIgnoreCase("JPG")) {
                        imageFmt = 1;
                    } else if (fileExt.equalsIgnoreCase("GIF")) {
                        imageFmt = 2;
                    } else if (fileExt.equalsIgnoreCase("SVG")) {
                        imageFmt = 5;
                    }
                    streamBytes = DialogDisplayChart.this.engine.calcImageBytes(DialogDisplayChart.this.imageDisplay.getWidth(), DialogDisplayChart.this.imageDisplay.getHeight(), imageFmt);
                }
                try {
                    FileOutputStream fos = new FileOutputStream(saveFile);
                    fos.write(streamBytes);
                    fos.close();
                }
                catch (Exception x) {
                    GM.showException(DialogDisplayChart.this, x);
                }
            }
        });
        panelEast.add(this.saveAs);
        this.copy = new JButton("Copy");
        this.copy.setMnemonic('p');
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogDisplayChart.this.engine != null) {
                    byte[] bytes = DialogDisplayChart.this.engine.calcImageBytes(DialogDisplayChart.this.imageDisplay.getWidth(), DialogDisplayChart.this.imageDisplay.getHeight(), (byte)3);
                    ImageIcon icon = new ImageIcon(bytes);
                    DialogDisplayChart.setClipboardImage(icon.getImage());
                } else {
                    DialogDisplayChart.setClipboardImage(DialogDisplayChart.this.ii.getImage());
                }
            }
        });
        panelEast.add(this.copy);
        if (this.data != null) {
            panelEast.add(new JLabel(" "));
            panelEast.add(this.settings);
        } else if (this.engine != null && this.engine.isAnimate()) {
            panelEast.add(new JLabel(" "));
            panelEast.add(this.play);
        }
        return panelEast;
    }

    private Object getFirstValid(String field) {
        int c = this.data.length();
        int r = 1;
        while (r <= c) {
            BaseRecord rec = this.data.getRecord(r);
            Object tmp = rec.getFieldValue(field);
            if (tmp != null) {
                return tmp;
            }
            ++r;
        }
        return null;
    }

    private void initTable() {
        Vector<String> code = new Vector<String>();
        Vector<String> disp = new Vector<String>();
        code.add(SUM);
        code.add(COUNT);
        code.add(AVG);
        code.add(MAX);
        code.add(MIN);
        disp.add(this.mm.getMessage(SUM));
        disp.add(this.mm.getMessage(COUNT));
        disp.add(this.mm.getMessage(AVG));
        disp.add(this.mm.getMessage(MAX));
        disp.add(this.mm.getMessage(MIN));
        this.cbAccumulate.x_setData(code, disp);
        String[] fieldNames = this.data.dataStruct().getFieldNames();
        this.cbSeries.addItem("");
        int i = 0;
        while (i < fieldNames.length) {
            String field = fieldNames[i];
            Object tmp = this.getFirstValid(field);
            this.cbCategory.addItem(field);
            this.cbSeries.addItem(field);
            if (tmp instanceof Number) {
                this.cbValue.addItem(field);
            }
            ++i;
        }
        String defCat = (String)this.cbCategory.getSelectedItem();
        int c = this.cbValue.getItemCount();
        int i2 = 0;
        while (i2 < c) {
            String defVal = this.cbValue.getItemAt(i2);
            if (!defCat.equals(defVal)) {
                this.cbValue.setSelectedIndex(i2);
                break;
            }
            ++i2;
        }
        this.cbGraphType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.refresh();
            }
        });
        this.cbCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.setCategory();
                DialogDisplayChart.this.refresh();
            }
        });
        this.cbSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.setSeries();
                DialogDisplayChart.this.refresh();
            }
        });
        this.cbValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.setValue();
                DialogDisplayChart.this.refresh();
            }
        });
        this.cbAccumulate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogDisplayChart.this.refresh();
            }
        });
        final DialogDisplayChart ddc = this;
        this.settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogGraphEdit dge = new DialogGraphEdit(ddc);
                dge.setVisible(true);
            }
        });
    }

    private void initAnimate() {
        this.spFrameCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int maximum = (Integer)DialogDisplayChart.this.spFrameCount.getValue();
                DialogDisplayChart.this.slider.setMaximum(maximum + 1);
                DialogDisplayChart.this.refreshAnimate();
            }
        });
        final String PLAY = this.splMM.getMessage("dialogdisplaychart.play");
        final String STOP = this.splMM.getMessage("dialogdisplaychart.stop");
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogDisplayChart.this.play.getText().equals(PLAY)) {
                    Thread animateThread = new Thread(){

                        @Override
                        public void run() {
                            DialogDisplayChart.this.play.setText(STOP);
                            int count = (this).DialogDisplayChart.this.slider.getMaximum();
                            int delay = (Integer)DialogDisplayChart.this.spFrameDelay.getValue();
                            int i = 0;
                            while (i <= count) {
                                (this).DialogDisplayChart.this.slider.setValue(i);
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (DialogDisplayChart.this.cbLoop.isSelected() && i == count) {
                                    i = 1;
                                }
                                if ((this).DialogDisplayChart.this.stop) break;
                                ++i;
                            }
                            (this).DialogDisplayChart.this.stop = false;
                            DialogDisplayChart.this.play.setText(PLAY);
                        }
                    };
                    animateThread.start();
                } else {
                    DialogDisplayChart.this.stop = true;
                }
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DialogDisplayChart.this.refreshAnimate();
            }
        });
    }

    private String getAccumulateExp() {
        String sCategory = (String)this.cbCategory.getSelectedItem();
        if (sCategory == null) {
            return null;
        }
        String exp = Escape.addEscAndQuote(sCategory, false);
        String sSeries = (String)this.cbSeries.getSelectedItem();
        if (StringUtils.isValidString(sSeries)) {
            exp = String.valueOf(exp) + "," + Escape.addEscAndQuote(sSeries, false);
        }
        return exp;
    }

    private boolean isNeedAccumulate() {
        String exp = this.getAccumulateExp();
        if (exp == null) {
            return false;
        }
        int originalLen = this.data.length();
        String sexp = "A.groups(" + exp + ")";
        Sequence seq = (Sequence)this.calculate(sexp);
        return seq.length() != originalLen;
    }

    private void enableAccumulate() {
        boolean needAccumulate = this.isNeedAccumulate();
        this.labelAccumulate.setEnabled(needAccumulate);
        this.cbAccumulate.setEnabled(needAccumulate);
    }

    private void setCategory() {
        String XTITLE = "xTitle";
        Object value = this.cbCategory.getSelectedItem();
        this.properties.put(XTITLE, value);
        this.enableAccumulate();
    }

    private void setSeries() {
        this.enableAccumulate();
    }

    private void setValue() {
        String YTITLE = "yTitle";
        String valueCol = (String)this.cbValue.getSelectedItem();
        this.properties.put(YTITLE, valueCol);
    }

    private Object calculate(String sexp) {
        Context ctx = new Context();
        ctx.setParamValue("A", this.data);
        Expression exp = new Expression(ctx, sexp);
        return exp.calculate(ctx);
    }

    private void init() throws Exception {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.getCenter(), "Center");
        panel.add(this.getEast(), "East");
        this.getContentPane().add(panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogDisplayChart.this.closeDialog();
            }
        });
        if (this.engine != null || this.data != null) {
            this.setSize(800, 600);
        } else if (this.ii.getIconWidth() != -1) {
            int w = this.ii.getIconWidth() + 100;
            int h = this.ii.getIconHeight() + 30;
            if (w > 700 || h > 570) {
                w = 800;
                h = 600;
            }
            this.setSize(w, h);
        } else {
            this.setSize(800, 600);
            this.copy.setEnabled(false);
        }
        this.resetLangText();
        GM.setDialogDefaultButton(this, this.close, this.close);
        if (this.data != null) {
            this.setLocation(this.getX() - 200, this.getY());
        }
    }

    public static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }
}

