/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.StringUtils;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.PanelConsole;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.ProcessWatchThread;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DialogExecCmd
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private JTextField textSpl = new JTextField();
    private JButton buttonFile = new JButton();
    private final int COL_DISP = 0;
    private final int COL_VALUE = 1;
    private final String TITLE_DISP = IdeSplMessage.get().getMessage("dialogexeccmd.name");
    private final String TITLE_VALUE = IdeSplMessage.get().getMessage("dialogexeccmd.value");
    private JTableEx paramTable = new JTableEx(new String[]{this.TITLE_DISP, this.TITLE_VALUE}){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (col != 1) {
                return;
            }
            GM.dialogEditTableText(DialogExecCmd.this, DialogExecCmd.this.paramTable, row, col);
        }
    };
    private JCheckBox jCBResult = new JCheckBox(IdeSplMessage.get().getMessage("dialogexeccmd.printresult"));

    public DialogExecCmd() {
        super(IdeSplMessage.get().getMessage("dialogexeccmd.title"), 400, 300);
        try {
            this.init();
            GM.centerWindow(this);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public void setSplFile(String splFile) {
        this.textSpl.setText(splFile);
        this.loadFile();
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        String splFile = this.textSpl.getText();
        if (!StringUtils.isValidString(splFile)) {
            GM.messageDialog(this, IdeSplMessage.get().getMessage("dialogexeccmd.emptydfx"));
            return false;
        }
        final File f = new File(splFile);
        if (!f.isFile() || !f.exists()) {
            GM.messageDialog(this, IdeSplMessage.get().getMessage("dialogexeccmd.dfxnotexist", splFile));
            return false;
        }
        String startHome = System.getProperty("start.home");
        File binDir = new File(startHome, "bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            GM.messageDialog(this, IdeSplMessage.get().getMessage("dialogexeccmd.binnotexist", binDir.getAbsolutePath()));
            return false;
        }
        String suffix = GM.isWindowsOS() ? "exe" : "sh";
        final File exeFile = new File(binDir, "esprocx." + suffix);
        if (!exeFile.isFile() || !exeFile.exists()) {
            GM.messageDialog(this, IdeSplMessage.get().getMessage("dialogexeccmd.exenotexist", exeFile.getAbsolutePath()));
            return false;
        }
        this.paramTable.acceptText();
        PanelConsole pc = ((IDEBase)GVSpl.appFrame).getPanelConsole();
        if (pc != null) {
            pc.autoClean();
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                int i;
                String[] cmds;
                ArrayList<String> args = new ArrayList<String>();
                int i2 = 0;
                while (i2 < DialogExecCmd.this.paramTable.getRowCount()) {
                    Object o = ((DialogExecCmd)DialogExecCmd.this).paramTable.data.getValueAt(i2, 1);
                    args.add(o == null ? "" : o.toString());
                    ++i2;
                }
                boolean isR = DialogExecCmd.this.jCBResult.isSelected();
                if (GM.isWindowsOS()) {
                    cmds = new String[(isR ? 8 : 7) + args.size()];
                    cmds[0] = "cmd.exe";
                    cmds[1] = "/c";
                    cmds[2] = "start";
                    cmds[3] = "/b";
                    cmds[4] = " ";
                    cmds[5] = exeFile.getAbsolutePath();
                    if (isR) {
                        cmds[6] = "-r";
                        cmds[7] = f.getAbsolutePath();
                    } else {
                        cmds[6] = f.getAbsolutePath();
                    }
                    i = 0;
                    while (i < args.size()) {
                        cmds[(isR ? 8 : 7) + i] = (String)args.get(i);
                        ++i;
                    }
                } else if (GM.isMacOS()) {
                    cmds = new String[(isR ? 4 : 3) + args.size()];
                    cmds[0] = "sh";
                    cmds[1] = exeFile.getAbsolutePath();
                    if (isR) {
                        cmds[2] = "-r";
                        cmds[3] = f.getAbsolutePath();
                    } else {
                        cmds[2] = f.getAbsolutePath();
                    }
                    i = 0;
                    while (i < args.size()) {
                        cmds[(isR ? 4 : 3) + i] = (String)args.get(i);
                        ++i;
                    }
                } else {
                    cmds = new String[(isR ? 5 : 4) + args.size()];
                    cmds[0] = "sh";
                    cmds[1] = "-c";
                    cmds[2] = exeFile.getAbsolutePath();
                    if (isR) {
                        cmds[3] = "-r";
                        cmds[4] = f.getAbsolutePath();
                    } else {
                        cmds[3] = f.getAbsolutePath();
                    }
                    i = 0;
                    while (i < args.size()) {
                        cmds[(isR ? 5 : 4) + i] = (String)args.get(i);
                        ++i;
                    }
                }
                try {
                    Process proc = Runtime.getRuntime().exec(cmds);
                    ProcessWatchThread wt = new ProcessWatchThread(proc.getInputStream());
                    wt.start();
                    ProcessWatchThread wt1 = new ProcessWatchThread(proc.getErrorStream());
                    wt1.start();
                    proc.waitFor();
                    wt.setOver(true);
                    wt1.setOver(true);
                    DialogExecCmd.this.closeDialog(0);
                    ((IDEBase)GV.appFrame).viewTabConsole();
                }
                catch (Exception e1) {
                    GM.showException(DialogExecCmd.this, e1);
                    return;
                }
            }
        };
        t.start();
        return false;
    }

    @Override
    protected void closeDialog(int option) {
        super.closeDialog(option);
        GM.setWindowDimension(this);
    }

    private void init() {
        JPanel panelNorth = new JPanel(new GridBagLayout());
        panelNorth.add((Component)new JLabel(IdeSplMessage.get().getMessage("dialogexeccmd.dfxfile")), GM.getGBC(0, 0));
        panelNorth.add((Component)this.textSpl, GM.getGBC(0, 1, true, false, 2));
        panelNorth.add((Component)this.buttonFile, GM.getGBC(0, 2));
        this.panelCenter.add((Component)panelNorth, "North");
        JPanel panelParam = new JPanel(new GridBagLayout());
        panelParam.add((Component)new JLabel(IdeSplMessage.get().getMessage("dialogexeccmd.dfxparam")), GM.getGBC(0, 0));
        panelParam.add((Component)new JScrollPane(this.paramTable), GM.getGBC(1, 0, true, true));
        this.panelCenter.add((Component)panelParam, "Center");
        JPanel panelSouth = new JPanel(new FlowLayout(0));
        panelSouth.add(this.jCBResult);
        this.panelCenter.add((Component)panelSouth, "South");
        this.buttonFile.setIcon(GM.getMenuImageIcon("file.open"));
        this.buttonFile.setToolTipText(IdeSplMessage.get().getMessage("dialogexeccmd.openfile"));
        this.buttonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = GM.dialogSelectFile(DialogExecCmd.this, "\"splx,spl,dfx\"", false);
                if (f != null) {
                    DialogExecCmd.this.textSpl.setText(f.getAbsolutePath());
                    DialogExecCmd.this.loadFile();
                }
            }
        });
        this.textSpl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExecCmd.this.loadFile();
            }
        });
        this.paramTable.setRowHeight(20);
        this.paramTable.setColumnEnable(this.TITLE_DISP, false);
    }

    private void loadFile() {
        this.paramTable.acceptText();
        this.paramTable.removeAllRows();
        this.paramTable.clearSelection();
        try {
            String filePath = this.textSpl.getText();
            if (!StringUtils.isValidString(filePath)) {
                return;
            }
            PgmCellSet cellSet = AppUtil.readCellSet(filePath);
            ParamList pl = cellSet.getParamList();
            if (pl != null) {
                int i = 0;
                int size = pl.count();
                while (i < size) {
                    Param p = pl.get(i);
                    int row = this.paramTable.addRow();
                    this.paramTable.data.setValueAt(StringUtils.isValidString(p.getRemark()) ? p.getRemark() : p.getName(), row, 0);
                    this.paramTable.data.setValueAt(p.getValue(), row, 1);
                    ++i;
                }
            }
        }
        catch (Exception e1) {
            GM.showException(this, e1);
        }
    }
}

