/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.base.TableExtLibs;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.resources.AppMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DialogExtLibs
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeSplMessage.get();
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JTextField jTFExtLibsPath = new JTextField();
    private JButton jBExtLibsPath = new JButton();
    private TableExtLibs tableNames;
    private int m_option = 2;
    private Vector<String> existNames = new Vector();
    private Vector<String> dirNames = new Vector();
    private Frame parent;
    private boolean isUploadMode = false;

    public DialogExtLibs(RaqsoftConfig config, Frame frame, String extLibsPath, List<String> extLibs) {
        super(frame, IdeSplMessage.get().getMessage("dialogselectnames.title"), true);
        this.parent = frame;
        this.initDialog(config, extLibsPath, extLibs);
    }

    public DialogExtLibs(RaqsoftConfig config, JDialog jdialog, String extLibsPath, List<String> extLibs) {
        super(jdialog, IdeSplMessage.get().getMessage("dialogselectnames.title"), true);
        this.initDialog(config, extLibsPath, extLibs);
    }

    private void initDialog(RaqsoftConfig config, String extLibsPath, List<String> extLibs) {
        this.tableNames = new TableExtLibs(this);
        try {
            this.init();
            this.setConfig(config, extLibsPath, extLibs);
            this.setSize(500, 450);
            this.resetText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
            this.setResizable(true);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public String getExtLibsPath() {
        return this.jTFExtLibsPath.getText();
    }

    public List<String> getExtLibs() {
        String[] selectedNames = this.tableNames.getSelectedNames(null);
        if (selectedNames != null && selectedNames.length == 0) {
            return null;
        }
        ArrayList<String> extLibs = new ArrayList<String>();
        String[] stringArray = selectedNames;
        int n = selectedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            extLibs.add(name);
            ++n2;
        }
        return extLibs;
    }

    public void setUploadMode() {
        this.isUploadMode = true;
    }

    private void setConfig(RaqsoftConfig config, String extLibsPath, List<String> extLibs) {
        this.jTFExtLibsPath.setText(extLibsPath);
        List<String> libs = extLibs;
        if (libs != null) {
            this.existNames.addAll(libs);
        }
        this.setExtLibsPath(false);
    }

    private synchronized void setExtLibsPath(boolean showException) {
        File[] subDirs;
        this.dirNames.clear();
        String extLibsPath = this.jTFExtLibsPath.getText();
        if (!StringUtils.isValidString(extLibsPath)) {
            this.tableNames.setExistNames(null);
            this.tableNames.setExistColor(true);
            this.tableNames.setNames(null, false, true);
            return;
        }
        File extLibsDir = new File(extLibsPath = GMSpl.getAbsolutePath(extLibsPath));
        if (!extLibsDir.exists() || !extLibsDir.isDirectory()) {
            if (showException) {
                GM.messageDialog(this, AppMessage.get().getMessage("configutil.noextpath"));
            } else {
                return;
            }
        }
        if ((subDirs = extLibsDir.listFiles()) != null) {
            File[] fileArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File sd = fileArray[n2];
                if (sd.isDirectory() && this.isExtLibrary(sd)) {
                    this.dirNames.add(sd.getName());
                }
                ++n2;
            }
        }
        int existSize = this.existNames.size();
        int i = existSize - 1;
        while (i >= 0) {
            if (!this.dirNames.contains(this.existNames.get(i))) {
                this.existNames.remove(i);
            }
            --i;
        }
        this.tableNames.setExistNames(this.existNames);
        this.tableNames.setExistColor(true);
        this.tableNames.setNames(this.dirNames, false, true);
    }

    /*
     * Exception decompiling
     */
    private boolean isExtLibrary(File dir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetText() {
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jBExtLibsPath.setText(IdeCommonMessage.get().getMessage("dialogoptions.select"));
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelEast = new JPanel();
        VFlowLayout vf = new VFlowLayout();
        vf.setAlignment(0);
        vf.setHorizontalFill(true);
        panelEast.setLayout(vf);
        panelEast.add(this.jBOK);
        panelEast.add(this.jBCancel);
        this.jBOK.addActionListener(this);
        this.jBCancel.addActionListener(this);
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.setMnemonic('O');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.setMnemonic('C');
        this.getContentPane().add((Component)panelEast, "East");
        JPanel panelNorth = new JPanel(new GridBagLayout());
        JLabel jLExtLibsPath = new JLabel(IdeCommonMessage.get().getMessage("dialogoptions.extlibspath"));
        panelNorth.add((Component)jLExtLibsPath, GM.getGBC(0, 0));
        panelNorth.add((Component)this.jTFExtLibsPath, GM.getGBC(0, 1, true));
        panelNorth.add((Component)this.jBExtLibsPath, GM.getGBC(0, 2));
        JPanel panelCenter = new JPanel(new BorderLayout());
        panelCenter.add((Component)panelNorth, "North");
        panelCenter.add((Component)this.tableNames, "Center");
        JLabel labelTips = new JLabel(IdeSplMessage.get().getMessage("dialogselectnames.tips"));
        labelTips.setForeground(Color.BLUE);
        panelCenter.add((Component)labelTips, "South");
        this.getContentPane().add((Component)panelCenter, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogExtLibs.this.close();
            }
        });
        this.jTFExtLibsPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    DialogExtLibs.this.jBOK.requestFocusInWindow();
                    DialogExtLibs.this.setExtLibsPath(true);
                }
            }
        });
        this.jBExtLibsPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newPath;
                File f;
                String oldDir = DialogExtLibs.this.jTFExtLibsPath.getText();
                if (StringUtils.isValidString(oldDir) && (f = new File(oldDir)) != null && f.exists()) {
                    oldDir = f.getParent();
                }
                if (!StringUtils.isValidString(oldDir)) {
                    oldDir = GV.lastDirectory;
                }
                if ((newPath = GM.dialogSelectDirectory(DialogExtLibs.this, oldDir)) != null) {
                    DialogExtLibs.this.jTFExtLibsPath.setText(newPath);
                    DialogExtLibs.this.setExtLibsPath(true);
                }
            }
        });
    }

    private void close() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (c == null) {
            return;
        }
        if (c.equals(this.jBOK)) {
            if (this.isUploadMode) {
                String path = this.getExtLibsPath();
                if (!StringUtils.isValidString(path)) {
                    GM.messageDialog(this.parent, this.mm.getMessage("dialogextlibs.emptypath"));
                    return;
                }
                List<String> libs = this.getExtLibs();
                if (libs == null || libs.isEmpty()) {
                    GM.messageDialog(this.parent, this.mm.getMessage("dialogextlibs.emptylib"));
                    return;
                }
            }
            this.m_option = 0;
            this.close();
        } else if (c.equals(this.jBCancel)) {
            this.close();
        }
    }
}

