/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.FTPInfo;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.control.TableSelectName;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.dialog.DialogFTP_this_windowAdapter;
import com.scudata.ide.spl.dialog.DialogHostManager;
import com.scudata.ide.spl.dialog.DialogUploadResult;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import sun.net.ftp.FtpClient;

public class DialogFTP
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MessageManager mm = IdeSplMessage.get();
    private JButton jBSave = new JButton();
    private JButton jBCancel = new JButton();
    private JButton jBManage = new JButton();
    private TableSelectName tableHost = new TableSelectName(this, this.mm.getMessage("dialoguploadresult.hostname")){
        private static final long serialVersionUID = 1L;

        @Override
        public void doubleClick(int row, int col) {
            if (col == 1) {
                DialogFTP.this.hostManager();
            }
        }
    };
    private JRadioButton jRBAsc = new JRadioButton();
    private JRadioButton jRBBinary = new JRadioButton();
    private int m_option = -1;
    private boolean isLowVersionJDK = false;
    private FTPInfo[] ftpInfos = null;
    private FtpClient ftpClient = null;
    private String filePath;

    public DialogFTP() {
        super(GV.appFrame, "\u4fdd\u5b58\u5230FTP", true);
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.compareTo("1.7") < 0) {
                this.isLowVersionJDK = true;
            }
            this.init();
            this.setSize(600, 300);
            this.resetText();
            this.loadFTPInfo();
            GM.setDialogDefaultButton(this, this.jBSave, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private void loadFTPInfo() {
        try {
            this.ftpInfos = ConfigFile.getConfigFile().loadFTP("dm");
            this.setFTPInfo();
        }
        catch (Throwable e) {
            this.ftpInfos = null;
        }
    }

    private void setFTPInfo() {
        if (this.ftpInfos != null && this.ftpInfos.length > 0) {
            Vector<String> hostNames = new Vector<String>();
            Vector<String> existNames = new Vector<String>();
            int i = 0;
            while (i < this.ftpInfos.length) {
                hostNames.add(this.ftpInfos[i].getHost());
                if (this.ftpInfos[i].isSelected()) {
                    existNames.add(this.ftpInfos[i].getHost());
                }
                ++i;
            }
            this.tableHost.setExistColor(false);
            this.tableHost.setExistNames(existNames);
            this.tableHost.setNames(hostNames, false, true);
        }
    }

    private void saveFTPInfo() {
        if (this.ftpInfos != null) {
            int[] indexes = this.tableHost.getSelectedIndexes();
            IntArrayList selectedIndexes = new IntArrayList();
            if (indexes != null) {
                selectedIndexes.addAll(indexes);
            }
            int i = 0;
            while (i < this.ftpInfos.length) {
                this.ftpInfos[i].setSelected(selectedIndexes.containsInt(i));
                ++i;
            }
        }
        try {
            ConfigFile.getConfigFile().storeFTP("dm", this.ftpInfos);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void resetText() {
        this.jBSave.setText(this.mm.getMessage("button.save"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.setTitle(this.mm.getMessage("dialogftp.title"));
        this.jBManage.setText(this.mm.getMessage("dialogftp.manager"));
        this.jRBBinary.setText(this.mm.getMessage("dialogftp.binary"));
    }

    public int getOption() {
        return this.m_option;
    }

    private void save() {
        if (this.ftpInfos == null) {
            return;
        }
        int[] indexes = this.tableHost.getSelectedIndexes();
        if (indexes == null || indexes.length == 0) {
            GM.messageDialog(this, this.mm.getMessage("dialogftp.savetohost"));
            return;
        }
        boolean[] successed = new boolean[indexes.length];
        String[] exceptions = new String[indexes.length];
        FTPInfo[] selectedFtps = new FTPInfo[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            FTPInfo ftpInfo;
            selectedFtps[i] = ftpInfo = this.ftpInfos[indexes[i]];
            String host = ftpInfo.getHost();
            int port = ftpInfo.getPort();
            try {
                Method m;
                String user = ftpInfo.getUser();
                String password = ftpInfo.getPassword();
                Class<?> clz = Class.forName("sun.net.ftp.FtpClient");
                if (this.isLowVersionJDK) {
                    Constructor<?> declaredConstructor = clz.getDeclaredConstructor(new Class[0]);
                    this.ftpClient = (FtpClient)declaredConstructor.newInstance(new Object[0]);
                    m = clz.getMethod("openServer", String.class, Integer.TYPE);
                    m.invoke((Object)this.ftpClient, host, port);
                    m = clz.getMethod("login", String.class, String.class);
                    m.invoke((Object)this.ftpClient, user, password);
                    if (this.jRBAsc.isSelected()) {
                        m = clz.getMethod("ascii", new Class[0]);
                        m.invoke((Object)this.ftpClient, new Object[0]);
                    } else if (this.jRBBinary.isSelected()) {
                        m = clz.getMethod("binary", new Class[0]);
                        m.invoke((Object)this.ftpClient, new Object[0]);
                    }
                } else {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    m = clz.getMethod("create", new Class[0]);
                    this.ftpClient = (FtpClient)m.invoke(clz, new Object[0]);
                    m = clz.getMethod("connect", SocketAddress.class);
                    m.invoke((Object)this.ftpClient, addr);
                    m = clz.getMethod("login", String.class, char[].class);
                    m.invoke((Object)this.ftpClient, user, password.toCharArray());
                    if (this.jRBAsc.isSelected()) {
                        m = clz.getMethod("setAsciiType", new Class[0]);
                        m.invoke((Object)this.ftpClient, new Object[0]);
                    } else if (this.jRBBinary.isSelected()) {
                        m = clz.getMethod("setBinaryType", new Class[0]);
                        m.invoke((Object)this.ftpClient, new Object[0]);
                    }
                }
                this.upload();
                successed[i] = true;
            }
            catch (Exception ex) {
                successed[i] = false;
                exceptions[i] = ex.getMessage();
            }
            ++i;
        }
        if (this.ftpClient != null) {
            try {
                Method m;
                Class<?> clz = Class.forName("sun.net.ftp.FtpClient");
                if (this.isLowVersionJDK) {
                    m = clz.getMethod("closeServer", new Class[0]);
                    m.invoke((Object)this.ftpClient, new Object[0]);
                } else {
                    m = clz.getMethod("close", new Class[0]);
                    m.invoke((Object)this.ftpClient, new Object[0]);
                }
            }
            catch (Exception clz) {
                // empty catch block
            }
        }
        DialogUploadResult dur = new DialogUploadResult(this);
        dur.setResult(selectedFtps, successed, exceptions);
        dur.setVisible(true);
    }

    public void upload() throws Exception {
        File file = new File(this.filePath);
        FileInputStream fis = null;
        OutputStream tos = null;
        try {
            Method m;
            fis = new FileInputStream(this.filePath);
            Class<?> clz = Class.forName("sun.net.ftp.FtpClient");
            if (this.isLowVersionJDK) {
                m = clz.getMethod("put", String.class);
                tos = (OutputStream)m.invoke((Object)this.ftpClient, file.getName());
            } else {
                m = clz.getMethod("putFileStream", String.class, Boolean.TYPE);
                tos = (OutputStream)m.invoke((Object)this.ftpClient, file.getName(), true);
            }
            int readLength = 0;
            byte[] buf = new byte[1024];
            while ((readLength = fis.read(buf)) != -1) {
                tos.write(buf, 0, readLength);
            }
            tos.flush();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (tos != null) {
                tos.close();
            }
        }
    }

    private void init() throws Exception {
        JPanel panelEast = new JPanel(new VFlowLayout());
        this.jBSave.setMnemonic('S');
        this.jBSave.setText("\u4fdd\u5b58(S)");
        this.jBSave.addActionListener(this);
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(this);
        this.jBManage.setMnemonic('M');
        this.jBManage.setText("\u4e3b\u673a\u7ba1\u7406(M)");
        this.jBManage.addActionListener(this);
        JLabel labelOpt = new JLabel(this.mm.getMessage("dialogftp.sendtype"));
        this.jRBAsc.setText("ASCII");
        this.jRBBinary.setText("\u4e8c\u8fdb\u5236");
        ButtonGroup bgOpt = new ButtonGroup();
        bgOpt.add(this.jRBAsc);
        bgOpt.add(this.jRBBinary);
        this.jRBBinary.setSelected(true);
        this.getContentPane().add((Component)panelEast, "East");
        panelEast.add((Component)this.jBSave, null);
        panelEast.add((Component)this.jBCancel, null);
        panelEast.add(new JPanel());
        panelEast.add(this.jBManage);
        JPanel panelCenter = new JPanel(new GridBagLayout());
        panelCenter.add((Component)this.tableHost, GM.getGBC(1, 1, true, true));
        JPanel panelOpt = new JPanel(new GridLayout(1, 3));
        panelOpt.add(labelOpt);
        panelOpt.add(this.jRBAsc);
        panelOpt.add(this.jRBBinary);
        this.getContentPane().add((Component)panelCenter, "Center");
        this.addWindowListener(new DialogFTP_this_windowAdapter(this));
    }

    void this_windowClosing(WindowEvent e) {
        this.saveFTPInfo();
        GM.setWindowDimension(this);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.jBSave.equals(src)) {
            this.save();
        } else if (this.jBCancel.equals(src)) {
            this.saveFTPInfo();
            GM.setWindowDimension(this);
            this.dispose();
        } else if (this.jBManage.equals(src)) {
            this.hostManager();
        }
    }

    private void hostManager() {
        DialogHostManager dhm = new DialogHostManager(this);
        dhm.setFTPInfo(this.ftpInfos);
        dhm.setVisible(true);
        if (dhm.getOption() == 0) {
            this.ftpInfos = dhm.getFTPInfo();
            this.setFTPInfo();
        }
    }
}

