/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.LookAndFeelManager;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.ColorComboBox;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.base.PanelEnv;
import com.scudata.ide.spl.dialog.DialogOptions_jBCancel_actionAdapter;
import com.scudata.ide.spl.dialog.DialogOptions_jBOK_actionAdapter;
import com.scudata.ide.spl.dialog.DialogOptions_this_windowAdapter;
import com.scudata.ide.spl.resources.IdeSplMessage;
import com.scudata.parallel.UnitContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

public class DialogOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    public MessageManager mm = IdeCommonMessage.get();
    private int m_option = -1;
    private JButton jBOK = new JButton();
    private JButton jBCancel = new JButton();
    private JComboBoxEx jCBLNF = new JComboBoxEx();
    private JCheckBox jCBAutoBackup = new JCheckBox();
    private JCheckBox jCBAutoConnect = new JCheckBox();
    private final String AUTO_SAVE_TIP = this.mm.getMessage("dialogoptions.autosavetip", (int)ConfigOptions.iAutoSaveMinutes);
    private JCheckBox jCBAutoSave = new JCheckBox(this.mm.getMessage("dialogoptions.autosave"));
    private JLabel jLAutoSaveInterval = new JLabel(this.mm.getMessage("dialogoptions.autosaveinterval"));
    protected GridLayout ideOptLayout = new GridLayout(5, 2);
    protected JPanel jPIdeOpt = new JPanel();
    private JSpinner jSAutoSaveInterval = new JSpinner(new SpinnerNumberModel(ConfigOptions.iAutoSaveMinutes, 1, 1440, 1));
    private JLabel jLAutoSaveMinutes = new JLabel(this.mm.getMessage("dialogoptions.autosaveminutes"));
    private JCheckBox jCBAutoTrimChar0 = new JCheckBox();
    private JLabel jLUndoCount = new JLabel(IdeSplMessage.get().getMessage("dialogoptions.undocount"));
    private JSpinner jSUndoCount = new JSpinner(new SpinnerNumberModel(20, 5, Integer.MAX_VALUE, 1));
    protected JTabbedPane tabMain = new JTabbedPane();
    private JSpinner jSConnectTimeout = new JSpinner(new SpinnerNumberModel(10, 0, Integer.MAX_VALUE, 1));
    private JSpinner jSFontSize = new JSpinner(new SpinnerNumberModel(12, 1, 36, 1));
    private JLabel jLabelTimeout = new JLabel();
    private JLabel jLabel9 = new JLabel();
    private JCheckBox jCBIdeConsole = new JCheckBox();
    private JCheckBox jCBAutoOpen = new JCheckBox();
    private JCheckBox jCBShowDBStruct = new JCheckBox();
    private JLabel jLabelNote = new JLabel();
    private JLabel jLabel22 = new JLabel();
    private JCheckBox jCBWindow = new JCheckBox();
    private JCheckBox jCBDispOutCell = new JCheckBox();
    private JCheckBox jCBMultiLineExpEditor = new JCheckBox();
    private JCheckBox jCBStepLastLocation = new JCheckBox();
    private JCheckBox jCBAutoSizeRowHeight = new JCheckBox();
    private JCheckBox jCBAdjustNoteCell = new JCheckBox(this.mm.getMessage("dialogoptions.adjustnotecell"));
    private JLabel jLabelLevel = new JLabel();
    private JComboBoxEx jCBLevel = new JComboBoxEx();
    private JLabel jLabelLogType = new JLabel();
    private JComboBoxEx jCBLogType = new JComboBoxEx();
    private JLabel jLXmx = new JLabel(this.mm.getMessage("dialogoptions.xmx"));
    private JTextField jTFXmx = new JTextField();
    private JLabel jLGCLog = new JLabel(this.mm.getMessage("dialogoptions.gclog"));
    private JTextField jTFGCLog = new JTextField();
    private JButton jBGCLog = new JButton(this.mm.getMessage("dialogoptions.select"));
    private JCheckBox jCBPrintGCDetails = new JCheckBox(this.mm.getMessage("dialogoptions.printgcdetails"));
    private JCheckBox jCBPrintGCTimeStamps = new JCheckBox(this.mm.getMessage("dialogoptions.printgctime"));
    private JCheckBox jCBPrintGCDateStamps = new JCheckBox(this.mm.getMessage("dialogoptions.printgcdate"));
    private JCheckBox jCBPrintHeapAtGC = new JCheckBox(this.mm.getMessage("dialogoptions.printheap"));
    private JSpinner jSPRowCount;
    private JSpinner jSPColCount;
    private JSpinner jSPRowHeight;
    private JSpinner jSPColWidth;
    private ColorComboBox constFColor;
    private ColorComboBox constBColor;
    private ColorComboBox noteFColor;
    private ColorComboBox noteBColor;
    private ColorComboBox valFColor;
    private ColorComboBox valBColor;
    private ColorComboBox nValFColor;
    private ColorComboBox nValBColor;
    private JComboBox jCBFontName;
    private JComboBoxEx jCBFontSize;
    private JCheckBox jCBBold;
    private JCheckBox jCBItalic;
    private JCheckBox jCBUnderline;
    private JCheckBox jCBGridline;
    private JSpinner jSPIndent;
    private JComboBoxEx jCBHAlign;
    private JComboBoxEx jCBVAlign;
    private JLabel labelFontSize = new JLabel(this.mm.getMessage("dialogoptions.fontsize"));
    private JSpinner jSSeqMembers;
    private JLabel labelLocale = new JLabel(this.mm.getMessage("dialogoptions.labellocale"));
    private JLabel labelFontName = new JLabel(this.mm.getMessage("dialogoptions.fontname"));
    private JComboBoxEx jCBLocale = new JComboBoxEx();
    private final byte TAB_NORMAL = 0;
    private final byte TAB_ENV = 1;
    private boolean isUnit = false;
    private boolean isCtrlDown = false;
    protected JPanel panelEsprocEnv = new JPanel(new GridBagLayout());
    protected PanelEnv panelEnv;
    protected JLabel jLConfigFile = new JLabel(this.mm.getMessage("dialogoptions.configfile"));
    protected JComboBoxEx jCBConfigFile = new JComboBoxEx();
    protected JButton jBLoadConfig = new JButton(this.mm.getMessage("dialogoptions.select"));
    protected JButton jBSaveConfig = new JButton(this.mm.getMessage("dialogoptions.saveconfigfile"));
    protected boolean preventChange = true;
    protected RaqsoftConfig activeConfig = GV.config;
    private String oldXmx = null;
    private boolean oldPrintGCDetails = false;
    private boolean oldPrintGCTimeStamps = false;
    private boolean oldPrintGCDateStamps = false;
    private String oldGCLogFile = null;
    private boolean oldPrintHeapAtGC = false;
    public static final Color NOTE_COLOR = new Color(165, 0, 0);
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (DialogOptions.this.isUnit) {
                return;
            }
            if (e.getKeyCode() == 9 && e.isControlDown()) {
                DialogOptions.this.showNextTab();
                DialogOptions.this.isCtrlDown = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                DialogOptions.this.isCtrlDown = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };

    public DialogOptions() {
        this(GV.appFrame, false);
    }

    public DialogOptions(JFrame parent, boolean isUnit) {
        super(parent, "\u9009\u9879", true);
        try {
            try {
                this.preventChange = true;
                this.isUnit = isUnit;
                if (isUnit) {
                    this.loadUnitServerConfig();
                    GV.dsModel = new DataSourceListModel();
                }
                this.initUI();
                this.load();
                int dialogWidth = 830;
                int dialogHeight = 590;
                if (GC.LANGUAGE == 0 && !isUnit) {
                    dialogWidth = 700;
                }
                this.setSize(dialogWidth, dialogHeight);
                if (isUnit) {
                    ConfigOptions.bWindowSize = Boolean.FALSE;
                }
                GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
                this.resetLangText();
                this.jCBMultiLineExpEditor.setVisible(false);
                this.addListener(this.tabMain);
                this.setResizable(true);
            }
            catch (Exception ex) {
                GM.showException(this, ex);
                this.preventChange = false;
            }
        }
        finally {
            this.preventChange = false;
        }
    }

    public int getOption() {
        return this.m_option;
    }

    protected void saveCustom() {
    }

    protected boolean isExtEnabled() {
        return true;
    }

    protected RaqsoftConfig loadConfigFile(String filePath) throws Exception {
        String path = GM.getAbsolutePath(filePath);
        RaqsoftConfig config = ConfigUtil.load(path, false, false);
        this.panelEnv.setConfig(config);
        this.jCBLevel.x_setSelectedCodeItem(config.getLogLevel());
        this.jCBLogType.x_setSelectedCodeItem(config.getLogType());
        this.activeConfig = config;
        try {
            this.preventChange = true;
            this.jCBConfigFile.setSelectedItem(filePath);
        }
        finally {
            this.preventChange = false;
        }
        return config;
    }

    protected boolean saveAsConfigFile() {
        try {
            if (!this.save()) {
                return false;
            }
        }
        catch (Throwable e) {
            GM.showException(this, e);
            return false;
        }
        File f = GM.dialogSelectFile(this, "xml");
        if (f == null) {
            return false;
        }
        try {
            ConfigUtilIde.writeConfig(true, this.activeConfig, f);
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
        return true;
    }

    private boolean isArgChanged(String oldArg, String newArg) {
        if (StringUtils.isValidString(oldArg)) {
            if (!StringUtils.isValidString(newArg)) {
                return true;
            }
            if (!oldArg.equalsIgnoreCase(newArg)) {
                return true;
            }
        } else if (StringUtils.isValidString(newArg)) {
            return true;
        }
        return false;
    }

    private boolean save() throws Throwable {
        boolean newPrintHeapAtGC;
        boolean newPrintGCDateStamps;
        boolean newPrintGCTimeStamps;
        boolean newPrintGCDetails;
        String newGCLogFile;
        try {
            if (!this.panelEnv.checkValid()) {
                return false;
            }
        }
        catch (Exception ex) {
            if (!this.isUnit) {
                this.tabMain.setSelectedIndex(1);
            }
            GM.messageDialog(this, ex.getMessage());
            return false;
        }
        if (!this.checkXmx()) {
            if (!this.isUnit) {
                this.tabMain.setSelectedIndex(0);
            }
            return false;
        }
        HashMap<String, String> jvmArgMap = new HashMap<String, String>();
        String newXmx = this.jTFXmx.getText();
        if (this.isArgChanged(this.oldXmx, newXmx)) {
            newXmx = newXmx.trim();
            try {
                Integer.parseInt(newXmx);
                newXmx = String.valueOf(newXmx) + "M";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isValidString(newXmx)) {
                jvmArgMap.put("-Xmx", "-Xmx" + newXmx);
                jvmArgMap.put("-Xms", "-Xms" + newXmx);
            } else {
                jvmArgMap.put("-Xmx", "");
                jvmArgMap.put("-Xms", "");
            }
        }
        if (this.isArgChanged(this.oldGCLogFile, newGCLogFile = this.jTFGCLog.getText())) {
            if (StringUtils.isValidString(newGCLogFile)) {
                if (GM.isWindowsOS()) {
                    newGCLogFile = Escape.addEscAndQuote(newGCLogFile);
                }
                jvmArgMap.put("-Xloggc:", "-Xloggc:" + newGCLogFile);
            } else {
                jvmArgMap.put("-Xloggc:", "");
            }
        }
        if (this.oldPrintGCDetails != (newPrintGCDetails = this.jCBPrintGCDetails.isSelected())) {
            jvmArgMap.put("-XX:+PrintGCDetails", newPrintGCDetails ? "-XX:+PrintGCDetails" : "");
        }
        if (this.oldPrintGCTimeStamps != (newPrintGCTimeStamps = this.jCBPrintGCTimeStamps.isSelected())) {
            jvmArgMap.put("-XX:+PrintGCTimeStamps", newPrintGCTimeStamps ? "-XX:+PrintGCTimeStamps" : "");
        }
        if (this.oldPrintGCDateStamps != (newPrintGCDateStamps = this.jCBPrintGCDateStamps.isSelected())) {
            jvmArgMap.put("-XX:+PrintGCDateStamps", newPrintGCDateStamps ? "-XX:+PrintGCDateStamps" : "");
        }
        if (this.oldPrintHeapAtGC != (newPrintHeapAtGC = this.jCBPrintHeapAtGC.isSelected())) {
            jvmArgMap.put("-XX:+PrintHeapAtGC", newPrintHeapAtGC ? "-XX:+PrintHeapAtGC" : "");
        }
        if (!jvmArgMap.isEmpty()) {
            GMSpl.setJVMArgs(jvmArgMap);
        }
        ConfigOptions.iUndoCount = (Integer)this.jSUndoCount.getValue();
        ConfigOptions.bIdeConsole = new Boolean(this.jCBIdeConsole.isSelected());
        ConfigOptions.bAutoOpen = new Boolean(this.jCBAutoOpen.isSelected());
        ConfigOptions.bAutoBackup = new Boolean(this.jCBAutoBackup.isSelected());
        ConfigOptions.bAutoConnect = new Boolean(this.jCBAutoConnect.isSelected());
        ConfigOptions.bAutoSave = new Boolean(this.jCBAutoSave.isSelected());
        ConfigOptions.iAutoSaveMinutes = ((Number)this.jSAutoSaveInterval.getValue()).intValue();
        ConfigOptions.bAutoTrimChar0 = new Boolean(this.jCBAutoTrimChar0.isSelected());
        ConfigOptions.bAdjustNoteCell = new Boolean(this.jCBAdjustNoteCell.isSelected());
        ConfigOptions.bWindowSize = new Boolean(this.jCBWindow.isSelected());
        ConfigOptions.iLookAndFeel = (Byte)this.jCBLNF.x_getSelectedItem();
        ConfigOptions.iConnectTimeout = (Integer)this.jSConnectTimeout.getValue();
        ConfigOptions.iFontSize = ((Integer)this.jSFontSize.getValue()).shortValue();
        ConfigOptions.bDispOutCell = new Boolean(this.jCBDispOutCell.isSelected());
        ConfigOptions.bMultiLineExpEditor = new Boolean(this.jCBMultiLineExpEditor.isSelected());
        ConfigOptions.bStepLastLocation = new Boolean(this.jCBStepLastLocation.isSelected());
        ConfigOptions.bAutoSizeRowHeight = new Boolean(this.jCBAutoSizeRowHeight.isSelected());
        ConfigOptions.bShowDBStruct = new Boolean(this.jCBShowDBStruct.isSelected());
        ConfigOptions.iRowCount = (Integer)this.jSPRowCount.getValue();
        ConfigOptions.iColCount = (Integer)this.jSPColCount.getValue();
        ConfigOptions.fRowHeight = new Float(this.jSPRowHeight.getValue().toString());
        ConfigOptions.fColWidth = new Float(this.jSPColWidth.getValue().toString());
        ConfigOptions.iConstFColor = new Color(this.constFColor.getColor());
        ConfigOptions.iConstBColor = new Color(this.constBColor.getColor());
        ConfigOptions.iNoteFColor = new Color(this.noteFColor.getColor());
        ConfigOptions.iNoteBColor = new Color(this.noteBColor.getColor());
        ConfigOptions.iValueFColor = new Color(this.valFColor.getColor());
        ConfigOptions.iValueBColor = new Color(this.valBColor.getColor());
        ConfigOptions.iNValueFColor = new Color(this.nValFColor.getColor());
        ConfigOptions.iNValueBColor = new Color(this.nValBColor.getColor());
        ConfigOptions.sFontName = (String)this.jCBFontName.getSelectedItem();
        Object oSize = this.jCBFontSize.x_getSelectedItem();
        Short iSize = oSize instanceof String ? new Short((String)oSize) : (Short)oSize;
        ConfigOptions.iFontSize = iSize;
        ConfigOptions.bBold = new Boolean(this.jCBBold.isSelected());
        ConfigOptions.bItalic = new Boolean(this.jCBItalic.isSelected());
        ConfigOptions.bUnderline = new Boolean(this.jCBUnderline.isSelected());
        ConfigOptions.bGridline = new Boolean(this.jCBGridline.isSelected());
        ConfigOptions.iIndent = (Integer)this.jSPIndent.getValue();
        ConfigOptions.iSequenceDispMembers = (Integer)this.jSSeqMembers.getValue();
        ConfigOptions.iHAlign = (Byte)this.jCBHAlign.x_getSelectedItem();
        ConfigOptions.iVAlign = (Byte)this.jCBVAlign.x_getSelectedItem();
        ConfigOptions.iLocale = (Byte)this.jCBLocale.x_getSelectedItem();
        this.saveCustom();
        this.panelEnv.save();
        if (GVSpl.splEditor != null) {
            GVSpl.splEditor.getComponent().repaint();
        }
        String sLogLevel = (String)this.jCBLevel.x_getSelectedItem();
        this.activeConfig.setLogLevel(sLogLevel);
        Logger.setLevel(sLogLevel);
        String sLogType = (String)this.jCBLogType.x_getSelectedItem();
        this.activeConfig.setLogType(sLogType);
        Logger.setLogType(sLogType);
        if (!this.isUnit && GV.config != this.activeConfig) {
            GM.resetDataSource(this.activeConfig);
            GM.clearEnv();
        }
        ConfigOptions.sConfigFile = this.getConfigFile();
        ConfigOptions.save(!this.isUnit);
        try {
            if (this.isUnit) {
                File f = new File(GM.getAbsolutePath("config"), "raqsoftConfig.xml");
                ConfigUtilIde.writeConfig(!this.isUnit, this.activeConfig, f);
            } else {
                ConfigUtilIde.writeConfig(!this.isUnit, this.activeConfig);
            }
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
        GV.config = this.activeConfig;
        return true;
    }

    private void load() {
        String[] JVM_ARG_KEYS = new String[]{"-Xmx", "-XX:+PrintGCDetails", "-XX:+PrintGCTimeStamps", "-XX:+PrintGCDateStamps", "-Xloggc:", "-XX:+PrintHeapAtGC"};
        Map<String, String> jvmArgMap = GMSpl.getJVMArgs(JVM_ARG_KEYS);
        if (jvmArgMap != null) {
            String printHeapAtGC;
            String printGCDateStamps;
            String printGCTimeStamps;
            String printGCDetails;
            String gcLogFile;
            String xmx = jvmArgMap.get("-Xmx");
            if (StringUtils.isValidString(xmx)) {
                this.oldXmx = xmx.substring("-Xmx".length());
                if (StringUtils.isValidString(this.oldXmx)) {
                    this.oldXmx = this.oldXmx.trim();
                    this.jTFXmx.setText(this.oldXmx);
                }
            }
            if (StringUtils.isValidString(gcLogFile = jvmArgMap.get("-Xloggc:")) && StringUtils.isValidString(gcLogFile = gcLogFile.substring("-Xloggc:".length()))) {
                this.oldGCLogFile = gcLogFile.trim();
                if (GM.isWindowsOS()) {
                    this.oldGCLogFile = Escape.removeEscAndQuote(this.oldGCLogFile);
                }
                this.jTFGCLog.setText(this.oldGCLogFile);
            }
            if (StringUtils.isValidString(printGCDetails = jvmArgMap.get("-XX:+PrintGCDetails"))) {
                this.oldPrintGCDetails = true;
                this.jCBPrintGCDetails.setSelected(true);
            }
            if (StringUtils.isValidString(printGCTimeStamps = jvmArgMap.get("-XX:+PrintGCTimeStamps"))) {
                this.oldPrintGCTimeStamps = true;
                this.jCBPrintGCTimeStamps.setSelected(true);
            }
            if (StringUtils.isValidString(printGCDateStamps = jvmArgMap.get("-XX:+PrintGCDateStamps"))) {
                this.oldPrintGCDateStamps = true;
                this.jCBPrintGCDateStamps.setSelected(true);
            }
            if (StringUtils.isValidString(printHeapAtGC = jvmArgMap.get("-XX:+PrintHeapAtGC"))) {
                this.oldPrintHeapAtGC = true;
                this.jCBPrintHeapAtGC.setSelected(true);
            }
        }
        this.jSUndoCount.setValue(ConfigOptions.iUndoCount);
        this.jCBIdeConsole.setSelected(ConfigOptions.bIdeConsole);
        this.jCBAutoOpen.setSelected(ConfigOptions.bAutoOpen);
        this.jCBAutoBackup.setSelected(ConfigOptions.bAutoBackup);
        this.jCBAutoConnect.setSelected(ConfigOptions.bAutoConnect);
        this.jCBAutoSave.setSelected(ConfigOptions.bAutoSave);
        this.jSAutoSaveInterval.setValue((int)ConfigOptions.iAutoSaveMinutes);
        this.jCBAutoTrimChar0.setSelected(ConfigOptions.bAutoTrimChar0);
        this.jCBWindow.setSelected(ConfigOptions.bWindowSize);
        this.jCBDispOutCell.setSelected(ConfigOptions.bDispOutCell);
        this.jCBMultiLineExpEditor.setSelected(ConfigOptions.bMultiLineExpEditor);
        this.jCBStepLastLocation.setSelected(ConfigOptions.bStepLastLocation);
        this.jCBAutoSizeRowHeight.setSelected(ConfigOptions.bAutoSizeRowHeight);
        this.jCBShowDBStruct.setSelected(ConfigOptions.bShowDBStruct);
        this.jCBAdjustNoteCell.setSelected(ConfigOptions.bAdjustNoteCell);
        this.jCBAdjustNoteCell.setSelected(Env.isAdjustNoteCell());
        this.jCBLevel.x_setSelectedCodeItem(Logger.getLevelName(Logger.getLevel()));
        this.jCBLogType.x_setSelectedCodeItem(this.activeConfig.getLogType());
        this.jCBLNF.x_setSelectedCodeItem(LookAndFeelManager.getValidLookAndFeel(ConfigOptions.iLookAndFeel));
        this.jSConnectTimeout.setValue(ConfigOptions.iConnectTimeout);
        this.jSFontSize.setValue(new Integer(ConfigOptions.iFontSize.intValue()));
        this.jSPRowCount.setValue(ConfigOptions.iRowCount);
        this.jSPColCount.setValue(ConfigOptions.iColCount);
        this.jSPRowHeight.setValue(new Double(ConfigOptions.fRowHeight.floatValue()));
        this.jSPColWidth.setValue(new Double(ConfigOptions.fColWidth.floatValue()));
        this.constFColor.setSelectedItem(new Integer(ConfigOptions.iConstFColor.getRGB()));
        this.constBColor.setSelectedItem(new Integer(ConfigOptions.iConstBColor.getRGB()));
        this.noteFColor.setSelectedItem(new Integer(ConfigOptions.iNoteFColor.getRGB()));
        this.noteBColor.setSelectedItem(new Integer(ConfigOptions.iNoteBColor.getRGB()));
        this.valFColor.setSelectedItem(new Integer(ConfigOptions.iValueFColor.getRGB()));
        this.valBColor.setSelectedItem(new Integer(ConfigOptions.iValueBColor.getRGB()));
        this.nValFColor.setSelectedItem(new Integer(ConfigOptions.iNValueFColor.getRGB()));
        this.nValBColor.setSelectedItem(new Integer(ConfigOptions.iNValueBColor.getRGB()));
        this.jCBFontName.setSelectedItem(ConfigOptions.sFontName);
        this.jCBFontSize.setSelectedItem(ConfigOptions.iFontSize);
        this.jCBBold.setSelected(ConfigOptions.bBold);
        this.jCBItalic.setSelected(ConfigOptions.bItalic);
        this.jCBUnderline.setSelected(ConfigOptions.bUnderline);
        this.jCBGridline.setSelected(ConfigOptions.bGridline);
        this.jSPIndent.setValue(ConfigOptions.iIndent);
        this.jSSeqMembers.setValue(ConfigOptions.iSequenceDispMembers);
        this.jCBHAlign.x_setSelectedCodeItem(this.compatibleHalign(ConfigOptions.iHAlign));
        this.jCBVAlign.x_setSelectedCodeItem(this.compatibleValign(ConfigOptions.iVAlign));
        this.panelEnv.setConfig(this.activeConfig);
        try {
            List<String> configFiles = ConfigFile.getConfigFile().getRecentConfigFiles("dm");
            String[] paths = null;
            if (configFiles != null && !configFiles.isEmpty()) {
                paths = new String[configFiles.size()];
                int i = 0;
                while (i < configFiles.size()) {
                    paths[i] = configFiles.get(i);
                    ++i;
                }
            }
            this.jCBConfigFile.setListData(paths);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.jCBConfigFile.setSelectedItem(ConfigOptions.sConfigFile == null ? "" : ConfigOptions.sConfigFile);
        if (ConfigOptions.iLocale != null) {
            this.jCBLocale.x_setSelectedCodeItem((byte)ConfigOptions.iLocale);
        } else if (GC.LANGUAGE == 0) {
            this.jCBLocale.x_setSelectedCodeItem(new Byte(0));
        } else {
            this.jCBLocale.x_setSelectedCodeItem(new Byte(4));
        }
        this.autoOpenChanged();
    }

    private RaqsoftConfig loadUnitServerConfig() {
        block12: {
            InputStream is = null;
            try {
                try {
                    is = UnitContext.getUnitInputStream("raqsoftConfig.xml");
                    this.activeConfig = ConfigUtilIde.loadConfig(is);
                }
                catch (Exception x) {
                    this.activeConfig = new RaqsoftConfig();
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.activeConfig;
    }

    private void autoOpenChanged() {
        boolean isAutoOpen = this.jCBAutoOpen.isSelected();
        this.jCBAutoSave.setEnabled(isAutoOpen);
        if (!this.jCBAutoOpen.isSelected() && this.jCBAutoSave.isSelected()) {
            this.jCBAutoSave.setSelected(false);
        }
        this.autoSaveChanged();
    }

    private void autoSaveChanged() {
        boolean isAutoSave = this.jCBAutoSave.isSelected();
        this.jLAutoSaveInterval.setEnabled(isAutoSave);
        this.jSAutoSaveInterval.setEnabled(isAutoSave);
        this.jLAutoSaveMinutes.setEnabled(isAutoSave);
    }

    private void showNextTab() {
        int size = this.tabMain.getComponentCount();
        if (size <= 1) {
            return;
        }
        int index = size - 1;
        int i = this.tabMain.getSelectedIndex();
        index = this.isCtrlDown ? size - 1 : (i == size - 1 ? 0 : i + 1);
        this.tabMain.setSelectedIndex(index);
    }

    private void addListener(JComponent comp) {
        Component[] comps = comp.getComponents();
        if (comps != null) {
            int i = 0;
            while (i < comps.length) {
                if (comps[i] instanceof JComponent) {
                    JComponent jcomp = (JComponent)comps[i];
                    jcomp.addKeyListener(this.keyListener);
                    this.addListener(jcomp);
                }
                ++i;
            }
        }
    }

    void resetLangText() {
        this.setTitle(this.mm.getMessage("dialogoptions.title"));
        this.jBOK.setText(this.mm.getMessage("button.ok"));
        this.jBCancel.setText(this.mm.getMessage("button.cancel"));
        this.jCBIdeConsole.setText(this.mm.getMessage("dialogoptions.ideconsole"));
        this.jCBAutoOpen.setText(this.mm.getMessage("dialogoptions.autoopen"));
        this.jCBAutoBackup.setText(this.mm.getMessage("dialogoptions.autobackup"));
        this.jCBAutoConnect.setText(this.mm.getMessage("dialogoptions.autoconnect"));
        this.jCBAutoTrimChar0.setText(this.mm.getMessage("dialogoptions.autotrimchar0"));
        this.jCBWindow.setText(this.mm.getMessage("dialogoptions.windowsize"));
        this.jLabel22.setText(this.mm.getMessage("dialogoptions.applnf"));
        this.jLabelTimeout.setText(this.mm.getMessage("dialogoptions.timeoutnum"));
        this.jLabel9.setText(this.mm.getMessage("dialogoptions.second"));
        this.jLabelNote.setText(this.mm.getMessage("dialogoptions.attention"));
        this.jLabelLevel.setText(this.mm.getMessage("dialogoptions.loglevel"));
        this.jLabelLogType.setText(this.mm.getMessage("dialogoptions.logtype"));
        this.jCBDispOutCell.setText(this.mm.getMessage("dialogoptions.dispoutcell"));
        this.jCBAutoSizeRowHeight.setText(this.mm.getMessage("dialogoptions.autosizerowheight"));
        this.jCBShowDBStruct.setText(this.mm.getMessage("dialogoptions.showdbstruct"));
        this.jCBMultiLineExpEditor.setText(this.mm.getMessage("dialogoptions.multiline"));
        this.jCBStepLastLocation.setText(this.mm.getMessage("dialogoptions.steplastlocation"));
    }

    private void initUI() throws Exception {
        this.jCBAutoBackup.setText("\u4fdd\u5b58\u65f6\u81ea\u52a8\u5907\u4efd\uff08\u52a0\u6587\u4ef6\u540e\u7f00.BAK\uff09");
        this.jCBAutoConnect.setText("\u81ea\u52a8\u8fde\u63a5\uff08\u6700\u8fd1\u8fde\u63a5\uff09");
        this.jCBAutoConnect.setEnabled(true);
        this.jCBAutoConnect.setForeground(Color.blue);
        this.labelLocale.setForeground(Color.blue);
        this.jLabelTimeout.setText("\u8fde\u63a5\u5230\u6570\u636e\u5e93\u65f6\u6700\u957f\u7b49\u5f85");
        this.jSConnectTimeout.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jSConnectTimeout.setPreferredSize(new Dimension(80, 25));
        this.jLXmx.setForeground(Color.BLUE);
        this.jLGCLog.setForeground(Color.BLUE);
        this.jCBPrintGCDetails.setForeground(Color.BLUE);
        this.jCBPrintGCTimeStamps.setForeground(Color.BLUE);
        this.jCBPrintGCDateStamps.setForeground(Color.BLUE);
        this.jCBPrintHeapAtGC.setForeground(Color.BLUE);
        this.jSFontSize.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jCBIdeConsole.setText("\u63a5\u7ba1\u63a7\u5236\u53f0");
        this.jCBAutoOpen.setForeground(Color.blue);
        this.jCBAutoOpen.setText("\u81ea\u52a8\u6253\u5f00\uff08\u6700\u8fd1\u6587\u4ef6\uff09");
        this.jLabel9.setText("\u79d2");
        this.jLabelNote.setForeground(NOTE_COLOR);
        this.jLabelNote.setText("\u6ce8\u610f\uff1a\u9009\u9879\u91cc\u9762\u84dd\u8272\u7684\u9009\u9879\u9700\u8981\u91cd\u65b0\u542f\u52a8IDE\u624d\u80fd\u751f\u6548\u3002");
        this.jLabel22.setForeground(Color.blue);
        this.jLabel22.setText("\u5e94\u7528\u7a0b\u5e8f\u5916\u89c2");
        this.jCBWindow.setText("\u8bb0\u5fc6\u7a97\u53e3\u4f4d\u7f6e\u5927\u5c0f");
        this.jCBDispOutCell.setText("\u5185\u5bb9\u51b2\u51fa\u5355\u5143\u683c\u663e\u793a");
        this.jCBMultiLineExpEditor.setText("\u591a\u884c\u8868\u8fbe\u5f0f\u7f16\u8f91");
        this.jCBStepLastLocation.setText("\u5355\u6b65\u6267\u884c\u65f6\u5149\u6807\u8ddf\u968f");
        this.jCBAutoSizeRowHeight.setText("\u81ea\u52a8\u8c03\u6574\u884c\u9ad8");
        Vector<Byte> lnfCodes = LookAndFeelManager.listLNFCode();
        Vector<String> lnfDisps = LookAndFeelManager.listLNFDisp();
        this.jCBLNF.x_setData(lnfCodes, lnfDisps);
        JPanel jPanelButton = new JPanel();
        VFlowLayout VFlowLayout1 = new VFlowLayout();
        jPanelButton.setLayout(VFlowLayout1);
        this.jBOK.setActionCommand("");
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new DialogOptions_jBOK_actionAdapter(this));
        this.jBOK.setMnemonic('O');
        this.jBCancel.setActionCommand("");
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new DialogOptions_jBCancel_actionAdapter(this));
        this.jBCancel.setMnemonic('C');
        jPanelButton.add((Component)this.jBOK, null);
        jPanelButton.add((Component)this.jBCancel, null);
        this.jLabelLevel.setText("\u65e5\u5fd7\u7ea7\u522b");
        this.jCBLevel.x_setData(ConfigOptions.dispLevels(), ConfigOptions.dispLevels());
        this.jCBLevel.x_setSelectedCodeItem(Logger.DEBUG);
        this.jLabelLogType.setText("\u65e5\u5fd7\u7c7b\u578b");
        this.jCBLogType.x_setData(ConfigOptions.codeLogTypes(), ConfigOptions.dispLogTypes());
        this.jCBLogType.x_setSelectedCodeItem("default");
        JPanel panelNormal = new JPanel(new VFlowLayout(0));
        panelNormal.add(this.jPIdeOpt);
        this.jPIdeOpt.setLayout(this.ideOptLayout);
        this.jPIdeOpt.add((Component)this.jCBIdeConsole, null);
        this.jPIdeOpt.add((Component)this.jCBAutoBackup, null);
        this.jPIdeOpt.add((Component)this.jCBAutoConnect, null);
        this.jPIdeOpt.add((Component)this.jCBWindow, null);
        this.jPIdeOpt.add((Component)this.jCBDispOutCell, null);
        this.jPIdeOpt.add((Component)this.jCBAutoSizeRowHeight, null);
        this.jPIdeOpt.add((Component)this.jCBShowDBStruct, null);
        this.jPIdeOpt.add((Component)this.jCBStepLastLocation, null);
        this.jPIdeOpt.add((Component)this.jCBAutoTrimChar0, null);
        this.jPIdeOpt.add((Component)this.jCBAdjustNoteCell, null);
        this.jCBFontName = new JComboBox<String>(GM.getFontNames());
        FlowLayout fl1 = new FlowLayout(0);
        fl1.setHgap(0);
        JPanel jPanelTimeout = new JPanel();
        jPanelTimeout.setLayout(fl1);
        jPanelTimeout.add(this.jSConnectTimeout);
        jPanelTimeout.add(this.jLabel9);
        boolean isHighVersionJDK = false;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.9") > 0) {
            isHighVersionJDK = true;
        }
        JPanel panelMid = new JPanel(new GridBagLayout());
        if (!isHighVersionJDK) {
            panelMid.add((Component)this.jLabel22, GM.getGBC(1, 1));
            panelMid.add((Component)this.jCBLNF, GM.getGBC(1, 2, true));
            panelMid.add((Component)this.labelLocale, GM.getGBC(1, 3));
            panelMid.add((Component)this.jCBLocale, GM.getGBC(1, 4, true));
            panelMid.add((Component)this.jLabelLevel, GM.getGBC(2, 1));
            panelMid.add((Component)this.jCBLevel, GM.getGBC(2, 2, true));
            panelMid.add((Component)this.jLabelLogType, GM.getGBC(2, 3));
            panelMid.add((Component)this.jCBLogType, GM.getGBC(2, 4, true));
            panelMid.add((Component)this.labelFontName, GM.getGBC(3, 1));
            panelMid.add((Component)this.jCBFontName, GM.getGBC(3, 2, true));
            panelMid.add((Component)this.jLUndoCount, GM.getGBC(3, 3));
            panelMid.add((Component)this.jSUndoCount, GM.getGBC(3, 4, true));
            panelMid.add((Component)this.jLabelTimeout, GM.getGBC(4, 1));
            panelMid.add((Component)jPanelTimeout, GM.getGBC(4, 2, true));
        } else {
            panelMid.add((Component)this.labelLocale, GM.getGBC(1, 1));
            panelMid.add((Component)this.jCBLocale, GM.getGBC(1, 2, true));
            panelMid.add((Component)this.labelFontName, GM.getGBC(1, 3));
            panelMid.add((Component)this.jCBFontName, GM.getGBC(1, 4, true));
            panelMid.add((Component)this.jLabelLevel, GM.getGBC(2, 1));
            panelMid.add((Component)this.jCBLevel, GM.getGBC(2, 2, true));
            panelMid.add((Component)this.jLabelLogType, GM.getGBC(2, 3));
            panelMid.add((Component)this.jCBLogType, GM.getGBC(2, 4, true));
            panelMid.add((Component)this.jLUndoCount, GM.getGBC(4, 1));
            panelMid.add((Component)this.jSUndoCount, GM.getGBC(4, 2, true));
            panelMid.add((Component)this.jLabelTimeout, GM.getGBC(4, 3));
            panelMid.add((Component)jPanelTimeout, GM.getGBC(4, 4, true));
        }
        this.jLUndoCount.setToolTipText(IdeSplMessage.get().getMessage("dialogoptions.undocountcause"));
        this.jSUndoCount.setToolTipText(IdeSplMessage.get().getMessage("dialogoptions.undocountcause"));
        this.jLUndoCount.setForeground(Color.BLUE);
        JPanel panelVM = new JPanel(new GridLayout(3, 2));
        panelVM.setBorder(BorderFactory.createTitledBorder(this.mm.getMessage("dialogoptions.vmborder")));
        GridBagConstraints gbc = GM.getGBC(5, 1, true, true);
        gbc.gridwidth = 4;
        JPanel panelXmx = new JPanel(new GridBagLayout());
        panelXmx.add((Component)this.jLXmx, GM.getGBC(1, 1));
        panelXmx.add((Component)this.jTFXmx, GM.getGBC(1, 2, true));
        panelVM.add(panelXmx);
        JPanel panelGCLog = new JPanel(new GridBagLayout());
        panelGCLog.add((Component)this.jLGCLog, GM.getGBC(1, 1));
        panelGCLog.add((Component)this.jTFGCLog, GM.getGBC(1, 2, true));
        panelGCLog.add((Component)this.jBGCLog, GM.getGBC(1, 3));
        panelVM.add(panelGCLog);
        panelVM.add(this.jCBPrintGCDetails);
        panelVM.add(this.jCBPrintGCTimeStamps);
        panelVM.add(this.jCBPrintGCDateStamps);
        panelVM.add(this.jCBPrintHeapAtGC);
        this.jLAutoSaveMinutes.setPreferredSize(new Dimension(60, 25));
        JPanel panelAutoSave = new JPanel(new GridBagLayout());
        panelAutoSave.add((Component)this.jCBAutoOpen, GM.getGBC(0, 0, false, false, 0));
        panelAutoSave.add((Component)new JPanel(), GM.getGBC(0, 1));
        panelAutoSave.add((Component)this.jCBAutoSave, GM.getGBC(0, 2));
        panelAutoSave.add((Component)this.jLAutoSaveInterval, GM.getGBC(0, 4, false, false, 2));
        panelAutoSave.add((Component)this.jSAutoSaveInterval, GM.getGBC(0, 5, false, false, 2));
        panelAutoSave.add((Component)this.jLAutoSaveMinutes, GM.getGBC(0, 6, false, false, 2));
        panelAutoSave.add((Component)new JPanel(), GM.getGBC(0, 7, true, false, 0));
        panelNormal.add(panelAutoSave);
        this.jCBAutoOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogOptions.this.autoOpenChanged();
            }
        });
        this.jCBAutoSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogOptions.this.autoSaveChanged();
            }
        });
        this.jBGCLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = GM.dialogSelectFile(DialogOptions.this, "log");
                if (f != null) {
                    DialogOptions.this.jTFGCLog.setText(f.getAbsolutePath());
                }
            }
        });
        panelNormal.add(panelMid);
        panelNormal.add(panelVM);
        JPanel jp1 = new JPanel();
        jp1.setLayout(new GridBagLayout());
        jp1.add((Component)this.jLabelNote, GM.getGBC(1, 1, true));
        panelNormal.add(jp1);
        JPanel panelSpl = new JPanel();
        panelSpl.setLayout(new BorderLayout());
        JPanel panelSplGrid = new JPanel();
        panelSpl.add((Component)panelSplGrid, "North");
        panelSplGrid.setLayout(new GridBagLayout());
        JLabel labelRowCount = new JLabel(this.mm.getMessage("dialogoptions.rowcount"));
        JLabel labelColCount = new JLabel(this.mm.getMessage("dialogoptions.colcount"));
        JLabel labelRowHeight = new JLabel(this.mm.getMessage("dialogoptions.rowheight"));
        JLabel labelColWidth = new JLabel(this.mm.getMessage("dialogoptions.colwidth"));
        JLabel labelCFColor = new JLabel(this.mm.getMessage("dialogoptions.cfcolor"));
        JLabel labelCBColor = new JLabel(this.mm.getMessage("dialogoptions.cbcolor"));
        JLabel labelNFColor = new JLabel(this.mm.getMessage("dialogoptions.nfcolor"));
        JLabel labelNBColor = new JLabel(this.mm.getMessage("dialogoptions.nbcolor"));
        JLabel labelVFColor = new JLabel(this.mm.getMessage("dialogoptions.vfcolor"));
        JLabel labelVBColor = new JLabel(this.mm.getMessage("dialogoptions.vbcolor"));
        JLabel labelNVFColor = new JLabel(this.mm.getMessage("dialogoptions.nvfcolor"));
        JLabel labelNVBColor = new JLabel(this.mm.getMessage("dialogoptions.nvbcolor"));
        JLabel labelIndent = new JLabel(this.mm.getMessage("dialogoptions.indent"));
        JLabel labelSeqMembers = new JLabel(this.mm.getMessage("dialogoptions.seqmembers"));
        JLabel labelHAlign = new JLabel(IdeSplMessage.get().getMessage("dialogoptionsdfx.halign"));
        JLabel labelVAlign = new JLabel(IdeSplMessage.get().getMessage("dialogoptionsdfx.valign"));
        this.jSPRowCount = new JSpinner(new SpinnerNumberModel(20, 1, 100000, 1));
        this.jSPColCount = new JSpinner(new SpinnerNumberModel(6, 1, 10000, 1));
        this.jSPRowHeight = new JSpinner(new SpinnerNumberModel(25.0, 1.0, 100.0, 1.0));
        this.jSPColWidth = new JSpinner(new SpinnerNumberModel(150.0, 1.0, 1000.0, 1.0));
        this.constFColor = new ColorComboBox();
        this.constBColor = new ColorComboBox();
        this.noteFColor = new ColorComboBox();
        this.noteBColor = new ColorComboBox();
        this.valFColor = new ColorComboBox();
        this.valBColor = new ColorComboBox();
        this.nValFColor = new ColorComboBox();
        this.nValBColor = new ColorComboBox();
        this.jCBFontSize = GM.getFontSizes();
        this.jCBFontSize.setEditable(true);
        this.jCBBold = new JCheckBox(this.mm.getMessage("dialogoptions.bold"));
        this.jCBItalic = new JCheckBox(this.mm.getMessage("dialogoptions.italic"));
        this.jCBUnderline = new JCheckBox(this.mm.getMessage("dialogoptions.underline"));
        this.jCBGridline = new JCheckBox(this.mm.getMessage("dialogoptions.gridline"));
        this.jSPIndent = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.jSSeqMembers = new JSpinner(new SpinnerNumberModel(3, 1, Integer.MAX_VALUE, 1));
        this.jCBHAlign = new JComboBoxEx();
        this.jCBHAlign.x_setData(DialogOptions.getHAlignCodes(), DialogOptions.getHAlignDisps());
        this.jCBVAlign = new JComboBoxEx();
        this.jCBVAlign.x_setData(DialogOptions.getVAlignCodes(), DialogOptions.getVAlignDisps());
        panelSplGrid.add((Component)labelRowCount, GM.getGBC(1, 1));
        panelSplGrid.add((Component)this.jSPRowCount, GM.getGBC(1, 2, true));
        panelSplGrid.add((Component)labelColCount, GM.getGBC(1, 3));
        panelSplGrid.add((Component)this.jSPColCount, GM.getGBC(1, 4, true));
        panelSplGrid.add((Component)labelRowHeight, GM.getGBC(2, 1));
        panelSplGrid.add((Component)this.jSPRowHeight, GM.getGBC(2, 2, true));
        panelSplGrid.add((Component)labelColWidth, GM.getGBC(2, 3));
        panelSplGrid.add((Component)this.jSPColWidth, GM.getGBC(2, 4, true));
        panelSplGrid.add((Component)labelCFColor, GM.getGBC(3, 1));
        panelSplGrid.add((Component)this.constFColor, GM.getGBC(3, 2, true));
        panelSplGrid.add((Component)labelCBColor, GM.getGBC(3, 3));
        panelSplGrid.add((Component)this.constBColor, GM.getGBC(3, 4, true));
        panelSplGrid.add((Component)labelNFColor, GM.getGBC(4, 1));
        panelSplGrid.add((Component)this.noteFColor, GM.getGBC(4, 2, true));
        panelSplGrid.add((Component)labelNBColor, GM.getGBC(4, 3));
        panelSplGrid.add((Component)this.noteBColor, GM.getGBC(4, 4, true));
        panelSplGrid.add((Component)labelVFColor, GM.getGBC(5, 1));
        panelSplGrid.add((Component)this.valFColor, GM.getGBC(5, 2, true));
        panelSplGrid.add((Component)labelVBColor, GM.getGBC(5, 3));
        panelSplGrid.add((Component)this.valBColor, GM.getGBC(5, 4, true));
        panelSplGrid.add((Component)labelNVFColor, GM.getGBC(6, 1));
        panelSplGrid.add((Component)this.nValFColor, GM.getGBC(6, 2, true));
        panelSplGrid.add((Component)labelNVBColor, GM.getGBC(6, 3));
        panelSplGrid.add((Component)this.nValBColor, GM.getGBC(6, 4, true));
        if (!this.isUnit) {
            panelSplGrid.add((Component)this.labelFontSize, GM.getGBC(7, 1));
            panelSplGrid.add((Component)this.jCBFontSize, GM.getGBC(7, 2, true));
        }
        GridBagConstraints gbc8 = GM.getGBC(8, 1, true);
        gbc8.gridwidth = 4;
        JPanel panel8 = new JPanel();
        GridLayout gl8 = new GridLayout();
        gl8.setColumns(4);
        gl8.setRows(1);
        panel8.setLayout(gl8);
        panel8.add(this.jCBBold);
        panel8.add(this.jCBItalic);
        panel8.add(this.jCBUnderline);
        panel8.add(this.jCBGridline);
        panelSplGrid.add((Component)panel8, gbc8);
        panelSplGrid.add((Component)labelIndent, GM.getGBC(7, 3));
        panelSplGrid.add((Component)this.jSPIndent, GM.getGBC(7, 4, true));
        panelSplGrid.add((Component)labelHAlign, GM.getGBC(9, 1));
        panelSplGrid.add((Component)this.jCBHAlign, GM.getGBC(9, 2, true));
        panelSplGrid.add((Component)labelVAlign, GM.getGBC(9, 3));
        panelSplGrid.add((Component)this.jCBVAlign, GM.getGBC(9, 4, true));
        panelSplGrid.add((Component)labelSeqMembers, GM.getGBC(10, 1));
        panelSplGrid.add((Component)this.jSSeqMembers, GM.getGBC(10, 2, true));
        this.jCBLocale.x_setData(GM.getCodeLocale(), GM.getDispLocale());
        this.panelEnv = new PanelEnv(this, this.isUnit ? (byte)1 : 0){
            private static final long serialVersionUID = 1L;

            @Override
            protected void addOptComponents(JPanel panelOpt) {
                if (DialogOptions.this.isUnit) {
                    panelOpt.add((Component)DialogOptions.this.jLabelLevel, GM.getGBC(7, 1));
                    panelOpt.add((Component)DialogOptions.this.jCBLevel, GM.getGBC(7, 2, true));
                    panelOpt.add((Component)DialogOptions.this.jLabelLogType, GM.getGBC(7, 3));
                    panelOpt.add((Component)DialogOptions.this.jCBLogType, GM.getGBC(7, 4, true));
                    panelOpt.add((Component)DialogOptions.this.labelFontSize, GM.getGBC(8, 1));
                    panelOpt.add((Component)DialogOptions.this.jCBFontSize, GM.getGBC(8, 2, true));
                }
            }

            @Override
            protected boolean isExtLibsEnabled() {
                return DialogOptions.this.isExtEnabled();
            }

            @Override
            public void selectEnvTab() {
                if (!DialogOptions.this.isUnit) {
                    DialogOptions.this.tabMain.setSelectedIndex(1);
                }
            }
        };
        if (this.isUnit) {
            JPanel panelRestartMessage = new JPanel(new FlowLayout(0));
            panelRestartMessage.add(this.jLabelNote);
            this.panelEnv.add((Component)panelRestartMessage, GM.getGBC(4, 1, true));
        }
        this.jCBConfigFile.setEditable(true);
        if (this.isUnit) {
            this.tabMain.add((Component)this.panelEnv, this.mm.getMessage("dialogoptions.panel0"));
        } else {
            this.panelEnv.setBorder(BorderFactory.createEtchedBorder());
            this.tabMain.add((Component)panelNormal, this.mm.getMessage("dialogoptions.panel0"));
            JPanel panelConfig = new JPanel(new GridBagLayout());
            panelConfig.add((Component)this.jLConfigFile, GM.getGBC(1, 1));
            panelConfig.add((Component)this.jCBConfigFile, GM.getGBC(1, 2, true));
            panelConfig.add((Component)this.jBLoadConfig, GM.getGBC(1, 3));
            panelConfig.add((Component)this.jBSaveConfig, GM.getGBC(1, 4));
            this.panelEsprocEnv.add((Component)panelConfig, GM.getGBC(0, 0, true, false));
            this.panelEsprocEnv.add((Component)this.panelEnv, GM.getGBC(1, 0, true, true, 0, 0));
            this.tabMain.add((Component)this.panelEsprocEnv, this.mm.getMessage("dialogoptions.panel1"));
            this.tabMain.add((Component)panelSpl, this.mm.getMessage("dialogoptions.panel2"));
        }
        this.jCBConfigFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogOptions.this.preventChange) {
                    return;
                }
                String configFile = DialogOptions.this.getConfigFile();
                if (!StringUtils.isValidString(configFile)) {
                    JOptionPane.showMessageDialog(DialogOptions.this, DialogOptions.this.mm.getMessage("dialogoptions.noconfigfileload"));
                    return;
                }
                try {
                    DialogOptions.this.loadConfigFile(configFile);
                }
                catch (Exception ex) {
                    GM.showException(DialogOptions.this, ex);
                }
            }
        });
        this.jCBConfigFile.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        e.consume();
                        ((JComponent)e.getSource()).requestFocusInWindow();
                        Component jText = DialogOptions.this.jCBConfigFile.getEditor().getEditorComponent();
                        if (jText instanceof JTextComponent) {
                            String path = ((JTextComponent)jText).getText();
                            if (!StringUtils.isValidString(path)) {
                                JOptionPane.showMessageDialog(DialogOptions.this, DialogOptions.this.mm.getMessage("dialogoptions.noconfigfileload"));
                                return;
                            }
                            DialogOptions.this.loadConfigFile(path);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.jBLoadConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File home;
                File f = GM.dialogSelectFile(DialogOptions.this, "xml");
                if (f == null) {
                    return;
                }
                String path = f.getAbsolutePath();
                if (path.startsWith((home = new File(System.getProperty("start.home"))).getAbsolutePath())) {
                    path = path.substring(home.getAbsolutePath().length());
                    while (path.startsWith("\\")) {
                        path = path.substring(1);
                    }
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                }
                try {
                    DialogOptions.this.loadConfigFile(path);
                }
                catch (Exception ex) {
                    GM.showException(DialogOptions.this, ex);
                }
            }
        });
        this.jBSaveConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogOptions.this.saveAsConfigFile();
            }
        });
        this.addWindowListener(new DialogOptions_this_windowAdapter(this));
        this.getContentPane().add((Component)this.tabMain, "Center");
        this.getContentPane().add((Component)jPanelButton, "East");
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.jCBAutoSave.setToolTipText(this.AUTO_SAVE_TIP);
        this.jLAutoSaveInterval.setToolTipText(this.AUTO_SAVE_TIP);
        this.jSAutoSaveInterval.setToolTipText(this.AUTO_SAVE_TIP);
        this.jLAutoSaveMinutes.setToolTipText(this.AUTO_SAVE_TIP);
    }

    private String getConfigFile() {
        String configFile = this.jCBConfigFile.getSelectedItem() == null ? null : (String)this.jCBConfigFile.getSelectedItem();
        return configFile;
    }

    private boolean checkXmx() {
        String sNum = this.jTFXmx.getText();
        if (!StringUtils.isValidString(sNum)) {
            return true;
        }
        sNum = sNum.trim();
        try {
            Integer.parseInt(sNum);
            return true;
        }
        catch (Exception exception) {
            int buffer = ConfigUtil.parseBufferSize(sNum);
            if (buffer == -1) {
                return true;
            }
            if (buffer == -2) {
                GM.messageDialog(this, this.mm.getMessage("dialogoptions.invalidxmx"));
                return false;
            }
            return true;
        }
    }

    void jBCancel_actionPerformed(ActionEvent e) {
        GM.setWindowDimension(this);
        this.m_option = 2;
        this.dispose();
    }

    void jBOK_actionPerformed(ActionEvent e) {
        try {
            if (this.save()) {
                GM.setWindowDimension(this);
                this.m_option = 0;
                this.dispose();
            }
        }
        catch (Throwable t) {
            GM.showException(this, t);
        }
    }

    void this_windowClosing(WindowEvent e) {
        GM.setWindowDimension(this);
        this.dispose();
    }

    public static Vector<Byte> getHAlignCodes() {
        Vector<Byte> hAligns = new Vector<Byte>();
        hAligns.add(new Byte(0));
        hAligns.add(new Byte(2));
        hAligns.add(new Byte(4));
        return hAligns;
    }

    public static Vector<String> getHAlignDisps() {
        MessageManager mm = IdeCommonMessage.get();
        Vector<String> hAligns = new Vector<String>();
        hAligns.add(mm.getMessage("dialogoptions.hleft"));
        hAligns.add(mm.getMessage("dialogoptions.hcenter"));
        hAligns.add(mm.getMessage("dialogoptions.hright"));
        return hAligns;
    }

    public static Vector<Byte> getVAlignCodes() {
        Vector<Byte> vAligns = new Vector<Byte>();
        vAligns.add(new Byte(8));
        vAligns.add(new Byte(16));
        vAligns.add(new Byte(32));
        return vAligns;
    }

    public static Vector<String> getVAlignDisps() {
        MessageManager mm = IdeCommonMessage.get();
        Vector<String> vAligns = new Vector<String>();
        vAligns.add(mm.getMessage("dialogoptions.vtop"));
        vAligns.add(mm.getMessage("dialogoptions.vcenter"));
        vAligns.add(mm.getMessage("dialogoptions.vbottom"));
        return vAligns;
    }

    private Byte compatibleHalign(Byte value) {
        switch (value) {
            case -48: {
                return new Byte(0);
            }
            case -47: {
                return new Byte(2);
            }
            case -46: {
                return new Byte(4);
            }
        }
        return value;
    }

    private Byte compatibleValign(Byte value) {
        switch (value) {
            case -32: 
            case 0: {
                return new Byte(8);
            }
            case -31: 
            case 1: {
                return new Byte(16);
            }
            case -30: 
            case 2: {
                return new Byte(32);
            }
        }
        return value;
    }
}

