/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.ServiceUtil;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.FreeConstraints;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GMSplSE;
import com.scudata.ide.spl.ICheckHandler;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.spl.control.SplEditorSE;
import com.scudata.ide.spl.dialog.DialogSerialNo;
import com.scudata.ide.spl.dialog.DialogSplash;
import com.scudata.resources.ManageMsg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextField;

public abstract class DialogSplashSE
extends DialogSplash {
    private static final long serialVersionUID = 1L;
    private boolean isCanceled = false;
    private JButton jBExit = new JButton();
    private JTextField textMessage;

    public DialogSplashSE(String splashImage) {
        super(splashImage);
    }

    public void connectWebsite(String productType, String productName, final ICheckHandler handler) {
        if (!this.needConnectWebsite()) {
            return;
        }
        boolean canStop = !this.forceConnectWebsite();
        this.setMessage(ManageMsg.get().getMessage("update.connect"), canStop);
        if (!this.count(productType)) {
            if (!canStop) {
                ImageIcon ii = GMSpl.getLogoImage(this, true);
                DialogSerialNo dsn = new DialogSerialNo(GV.appFrame, GV.config.getEsprocSerialNo(), IdeCommonMessage.get().getMessage("dialogsplash.nointernet", productName), ii == null ? null : ii.getImage()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void updateSerialNo(String serialNo) throws Exception {
                        GMSplSE.updateSerialNo(serialNo);
                        IDEBase.checkExpirationSystem();
                        SplEditorSE.checkNoIDE();
                        if (handler != null) {
                            handler.check();
                        }
                    }

                    @Override
                    public String getDownloadUrl() {
                        return GMSplSE.getDownloadUrl();
                    }
                };
                if (GM.isMacOS()) {
                    dsn.setAlwaysOnTop(true);
                }
                dsn.setVisible(true);
                if (dsn.getOption() == 0) {
                    this.connectWebsite(productType, productName, handler);
                } else {
                    System.exit(0);
                }
            }
        } else {
            this.textMessage.setVisible(false);
            this.jBExit.setVisible(false);
            this.refreshImage();
        }
    }

    public abstract boolean needConnectWebsite();

    public abstract boolean forceConnectWebsite();

    private boolean count(String productType) {
        if (this.isCanceled) {
            return false;
        }
        try {
            ServiceUtil.count(productType);
            return true;
        }
        catch (Throwable t) {
            if (this.isCanceled) {
                return false;
            }
            try {
                this.getContent("http://www.baidu.com", true);
            }
            catch (Throwable t1) {
                if (this.isCanceled) {
                    return false;
                }
                try {
                    this.getContent("http://www.google.com", true);
                }
                catch (Throwable tt) {
                    return false;
                }
            }
            return true;
        }
    }

    private String getContent(String urlAddress, boolean oneline) throws Exception {
        String tmp;
        BufferedReader br = null;
        URL url = new URL(urlAddress);
        br = new BufferedReader(new InputStreamReader(url.openStream()));
        StringBuffer content = new StringBuffer();
        while ((tmp = br.readLine()) != null) {
            if (oneline) {
                String string = tmp;
                return string;
            }
            if (content.length() > 0) {
                content.append("\n");
            }
            content.append(tmp);
        }
        String string = content.toString();
        return string;
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public void cancelConnect() {
        this.isCanceled = true;
        this.textMessage.setVisible(false);
        this.jBExit.setVisible(false);
        this.refreshImage();
    }

    public void setMessage(String message, boolean canStop) {
        if (this.textMessage == null) {
            this.initJText(canStop);
        }
        this.textMessage.setText(message);
        this.refreshImage();
    }

    private void refreshImage() {
        this.panelImage.updateUI();
        this.panelImage.revalidate();
        this.panelImage.repaint();
    }

    private void initJText(boolean canStop) {
        int HEIGHT = 25;
        int TEXT_WIDTH = 250;
        int BUTTON_WIDTH = 60;
        this.textMessage = new JTextField();
        this.textMessage.setEditable(false);
        this.textMessage.setPreferredSize(new Dimension(250, 27));
        this.jBExit.setPreferredSize(new Dimension(60, 25));
        this.jBExit.setBorder(null);
        this.jBExit.setOpaque(true);
        if (canStop) {
            this.jBExit.setText(IdeCommonMessage.get().getMessage("public.skip"));
            this.jBExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogSplashSE.this.cancelConnect();
                }
            });
        } else {
            this.jBExit.setText(IdeCommonMessage.get().getMessage("public.exit"));
            this.jBExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        int x1 = 30;
        int y = 325;
        this.panelImage.add((Component)this.textMessage, new FreeConstraints(x1, y - 1, 250, -1));
        this.panelImage.add((Component)this.jBExit, new FreeConstraints(x1 + 5 + 250, y, 60, -1));
    }
}

