/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.dialog;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.RQDialog;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.GCSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DialogZoom
extends RQDialog {
    private static final long serialVersionUID = 1L;
    private int customValue = 100;
    private boolean preventChange = false;
    private JRadioButton jRB200 = new JRadioButton("200%");
    private JRadioButton jRB150 = new JRadioButton("150%");
    private JRadioButton jRB100 = new JRadioButton("100%");
    private JRadioButton jRB75 = new JRadioButton("75%");
    private JRadioButton jRB50 = new JRadioButton("50%");
    private JRadioButton jRBCustom = new JRadioButton(IdeSplMessage.get().getMessage("dialogscale.custom"));
    private JTextField jTFCustom = new JTextField();

    public DialogZoom() {
        super(IdeSplMessage.get().getMessage("dialogscale.title"), 200, 250);
        try {
            this.initUI();
        }
        catch (Exception e) {
            GM.showException(this, e);
        }
    }

    public void setScale(float scale) {
        if (Float.compare(scale *= 100.0f, 200.0f) == 0) {
            this.jRB200.setSelected(true);
        } else if (Float.compare(scale, 150.0f) == 0) {
            this.jRB150.setSelected(true);
        } else if (Float.compare(scale, 100.0f) == 0) {
            this.jRB100.setSelected(true);
        } else if (Float.compare(scale, 75.0f) == 0) {
            this.jRB75.setSelected(true);
        } else if (Float.compare(scale, 50.0f) == 0) {
            this.jRB50.setSelected(true);
        } else {
            this.jRBCustom.setSelected(true);
        }
        int percent = (int)scale;
        this.setCustomValue(percent);
    }

    public float getScale() {
        int percent = this.jRB200.isSelected() ? 200 : (this.jRB150.isSelected() ? 150 : (this.jRB100.isSelected() ? 100 : (this.jRB75.isSelected() ? 75 : (this.jRB50.isSelected() ? 50 : this.customValue))));
        return new Float(percent).floatValue() / 100.0f;
    }

    @Override
    protected void dialogOpened() {
        if (this.jRBCustom.isSelected()) {
            this.jTFCustom.requestFocus();
        }
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        return this.checkCustomValue();
    }

    private boolean checkCustomValue() {
        if (!this.jRBCustom.isSelected()) {
            return true;
        }
        String strCustom = this.jTFCustom.getText();
        if (!StringUtils.isValidString(strCustom)) {
            JOptionPane.showMessageDialog(this, IdeSplMessage.get().getMessage("dialogscale.emptycustom"));
            return false;
        }
        int min = GCSpl.DEFAULT_SCALES[0];
        int max = GCSpl.DEFAULT_SCALES[GCSpl.DEFAULT_SCALES.length - 1];
        try {
            Float f = Float.valueOf(Float.parseFloat(strCustom));
            this.customValue = f.intValue();
            if (this.customValue > max || this.customValue < min) {
                JOptionPane.showMessageDialog(this, IdeSplMessage.get().getMessage("dialogscale.invalidcustom", String.valueOf(min), String.valueOf(max)));
                return false;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, IdeSplMessage.get().getMessage("dialogscale.invalidcustom", String.valueOf(min), String.valueOf(max)));
            return false;
        }
        return true;
    }

    private void initUI() {
        this.panelCenter.setLayout(new VFlowLayout(1));
        this.jTFCustom.setPreferredSize(new Dimension(80, 25));
        JPanel jPCustom = new JPanel(new FlowLayout(0, 0, 0));
        jPCustom.add(this.jRBCustom);
        jPCustom.add(this.jTFCustom);
        jPCustom.add(new JLabel("%"));
        JPanel panelScale = new JPanel(new VFlowLayout(0));
        panelScale.add(this.jRB200);
        panelScale.add(this.jRB150);
        panelScale.add(this.jRB100);
        panelScale.add(this.jRB75);
        panelScale.add(this.jRB50);
        panelScale.add(jPCustom);
        this.panelCenter.add(panelScale);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.jRB200);
        bg1.add(this.jRB150);
        bg1.add(this.jRB100);
        bg1.add(this.jRB75);
        bg1.add(this.jRB50);
        bg1.add(this.jRBCustom);
        this.jRB200.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogZoom.this.setCustomValue(200);
            }
        });
        this.jRB150.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogZoom.this.setCustomValue(150);
            }
        });
        this.jRB100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogZoom.this.setCustomValue(100);
            }
        });
        this.jRB75.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogZoom.this.setCustomValue(75);
            }
        });
        this.jRB50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogZoom.this.setCustomValue(50);
            }
        });
        this.jTFCustom.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogZoom.this.customValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogZoom.this.customValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DialogZoom.this.customValueChanged();
            }
        });
    }

    private void customValueChanged() {
        if (this.preventChange) {
            return;
        }
        if (!this.jRBCustom.isSelected()) {
            this.jRBCustom.setSelected(true);
        }
    }

    private void setCustomValue(int percent) {
        try {
            this.preventChange = true;
            this.jTFCustom.setText(String.valueOf(percent));
        }
        finally {
            this.preventChange = false;
        }
    }
}

