/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.spl.etl.ElementInfo;
import com.scudata.ide.spl.etl.ElementLib;
import com.scudata.ide.spl.etl.EtlConsts;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.ObjectElement;
import com.scudata.ide.spl.etl.ParamInfoList;
import com.scudata.ide.spl.etl.ParamInputPanel;
import com.scudata.ide.spl.resources.ChartMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogFuncEdit
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int m_option = -1;
    private static MessageManager mm = FuncMessage.get();
    JLabel lbUrl = new JLabel("Help");
    JButton okbtn = new JButton();
    JButton cancelbtn = new JButton();
    ParamInputPanel propPanel;
    JLabel lbCellNames = new JLabel("\u8bf7\u9009\u62e9\u5355\u5143\u683c\uff1a");
    JComboBoxEx jCBCellNames = new JComboBoxEx();
    JLabel lbFuncNames = new JLabel("\u8bf7\u9009\u62e9\u51fd\u6570\uff1a");
    JComboBoxEx jCBElementNames = new JComboBoxEx();
    transient HashMap<String, ObjectElement> cellNames = null;
    transient ObjectElement oe;

    public DialogFuncEdit(HashMap<String, ObjectElement> cellNames, ObjectElement currentOe) {
        super(GV.appFrame, "\u51fd\u6570\u7f16\u8f91", true);
        try {
            this.cellNames = cellNames;
            this.oe = currentOe;
            this.init();
            this.rqInit();
            this.setSize(640, 480);
            this.resetText();
            GM.setDialogDefaultButton(this, this.okbtn, this.cancelbtn);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText() {
        this.setTitle(mm.getMessage("DialogFuncEdit.title"));
        this.lbCellNames.setText(mm.getMessage("DialogFuncEdit.selectcell"));
        this.lbFuncNames.setText(mm.getMessage("DialogFuncEdit.selectfunc"));
    }

    private void init() {
        this.lbUrl.setCursor(Cursor.getPredefinedCursor(12));
        this.lbUrl.setFont(new Font("Comic Sans MS", 2, 13));
        this.lbUrl.setForeground(Color.blue);
        this.lbUrl.setBorder(null);
        this.okbtn.setText(ChartMessage.get().getMessage("button.ok"));
        this.okbtn.setPreferredSize(new Dimension(70, 25));
        this.okbtn.setMargin(new Insets(2, 10, 2, 10));
        this.okbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFuncEdit.this.okbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setText(ChartMessage.get().getMessage("button.cancel"));
        this.cancelbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFuncEdit.this.cancelbtn_actionPerformed(e);
            }
        });
        this.cancelbtn.setPreferredSize(new Dimension(70, 25));
        this.cancelbtn.setMargin(new Insets(2, 10, 2, 10));
        this.okbtn.setMnemonic('O');
        this.cancelbtn.setMnemonic('C');
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.lbUrl, GM.getGBC(1, 1, true));
        panel.add((Component)new JLabel(" "), GM.getGBC(1, 2));
        panel.add((Component)this.okbtn, GM.getGBC(1, 3));
        panel.add((Component)this.cancelbtn, GM.getGBC(1, 4));
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)panel, "South");
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new GridBagLayout());
        cmdPanel.add((Component)this.lbCellNames, GM.getGBC(1, 1));
        cmdPanel.add((Component)this.jCBCellNames, GM.getGBC(1, 2, true));
        cmdPanel.add((Component)this.lbFuncNames, GM.getGBC(1, 3));
        GridBagConstraints gbc = GM.getGBC(1, 4, true);
        cmdPanel.add((Component)this.jCBElementNames, gbc);
        pane.add((Component)cmdPanel, "North");
        this.propPanel = new ParamInputPanel(this);
        pane.add(this.propPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogFuncEdit.this.closeDialog();
            }
        });
    }

    private boolean isInludeType(byte[] allType, byte current) {
        int i = 0;
        while (i < allType.length) {
            if (allType[i] == current) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArrayList<String> getAncestorNames() {
        ArrayList<String> ans = new ArrayList<String>();
        String currentName = (String)this.jCBCellNames.x_getSelectedItem();
        if (this.cellNames != null && !this.cellNames.isEmpty()) {
            while (StringUtils.isValidString(currentName)) {
                ans.add(currentName);
                ObjectElement tmp = this.cellNames.get(currentName);
                currentName = tmp.getCellName();
            }
        }
        return ans;
    }

    public JComboBoxEx getCellNameDropdownBox(byte[] cellTypes) {
        Vector<String> scodes = new Vector<String>();
        Vector<String> sdisps = new Vector<String>();
        if (this.cellNames != null) {
            ArrayList<String> names = new ArrayList<String>();
            Iterator<String> it = this.cellNames.keySet().iterator();
            ArrayList<String> ans = this.getAncestorNames();
            while (it.hasNext()) {
                String name = it.next();
                if (ans.contains(name)) continue;
                names.add(name);
            }
            Collections.sort(names);
            scodes.add("");
            sdisps.add("");
            for (String name : names) {
                ObjectElement cellOE = this.cellNames.get(name);
                byte cellType = cellOE.getReturnType();
                if (!this.isInludeType(cellTypes, cellType)) continue;
                scodes.add(name);
                sdisps.add(this.cellTitle(name));
            }
        }
        JComboBoxEx combo = new JComboBoxEx();
        combo.x_setData(scodes, sdisps);
        return combo;
    }

    private void refreshCellNames() {
        String cellName = (String)this.jCBCellNames.x_getSelectedItem();
        byte cellType = 0;
        if (StringUtils.isValidString(cellName)) {
            ObjectElement cellOE = this.cellNames.get(cellName);
            cellType = cellOE.getReturnType();
        }
        ArrayList<ElementInfo> elements = ElementLib.getElementInfos(cellType);
        Vector<String> names = new Vector<String>();
        Vector<String> titles = new Vector<String>();
        String codeItem = null;
        int i = 0;
        while (i < elements.size()) {
            ElementInfo ei = elements.get(i);
            if (codeItem == null) {
                codeItem = ei.getName();
            }
            names.add(ei.getName());
            titles.add(ei.getTitle());
            ++i;
        }
        this.jCBElementNames.x_setData(names, titles);
    }

    private String cellTitle(String name) {
        ObjectElement oe = this.cellNames.get(name);
        String oeType = EtlConsts.getTypeDesc(oe.getReturnType());
        return String.valueOf(name) + "(" + oeType + ")";
    }

    private void rqInit() {
        if (this.oe == null) {
            ArrayList<String> names = new ArrayList<String>();
            for (String name : this.cellNames.keySet()) {
                names.add(name);
            }
            Collections.sort(names);
            Vector<String> vNames = new Vector<String>();
            Vector<String> vTitles = new Vector<String>();
            vNames.add("");
            vTitles.add("");
            for (String name : names) {
                vNames.add(name);
                vTitles.add(this.cellTitle(name));
            }
            this.jCBCellNames.x_setData(vNames, vTitles);
            this.jCBCellNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogFuncEdit.this.refreshCellNames();
                }
            });
            this.jCBElementNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String elementName = (String)DialogFuncEdit.this.jCBElementNames.x_getSelectedItem();
                    if (elementName == null) {
                        return;
                    }
                    ElementInfo ei = ElementLib.getElementInfo(elementName);
                    DialogFuncEdit.this.oe = ei.newInstance();
                    DialogFuncEdit.this.dispDetail();
                }
            });
            this.jCBCellNames.x_setSelectedCodeItem("");
            this.refreshCellNames();
            Object dispItem = this.jCBElementNames.getItemAt(0);
            this.jCBElementNames.x_setSelectedCodeItem(dispItem);
        } else {
            Vector<String> vNames = new Vector<String>();
            Vector<String> vTitles = new Vector<String>();
            for (String name : this.cellNames.keySet()) {
                ObjectElement tmp = this.cellNames.get(name);
                if (this.oe.getParentType() != tmp.getReturnType()) continue;
                vNames.add(name);
            }
            Collections.sort(vNames);
            for (String name : vNames) {
                vTitles.add(this.cellTitle(name));
            }
            this.jCBCellNames.x_setData(vNames, vTitles);
            this.jCBCellNames.x_setSelectedCodeItem(this.oe.getCellName());
            String elementName = this.oe.getElementName();
            ElementInfo ei = ElementLib.getElementInfo(elementName);
            Vector<String> names = new Vector<String>();
            Vector<String> titles = new Vector<String>();
            names.add(ei.getName());
            titles.add(ei.getTitle());
            this.jCBElementNames.x_setData(names, titles);
            this.jCBElementNames.x_setSelectedCodeItem(elementName);
            this.jCBElementNames.setEnabled(false);
            this.dispDetail();
        }
        this.lbUrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int b = e.getButton();
                if (b != 1) {
                    return;
                }
                if (GM.getOperationSytem() == 0) {
                    try {
                        Runtime.getRuntime().exec("cmd /C start " + DialogFuncEdit.this.lbUrl.getText());
                    }
                    catch (Exception x) {
                        GM.showException(DialogFuncEdit.this, x);
                    }
                }
            }
        });
    }

    public int getOption() {
        return this.m_option;
    }

    public ObjectElement getObjectElement() {
        String cellName = (String)this.jCBCellNames.x_getSelectedItem();
        this.oe.setCellName(cellName);
        return this.oe;
    }

    public void dispDetail() {
        String funcTitle = (String)this.jCBElementNames.getSelectedItem();
        byte type = this.oe.getParentType();
        String stype = EtlConsts.getTypeDesc(type);
        String funcDesc = this.oe.getFuncDesc();
        this.propPanel.setParamInfoList(stype, funcTitle, funcDesc, this.oe.getParamInfoList());
        this.lbUrl.setText(this.oe.getHelpUrl());
    }

    private void closeDialog() {
        GM.setWindowDimension(this);
        this.dispose();
    }

    void okbtn_actionPerformed(ActionEvent e) {
        this.propPanel.getParamTable().acceptText();
        this.m_option = 0;
        ParamInfoList pil = this.propPanel.getParamInfoList();
        try {
            pil.check();
            this.oe.setParamInfoList(pil.getAllParams());
            this.closeDialog();
        }
        catch (Exception x) {
            GM.showException(this, x);
        }
    }

    void cancelbtn_actionPerformed(ActionEvent e) {
        this.m_option = 2;
        this.closeDialog();
    }
}

