/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.ide.spl.etl.ElementInfo;
import com.scudata.ide.spl.etl.FuncMessage;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ElementLib {
    private static ArrayList<ElementInfo> elements = new ArrayList(20);
    private static MessageManager mm = FuncMessage.get();

    static {
        ElementLib.loadSystemElements();
    }

    private static int indexof(String name) {
        int size = elements.size();
        int i = 0;
        while (i < size) {
            ElementInfo ei = elements.get(i);
            if (ei.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ElementInfo getElementInfo(String name) {
        int i = ElementLib.indexof(name);
        if (i >= 0) {
            return elements.get(i);
        }
        return null;
    }

    public static void addElement(String name) {
        try {
            String packageName = "com.scudata.ide.spl.etl.element.";
            String className = String.valueOf(packageName) + name;
            Class<?> elemClass = Class.forName(className);
            String title = mm.getMessage(name);
            ElementInfo ei = new ElementInfo(name, title, elemClass);
            int i = ElementLib.indexof(name);
            if (i >= 0) {
                elements.add(i, ei);
            } else {
                elements.add(ei);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static ArrayList<ElementInfo> getElementInfos(byte parentType) {
        ArrayList<ElementInfo> eis = new ArrayList<ElementInfo>();
        for (ElementInfo ei : elements) {
            if (ei.getParentType() != parentType) continue;
            eis.add(ei);
        }
        return eis;
    }

    public static ArrayList<ElementInfo> getElementInfos(String funcName) {
        ArrayList<ElementInfo> eis = new ArrayList<ElementInfo>();
        for (ElementInfo ei : elements) {
            if (!ei.getFuncName().equals(funcName)) continue;
            eis.add(ei);
        }
        return eis;
    }

    public static void loadSystemElements() {
        String names = "ACreate,ADelete,ADerive,AGroup,AGroup2,AGroups,AInsert,AJoin,AKeys,ANew,ANews,ARename,ARun,ASelect,ConnectDB,ConnectDriver,Create,CsDerive,CsFetch,CsGroup,CsGroups,CsGroupx,CsJoin,CsJoinx,CsNew,CsNews,CsRename,CsRun,CsSortx,DCursorSQL,DExecute,DQuerySQL,DUpdate,FCreate,FCursor,FExport,File,FImport,FOpen,FXlsExport,FXlsImport,FXlsOpen,FXlsWrite,Joinx,TAppend,TAttach,TClose,TCursor,TUpdate,XXlsClose,XXlsExport,XXlsImport";
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            ElementLib.addElement(name);
        }
    }
}

