/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.etl.FieldDefine;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.IFieldDefineDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ExportFieldsDialog
extends JDialog
implements IFieldDefineDialog {
    private static final long serialVersionUID = 1L;
    private static MessageManager mm = FuncMessage.get();
    JPanel jPanel2 = new JPanel();
    VFlowLayout vFlowLayout1 = new VFlowLayout();
    JButton jBOK = new JButton();
    JButton jBCancel = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    private final byte COL_INDEX = 0;
    private final byte COL_EXP = 1;
    private final byte COL_FIELD = (byte)2;
    JTableEx exportFields;
    JPanel jPanel1 = new JPanel();
    JButton jBAdd = new JButton();
    JButton jBDel = new JButton();
    private int m_option = 2;

    public ExportFieldsDialog(Dialog owner, int defineType) {
        super(owner);
        try {
            String colNames = defineType == 1022 ? "ExportFieldsDialog.exportfields" : (defineType == 1023 ? "ExportFieldsDialog.fieldExps" : "ExportFieldsDialog.renameFields");
            this.exportFields = new JTableEx(mm.getMessage(colNames));
            this.init();
            this.rqInit();
            this.setSize(450, 300);
            this.resetText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText() {
        this.setTitle(mm.getMessage("ExportFieldsDialog.title"));
        MessageManager icm = IdeCommonMessage.get();
        this.jBOK.setText(icm.getMessage("button.ok"));
        this.jBCancel.setText(icm.getMessage("button.cancel"));
        this.jBAdd.setText(icm.getMessage("button.add"));
        this.jBDel.setText(icm.getMessage("button.delete"));
    }

    @Override
    public int getOption() {
        return this.m_option;
    }

    @Override
    public void setFieldDefines(ArrayList<FieldDefine> fields) {
        if (fields == null) {
            return;
        }
        int i = 0;
        while (i < fields.size()) {
            int row = this.exportFields.addRow();
            FieldDefine fd = fields.get(i);
            this.exportFields.data.setValueAt(fd.getOne(), row, 1);
            this.exportFields.data.setValueAt(fd.getTwo(), row, 2);
            ++i;
        }
    }

    @Override
    public ArrayList<FieldDefine> getFieldDefines() {
        this.exportFields.acceptText();
        int rows = this.exportFields.getRowCount();
        if (rows == 0) {
            return null;
        }
        ArrayList<FieldDefine> fields = new ArrayList<FieldDefine>();
        int i = 0;
        while (i < rows) {
            String name = (String)this.exportFields.data.getValueAt(i, 1);
            if (StringUtils.isValidString(name)) {
                FieldDefine fd = new FieldDefine();
                fd.setOne(name);
                fd.setTwo((String)this.exportFields.data.getValueAt(i, 2));
                fields.add(fd);
            }
            ++i;
        }
        return fields;
    }

    private void rqInit() {
        this.exportFields.setIndexCol(0);
        this.exportFields.setRowHeight(20);
    }

    private void init() throws Exception {
        this.setModal(true);
        this.jPanel2.setLayout(this.vFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFieldsDialog.this.exportFields.acceptText();
                ExportFieldsDialog.this.m_option = 0;
                ExportFieldsDialog.this.dispose();
            }
        });
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFieldsDialog.this.dispose();
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFieldsDialog.this.exportFields.addRow();
            }
        });
        this.jBDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFieldsDialog.this.exportFields.deleteSelectedRows();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExportFieldsDialog.this.dispose();
            }
        });
        this.jScrollPane1.getViewport().add(this.exportFields);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jPanel2.add((Component)this.jBOK, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel2.add((Component)this.jPanel1, null);
        this.jPanel2.add((Component)this.jBAdd, null);
        this.jPanel2.add((Component)this.jBDel, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
    }
}

