/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.dialog.DialogCellFormat;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.VFlowLayout;
import com.scudata.ide.spl.etl.FieldDefine;
import com.scudata.ide.spl.etl.FuncMessage;
import com.scudata.ide.spl.etl.IFieldDefineDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FieldDefineDialog
extends JDialog
implements IFieldDefineDialog {
    private static final long serialVersionUID = 1L;
    private static MessageManager mm = FuncMessage.get();
    JPanel jPanel2 = new JPanel();
    VFlowLayout vFlowLayout1 = new VFlowLayout();
    JButton jBOK = new JButton();
    JButton jBCancel = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    private final byte COL_INDEX = 0;
    private final byte COL_NAME = 1;
    private final byte COL_TYPE = (byte)2;
    private final byte COL_FORMAT = (byte)3;
    JTableEx tableFields = new JTableEx(mm.getMessage("FieldDefineDialog.tablefields")){

        @Override
        public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
            if (row > -1 && col == 3) {
                DialogCellFormat dcf = new DialogCellFormat();
                String fmt = (String)this.data.getValueAt(row, col);
                dcf.setFormat(fmt);
                dcf.setVisible(true);
                if (dcf.getOption() == 0) {
                    this.acceptText();
                    this.setValueAt(dcf.getFormat(), row, col);
                    this.acceptText();
                }
            }
        }
    };
    JPanel jPanel1 = new JPanel();
    JButton jBAdd = new JButton();
    JButton jBDel = new JButton();
    private int m_option = 2;

    public FieldDefineDialog(Dialog owner) {
        super(owner);
        try {
            this.init();
            this.rqInit();
            this.setSize(450, 300);
            this.resetText();
            GM.setDialogDefaultButton(this, this.jBOK, this.jBCancel);
        }
        catch (Exception ex) {
            GM.showException(this, ex);
        }
    }

    private void resetText() {
        this.setTitle(mm.getMessage("FieldDefineDialog.title"));
        MessageManager icm = IdeCommonMessage.get();
        this.jBOK.setText(icm.getMessage("button.ok"));
        this.jBCancel.setText(icm.getMessage("button.cancel"));
        this.jBAdd.setText(icm.getMessage("button.add"));
        this.jBDel.setText(icm.getMessage("button.delete"));
    }

    @Override
    public int getOption() {
        return this.m_option;
    }

    @Override
    public void setFieldDefines(ArrayList<FieldDefine> fields) {
        if (fields == null) {
            return;
        }
        int i = 0;
        while (i < fields.size()) {
            int row = this.tableFields.addRow();
            FieldDefine fd = fields.get(i);
            this.tableFields.data.setValueAt(fd.getOne(), row, 1);
            this.tableFields.data.setValueAt(fd.getTwo(), row, 2);
            this.tableFields.data.setValueAt(fd.getThree(), row, 3);
            ++i;
        }
    }

    @Override
    public ArrayList<FieldDefine> getFieldDefines() {
        this.tableFields.acceptText();
        int rows = this.tableFields.getRowCount();
        if (rows == 0) {
            return null;
        }
        ArrayList<FieldDefine> fields = new ArrayList<FieldDefine>();
        int i = 0;
        while (i < rows) {
            String name = (String)this.tableFields.data.getValueAt(i, 1);
            if (StringUtils.isValidString(name)) {
                FieldDefine fd = new FieldDefine();
                fd.setOne(name);
                fd.setTwo((String)this.tableFields.data.getValueAt(i, 2));
                fd.setThree((String)this.tableFields.data.getValueAt(i, 3));
                fields.add(fd);
            }
            ++i;
        }
        return fields;
    }

    private void rqInit() {
        this.tableFields.setIndexCol(0);
        this.tableFields.setRowHeight(20);
        Vector<String> disp = new Vector<String>();
        disp.add("");
        disp.add("bool");
        disp.add("int");
        disp.add("long");
        disp.add("float");
        disp.add("decimal");
        disp.add("number");
        disp.add("string");
        disp.add("date");
        disp.add("time");
        disp.add("datetime");
        JComboBoxEx combo = this.tableFields.setColumnDropDown(2, disp, disp);
        combo.setMaximumRowCount(10);
        this.tableFields.setAutoResizeMode(0);
        this.tableFields.getTableHeader().setReorderingAllowed(false);
        this.tableFields.setColumnWidth(1, 120);
        this.tableFields.setColumnWidth(2, 86);
        this.tableFields.setColumnWidth(3, 120);
    }

    private void init() throws Exception {
        this.setModal(true);
        this.jPanel2.setLayout(this.vFlowLayout1);
        this.jBOK.setMnemonic('O');
        this.jBOK.setText("\u786e\u5b9a(O)");
        this.jBOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDefineDialog.this.tableFields.acceptText();
                FieldDefineDialog.this.m_option = 0;
                FieldDefineDialog.this.dispose();
            }
        });
        this.jBCancel.setMnemonic('C');
        this.jBCancel.setText("\u53d6\u6d88(C)");
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDefineDialog.this.dispose();
            }
        });
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDefineDialog.this.tableFields.addRow();
            }
        });
        this.jBDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldDefineDialog.this.tableFields.deleteSelectedRows();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FieldDefineDialog.this.dispose();
            }
        });
        this.jScrollPane1.getViewport().add(this.tableFields);
        this.jBAdd.setMnemonic('A');
        this.jBAdd.setText("\u589e\u52a0(A)");
        this.jBDel.setMnemonic('D');
        this.jBDel.setText("\u5220\u9664(D)");
        this.jPanel2.add((Component)this.jBOK, null);
        this.jPanel2.add((Component)this.jBCancel, null);
        this.jPanel2.add((Component)this.jPanel1, null);
        this.jPanel2.add((Component)this.jBAdd, null);
        this.jPanel2.add((Component)this.jBDel, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel2, "East");
    }
}

