/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.ide.spl.etl.StringListDialog;
import com.scudata.ide.spl.etl.StringListIcon;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class StringListEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    protected ArrayList<String> editingVal = null;
    private Dialog owner;
    private JButton button = new JButton();
    StringListIcon icon = new StringListIcon();

    public StringListEditor(Dialog owner) {
        super(new JCheckBox());
        this.owner = owner;
        this.button.setIcon(this.icon);
        this.button.setHorizontalAlignment(0);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringListEditor.this.clicked();
            }
        });
    }

    protected void clicked() {
        this.icon.setSize(this.button.getWidth(), this.button.getHeight());
        StringListDialog dialog = new StringListDialog(this.owner);
        dialog.setList(this.editingVal);
        Point p = this.button.getLocationOnScreen();
        dialog.setLocation(p.x, p.y + this.button.getHeight());
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.editingVal = dialog.getList();
            this.icon.setList(this.editingVal);
            this.stopCellEditing();
        }
        dialog.dispose();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingVal = (ArrayList)value;
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        this.icon.setList(this.editingVal);
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editingVal;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

