/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.etl;

import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.dm.Sequence;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.JTextAreaEditor;
import com.scudata.ide.spl.chart.ImageEditor;
import com.scudata.ide.spl.chart.ImageRenderer;
import com.scudata.ide.spl.chart.box.DefaultParamTableRender;
import com.scudata.ide.spl.dialog.DialogTextEditor;
import com.scudata.ide.spl.etl.EtlConsts;
import com.scudata.ide.spl.etl.EtlRowEditor;
import com.scudata.ide.spl.etl.EtlRowRenderer;
import com.scudata.ide.spl.etl.ParamInfo;
import com.scudata.ide.spl.etl.ParamInfoList;
import com.scudata.ide.spl.resources.ChartMessage;
import com.scudata.util.Variant;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class TableParamEdit
extends JTableEx {
    private static final long serialVersionUID = 924940299890651265L;
    private String NAMECOL = ChartMessage.get().getMessage("label.propname");
    private String VALUECOL = ChartMessage.get().getMessage("label.propvalue");
    private String EXPCOL = ChartMessage.get().getMessage("label.propexp");
    private String EDITSTYLECOL = "editstyle";
    private String OBJCOL = "objcol";
    private int iNAMECOL = 1;
    private int iVALUECOL = 2;
    private int iEXPCOL = 3;
    private int iEDITSTYLECOL = 4;
    private int iOBJCOL = 5;
    private HashMap<String, ArrayList<Object[]>> hiddenMap = new HashMap();
    private JDialog owner;

    public TableParamEdit(JDialog owner) {
        this.owner = owner;
        Object[] colNames = new String[]{" ", this.NAMECOL, this.VALUECOL, this.EXPCOL, this.EDITSTYLECOL, this.OBJCOL};
        this.data.setColumnIdentifiers(colNames);
        this.setRowHeight(25);
        DefaultParamTableRender render = new DefaultParamTableRender();
        TableColumn tc = this.getColumn(0);
        tc.setMaxWidth(20);
        tc.setMinWidth(20);
        tc.setCellEditor(new ImageEditor());
        tc.setCellRenderer(new ImageRenderer());
        tc = this.getColumn(this.iNAMECOL);
        tc.setCellRenderer(render);
        tc.setPreferredWidth(200);
        tc = this.getColumn(this.iVALUECOL);
        tc.setCellEditor(new EtlRowEditor(this, this.iEDITSTYLECOL, owner));
        tc.setCellRenderer(new EtlRowRenderer(this.iEDITSTYLECOL, owner));
        tc = this.getColumn(this.iEXPCOL);
        tc.setCellEditor(new JTextAreaEditor(this));
        tc.setCellRenderer(render);
        this.setColumnVisible(this.EDITSTYLECOL, false);
        this.setColumnVisible(this.OBJCOL, false);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
    }

    public void setParamEdit(ParamInfoList list) {
        this.acceptText();
        this.data.setRowCount(0);
        this.hiddenMap.clear();
        TableColumn tc = this.getColumn(this.iVALUECOL);
        tc.setCellEditor(new EtlRowEditor(this, this.iEDITSTYLECOL, this.owner));
        tc.setCellRenderer(new EtlRowRenderer(this.iEDITSTYLECOL, this.owner));
        ArrayList<ParamInfo> root = list.getRootParams();
        int i = 0;
        while (i < root.size()) {
            ParamInfo pi = (ParamInfo)root.get(i);
            Object[] row = new Object[6];
            row[0] = null;
            row[this.iNAMECOL] = pi.getTitle();
            Object value = pi.getValue();
            if (value instanceof String) {
                if (value.toString().startsWith("=")) {
                    row[this.iEXPCOL] = value.toString().substring(1);
                } else {
                    row[this.iVALUECOL] = value;
                }
            } else {
                row[this.iVALUECOL] = value;
            }
            row[this.iEDITSTYLECOL] = new Integer(pi.getInputType());
            row[this.iOBJCOL] = pi;
            this.data.addRow(row);
            ++i;
        }
        ArrayList<String> groups = list.getGroupNames();
        if (groups != null) {
            int i2 = 0;
            while (i2 < groups.size()) {
                String groupName = (String)groups.get(i2);
                Object[] grow = new Object[6];
                grow[0] = i2 == groups.size() - 1 ? new Byte(4) : new Byte(1);
                grow[this.iNAMECOL] = groupName;
                grow[this.iEDITSTYLECOL] = new Integer(1);
                this.data.addRow(grow);
                ArrayList<Object[]> grows = new ArrayList<Object[]>();
                ArrayList<ParamInfo> glist = list.getParams(groupName);
                int j = 0;
                while (j < glist.size()) {
                    ParamInfo pi = (ParamInfo)glist.get(j);
                    Object[] row = new Object[6];
                    row[0] = j == glist.size() - 1 ? new Byte(5) : new Byte(2);
                    row[this.iNAMECOL] = pi.getTitle();
                    Object value = pi.getValue();
                    if (value instanceof String) {
                        if (value.toString().startsWith("=")) {
                            row[this.iEXPCOL] = value.toString().substring(1);
                            row[this.iVALUECOL] = pi.getDefValue();
                        } else {
                            row[this.iVALUECOL] = value;
                        }
                    } else if (value instanceof ArrayList) {
                        row[this.iVALUECOL] = this.arrayList2Series((ArrayList)value);
                        pi.setValue(row[this.iVALUECOL]);
                    } else {
                        row[this.iVALUECOL] = value;
                    }
                    row[this.iEDITSTYLECOL] = new Integer(pi.getInputType());
                    row[this.iOBJCOL] = pi;
                    this.data.addRow(row);
                    grows.add(row);
                    ++j;
                }
                this.hiddenMap.put(groupName, grows);
                ++i2;
            }
        }
    }

    @Override
    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
        Object val;
        if (col == 0) {
            return;
        }
        if (!this.isCellEditable(row, col)) {
            return;
        }
        if (col == this.iVALUECOL) {
            Object editStyle = this.data.getValueAt(row, this.iEDITSTYLECOL);
            byte es = ((Number)editStyle).byteValue();
            if (es == 51) {
                String fileExt = "ctx,btx,csv,txt,xls,xlsx";
                File file = GM.dialogSelectFile(this.owner, fileExt);
                if (file != null) {
                    String txt = file.getAbsolutePath();
                    Object src = e.getSource();
                    if (src instanceof JTextField) {
                        JTextField tf = (JTextField)src;
                        tf.setText(txt);
                    }
                    this.setValueAt(txt, row, col);
                    this.acceptText();
                }
                return;
            }
            if (es != 1 && es != 1007) {
                return;
            }
        }
        if ((val = this.data.getValueAt(row, col)) != null && !(val instanceof String)) {
            return;
        }
        DialogTextEditor dte = new DialogTextEditor(this.owner);
        String exp = (String)val;
        dte.setText(exp);
        dte.setVisible(true);
        if (dte.getOption() == 0) {
            String txt = dte.getText();
            Object src = e.getSource();
            if (src instanceof JTextField) {
                JTextField tf = (JTextField)src;
                tf.setText(txt);
            }
            this.setValueAt(txt, row, col);
            this.acceptText();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getButton() == 1) {
            byte oldType;
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (col != 0) {
                return;
            }
            if (this.data.getValueAt(row, col) == null || !(this.data.getValueAt(row, col) instanceof Byte)) {
                return;
            }
            byte newType = oldType = ((Byte)this.data.getValueAt(row, col)).byteValue();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            String key = (String)this.data.getValueAt(row, 1);
            this.acceptText();
            switch (oldType) {
                case 1: {
                    newType = 0;
                }
                case 4: {
                    newType = 3;
                    while (row + 1 < this.data.getRowCount() && this.data.getValueAt(row + 1, this.iOBJCOL) != null) {
                        Object[] rowData = new Object[this.data.getColumnCount()];
                        int c = 0;
                        while (c < this.data.getColumnCount()) {
                            rowData[c] = this.data.getValueAt(row + 1, c);
                            ++c;
                        }
                        list.add(rowData);
                        this.data.removeRow(row + 1);
                    }
                    this.hiddenMap.put(key, list);
                    break;
                }
                case 0: {
                    newType = 1;
                }
                case 3: {
                    newType = 4;
                    this.expand(key, row + 1);
                }
            }
            this.data.setValueAt(new Byte(newType), row, col);
            this.acceptText();
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        ParamInfo info = (ParamInfo)this.data.getValueAt(row, this.iOBJCOL);
        if (info == null) {
            return false;
        }
        if (column == this.iEXPCOL) {
            Object val = this.data.getValueAt(row, this.iVALUECOL);
            if (val instanceof Boolean) {
                return false;
            }
            int type = (Integer)this.data.getValueAt(row, this.iEDITSTYLECOL);
            return !EtlConsts.isDisableExpEditType(type);
        }
        return column != this.iNAMECOL;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object oldValue = this.getValueAt(row, column);
        if (oldValue == null) {
            oldValue = "";
        }
        if (column == this.iEXPCOL) {
            aValue = aValue.toString().trim();
        }
        if (Variant.isEquals(aValue, oldValue)) {
            return;
        }
        super.setValueAt(aValue, row, column);
        ParamInfo info = (ParamInfo)this.data.getValueAt(row, this.iOBJCOL);
        if (info != null) {
            if (column == this.iVALUECOL) {
                super.setValueAt(TableParamEdit.toExpString(info, aValue), row, this.iEXPCOL);
            } else if (column == this.iEXPCOL) {
                super.setValueAt(TableParamEdit.toValueObject(info, aValue.toString()), row, this.iVALUECOL);
                aValue = aValue.toString().trim().length() == 0 ? info.getDefValue() : "=" + aValue.toString();
            } else {
                return;
            }
            info.setValue(aValue);
        }
    }

    private void expand(String groupName, int row) {
        ArrayList<Object[]> list = this.hiddenMap.get(groupName);
        int i = 0;
        while (i < list.size()) {
            this.data.insertRow(row + i, list.get(i));
            ++i;
        }
    }

    @Override
    public void acceptText() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public static String toExpString(ParamInfo info, Object value) {
        int inputType = info.getInputType();
        switch (inputType) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return value == null ? "" : value.toString();
            }
        }
        return "";
    }

    public static Object toValueObject(ParamInfo info, String exp) {
        int inputType = info.getInputType();
        switch (inputType) {
            case 1: 
            case 2: 
            case 13: {
                return "";
            }
            case 12: {
                return info.getDefValue();
            }
        }
        Object value = PgmNormalCell.parseConstValue(exp);
        if (TableParamEdit.isRightType(inputType, value)) {
            return value;
        }
        return info.getDefValue();
    }

    public static boolean isRightType(int type, Object value) {
        switch (type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return value instanceof Integer;
            }
            case 25: {
                return value instanceof Double;
            }
            case 5: {
                return value instanceof String;
            }
            case 10: {
                return value instanceof Boolean;
            }
        }
        return false;
    }

    private Sequence arrayList2Series(ArrayList list) {
        Sequence series = new Sequence();
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof ArrayList) {
                series.add(this.arrayList2Series((ArrayList)o));
            } else {
                series.add(o);
            }
            ++i;
        }
        return series;
    }
}

