/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.spl.http;

import com.scudata.app.common.AppUtil;
import com.scudata.common.Logger;
import com.scudata.common.UUID;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.excel.ExcelApi;
import com.scudata.ide.spl.GMSpl;
import com.scudata.server.http.LinksPool;
import com.scudata.thread.Job;
import com.scudata.util.JSONUtil;
import com.scudata.util.Variant;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;

public class HttpHandlerExcel
implements HttpHandler {
    private final String ROW_SEP = "\n";
    private final String COL_SEP = "\t";

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            URI uri = httpExchange.getRequestURI();
            String path = uri.getPath();
            if (path.equals("/favicon.ico")) {
                return;
            }
            if (!LinksPool.canCreateLink()) {
                throw new Exception("The number of connections exceeds the maximum value: " + LinksPool.getMaxLinks());
            }
            new Thread(new HandlerThread(httpExchange)).start();
            LinksPool.addLink();
        }
        catch (Throwable t) {
            try {
                try {
                    String result = AppUtil.getThrowableString(t);
                    Logger.severe(t);
                    byte[] bytes = result.getBytes("UTF-8");
                    httpExchange.getResponseHeaders().add("Content-Type", "text/html;charset=UTF-8");
                    httpExchange.sendResponseHeaders(500, bytes.length);
                    OutputStream os = httpExchange.getResponseBody();
                    os.write(bytes);
                    os.close();
                }
                catch (Throwable th) {
                    Logger.severe(th);
                    try {
                        httpExchange.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                try {
                    httpExchange.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private synchronized JobSpace getJobSpace() {
        String uuid = UUID.randomUUID().toString();
        JobSpace jobSpace = JobSpaceManager.getSpace(uuid);
        return jobSpace;
    }

    private Object result2String(Object obj, boolean isHorizon) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String || obj instanceof byte[]) {
            return obj;
        }
        if (obj instanceof Sequence) {
            StringBuffer buf = new StringBuffer();
            Sequence seq = (Sequence)obj;
            int len = seq.length();
            DataStruct ds = seq.dataStruct();
            if (ds != null && (seq.isPurePmt() || seq instanceof Table)) {
                String[] fieldNames = ds.getFieldNames();
                int j = 0;
                while (j < fieldNames.length) {
                    if (j > 0) {
                        buf.append("\t");
                    }
                    buf.append(fieldNames[j]);
                    ++j;
                }
                int i = 1;
                while (i <= len) {
                    buf.append("\n");
                    BaseRecord record = (BaseRecord)seq.get(i);
                    int j2 = 0;
                    while (j2 < fieldNames.length) {
                        if (j2 > 0) {
                            buf.append("\t");
                        }
                        buf.append(this.obj2String(record.getFieldValue(j2)));
                        ++j2;
                    }
                    ++i;
                }
            } else {
                Object mem;
                boolean isSeq1 = true;
                int i = 1;
                while (i <= len) {
                    if (i > 1) {
                        buf.append("\n");
                    }
                    if ((mem = seq.get(i)) != null) {
                        int j;
                        int subSize;
                        if (mem instanceof Sequence) {
                            isSeq1 = false;
                            Sequence subSeq = (Sequence)mem;
                            subSize = subSeq.length();
                            j = 1;
                            while (j <= subSize) {
                                if (j > 1) {
                                    buf.append("\t");
                                }
                                buf.append(this.obj2String(subSeq.get(j)));
                                ++j;
                            }
                        } else if (mem instanceof BaseRecord) {
                            isSeq1 = false;
                            BaseRecord subRecord = (BaseRecord)mem;
                            subSize = subRecord.getFieldCount();
                            j = 0;
                            while (j < subSize) {
                                if (j > 0) {
                                    buf.append("\t");
                                }
                                buf.append(this.obj2String(subRecord.getFieldValue(j)));
                                ++j;
                            }
                        } else {
                            buf.append(this.obj2String(mem));
                        }
                    }
                    ++i;
                }
                if (isHorizon && isSeq1) {
                    buf.setLength(0);
                    i = 1;
                    while (i <= len) {
                        if (i > 1) {
                            buf.append("\t");
                        }
                        if ((mem = seq.get(i)) != null) {
                            buf.append(this.obj2String(mem));
                        }
                        ++i;
                    }
                }
            }
            return buf.toString();
        }
        if (obj instanceof BaseRecord) {
            StringBuffer buf = new StringBuffer();
            BaseRecord record = (BaseRecord)obj;
            String[] fieldNames = record.getFieldNames();
            int len = fieldNames.length;
            int j = 0;
            while (j < len) {
                if (j > 0) {
                    buf.append("\t");
                }
                buf.append(fieldNames[j]);
                ++j;
            }
            buf.append("\n");
            j = 0;
            while (j < len) {
                if (j > 0) {
                    buf.append("\t");
                }
                buf.append(this.obj2String(record.getFieldValue(j)));
                ++j;
            }
            return buf.toString();
        }
        return this.obj2String(obj);
    }

    private String obj2String(Object obj) {
        return Variant.toExportString(obj);
    }

    class HandlerThread
    extends Job {
        HttpExchange httpExchange;

        public HandlerThread(HttpExchange httpExchange) {
            this.httpExchange = httpExchange;
        }

        @Override
        public void run() {
            int status;
            Object result;
            block39: {
                result = "";
                status = 200;
                Context ctx = null;
                InputStream reqis = null;
                JobSpace jobSpace = null;
                try {
                    try {
                        reqis = this.httpExchange.getRequestBody();
                        BufferedReader br = new BufferedReader(new InputStreamReader(reqis, "UTF-8"));
                        boolean isHorizon = false;
                        Sequence params = new Sequence();
                        String line = null;
                        int index = 0;
                        while ((line = br.readLine()) != null) {
                            String[] settings;
                            if (index == 0) {
                                char[] cs = line.toCharArray();
                                Object obj = JSONUtil.parseJSON(cs, 0, cs.length - 1);
                                if (obj instanceof Sequence) {
                                    params = (Sequence)obj;
                                    int i = 1;
                                    int len = params.length();
                                    while (i <= len) {
                                        Sequence memSeq;
                                        Object mem;
                                        Sequence subSeq = (Sequence)params.get(i);
                                        if (subSeq.length() == 1 && (mem = subSeq.get(1)) instanceof Sequence && (memSeq = (Sequence)mem).length() == 1) {
                                            params.set(i, memSeq.get(1));
                                        }
                                        ++i;
                                    }
                                }
                                ++index;
                                continue;
                            }
                            if (index != true) break;
                            String[] stringArray = settings = line.split(";");
                            int n = settings.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String set = stringArray[n2];
                                String[] keyVal = set.split("=");
                                if ("isHorizon".equals(keyVal[0])) {
                                    try {
                                        isHorizon = Boolean.parseBoolean(keyVal[1]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                ++n2;
                            }
                            ++index;
                        }
                        ctx = GMSpl.prepareParentContext();
                        jobSpace = HttpHandlerExcel.this.getJobSpace();
                        ctx.setJobSpace(jobSpace);
                        result = ExcelApi.executeExcel(params, false, ctx);
                        result = HttpHandlerExcel.this.result2String(result, isHorizon);
                    }
                    catch (Throwable t) {
                        if (t != null) {
                            String message = t.getMessage();
                            if (message != null) {
                                message = message.replaceAll("\n", " ");
                            }
                            result = message;
                        }
                        Logger.severe(t);
                        try {
                            if (reqis != null) {
                                reqis.close();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (jobSpace != null) {
                            jobSpace.closeResource();
                            JobSpaceManager.closeSpace(jobSpace.getID());
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reqis != null) {
                            reqis.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    if (jobSpace != null) {
                        jobSpace.closeResource();
                        JobSpaceManager.closeSpace(jobSpace.getID());
                    }
                    throw throwable;
                }
                try {
                    if (reqis != null) {
                        reqis.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (jobSpace != null) {
                    jobSpace.closeResource();
                    JobSpaceManager.closeSpace(jobSpace.getID());
                }
            }
            try {
                try {
                    String encoding = "UTF-8";
                    Headers hs = this.httpExchange.getResponseHeaders();
                    byte[] bytes = null;
                    bytes = result instanceof String ? ((String)result).getBytes(encoding) : (byte[])result;
                    hs.add("Access-Control-Allow-Origin", "*");
                    hs.add("Access-Control-Allow-Methods", "POST,GET,PUT,DELETE");
                    hs.add("Access-Control-Allow-Headers", "*");
                    hs.add("Access-Control-Allow-Credentials", "true");
                    this.httpExchange.sendResponseHeaders(status, bytes.length);
                    OutputStream os = this.httpExchange.getResponseBody();
                    os.write(bytes);
                    os.close();
                }
                catch (Throwable x) {
                    Logger.severe(x);
                    try {
                        this.httpExchange.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LinksPool.removeLink();
                }
            }
            finally {
                try {
                    this.httpExchange.close();
                }
                catch (Throwable throwable) {}
                LinksPool.removeLink();
            }
        }
    }
}

