/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.Console;
import com.scudata.ide.common.EditListener;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.spl.IDEBase;
import com.scudata.ide.vdb.VDBTree;
import com.scudata.ide.vdb.config.ConfigFile;
import com.scudata.ide.vdb.config.ConfigOptions;
import com.scudata.ide.vdb.control.ConnectionConfig;
import com.scudata.ide.vdb.control.VDBTreeNode;
import com.scudata.ide.vdb.dialog.DialogConnection;
import com.scudata.ide.vdb.dialog.DialogOptions;
import com.scudata.ide.vdb.menu.MenuVDB;
import com.scudata.ide.vdb.menu.ToolbarVDB;
import com.scudata.ide.vdb.panel.PanelEditor;
import com.scudata.ide.vdb.panel.PanelImage;
import com.scudata.ide.vdb.panel.PanelItems;
import com.scudata.ide.vdb.panel.PanelScript;
import com.scudata.ide.vdb.panel.PanelSequence;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class VDB
extends AppFrame
implements EditListener {
    private static final long serialVersionUID = 1L;
    private ToolbarVDB toolbarVDB = null;
    private JSplitPane spCenter = null;
    private VDBTree vdbTree = null;
    private MenuVDB menuVDB = null;
    private static VDB activeFrame = null;
    transient PanelItems panelItems = new PanelItems(this){

        @Override
        public void doubleClicked(VDBTreeNode node) {
            VDB.this.showNodePanel(node);
        }
    };
    transient PanelSequence panelSequence = new PanelSequence(this);
    transient PanelImage panelImage = new PanelImage(this);
    transient PanelScript panelScript = new PanelScript(this);
    transient Timer timer = new Timer();
    int initLocation = 100;
    public static JTextArea consoleTextArea = null;
    private static Console console = null;

    public VDB() {
        this.init();
    }

    public MenuVDB getMenuVDB() {
        return this.menuVDB;
    }

    public ToolbarVDB getToolbarVDB() {
        return this.toolbarVDB;
    }

    private void init() {
        VDB.resetInstallDirectories();
        try {
            ConfigOptions.load();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        System.setProperty("java.awt.im.style", "on-the-spot");
        this.setTitle(this.getTitle());
        this.vdbTree = new VDBTree(){

            @Override
            public void showNode(VDBTreeNode node) {
                VDB.this.showNodePanel(node);
            }
        };
        this.getContentPane().setLayout(new BorderLayout());
        this.menuVDB = new MenuVDB();
        this.setJMenuBar(this.menuVDB);
        this.toolbarVDB = new ToolbarVDB();
        this.getContentPane().add((Component)this.toolbarVDB, "North");
        this.spCenter = new JSplitPane(1);
        this.spCenter.setOneTouchExpandable(true);
        this.spCenter.setDividerSize(7);
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.initLocation = (int)((double)screenWidth * 0.3);
        this.spCenter.setDividerLocation(this.initLocation);
        this.spCenter.add((Component)new JScrollPane(this.vdbTree), "left");
        this.getContentPane().add((Component)this.spCenter, "Center");
        VDB.holdConsole();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!VDB.this.exit()) {
                    VDB.this.setDefaultCloseOperation(0);
                    return;
                }
                VDB.this.setDefaultCloseOperation(2);
            }
        });
        this.setLocation(0, 0);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.menuVDB.disableConnectMenu();
        this.menuVDB.disableNodeMenu();
        this.menuVDB.disableDataMenu();
        this.loadConnections();
    }

    private void showNodePanel(final VDBTreeNode node) {
        if (node == null) {
            return;
        }
        this.timer.cancel();
        this.timer = new Timer();
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        PanelEditor p = null;
                        switch (node.getType()) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                p = (this).VDB.this.panelItems;
                                break;
                            }
                            case 4: {
                                p = (this).VDB.this.panelSequence;
                                break;
                            }
                            case 6: {
                                p = (this).VDB.this.panelImage;
                                break;
                            }
                            case 5: {
                                p = (this).VDB.this.panelScript;
                            }
                        }
                        if (p == null) {
                            return;
                        }
                        ((PanelEditor)p).setNode(node);
                        VDB.this.spCenter.add((Component)p, "right");
                        int location = VDB.this.spCenter.getDividerLocation();
                        if (location != (this).VDB.this.initLocation && (this).VDB.this.initLocation > 0) {
                            location = (this).VDB.this.initLocation;
                            (this).VDB.this.initLocation = 0;
                        }
                        VDB.this.spCenter.setDividerLocation(location);
                    }
                });
                VDB.this.timer.cancel();
            }
        };
        this.timer.schedule(tt, 200L, 500L);
        this.vdbTree.setSelectedNode(node);
    }

    private VDBTreeNode loadConnections() {
        Map<String, String> cons = ConfigOptions.connections;
        if (cons.isEmpty()) {
            return null;
        }
        Iterator<String> keys = cons.keySet().iterator();
        VDBTreeNode node = null;
        while (keys.hasNext()) {
            String key = keys.next();
            String configStr = cons.get(key);
            ConnectionConfig cc = ConnectionConfig.fromString(configStr);
            if (cc == null) continue;
            node = this.vdbTree.addConnection(cc);
        }
        return node;
    }

    public static void holdConsole() {
        if (ConfigOptions.bHoldConsole.booleanValue() && console != null) {
            consoleTextArea = new JTextArea();
            console = new Console(consoleTextArea);
        }
    }

    @Override
    public String getTitle() {
        return IdeMessage.get().getMessage("frame.title");
    }

    @Override
    public boolean closeAll() {
        if (this.vdbTree.isEditChanged()) {
            return this.vdbTree.close();
        }
        return true;
    }

    @Override
    public boolean exit() {
        if (this.closeAll()) {
            this.saveConfig();
            System.exit(0);
            return true;
        }
        return false;
    }

    private void saveConfig() {
        try {
            ConnectionConfig[] ccs = this.vdbTree.getConnections();
            if (ccs != null) {
                ConfigOptions.connections.clear();
                int i = 0;
                while (i < ccs.length) {
                    ConnectionConfig cc = ccs[i];
                    if (cc.isConnected()) {
                        cc.close();
                    }
                    ConfigOptions.connections.put(cc.getName(), cc.toString());
                    ++i;
                }
            }
            ConfigFile.save();
        }
        catch (Exception e) {
            GM.writeLog(e);
        }
    }

    @Override
    public String resetTitle() {
        return null;
    }

    public static void resetInstallDirectories() {
        String startHome = System.getProperty("start.home");
        if (!StringUtils.isValidString(startHome)) {
            startHome = System.getProperty("user.home");
            System.setProperty("start.home", startHome);
        }
        String[] path = new String[]{"/config", "/logo", "/log"};
        int i = 0;
        while (i < path.length) {
            File f = new File(GM.getAbsolutePath(path[i]));
            if (!f.exists()) {
                f.mkdirs();
            }
            ++i;
        }
    }

    public static VDB getInstance() {
        return activeFrame;
    }

    public static void main(String[] args) {
        System.out.println("VDB starting....");
        System.out.println("Language\uff1a" + Locale.getDefault());
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                IDEBase.initLNF();
                try {
                    activeFrame = new VDB();
                    GV.appFrame = activeFrame;
                    if (activeFrame != null) {
                        activeFrame.setVisible(true);
                        activeFrame.setExtendedState(6);
                        VDBTreeNode node = ((VDB)activeFrame).vdbTree.root;
                        if (node.getChildCount() > 0) {
                            node = (VDBTreeNode)node.getFirstChild();
                            activeFrame.vdbTree.setSelectedNode(node);
                        }
                    }
                    System.out.println("VDB started.");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        GM.showException(GV.appFrame, t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
    }

    public void executeCmd(short cmdId) {
        try {
            switch (cmdId) {
                case 5: {
                    DialogConnection dc = new DialogConnection(this.vdbTree.currentConnectionNames());
                    dc.setVisible(true);
                    int opt = dc.getOption();
                    if (opt == 0) {
                        ConnectionConfig cc = dc.getConnection();
                        this.vdbTree.addConnection(cc);
                    }
                    return;
                }
                case 10: {
                    this.vdbTree.openConnect();
                    return;
                }
                case 15: {
                    this.vdbTree.saveConnect();
                    return;
                }
                case 20: {
                    this.vdbTree.closeConnect(null);
                    return;
                }
                case 30: {
                    this.vdbTree.configConnect();
                    return;
                }
                case 40: {
                    this.vdbTree.deleteConnect();
                    return;
                }
                case 50: {
                    GM.showException(GV.appFrame, "Acheive");
                    return;
                }
                case 60: {
                    GM.showException(GV.appFrame, "purge");
                    return;
                }
                case 99: {
                    this.exit();
                    return;
                }
                case 210: {
                    this.vdbTree.copyNode();
                    return;
                }
                case 220: {
                    this.vdbTree.pasteNode();
                    return;
                }
                case 230: {
                    this.vdbTree.deleteNode();
                    return;
                }
                case 240: {
                    GM.showException(GV.appFrame, "NODE.CREATE");
                    return;
                }
                case 320: {
                    GM.showException(GV.appFrame, "DATA.COPY");
                    return;
                }
                case 330: {
                    GM.showException(GV.appFrame, "DATA.PASTE");
                    return;
                }
                case 310: {
                    GM.showException(GV.appFrame, "DATA.SAVE");
                    return;
                }
                case 340: {
                    GM.showException(GV.appFrame, "DATA.IMPORT");
                    return;
                }
                case 440: {
                    return;
                }
                case 450: {
                    new DialogOptions().setVisible(true);
                    return;
                }
            }
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    @Override
    public void editChanged(Object newVal) {
        this.vdbTree.setEditChanged();
    }

    @Override
    public void quit() {
    }

    @Override
    public JInternalFrame openSheetFile(String fileName) throws Exception {
        return null;
    }

    @Override
    public void changeMenuAndToolBar(JMenuBar menu, JToolBar toolBar) {
    }

    @Override
    public boolean closeSheet(Object sheet) {
        return false;
    }

    @Override
    public String getProductName() {
        return null;
    }
}

