/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb;

import com.scudata.dm.Sequence;
import com.scudata.ide.common.GV;
import com.scudata.ide.vdb.TransferableVS;
import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.commonvdb.GM;
import com.scudata.ide.vdb.control.ConnectionConfig;
import com.scudata.ide.vdb.control.VDBTreeNode;
import com.scudata.ide.vdb.control.VDBTreeRender;
import com.scudata.ide.vdb.dialog.DialogConnection;
import com.scudata.ide.vdb.menu.MenuVDB;
import com.scudata.vdb.IVS;
import com.scudata.vdb.VS;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public abstract class VDBTree
extends JTree {
    private static final long serialVersionUID = 1L;
    protected VDBTreeNode root = new VDBTreeNode((Object)"Connections", 0);
    private VDBTreeNode currentNode;
    private boolean preventChangeEvent = false;

    public VDBTree() {
        this.root.setLoaded(true);
        this.setModel(new DefaultTreeModel(this.root));
        this.setCellRenderer(new VDBTreeRender());
        this.setBorder(BorderFactory.createBevelBorder(1));
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.setSelectionModel(dtsm);
        this.addMouseListener(new mTree_mouseAdapter());
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                VDBTreeNode node = (VDBTreeNode)path.getLastPathComponent();
                if (node != null && !node.isLoaded()) {
                    VDBTree.this.loadSubNode(node);
                    node.setLoaded(true);
                    node.setExpanded(true);
                    VDBTree.this.nodeStructureChanged(node);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path == null) {
                    return;
                }
                VDBTreeNode node = (VDBTreeNode)path.getLastPathComponent();
                if (node != null) {
                    node.setExpanded(false);
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (VDBTree.this.preventChangeEvent) {
                    return;
                }
                try {
                    VDBTree.this.currentNode = (VDBTreeNode)e.getPath().getLastPathComponent();
                    VDBTree.this.showNode(VDBTree.this.currentNode);
                }
                catch (Exception x) {
                    GM.showException(x);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\n') {
                    VDBTree.this.openConnect();
                }
            }
        });
    }

    public void setSelectedNode(VDBTreeNode node) {
        Object[] path = node.getPath();
        this.setSelectionPath(new TreePath(path));
        this.currentNode = node;
        this.refreshNodeStatus(node);
    }

    private void refreshNodeStatus(VDBTreeNode node) {
        if (node == null) {
            return;
        }
        VDB fr = VDB.getInstance();
        if (fr == null) {
            return;
        }
        MenuVDB menu = fr.getMenuVDB();
        menu.nodeSelected(node);
    }

    public ConnectionConfig[] getConnections() {
        int n = this.root.getChildCount();
        ConnectionConfig[] ccs = new ConnectionConfig[n];
        int i = 0;
        while (i < n) {
            ConnectionConfig cc;
            VDBTreeNode node = (VDBTreeNode)this.root.getChildAt(i);
            ccs[i] = cc = (ConnectionConfig)node.getUserObject();
            ++i;
        }
        return ccs;
    }

    public ArrayList<String> currentConnectionNames() {
        ArrayList<String> names = new ArrayList<String>();
        int n = this.root.getChildCount();
        int i = 0;
        while (i < n) {
            VDBTreeNode sub = (VDBTreeNode)this.root.getChildAt(i);
            names.add(sub.getName());
            ++i;
        }
        return names;
    }

    public VDBTreeNode addConnection(ConnectionConfig cc) {
        VDBTreeNode connNode = new VDBTreeNode((Object)cc, 1);
        this.root.add(connNode);
        this.nodeStructureChanged(this.root);
        this.selectNode(connNode);
        return connNode;
    }

    public synchronized void openConnect() {
        VDBTreeNode node = this.getActiveNode();
        if (node == null || node.getType() != 1) {
            return;
        }
        ConnectionConfig cc = (ConnectionConfig)node.getUserObject();
        if (cc.isConnected()) {
            return;
        }
        try {
            com.scudata.vdb.VDB vdb = cc.connect();
            node.setLoaded(true);
            VDBTreeNode vdbNode = new VDBTreeNode(vdb);
            this.loadSubNode(vdbNode);
            node.add(vdbNode);
            this.nodeStructureChanged(node);
            this.selectNode(vdbNode);
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }

    public synchronized void saveConnect() {
        VDBTreeNode node = this.getActiveNode();
        if (node == null) {
            return;
        }
        ConnectionConfig cc = VDBTree.getNodeConnection(node);
        try {
            cc.commit();
            this.refreshNodeStatus(node);
        }
        catch (Exception x) {
            GM.showException(x);
        }
    }

    public boolean isEditChanged() {
        int c = this.root.getChildCount();
        int i = 0;
        while (i < c) {
            VDBTreeNode sub = (VDBTreeNode)this.root.getChildAt(i);
            ConnectionConfig cc = VDBTree.getNodeConnection(sub);
            if (cc.isEditChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean close() {
        int c = this.root.getChildCount();
        int i = 0;
        while (i < c) {
            VDBTreeNode sub = (VDBTreeNode)this.root.getChildAt(i);
            if (!this.closeConnect(sub)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized boolean closeConnect(VDBTreeNode node) {
        ConnectionConfig cc;
        if (node == null) {
            node = this.getActiveNode();
        }
        if ((cc = node.getType() != 1 ? VDBTree.getNodeConnection(node) : (ConnectionConfig)node.getUserObject()).isEditChanged()) {
            int option = JOptionPane.showConfirmDialog(GV.appFrame, "[ " + cc.getName() + " ]\u7684\u6570\u636e\u6ca1\u6709\u63d0\u4ea4\uff0c\u9700\u8981\u63d0\u4ea4\u5417\uff1f", "\u6570\u636e\u4fdd\u5b58", 1);
            switch (option) {
                case 0: {
                    try {
                        cc.commit();
                        break;
                    }
                    catch (Exception x) {
                        GM.showException(x);
                        return false;
                    }
                }
                case 1: {
                    cc.rollback();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (cc.isConnected()) {
            cc.close();
            node.removeAllChildren();
            this.nodeStructureChanged(node);
            this.refreshNodeStatus(node);
        }
        return true;
    }

    public synchronized void configConnect() {
        VDBTreeNode node = this.getActiveNode();
        if (node == null || node.getType() != 1) {
            return;
        }
        ConnectionConfig cc = (ConnectionConfig)node.getUserObject();
        if (cc.isConnected()) {
            int option = JOptionPane.showConfirmDialog(VDB.getInstance(), "\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u6253\u5f00\u72b6\u6001\uff0c\u7f16\u8f91\u524d\u9700\u8981\u5173\u95ed\u5b83\uff0c\u786e\u8ba4\u5173\u95ed\u5417\uff1f", "\u786e\u8ba4\u5173\u95ed", 2);
            switch (option) {
                case 0: {
                    if (this.closeConnect(node)) break;
                    return;
                }
            }
        }
        ArrayList<String> names = this.currentConnectionNames();
        names.remove(cc.getName());
        DialogConnection dc = new DialogConnection(names);
        dc.setConnection(cc);
        dc.setVisible(true);
        int opt = dc.getOption();
        if (opt == 0) {
            cc = dc.getConnection();
            node.setUserObject(cc);
            node.setTitle(cc.getName());
            this.nodeStructureChanged(node);
        }
    }

    public static ConnectionConfig getNodeConnection(VDBTreeNode node) {
        byte type = node.getType();
        while (type != 1) {
            if ((node = (VDBTreeNode)node.getParent()) == null) break;
            type = node.getType();
        }
        if (node == null) {
            return null;
        }
        return (ConnectionConfig)node.getUserObject();
    }

    public synchronized void deleteConnect() {
        VDBTreeNode node = this.getActiveNode();
        if (node == null || node.getType() != 1) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(VDB.getInstance(), "\u786e\u5b9e\u8981\u5220\u9664\u8fde\u63a5\u3010" + node.getTitle() + "\u3011\u5417\uff1f", "\u786e\u8ba4\u5220\u9664", 2);
        if (option != 0) {
            return;
        }
        ConnectionConfig cc = (ConnectionConfig)node.getUserObject();
        if (cc.isConnected() && !this.closeConnect(node)) {
            return;
        }
        VDBTreeNode pNode = (VDBTreeNode)node.getParent();
        pNode.remove(node);
        this.nodeStructureChanged(pNode);
    }

    private VDBTreeNode getNextNode(VDBTreeNode node) {
        VDBTreeNode brother = (VDBTreeNode)node.getNextSibling();
        if (brother == null) {
            brother = (VDBTreeNode)node.getPreviousNode();
        }
        if (brother == null) {
            brother = (VDBTreeNode)node.getParent();
        }
        return brother;
    }

    public void deleteNode() {
        if (this.currentNode == null) {
            return;
        }
        Object obj = this.currentNode.getUserObject();
        if (!(obj instanceof VS)) {
            JOptionPane.showMessageDialog(VDB.getInstance(), "\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002");
            return;
        }
        VS vs = (VS)obj;
        vs.delete(null);
        this.setEditChanged(this.currentNode);
        VDBTreeNode pNode = (VDBTreeNode)this.currentNode.getParent();
        VDBTreeNode nextFocus = this.getNextNode(this.currentNode);
        pNode.remove(this.currentNode);
        this.nodeStructureChanged(pNode);
        this.setSelectedNode(nextFocus);
    }

    public void copyNode() {
        if (this.currentNode == null) {
            return;
        }
        VS vs = (VS)this.currentNode.getUserObject();
        TransferableVS tvs = new TransferableVS(vs);
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(tvs, null);
    }

    private VS getClipBoard() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clip.getContents(null);
        if (contents == null) {
            return null;
        }
        try {
            VS vs = (VS)contents.getTransferData(TransferableVS.vsFlavor);
            return vs;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void pasteVS(VS p, VS s) {
        Object value = s.load(null);
        Object path = s.path(null);
        Object name = s.path("f");
        p.save(value, path, name);
        Sequence subNodes = s.list("w");
        if (subNodes == null || subNodes.length() == 0) {
            return;
        }
        int i = 1;
        while (i <= subNodes.length()) {
            VS sub = (VS)subNodes.get(i);
            this.pasteVS(p, sub);
            ++i;
        }
    }

    public void setEditChanged() {
        this.setEditChanged(this.currentNode);
        this.refreshNodeStatus(this.currentNode);
    }

    private void setEditChanged(VDBTreeNode node) {
        ConnectionConfig cc = VDBTree.getNodeConnection(node);
        cc.setEditChanged();
    }

    public void pasteNode() {
        if (this.currentNode == null) {
            return;
        }
        if (this.currentNode.getType() <= 1) {
            return;
        }
        VS vs = this.getClipBoard();
        if (vs == null) {
            return;
        }
        IVS p = (IVS)this.currentNode.getUserObject();
        Object value = vs.load(null);
        Object path = vs.path(null);
        Object name = vs.path("f");
        p.save(value, path, name);
        this.setEditChanged(this.currentNode);
        this.loadSubNode(this.currentNode);
        this.nodeStructureChanged(this.currentNode);
        this.setSelectedNode(this.currentNode);
    }

    public synchronized void refresh() {
    }

    private void loadSubNode(VDBTreeNode pNode) {
        try {
            IVS vs = (IVS)pNode.getUserObject();
            Sequence subNodes = vs.list("w");
            if (subNodes == null || subNodes.length() == 0) {
                return;
            }
            pNode.removeAllChildren();
            int i = 1;
            while (i <= subNodes.length()) {
                VS sub = (VS)subNodes.get(i);
                VDBTreeNode node = new VDBTreeNode(sub);
                Sequence subChilds = sub.list("w");
                if (subChilds != null) {
                    int n = 1;
                    while (n <= subChilds.length()) {
                        VS child = (VS)subChilds.get(n);
                        VDBTreeNode nodeChild = new VDBTreeNode(child);
                        node.add(nodeChild);
                        ++n;
                    }
                }
                pNode.add(node);
                ++i;
            }
            pNode.setLoaded(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JPopupMenu getPopupMenu(VDBTreeNode node) {
        JPopupMenu popMenu = new JPopupMenu();
        MenuListener menuListener = new MenuListener(node);
        return popMenu;
    }

    public static JMenuItem getMenuItem(byte action, ActionListener al) {
        String title = null;
        String imgPath = null;
        JMenuItem mi = new JMenuItem(title);
        mi.setName(String.valueOf(action));
        if (imgPath != null) {
            mi.setIcon(GM.getImageIcon("/com/scudata/ide/vdb/img/" + imgPath));
        }
        mi.addActionListener(al);
        return mi;
    }

    public void exchangeNode(byte type, int i1, int i2) {
        VDBTreeNode node1 = (VDBTreeNode)this.root.getChildAt(i1);
        VDBTreeNode node2 = (VDBTreeNode)this.root.getChildAt(i2);
        this.root.insert(node1, i2);
        this.root.insert(node2, i1);
        this.nodeStructureChanged(this.root);
    }

    public abstract void showNode(VDBTreeNode var1);

    public VDBTreeNode getActiveNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (VDBTreeNode)path.getLastPathComponent();
    }

    protected VDBTreeNode locateFileNode(VDBTreeNode pNode, String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        ArrayList<String> paths = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paths.add(st.nextToken());
        }
        if (paths.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < paths.size()) {
            if ((pNode = this.getChildByName(pNode, (String)paths.get(i))) == null) {
                return null;
            }
            ++i;
        }
        return pNode;
    }

    protected VDBTreeNode locateFileNode(VDBTreeNode pNode, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return pNode;
        }
        int size = paths.size();
        int i = size - 1;
        while (i >= 0) {
            if ((pNode = this.getChildByName(pNode, paths.get(i))) == null) {
                return null;
            }
            --i;
        }
        return pNode;
    }

    protected VDBTreeNode getChildByName(VDBTreeNode pNode, String nodeName) {
        if (nodeName == null) {
            return null;
        }
        int count = pNode.getChildCount();
        int i = 0;
        while (i < count) {
            VDBTreeNode childNode = (VDBTreeNode)pNode.getChildAt(i);
            if (nodeName.equals(childNode.getTitle())) {
                return childNode;
            }
            ++i;
        }
        return null;
    }

    protected void selectNode(VDBTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        this.setSelectionPath(path);
    }

    protected void nodeChanged(VDBTreeNode node) {
        if (node != null) {
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
    }

    protected void nodeStructureChanged(VDBTreeNode node) {
        this.preventChangeEvent = true;
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        this.preventChangeEvent = false;
    }

    public VDBTreeNode getRoot() {
        return this.root;
    }

    class MenuListener
    implements ActionListener {
        VDBTreeNode node;

        public MenuListener(VDBTreeNode node) {
            this.node = node;
        }

        public void setVDBTreeNode(VDBTreeNode node) {
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            String sAction = mi.getName();
            Byte.parseByte(sAction);
        }
    }

    class mTree_mouseAdapter
    extends MouseAdapter {
        mTree_mouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 3) {
                return;
            }
            TreePath path = VDBTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            VDBTree.this.setSelectionPath(path);
            VDBTreeNode node = (VDBTreeNode)path.getLastPathComponent();
            JPopupMenu pop = VDBTree.this.getPopupMenu(node);
            if (pop != null) {
                pop.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            TreePath path = VDBTree.this.getClosestPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            if (e.getClickCount() == 2) {
                VDBTree.this.openConnect();
            } else {
                VDBTreeNode node = (VDBTreeNode)path.getLastPathComponent();
                VDBTree.this.showNode(node);
            }
        }
    }
}

