/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.commonvdb;

import com.scudata.ide.vdb.config.ConfigOptions;
import java.util.Vector;
import javax.swing.UIManager;

public class LNFManager {
    public static final byte LNF_SYSTEM = 1;
    public static final byte LNF_WINDOWS = 2;
    public static final byte LNF_NIMBUS = 3;

    public static Vector<Object> listLNFCode() {
        Vector<Object> list = new Vector<Object>();
        if (LNFManager.isNimbusEnabled()) {
            list.add(new Byte(3));
        }
        list.add(new Byte(2));
        list.add(new Byte(1));
        return list;
    }

    public static Vector<String> listLNFDisp() {
        Vector<String> list = new Vector<String>();
        if (LNFManager.isNimbusEnabled()) {
            list.add("Nimbus");
        }
        list.add("Windows");
        list.add("System");
        return list;
    }

    public static Byte getValidLookAndFeel(Byte lnf) {
        if (lnf != null) {
            switch (lnf) {
                case 1: 
                case 2: {
                    return lnf;
                }
            }
        }
        return LNFManager.isNimbusEnabled() ? new Byte(3) : new Byte(1);
    }

    private static boolean isNimbusEnabled() {
        try {
            return Class.forName("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getLookAndFeelName() {
        switch (ConfigOptions.iLookAndFeel) {
            case 2: {
                return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            case 1: {
                return UIManager.getSystemLookAndFeelClassName();
            }
        }
        if (LNFManager.isNimbusEnabled()) {
            return "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
        }
        return UIManager.getSystemLookAndFeelClassName();
    }
}

