/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.config;

import com.scudata.common.RQException;
import com.scudata.ide.common.GM;
import com.scudata.ide.vdb.config.ConfigOptionsHandler;
import com.scudata.ide.vdb.config.ConfigOptionsWriter;
import com.scudata.ide.vdb.resources.IdeMessage;
import com.scudata.resources.AppMessage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ConfigFile {
    public static final String ROOT = "Config";
    public static final String VERSION = "Version";
    public static final String OPTIONS = "Options";
    public static final String OPTION = "Option";
    public static final String NAME = "Name";
    public static final String VALUE = "Value";
    public static final String DIMENSIONS = "Dimensions";
    public static final String DIMENSION = "Dimension";
    public static final String RECENT_FILES = "RecentFiles";
    public static final String RECENT_FILE = "RecentFile";
    public static final String CONNECTIONS = "Connections";
    public static final String CONNECTION = "Connection";
    public static final String CONFIG_FILE_NAME = "vdbuserconfig.xml";
    public static final String BAK_SUFFIX = ".bak";

    public static String getConfigFilePath() {
        return GM.getAbsolutePath("config/vdbuserconfig.xml");
    }

    public static void save() throws Exception {
        String filePath = ConfigFile.getConfigFilePath();
        File f = new File(filePath);
        if (f.exists() && !f.canWrite()) {
            String msg = IdeMessage.get().getMessage("file.readonly", CONFIG_FILE_NAME);
            throw new RQException(msg);
        }
        ConfigOptionsWriter writer = new ConfigOptionsWriter();
        writer.write(filePath);
    }

    public static void load() throws Exception {
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            File file = new File(ConfigFile.getConfigFilePath());
            if (file.exists() && file.isFile()) {
                is = new FileInputStream(file.getAbsoluteFile());
            }
            if (is == null) {
                throw new RQException(IdeMessage.get().getMessage("file.notexist", CONFIG_FILE_NAME));
            }
            bis = new BufferedInputStream(is);
            ConfigFile.load(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void load(InputStream is) throws Exception {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            ConfigOptionsHandler handler = new ConfigOptionsHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(is));
        }
        catch (Exception ex) {
            throw new RQException(AppMessage.get().getMessage("configfile.ex", ex.getMessage(), CONFIG_FILE_NAME), ex);
        }
    }

    public static void newInstance() {
        try {
            ConfigFile.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            GM.writeLog(e);
        }
    }

    public static void backup() {
        String filePath = ConfigFile.getConfigFilePath();
        File f = new File(filePath);
        File fb = new File(String.valueOf(filePath) + BAK_SUFFIX);
        fb.delete();
        f.renameTo(fb);
    }
}

