/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.config;

import com.scudata.common.StringUtils;
import com.scudata.ide.vdb.config.ConfigFile;
import java.util.HashMap;
import java.util.Map;

public class ConfigOptions {
    public static Boolean bAutoOpen = Boolean.TRUE;
    public static Byte iLookAndFeel = new Byte(3);
    public static Boolean bLogException = Boolean.TRUE;
    public static Boolean bWindowSize = Boolean.TRUE;
    public static Boolean bHoldConsole = Boolean.FALSE;
    public static String sLogFileName = "/log/vdb.log";
    public static String sLastDirectory = System.getProperty("user.home");
    public static String sEsprocLic = "/config/\u96c6\u7b97\u5668\u5185\u90e8\u6d4b\u8bd5\u7248.lic";
    public static Map<String, Object> options = new HashMap<String, Object>();
    public static Map<String, String> dimensions = new HashMap<String, String>();
    public static Map<String, String> connections = new HashMap<String, String>();

    static {
        ConfigOptions.putOptions();
    }

    private static void putOptions() {
        options.put("bAutoOpen", bAutoOpen);
        options.put("bLogException", bLogException);
        options.put("bWindowSize", bWindowSize);
        options.put("bHoldConsole", bHoldConsole);
        options.put("iLookAndFeel", iLookAndFeel);
        options.put("sLogFileName", sLogFileName);
        options.put("sLastDirectory", sLastDirectory);
        options.put("sEsprocLic", sEsprocLic);
    }

    public static void load() throws Exception {
        try {
            ConfigFile.load();
            for (String key : options.keySet()) {
                Object value = options.get(key);
                ConfigOptions.loadOption(key, value);
            }
            ConfigOptions.applyOptions();
        }
        catch (Exception ex) {
            ConfigFile.newInstance();
        }
    }

    private static void loadOption(String option, Object value) {
        if (!StringUtils.isValidString(value)) {
            return;
        }
        String val = (String)value;
        String type = option.substring(0, 1);
        if (type.equalsIgnoreCase("i")) {
            Integer i = Integer.valueOf(val);
            if (option.equalsIgnoreCase("iLookAndFeel")) {
                iLookAndFeel = new Byte(i.byteValue());
            }
        } else if (type.equalsIgnoreCase("b")) {
            Boolean b = Boolean.valueOf(val);
            if (option.equalsIgnoreCase("bLogException")) {
                bLogException = b;
            } else if (option.equalsIgnoreCase("bWindowSize")) {
                bWindowSize = b;
            } else if (option.equalsIgnoreCase("bAutoOpen")) {
                bAutoOpen = b;
            } else if (option.equalsIgnoreCase("bHoldConsole")) {
                bHoldConsole = b;
            }
        } else if (StringUtils.isValidString(val)) {
            if (option.equalsIgnoreCase("sLogFileName")) {
                sLogFileName = val;
            } else if (option.equalsIgnoreCase("sLastDirectory")) {
                sLastDirectory = val;
            } else if (option.equalsIgnoreCase("sEsprocLic")) {
                sEsprocLic = val;
            }
        }
    }

    public static boolean save() throws Exception {
        ConfigOptions.putOptions();
        ConfigFile.save();
        return ConfigOptions.applyOptions();
    }

    public static boolean applyOptions() {
        return true;
    }
}

