/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.control;

import com.scudata.common.SegmentSet;
import com.scudata.vdb.Library;
import com.scudata.vdb.VDB;

public class ConnectionConfig {
    private String name;
    private String url;
    private int port = 0;
    private String user;
    private String password;
    private boolean reservePassword = true;
    private boolean isConnected = false;
    private Library lib = null;
    private VDB vdb = null;
    private boolean editChanged = false;

    private Library getLibrary() {
        if (this.lib == null) {
            this.lib = new Library(this.url);
            this.lib.start();
        }
        return this.lib;
    }

    public String toString() {
        SegmentSet ss = new SegmentSet();
        ss.put("name", this.name);
        ss.put("url", this.url);
        ss.put("port", String.valueOf(this.port));
        ss.put("user", this.user);
        ss.put("password", this.password);
        ss.put("reservePassword", Boolean.toString(this.reservePassword));
        return ss.toString();
    }

    public static ConnectionConfig fromString(String config) {
        ConnectionConfig cc = new ConnectionConfig();
        SegmentSet ss = new SegmentSet(config);
        cc.name = ss.get("name");
        cc.url = ss.get("url");
        String buf = ss.get("port");
        try {
            cc.port = Integer.parseInt(buf);
        }
        catch (Exception x) {
            return null;
        }
        cc.user = ss.get("user");
        cc.password = ss.get("password");
        buf = ss.get("reservePassword");
        cc.reservePassword = new Boolean(buf);
        return cc;
    }

    public VDB connect() {
        if (!this.isConnected) {
            this.lib = this.getLibrary();
            this.vdb = this.lib.createVDB();
            this.vdb.begin();
        }
        this.isConnected = true;
        return this.vdb;
    }

    public void setEditChanged() {
        this.editChanged = true;
    }

    public boolean isEditChanged() {
        return this.editChanged;
    }

    public boolean commit() throws Exception {
        if (this.vdb != null) {
            int r = this.vdb.commit();
            if (r == 0) {
                this.editChanged = false;
                return true;
            }
            throw new Exception("\u63d0\u4ea4\u6570\u636e\u5e93\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a" + r);
        }
        throw new Exception("\u63d0\u4ea4\u6570\u636e\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5e93\u6ca1\u6709\u542f\u52a8\u3002");
    }

    public void rollback() {
        if (this.vdb != null) {
            this.vdb.rollback();
            this.editChanged = false;
        }
    }

    public void close() {
        if (this.vdb != null) {
            this.vdb.close();
            this.vdb = null;
        }
        if (this.lib != null) {
            this.lib.stop();
            this.lib = null;
        }
        this.isConnected = false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isReservePassword() {
        return this.reservePassword;
    }

    public void setReservePassword(boolean reservePassword) {
        this.reservePassword = reservePassword;
    }
}

