/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.dialog;

import com.scudata.common.StringUtils;
import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.commonvdb.GM;
import com.scudata.ide.vdb.control.ConnectionConfig;
import com.scudata.ide.vdb.dialog.RQDialog;
import com.scudata.ide.vdb.resources.IdeMessage;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogConnection
extends RQDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> existNames;
    private JTextField tfName = new JTextField();
    private JTextField tfUrl = new JTextField();
    private JButton buttonUrl = new JButton();
    private JTextField tfPort = new JTextField();
    private JTextField tfUser = new JTextField();
    private JPasswordField jPassword = new JPasswordField();
    private JCheckBox jCBReservePassword = new JCheckBox("\u8bb0\u4f4f\u5bc6\u7801");

    public DialogConnection(ArrayList<String> existNames) {
        super("\u8fde\u63a5\u4fe1\u606f", 450, 300);
        this.init();
        this.existNames = existNames;
    }

    @Override
    protected boolean okAction(ActionEvent e) {
        String newName = this.tfName.getText().trim();
        if (!StringUtils.isValidString(newName)) {
            JOptionPane.showMessageDialog(VDB.getInstance(), "\u8fde\u63a5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        int n = this.existNames.size();
        int i = 0;
        while (i < n) {
            String name = this.existNames.get(i);
            if (name.equalsIgnoreCase(newName)) {
                JOptionPane.showMessageDialog(VDB.getInstance(), "\u91cd\u590d\u7684\u8fde\u63a5\u540d\u5b57\uff1a" + newName);
                return false;
            }
            ++i;
        }
        return true;
    }

    public ConnectionConfig getConnection() {
        ConnectionConfig cc = new ConnectionConfig();
        cc.setName(this.tfName.getText().trim());
        cc.setUrl(this.tfUrl.getText());
        String buf = this.tfPort.getText();
        if (StringUtils.isValidString(buf)) {
            cc.setPort(Integer.parseInt(buf));
        }
        cc.setUser(this.tfUser.getText());
        if (this.jCBReservePassword.isSelected()) {
            cc.setPassword(new String(this.jPassword.getPassword()));
        }
        return cc;
    }

    public void setConnection(ConnectionConfig cc) {
        this.tfName.setText(cc.getName());
        this.tfUrl.setText(cc.getUrl());
        this.tfPort.setText(String.valueOf(cc.getPort()));
        this.tfUser.setText(cc.getUser());
        this.jPassword.setText(cc.getPassword());
        this.jCBReservePassword.setSelected(cc.isReservePassword());
    }

    private void selectFile(JTextField textField) {
        File f;
        String filePath = textField.getText();
        String lastDir = "";
        String fileName = "";
        if (StringUtils.isValidString(filePath)) {
            f = new File(filePath);
            lastDir = f.getParent();
            fileName = f.getName();
        }
        if ((f = GM.dialogSelectFile("vdb,db", lastDir, null, fileName)) != null) {
            textField.setText(f.getAbsolutePath());
            String name = this.tfName.getText();
            if (!StringUtils.isValidString(name)) {
                name = f.getName();
                int i = name.indexOf(46);
                if (i >= 0) {
                    this.tfName.setText(name.substring(0, i));
                } else {
                    this.tfName.setText(name);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();
        if (this.buttonUrl == c) {
            this.selectFile(this.tfUrl);
        }
    }

    private void init() {
        this.panelCenter.setLayout(new GridBagLayout());
        this.panelCenter.add((Component)new JLabel("\u540d\u79f0"), GM.getGBC(0, 0));
        this.panelCenter.add((Component)this.tfName, GM.getGBC(0, 1, true, false));
        this.panelCenter.add((Component)new JLabel("URL\u6216\u6587\u4ef6\u540d"), GM.getGBC(1, 0));
        JPanel tmp = new JPanel(new GridBagLayout());
        tmp.add((Component)this.tfUrl, GM.getGBC(0, 0, true, false, 0));
        tmp.add((Component)this.buttonUrl, GM.getGBC(0, 1, false, false, 0));
        this.panelCenter.add((Component)tmp, GM.getGBC(1, 1, true, false));
        this.panelCenter.add((Component)new JLabel("\u7aef\u53e3\u53f7"), GM.getGBC(2, 0));
        this.panelCenter.add((Component)this.tfPort, GM.getGBC(2, 1, true, false));
        this.panelCenter.add((Component)new JLabel("\u7528\u6237\u540d"), GM.getGBC(3, 0));
        this.panelCenter.add((Component)this.tfUser, GM.getGBC(3, 1, true, false));
        this.panelCenter.add((Component)new JLabel("\u5bc6\u7801"), GM.getGBC(4, 0));
        this.panelCenter.add((Component)this.jPassword, GM.getGBC(4, 1, true, false));
        this.panelCenter.add((Component)this.jCBReservePassword, GM.getGBC(5, 1, true, false));
        this.panelCenter.add((Component)new JLabel(), GM.getGBC(6, 1, true, true));
        this.buttonUrl.setText(IdeMessage.get().getMessage("public.select"));
        this.buttonUrl.addActionListener(this);
    }
}

