/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.vdb.menu;

import com.scudata.ide.vdb.VDB;
import com.scudata.ide.vdb.VDBTree;
import com.scudata.ide.vdb.control.ConnectionConfig;
import com.scudata.ide.vdb.control.VDBTreeNode;
import com.scudata.ide.vdb.menu.MenuFactory;
import com.scudata.ide.vdb.menu.ToolbarVDB;
import javax.swing.JMenu;

public class MenuVDB
extends MenuFactory {
    private static final long serialVersionUID = 1L;

    public MenuVDB() {
        JMenu menu = this.newMenu((short)0, "connection", 'C', true);
        menu.add(this.newMenuItem((short)5, "conn.new", 'N', Boolean.TRUE, true));
        menu.add(this.newMenuItem((short)10, "conn.open", 'O', Boolean.TRUE, true));
        menu.add(this.newMenuItem((short)15, "conn.save", 'S', Boolean.TRUE, true));
        menu.add(this.newMenuItem((short)20, "conn.close", 'C', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)30, "conn.config", 'G', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)40, "conn.delete", 'D', Boolean.FALSE, false));
        menu.addSeparator();
        menu.add(this.newMenuItem((short)50, "conn.acheive", 'A', Boolean.FALSE, false));
        menu.add(this.newMenuItem((short)60, "conn.purge", 'P', Boolean.FALSE, false));
        menu.addSeparator();
        menu.add(this.newMenuItem((short)99, "conn.exit", 'X', Boolean.FALSE, true));
        this.add(menu);
        menu = this.newMenu((short)200, "node", 'N', true);
        menu.add(this.newMenuItem((short)210, "node.copy", 'C', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)220, "node.paste", 'P', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)230, "node.delete", 'D', Boolean.TRUE, true));
        menu.add(this.newMenuItem((short)240, "node.create", 'T', Boolean.FALSE, true));
        this.add(menu);
        menu = this.newMenu((short)300, "data", 'D', true);
        menu.add(this.newMenuItem((short)320, "data.copy", 'C', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)330, "data.paste", 'P', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)310, "data.save", 'S', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)340, "data.import", 'I', Boolean.FALSE, true));
        this.add(menu);
        menu = this.newMenu((short)400, "tools", 'T', true);
        menu.add(this.newMenuItem((short)450, "tools.option", 'O', Boolean.FALSE, true));
        this.add(menu);
        menu = this.newMenu((short)501, "window", 'W', true);
        menu.add(this.newMenuItem((short)511, "window.cascade", 'C', Boolean.FALSE, true));
        menu.add(this.newMenuItem((short)512, "window.tilehorizontal", 'H', Boolean.FALSE, false));
        menu.add(this.newMenuItem((short)513, "window.tilevertical", 'V', Boolean.FALSE, false));
        menu.add(this.newMenuItem((short)514, "window.layer", 'L', Boolean.FALSE, false));
        this.add(menu);
    }

    public void nodeSelected(VDBTreeNode node) {
        this.disableConnectMenu();
        this.disableNodeMenu();
        ToolbarVDB toolbar = VDB.getInstance().getToolbarVDB();
        toolbar.disableAll();
        if (node.getType() == 0) {
            return;
        }
        if (node.getType() == 1) {
            ConnectionConfig cc = (ConnectionConfig)node.getUserObject();
            this.setMenuEnabled((short)10, !cc.isConnected());
            this.setMenuEnabled((short)15, cc.isEditChanged());
            this.setMenuEnabled((short)20, cc.isConnected());
            this.setMenuEnabled((short)30, !cc.isConnected());
            this.setMenuEnabled((short)40, true);
            this.setMenuEnabled((short)50, true);
            this.setMenuEnabled((short)60, true);
            toolbar.setButtonEnabled((short)10, !cc.isConnected());
            toolbar.setButtonEnabled((short)15, cc.isEditChanged());
            toolbar.setButtonEnabled((short)20, cc.isConnected());
            toolbar.setButtonEnabled((short)30, !cc.isConnected());
            return;
        }
        ConnectionConfig cc = VDBTree.getNodeConnection(node);
        if (cc != null) {
            this.setMenuEnabled((short)15, cc.isEditChanged());
            toolbar.setButtonEnabled((short)15, cc.isEditChanged());
        }
        this.setMenuEnabled((short)210, true);
        this.setMenuEnabled((short)220, true);
        this.setMenuEnabled((short)230, true);
        this.setMenuEnabled((short)240, true);
    }

    public void disableConnectMenu() {
        short[] menuIds = new short[]{10, 20, 30, 40, 50, 60};
        this.setMenuEnabled(menuIds, false);
    }

    public void disableNodeMenu() {
        short[] menuIds = new short[]{210, 220, 230, 240};
        this.setMenuEnabled(menuIds, false);
    }

    public void disableDataMenu() {
        short[] menuIds = new short[]{320, 330, 310, 340};
        this.setMenuEnabled(menuIds, false);
    }
}

