/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ResourceManager;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.GroupmCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.MergesCursor;
import com.scudata.dm.cursor.PJoinCursor;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dw.Cursor;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.PhyTable;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.FunctionLib;
import com.scudata.expression.Gather;
import com.scudata.parallel.Cluster;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.IClusterObject;
import com.scudata.parallel.IIIIIlIlIlIlIIIl;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.IlIIIlIlIlllIlll;
import com.scudata.parallel.RemoteCursor;
import com.scudata.parallel.RemoteCursorProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.TableProxy;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.ThreadPool;
import com.scudata.util.CursorUtil;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterCursor
extends ICursor
implements IClusterObject,
IMultipath {
    private IClusterObject _$9;
    private Cluster _$8;
    private int[] _$7;
    private boolean _$6;
    private int _$5 = 0;
    private Expression _$4;
    private String[] _$3;

    public ClusterCursor(IClusterObject source, int[] cursorProxyIds, boolean isDistributed) {
        this._$9 = source;
        this._$8 = source.getCluster();
        this._$7 = cursorProxyIds;
        this._$6 = isDistributed;
    }

    public ClusterCursor(Cluster cluster, int[] cursorProxyIds, boolean isDistributed) {
        this._$8 = cluster;
        this._$7 = cursorProxyIds;
        this._$6 = isDistributed;
    }

    public boolean isDistributed() {
        return this._$6;
    }

    public IClusterObject getSource() {
        return this._$9;
    }

    @Override
    public Cluster getCluster() {
        return this._$8;
    }

    public int[] getCursorProxyIds() {
        return this._$7;
    }

    public int getCursorProxyId(int unit) {
        return this._$7[unit];
    }

    public Expression getDistribute() {
        return this._$4;
    }

    public void setDistribute(Expression distribute) {
        this._$4 = distribute;
    }

    public String[] getSortedColNames() {
        return this._$3;
    }

    public void setSortedColNames(String[] sortedColNames) {
        this._$3 = sortedColNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence _$1(int current, int n) {
        Cluster cluster = this.getCluster();
        UnitClient client = new UnitClient(cluster.getHost(current), cluster.getPort(current));
        try {
            UnitCommand command = new UnitCommand(31);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[current]));
            command.setAttribute("count", new Integer(n));
            Response response = client.send(command);
            Sequence sequence = (Sequence)response.checkResult();
            return sequence;
        }
        finally {
            client.close();
        }
    }

    public static Response executeFetch(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        Integer count = (Integer)attributes.get("count");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            if (cursor.getCursor() == null) {
                return new Response();
            }
            Sequence result = cursor.getCursor().fetch(count);
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _$1(int cursorProxyId, long n) {
        Cluster cluster = this.getCluster();
        UnitClient client = new UnitClient(cluster.getHost(this._$5), cluster.getPort(this._$5));
        try {
            UnitCommand command = new UnitCommand(32);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[this._$5]));
            command.setAttribute("count", new Long(n));
            Response response = client.send(command);
            Long result = (Long)response.checkResult();
            long l = result;
            return l;
        }
        finally {
            client.close();
        }
    }

    public static Response executeSkip(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        Long count = (Long)attributes.get("count");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            long result = cursor.getCursor().skip(count);
            return new Response(new Long(result));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    @Override
    protected Sequence get(int n) {
        if (this._$5 == -1) {
            return null;
        }
        Sequence result = null;
        if (n == 0x7FFFFFFE) {
            Cluster cluster = this.getCluster();
            int count = cluster.getUnitCount();
            int len = count - this._$5;
            IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[len];
            ThreadPool pool = TaskManager.getPool();
            int i = this._$5;
            int j = 0;
            while (i < count) {
                UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
                UnitCommand command = new UnitCommand(31);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
                command.setAttribute("count", new Integer(n));
                jobs[j] = new IlIIIlIlIlllIlll(client, command);
                pool.submit(jobs[j]);
                ++i;
                ++j;
            }
            for (i = 0; i < len; ++i) {
                jobs[i].join();
                Sequence cur = (Sequence)jobs[i].getResult();
                result = result == null ? cur : ClusterCursor.append(result, cur);
            }
        } else {
            int size = 0;
            while (result == null || size < n) {
                Sequence cur = this._$1(this._$5, n - size);
                if (cur == null || cur.length() == 0) {
                    if (++this._$5 != this._$7.length) continue;
                    this._$5 = -1;
                    break;
                }
                result = result == null ? cur : ClusterCursor.append(result, cur);
                size += cur.length();
            }
        }
        return result;
    }

    @Override
    protected long skipOver(long n) {
        if (this._$5 == -1) {
            return 0L;
        }
        long size = 0L;
        while (size < n) {
            long cur = this._$1(this._$5, n - size);
            if (cur == 0L) {
                if (++this._$5 != this._$7.length) continue;
                this._$5 = -1;
                break;
            }
            size += cur;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(33);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    public static Response executeClose(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            cursor.close();
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operable addOperation(Operation op, Context ctx) {
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        Function function = op.getFunction();
        String functionName = function.getFunctionName();
        String option = function.getOption();
        String param = function.getParamString();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(30);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
                command.setAttribute("functionName", functionName);
                command.setAttribute("option", option);
                command.setAttribute("param", param);
                IIlllIlIIIIIlllI.setParams(command, function, ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeAddOperation(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String functionName = (String)attributes.get("functionName");
        String option = (String)attributes.get("option");
        String param = (String)attributes.get("param");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes, functionName, option);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            FunctionLib.executeMemberFunction(cursor.getCursor(), functionName, param, option, ctx);
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public Object groups(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int groupCount, String[] newNames, Expression[] newExps) {
        int i;
        int i2;
        boolean copt = opt != null && opt.indexOf(99) != -1;
        int dcount = 0;
        int mcount = 0;
        if (exps != null) {
            dcount = exps.length;
            if (names == null) {
                names = new String[dcount];
            }
            for (i2 = 0; i2 < dcount; ++i2) {
                if (names[i2] != null && names[i2].length() != 0) continue;
                names[i2] = exps[i2].getFieldName();
            }
        }
        if (calcExps != null) {
            mcount = calcExps.length;
            if (calcNames == null) {
                calcNames = new String[mcount];
            }
            for (i2 = 0; i2 < mcount; ++i2) {
                if (calcNames[i2] != null && calcNames[i2].length() != 0) continue;
                calcNames[i2] = calcExps[i2].getFieldName();
            }
        }
        String[] dexps = null;
        String[] mexps = null;
        Expression[] totalExps = new Expression[dcount + mcount];
        if (dcount > 0) {
            dexps = new String[dcount];
            for (i = 0; i < dcount; ++i) {
                dexps[i] = exps[i].toString();
                totalExps[i] = exps[i];
            }
        }
        if (mcount > 0) {
            mexps = new String[mcount];
            for (i = 0; i < mcount; ++i) {
                mexps[i] = calcExps[i].toString();
                totalExps[i + dcount] = calcExps[i];
            }
        }
        String[] newExpStrs = null;
        if (copt && newNames != null) {
            int count = newExps.length;
            newExpStrs = new String[count];
            for (int i3 = 0; i3 < count; ++i3) {
                newExpStrs[i3] = newExps[i3].toString();
            }
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[count];
        ThreadPool pool = TaskManager.getPool();
        for (int i4 = 0; i4 < count; ++i4) {
            UnitClient client = new UnitClient(cluster.getHost(i4), cluster.getPort(i4));
            UnitCommand command = new UnitCommand(40);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[i4]));
            command.setAttribute("dexps", dexps);
            command.setAttribute("names", names);
            command.setAttribute("mexps", mexps);
            command.setAttribute("calcNames", calcNames);
            command.setAttribute("option", opt);
            command.setAttribute("groupCount", groupCount);
            if (copt) {
                command.setAttribute("newNames", newNames);
                command.setAttribute("newExpStrs", newExpStrs);
            }
            IIlllIlIIIIIlllI.setParams(command, totalExps, ctx);
            jobs[i4] = new IlIIIlIlIlllIlll(client, command);
            pool.submit(jobs[i4]);
        }
        if (copt) {
            IIIIIlIlIlIlIIIl[] tables = new IIIIIlIlIlIlIIIl[count];
            for (int i5 = 0; i5 < count; ++i5) {
                jobs[i5].join();
                tables[i5] = (IIIIIlIlIlIlIIIl)jobs[i5].getResult();
            }
            return new ClusterMemoryTable(cluster, tables, true);
        }
        Sequence result = new Sequence();
        for (int i6 = 0; i6 < count; ++i6) {
            jobs[i6].join();
            result.addAll((Sequence)jobs[i6].getResult());
        }
        if (opt != null && opt.indexOf(111) != -1) {
            if (newNames != null) {
                int groupFieldCount = 0;
                if (opt == null || opt.indexOf(98) == -1) {
                    groupFieldCount = dcount;
                }
                return ClusterCursor._$1(result, newNames, newExps, ctx, groupFieldCount);
            }
            return result.derive("o");
        }
        Expression[] exps2 = null;
        if (dcount > 0) {
            exps2 = new Expression[dcount];
            int i7 = 0;
            int q = 1;
            while (i7 < dcount) {
                exps2[i7] = new Expression(ctx, "#" + q);
                ++i7;
                ++q;
            }
        }
        Expression[] calcExps2 = null;
        if (mcount > 0) {
            calcExps2 = new Expression[mcount];
            int i8 = 0;
            int q = dcount + 1;
            while (i8 < mcount) {
                Gather gather = (Gather)calcExps[i8].getHome();
                gather.prepare(ctx);
                calcExps2[i8] = gather.getRegatherExpression(q);
                ++i8;
                ++q;
            }
        }
        Table table = result.groups(exps2, names, calcExps2, calcNames, opt, ctx);
        if (newNames != null) {
            int groupFieldCount = 0;
            if (opt == null || opt.indexOf(98) == -1) {
                groupFieldCount = dcount;
            }
            table = ClusterCursor._$1(table, newNames, newExps, ctx, groupFieldCount);
        }
        if (opt == null || opt.indexOf(100) == -1) {
            return table;
        }
        return ClusterMemoryTable.dupLocal(cluster, table);
    }

    private static Table _$1(Sequence result, String[] newNames, Expression[] newExps, Context ctx, int groupFieldCount) {
        Table table = result.newTable(newNames, newExps, ctx);
        if (groupFieldCount > 0) {
            String[] pk = new String[groupFieldCount];
            for (int i = 1; i <= groupFieldCount; ++i) {
                pk[i - 1] = "#" + i;
            }
            table.setPrimary(pk);
        }
        return table;
    }

    public static Response executeGroups(HashMap<String, Object> attributes) {
        int i;
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String[] dexps = (String[])attributes.get("dexps");
        String[] names = (String[])attributes.get("names");
        String[] mexps = (String[])attributes.get("mexps");
        String[] calcNames = (String[])attributes.get("calcNames");
        String opt = (String)attributes.get("option");
        Integer groupCount = (Integer)attributes.get("groupCount");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        boolean copt = opt != null && opt.indexOf(99) != -1;
        String[] newNames = null;
        String[] newExpStrs = null;
        Expression[] newExps = null;
        if (copt) {
            newNames = (String[])attributes.get("newNames");
            newExpStrs = (String[])attributes.get("newExpStrs");
            if (newExpStrs != null) {
                int count = newExpStrs.length;
                newExps = new Expression[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    newExps[i2] = new Expression(ctx, newExpStrs[i2]);
                }
            }
        }
        Expression[] exps = null;
        Expression[] calcExps = null;
        if (dexps != null) {
            int dcount = dexps.length;
            exps = new Expression[dcount];
            for (i = 0; i < dcount; ++i) {
                exps[i] = new Expression(ctx, dexps[i]);
            }
        }
        if (mexps != null) {
            int mcount = mexps.length;
            calcExps = new Expression[mcount];
            for (i = 0; i < mcount; ++i) {
                calcExps[i] = new Expression(ctx, mexps[i]);
            }
        }
        try {
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor cs = cursor.getCursor();
            Table result = null;
            if (cs != null) {
                result = cs.groups(exps, names, calcExps, calcNames, opt, ctx, groupCount);
            }
            if (copt) {
                if (newNames != null) {
                    int groupFieldCount = 0;
                    if ((opt == null || opt.indexOf(98) == -1) && exps != null) {
                        groupFieldCount = exps.length;
                    }
                    result = ClusterCursor._$1(result, newNames, newExps, ctx, groupFieldCount);
                }
                result = new MemoryTable(result);
                TableProxy proxy = new TableProxy(result, cursor.getUnit());
                rm.addProxy(proxy);
                IIIIIlIlIlIlIIIl rmt = ClusterMemoryTable.newRemoteMemoryTable(proxy.getProxyId(), result);
                return new Response(rmt);
            }
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static Response executeTotal(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String[] expStrs = (String[])attributes.get("expStrs");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        Expression[] calcExps = null;
        int valCount = expStrs.length;
        calcExps = new Expression[valCount];
        for (int i = 0; i < valCount; ++i) {
            calcExps[i] = new Expression(ctx, expStrs[i]);
        }
        try {
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor cs = cursor.getCursor();
            Object result = null;
            if (cs != null) {
                result = cs.total(calcExps, ctx);
            }
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public ClusterMemoryTable memory(String[] fields, Context ctx) {
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[count];
        ThreadPool pool = TaskManager.getPool();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            UnitCommand command = new UnitCommand(11);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
            command.setAttribute("fields", fields);
            jobs[i] = new IlIIIlIlIlllIlll(client, command);
            pool.submit(jobs[i]);
        }
        IIIIIlIlIlIlIIIl[] tables = new IIIIIlIlIlIlIIIl[count];
        for (int i = 0; i < count; ++i) {
            jobs[i].join();
            tables[i] = (IIIIIlIlIlIlIIIl)jobs[i].getResult();
        }
        ClusterMemoryTable result = new ClusterMemoryTable(this.getCluster(), tables, this._$6);
        result.setDistribute(this._$4);
        result.setSortedColNames(this._$3);
        return result;
    }

    public static Response executeMemory(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String[] fields = (String[])attributes.get("fields");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        try {
            PhyTable tmd;
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor cs = cursor.getCursor();
            Sequence seq = cs.fetch();
            Table table = seq instanceof Table ? (Table)seq : seq.derive("o");
            MemoryTable memoryTable = new MemoryTable(table);
            if (fields != null) {
                memoryTable.setPrimary(fields);
            }
            if ((tmd = CursorUtil.getTableMetaData(cs)) != null) {
                String distribute = tmd.getDistribute();
                Integer partition = tmd.getGroupTable().getPartition();
                if (partition != null) {
                    memoryTable.setDistribute(distribute);
                    memoryTable.setPart(partition);
                }
            }
            TableProxy proxy = new TableProxy(memoryTable, cursor.getUnit());
            rm.addProxy(proxy);
            IIIIIlIlIlIlIIIl rmt = ClusterMemoryTable.newRemoteMemoryTable(proxy.getProxyId(), memoryTable);
            return new Response(rmt);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    @Override
    public ICursor groupx(Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, String opt, Context ctx, int capacity) {
        Integer id;
        int i;
        int i2;
        int dcount = 0;
        int mcount = 0;
        if (exps != null) {
            dcount = exps.length;
            if (names == null) {
                names = new String[dcount];
            }
            for (i2 = 0; i2 < dcount; ++i2) {
                if (names[i2] != null && names[i2].length() != 0) continue;
                names[i2] = exps[i2].getFieldName();
            }
        }
        if (calcExps != null) {
            mcount = calcExps.length;
            if (calcNames == null) {
                calcNames = new String[mcount];
            }
            for (i2 = 0; i2 < mcount; ++i2) {
                if (calcNames[i2] != null && calcNames[i2].length() != 0) continue;
                calcNames[i2] = calcExps[i2].getFieldName();
            }
        }
        String[] dexps = null;
        String[] mexps = null;
        Expression[] totalExps = new Expression[dcount + mcount];
        if (dcount > 0) {
            dexps = new String[dcount];
            for (i = 0; i < dcount; ++i) {
                dexps[i] = exps[i].toString();
                totalExps[i] = exps[i];
            }
        }
        if (mcount > 0) {
            mexps = new String[mcount];
            for (i = 0; i < mcount; ++i) {
                mexps[i] = calcExps[i].toString();
                totalExps[i + dcount] = calcExps[i];
            }
        }
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[count];
        ThreadPool pool = TaskManager.getPool();
        for (int i3 = 0; i3 < count; ++i3) {
            UnitClient client = new UnitClient(cluster.getHost(i3), cluster.getPort(i3));
            UnitCommand command = new UnitCommand(43);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[i3]));
            command.setAttribute("dexps", dexps);
            command.setAttribute("names", names);
            command.setAttribute("mexps", mexps);
            command.setAttribute("calcNames", calcNames);
            command.setAttribute("option", opt);
            command.setAttribute("capacity", new Integer(capacity));
            IIlllIlIIIIIlllI.setParams(command, totalExps, ctx);
            jobs[i3] = new IlIIIlIlIlllIlll(client, command);
            pool.submit(jobs[i3]);
        }
        if (opt != null && opt.indexOf(99) != -1) {
            int[] cursorProxyIds = new int[count];
            for (int i4 = 0; i4 < count; ++i4) {
                jobs[i4].join();
                id = (Integer)jobs[i4].getResult();
                cursorProxyIds[i4] = id;
            }
            return new ClusterCursor(this, cursorProxyIds, true);
        }
        ICursor[] cursors = new ICursor[count];
        for (int i5 = 0; i5 < count; ++i5) {
            jobs[i5].join();
            id = (Integer)jobs[i5].getResult();
            cursors[i5] = new RemoteCursor(cluster.getHost(i5), cluster.getPort(i5), id);
        }
        Expression[] exps2 = null;
        if (dcount > 0) {
            exps2 = new Expression[dcount];
            int i6 = 0;
            int q = 1;
            while (i6 < dcount) {
                exps2[i6] = new Expression(ctx, "#" + q);
                ++i6;
                ++q;
            }
        }
        Expression[] calcExps2 = null;
        if (mcount > 0) {
            calcExps2 = new Expression[mcount];
            int i7 = 0;
            int q = dcount + 1;
            while (i7 < mcount) {
                Gather gather = (Gather)calcExps[i7].getHome();
                gather.prepare(ctx);
                calcExps2[i7] = gather.getRegatherExpression(q);
                ++i7;
                ++q;
            }
        }
        MergesCursor mc = new MergesCursor(cursors, exps2, ctx);
        return new GroupmCursor(mc, exps2, names, calcExps2, calcNames, ctx);
    }

    public static Response executeGroupx(HashMap<String, Object> attributes) {
        int i;
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String[] dexps = (String[])attributes.get("dexps");
        String[] names = (String[])attributes.get("names");
        String[] mexps = (String[])attributes.get("mexps");
        String[] calcNames = (String[])attributes.get("calcNames");
        String opt = (String)attributes.get("option");
        Integer capacity = (Integer)attributes.get("capacity");
        Expression[] exps = null;
        Expression[] calcExps = null;
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        if (dexps != null) {
            int dcount = dexps.length;
            exps = new Expression[dcount];
            for (i = 0; i < dcount; ++i) {
                exps[i] = new Expression(ctx, dexps[i]);
            }
        }
        if (mexps != null) {
            int mcount = mexps.length;
            calcExps = new Expression[mcount];
            for (i = 0; i < mcount; ++i) {
                calcExps[i] = new Expression(ctx, mexps[i]);
            }
        }
        try {
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor result = cursor.getCursor().groupx(exps, names, calcExps, calcNames, opt, ctx, capacity);
            if (opt == null || opt.indexOf(99) == -1) {
                RemoteCursorProxy rcp = new RemoteCursorProxy(result);
                return new Response(new Integer(rcp._$2()));
            }
            CursorProxy proxy = new CursorProxy(result, cursor.getUnit());
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    @Override
    public ICursor sortx(Expression[] exps, Context ctx, int capacity, String opt) {
        int i;
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        IlIIIlIlIlllIlll[] jobs = new IlIIIlIlIlllIlll[count];
        ThreadPool pool = TaskManager.getPool();
        int fcount = exps.length;
        String[] fields = new String[fcount];
        for (i = 0; i < fcount; ++i) {
            fields[i] = exps[i].toString();
        }
        for (i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            UnitCommand command = new UnitCommand(42);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
            command.setAttribute("fields", fields);
            command.setAttribute("capacity", new Integer(capacity));
            command.setAttribute("opt", opt);
            IIlllIlIIIIIlllI.setParams(command, exps, ctx);
            jobs[i] = new IlIIIlIlIlllIlll(client, command);
            pool.submit(jobs[i]);
        }
        ICursor[] cursors = new ICursor[count];
        for (int i2 = 0; i2 < count; ++i2) {
            jobs[i2].join();
            Integer id = (Integer)jobs[i2].getResult();
            cursors[i2] = new RemoteCursor(cluster.getHost(i2), cluster.getPort(i2), id);
        }
        return new MergesCursor(cursors, exps, ctx);
    }

    public static Response executeSortx(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        String[] fields = (String[])attributes.get("fields");
        Integer capacity = (Integer)attributes.get("capacity");
        String opt = (String)attributes.get("opt");
        Expression[] exps = null;
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
        int fcount = fields.length;
        exps = new Expression[fcount];
        for (int i = 0; i < fcount; ++i) {
            exps[i] = new Expression(ctx, fields[i]);
        }
        try {
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor result = CursorUtil.sortx(cursor.getCursor(), exps, ctx, capacity, opt);
            RemoteCursorProxy rcp = new RemoteCursorProxy(result);
            return new Response(new Integer(rcp._$2()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[][] _$1(int dimCount) {
        int count = this._$8.getUnitCount();
        Object[][] minValues = new Object[count][];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(this._$8.getHost(i), this._$8.getPort(i));
            try {
                UnitCommand command = new UnitCommand(34);
                command.setAttribute("jobSpaceId", this._$8.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
                command.setAttribute("dimCount", new Integer(dimCount));
                Response response = client.send(command);
                minValues[i] = (Object[])response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return minValues;
    }

    public static Response executeGetMinValues(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        int cursorProxyId = (Integer)attributes.get("cursorProxyId");
        int dimCount = (Integer)attributes.get("dimCount");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        try {
            ResourceManager rm = js.getResourceManager();
            CursorProxy cp = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor cs = cp.getCursor();
            if (cs instanceof IMultipath) {
                ICursor[] cursors = ((IMultipath)((Object)cs)).getParallelCursors();
                cs = cursors[0];
            }
            if (!(cs instanceof Cursor)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
            }
            Cursor cursor = (Cursor)cs;
            PhyTable table = cursor.getTableMetaData();
            String[] names = table.getSortedColNames();
            if (names == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.needMCursor"));
            }
            if (dimCount < 1) {
                dimCount = names.length;
            } else if (names.length < dimCount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
            }
            Sequence seq = cursor.peek(1);
            if (seq == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("dw.needMCursor"));
            }
            BaseRecord r = (BaseRecord)seq.get(1);
            Object[] vals = new Object[dimCount];
            for (int f = 0; f < dimCount; ++f) {
                vals[f] = r.getFieldValue(names[f]);
            }
            return new Response(vals);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static ClusterCursor joinx(ClusterCursor[] cursors, Expression[][] exps, String[] names, String opt, Context ctx) {
        int csCount = cursors.length;
        Cluster cluster = cursors[0].getCluster();
        for (int i = 1; i < csCount; ++i) {
            Cluster tmp = cursors[i].getCluster();
            if (cluster.isEquals(tmp)) continue;
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.clusterCSNotMatch"));
        }
        int unitCount = cluster.getUnitCount();
        String[] expStrs = null;
        Expression[] totalExps = null;
        if (opt == null || opt.indexOf(112) == -1) {
            int fieldCount = exps[0].length;
            int totalCount = csCount * fieldCount;
            expStrs = new String[totalCount];
            totalExps = new Expression[totalCount];
            int q = 0;
            for (int i = 0; i < csCount; ++i) {
                Expression[] tmp = exps[i];
                int f = 0;
                while (f < fieldCount) {
                    expStrs[q] = tmp[f].toString();
                    totalExps[q] = tmp[f];
                    ++f;
                    ++q;
                }
            }
        }
        int[] newCursorProxyIds = new int[csCount];
        for (int i = 0; i < unitCount; ++i) {
            int[] cursorProxyIds = new int[csCount];
            for (int j = 0; j < csCount; ++j) {
                cursorProxyIds[j] = cursors[j].getCursorProxyId(i);
            }
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            UnitCommand command = new UnitCommand(41);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("cursorProxyIds", cursorProxyIds);
            command.setAttribute("expStrs", expStrs);
            command.setAttribute("names", names);
            command.setAttribute("option", opt);
            command.setAttribute("unit", new Integer(i));
            if (totalExps != null) {
                IIlllIlIIIIIlllI.setParams(command, totalExps, ctx);
            }
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            newCursorProxyIds[i] = id;
        }
        return new ClusterCursor(cluster, newCursorProxyIds, true);
    }

    public static Response executeJoinx(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        int[] cursorProxyIds = (int[])attributes.get("cursorProxyIds");
        String[] expStrs = (String[])attributes.get("expStrs");
        String[] names = (String[])attributes.get("names");
        String opt = (String)attributes.get("option");
        Integer unit = (Integer)attributes.get("unit");
        try {
            ICursor join;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            int csCount = cursorProxyIds.length;
            ICursor[] cursors = new ICursor[csCount];
            ResourceManager rm = js.getResourceManager();
            if (expStrs == null) {
                for (int i = 0; i < csCount; ++i) {
                    CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyIds[i]);
                    cursors[i] = cursor.getCursor();
                }
                join = new PJoinCursor(cursors, names);
            } else {
                int totalCount = expStrs.length;
                int fieldCount = totalCount / csCount;
                Expression[][] exps = new Expression[csCount][];
                int q = 0;
                for (int i = 0; i < csCount; ++i) {
                    CursorProxy cursor = (CursorProxy)rm.getProxy(cursorProxyIds[i]);
                    cursors[i] = cursor.getCursor();
                    exps[i] = new Expression[fieldCount];
                    int f = 0;
                    while (f < fieldCount) {
                        exps[i][f] = new Expression(ctx, expStrs[q]);
                        ++f;
                        ++q;
                    }
                }
                join = CursorUtil.joinx(cursors, names, exps, opt, ctx);
            }
            CursorProxy proxy = new CursorProxy(join, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    @Override
    public int getPathCount() {
        return this._$7.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICursor[] getParallelCursors() {
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        ICursor[] cursors = new ICursor[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(35);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("cursorProxyId", new Integer(this._$7[i]));
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                cursors[i] = new RemoteCursor(cluster.getHost(i), cluster.getPort(i), id);
                continue;
            }
            finally {
                client.close();
            }
        }
        return cursors;
    }

    public static Response executeGetParallelCursors(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer cursorProxyId = (Integer)attributes.get("cursorProxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            CursorProxy cursorProxy = (CursorProxy)rm.getProxy(cursorProxyId);
            ICursor cursor = cursorProxy.getCursor();
            RemoteCursorProxy rcp = new RemoteCursorProxy(cursor);
            return new Response(new Integer(rcp._$2()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }
}

