/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.IResource;
import com.scudata.dm.IndexTable;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.ListBase1;
import com.scudata.dm.Record;
import com.scudata.dm.ResourceManager;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.op.New;
import com.scudata.dm.op.Operable;
import com.scudata.dm.op.Operation;
import com.scudata.dm.op.Select;
import com.scudata.dw.MemoryTable;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.FunctionLib;
import com.scudata.parallel.Cluster;
import com.scudata.parallel.ClusterCursor;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.IClusterObject;
import com.scudata.parallel.IIIIIlIlIlIlIIIl;
import com.scudata.parallel.IIlllIlIIIIIlllI;
import com.scudata.parallel.IlIllllllIIIllII;
import com.scudata.parallel.Response;
import com.scudata.parallel.TableProxy;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.parallel.lIlllllllIIIllII;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterMemoryTable
extends Operable
implements IClusterObject,
IResource,
Externalizable {
    private static final long serialVersionUID = 117527555L;
    private Cluster _$9;
    private IIIIIlIlIlIlIIIl[] _$8;
    private boolean _$7;
    private Expression _$6;
    private String[] _$5;
    private DataStruct _$4;
    private IIIIIlIlIlIlIIIl[] _$3;
    private int _$2;
    private int[] _$1;

    public ClusterMemoryTable() {
    }

    public ClusterMemoryTable(Cluster cluster, IIIIIlIlIlIlIIIl[] tables, boolean isDistributed) {
        this._$9 = cluster;
        this._$8 = tables;
        this._$7 = isDistributed;
    }

    private void _$1(Context ctx) {
        String str;
        if (this._$3 != null) {
            return;
        }
        IIIIIlIlIlIlIIIl[] tables = this._$8;
        if (this._$6 == null && (str = tables[0].getDistribute()) != null && str.length() > 0) {
            this._$6 = new Expression(str);
        }
        if (this._$6 != null) {
            for (IIIIIlIlIlIlIIIl table : tables) {
                if (table.getPart() >= 1) continue;
                this._$6 = null;
                break;
            }
        }
        int count = tables.length;
        this._$3 = new IIIIIlIlIlIlIIIl[count];
        System.arraycopy(tables, 0, this._$3, 0, count);
        if (this._$6 == null) {
            lIlllllllIIIllII cmp = new lIlllllllIIIllII(this);
            Arrays.sort(this._$3, cmp);
        } else {
            int i;
            IlIllllllIIIllII cmp = new IlIllllllIIIllII(this);
            Arrays.sort(this._$3, cmp);
            this._$2 = this._$3[count - 1].getPart();
            this._$1 = new int[this._$2 + 1];
            for (i = 0; i < this._$2; ++i) {
                this._$1[i] = -1;
            }
            for (i = 0; i < count; ++i) {
                this._$1[this._$3[i].getPart()] = i;
            }
            if (this._$5 != null) {
                this._$4 = new DataStruct(this._$5);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                this._$6.getUsedFields(ctx, list);
                if (list.size() != 0) {
                    String[] names = new String[list.size()];
                    list.toArray(names);
                    this._$4 = new DataStruct(names);
                }
            }
        }
    }

    public boolean isDistributed() {
        return this._$7;
    }

    public Expression getDistribute() {
        return this._$6;
    }

    public void setDistribute(Expression distribute) {
        this._$6 = distribute;
    }

    public String[] getSortedColNames() {
        return this._$5;
    }

    public void setSortedColNames(String[] sortedColNames) {
        this._$5 = sortedColNames;
    }

    public int getProxyId(int seq) {
        return this._$8[seq].getProxyId();
    }

    public int[] getProxyIds() {
        int len = this._$8.length;
        int[] ids = new int[len];
        for (int i = 0; i < len; ++i) {
            ids[i] = this._$8[i].getProxyId();
        }
        return ids;
    }

    public int getCurrentClusterProxyId() {
        HostManager hm = HostManager.instance();
        String host = hm.getHost();
        int port = hm.getPort();
        int count = this._$9.getUnitCount();
        for (int i = 0; i < count; ++i) {
            if (!this._$9.getHost(i).equals(host) || this._$9.getPort(i) != port) continue;
            return this._$8[i].getProxyId();
        }
        return -1;
    }

    @Override
    public Cluster getCluster() {
        return this._$9;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._$9);
        out.writeObject(this._$8);
        out.writeBoolean(this._$7);
        String exp = null;
        if (this._$6 != null) {
            exp = this._$6.toString();
        }
        out.writeObject(exp);
        out.writeObject(this._$5);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._$9 = (Cluster)in.readObject();
        this._$8 = (IIIIIlIlIlIlIIIl[])in.readObject();
        this._$7 = in.readBoolean();
        String exp = (String)in.readObject();
        if (exp != null) {
            this._$6 = new Expression(exp);
        }
        this._$5 = (String[])in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRecord getRow(Object key) {
        BaseRecord r = null;
        Cluster cluster = this._$9;
        int count = cluster.getUnitCount();
        if (!this._$7) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(14);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", this.getProxyId(i));
                command.setAttribute("key", key);
                Response response = client.send(command);
                r = (BaseRecord)response.checkResult();
                if (r == null) continue;
                break;
            }
            finally {
                client.close();
            }
        }
        return r;
    }

    public static Response executeGetRow(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        Object key = attributes.get("key");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            TableProxy table = (TableProxy)rm.getProxy(proxyId);
            return new Response(table.getRow(key, null));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(Integer capacity, String opt) {
        Cluster cluster = this._$9;
        int count = cluster.getUnitCount();
        boolean result = true;
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(13);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", this.getProxyId(i));
                command.setAttribute("capacity", capacity);
                command.setAttribute("opt", opt);
                Response response = client.send(command);
                result &= ((Boolean)response.checkResult()).booleanValue();
                continue;
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    public static Response executeCreateIndex(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        Integer capacity = (Integer)attributes.get("capacity");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            TableProxy table = (TableProxy)rm.getProxy(proxyId);
            table.createIndex(capacity, opt);
            return new Response(Boolean.TRUE);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table dup() {
        Cluster cluster = this._$9;
        int count = cluster.getUnitCount();
        if (!this._$7) {
            count = 1;
        }
        Table mt = null;
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(15);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", this.getProxyId(i));
                Response response = client.send(command);
                Table cur = (Table)response.checkResult();
                if (mt != null) {
                    mt.append(cur, null);
                    continue;
                }
                mt = cur;
                continue;
            }
            finally {
                client.close();
            }
        }
        return mt;
    }

    public static Response executeDup(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            TableProxy table = (TableProxy)rm.getProxy(proxyId);
            return new Response(table.getTable());
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterMemoryTable dupLocal(Cluster cluster, Table table) {
        int count = cluster.getUnitCount();
        IIIIIlIlIlIlIIIl[] tables = new IIIIIlIlIlIlIIIl[count];
        int recordCount = table.length();
        int[] seqs = table.dataStruct().getPKIndex();
        int keyCount = seqs == null ? 0 : seqs.length;
        Object keyValue = null;
        if (keyCount == 1) {
            if (recordCount > 0) {
                BaseRecord r = table.getRecord(1);
                keyValue = r.getNormalFieldValue(seqs[0]);
            }
        } else if (keyCount > 1) {
            Object[] vals;
            keyValue = vals = new Object[keyCount];
            if (recordCount > 0) {
                BaseRecord r = table.getRecord(1);
                for (int i = 0; i < keyCount; ++i) {
                    vals[i] = r.getNormalFieldValue(seqs[i]);
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            String host = cluster.getHost(i);
            int port = cluster.getPort(i);
            UnitClient client = new UnitClient(host, port);
            try {
                UnitCommand command = new UnitCommand(16);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("table", table);
                command.setAttribute("unit", new Integer(i));
                Response response = client.send(command);
                Integer proxyId = (Integer)response.checkResult();
                tables[i] = new IIIIIlIlIlIlIIIl(host, port, proxyId, recordCount);
                if (keyCount > 0) {
                    tables[i].setStartKeyValue(keyValue, keyCount);
                }
                if (!(table instanceof MemoryTable)) continue;
                MemoryTable mt = (MemoryTable)table;
                tables[i].setDistribute(mt.getDistribute(), mt.getPart());
                continue;
            }
            finally {
                client.close();
            }
        }
        return new ClusterMemoryTable(cluster, tables, false);
    }

    public static Response executeDupLocal(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Table table = (Table)attributes.get("table");
        Integer unit = (Integer)attributes.get("unit");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            TableProxy proxy = new TableProxy(table, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCursor cursor(Expression[] exps, String[] names, Expression filter, int segCount, String opt, Context ctx) {
        Cluster cluster = this._$9;
        int count = cluster.getUnitCount();
        int[] cursorProxyIds = new int[count];
        boolean isSeg = !this._$7;
        String[] fieldExps = null;
        if (exps != null) {
            int fcount = exps.length;
            fieldExps = new String[fcount];
            for (int i = 0; i < fcount; ++i) {
                fieldExps[i] = exps[i].toString();
            }
        }
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(24);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", this.getProxyId(i));
                command.setAttribute("fieldExps", fieldExps);
                command.setAttribute("names", names);
                command.setAttribute("filter", filter == null ? null : filter.toString());
                command.setAttribute("option", opt);
                command.setAttribute("unit", new Integer(i));
                command.setAttribute("unitCount", new Integer(count));
                command.setAttribute("isSeg", isSeg);
                command.setAttribute("segCount", new Integer(segCount));
                IIlllIlIIIIIlllI.setParams(command, exps, ctx);
                Response response = client.send(command);
                Integer id = (Integer)response.checkResult();
                cursorProxyIds[i] = id;
                continue;
            }
            finally {
                client.close();
            }
        }
        ClusterCursor result = new ClusterCursor(this, cursorProxyIds, this._$7);
        result.setDistribute(this._$6);
        result.setSortedColNames(this._$5);
        return result;
    }

    public static Response executeCreateCursor(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        String[] fieldExps = (String[])attributes.get("fieldExps");
        String[] names = (String[])attributes.get("names");
        String filter = (String)attributes.get("filter");
        String option = (String)attributes.get("option");
        Integer unit = (Integer)attributes.get("unit");
        int unitCount = (Integer)attributes.get("unitCount");
        boolean isSeg = (Boolean)attributes.get("isSeg");
        int segCount = (Integer)attributes.get("segCount");
        try {
            ICursor cursor;
            int i;
            int blockSize;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes);
            ResourceManager rm = js.getResourceManager();
            TableProxy tp = (TableProxy)rm.getProxy(proxyId);
            Table table = tp.getTable();
            int len = table.length();
            int start = 1;
            int end = len + 1;
            if (isSeg) {
                blockSize = len / unitCount;
                start = blockSize * unit + 1;
                if (unit + 1 != unitCount) {
                    end = blockSize + start;
                }
            }
            if (option != null && option.indexOf(109) != -1) {
                if (segCount < 2) {
                    segCount = Env.getCursorParallelNum();
                }
                len = end - start;
                if (segCount > 1 && segCount < len) {
                    blockSize = len / segCount;
                    ICursor[] cursors = new ICursor[segCount];
                    for (i = 1; i <= segCount; ++i) {
                        int start2 = blockSize * (i - 1) + start;
                        int end2 = i == segCount ? end : start2 + blockSize;
                        cursors[i - 1] = new MemoryCursor(table, start2, end2);
                    }
                    cursor = new MultipathCursors(cursors, ctx);
                } else {
                    cursor = new MemoryCursor(table, start, end);
                }
            } else {
                cursor = new MemoryCursor(table, start, end);
            }
            if (names != null) {
                int fcount = names.length;
                Expression[] exps = new Expression[fcount];
                for (i = 0; i < fcount; ++i) {
                    exps[i] = new Expression(ctx, fieldExps[i]);
                }
                New newOp = new New(exps, names, null);
                cursor.addOperation(newOp, ctx);
            }
            if (filter != null) {
                Expression filterExp = new Expression(ctx, filter);
                Select select = new Select(filterExp, null);
                cursor.addOperation(select, ctx);
            }
            CursorProxy proxy = new CursorProxy(cursor, unit);
            rm.addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public static ClusterMemoryTable memory(Cluster cluster, String varName) {
        int count = cluster.getUnitCount();
        IIIIIlIlIlIlIIIl[] tables = new IIIIIlIlIlIlIIIl[count];
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            UnitCommand command = new UnitCommand(12);
            command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
            command.setAttribute("varName", varName);
            command.setAttribute("unit", new Integer(i));
            Response response = client.send(command);
            tables[i] = (IIIIIlIlIlIlIIIl)response.checkResult();
        }
        Object keyValue1 = tables[0].getStartKeyValue();
        Object keyValue2 = tables[1].getStartKeyValue();
        boolean b = count > 1 && !Variant.isEquals(keyValue1, keyValue2);
        return new ClusterMemoryTable(cluster, tables, b);
    }

    public static Response executeMemory(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String varName = (String)attributes.get("varName");
        Integer unit = (Integer)attributes.get("unit");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = new Context();
        ctx.setJobSpace(js);
        try {
            MemoryTable mt;
            Expression exp = new Expression(ctx, varName);
            Object val = exp.calculate(ctx);
            if (val instanceof MemoryTable) {
                mt = (MemoryTable)val;
            } else if (val instanceof Table) {
                mt = new MemoryTable((Table)val);
            } else if (val instanceof Sequence) {
                Sequence seq = (Sequence)val;
                Table table = seq.derive("o");
                mt = new MemoryTable(table);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("memory" + mm.getMessage("function.paramTypeError"));
            }
            ResourceManager rm = js.getResourceManager();
            TableProxy proxy = new TableProxy(mt, unit);
            rm.addProxy(proxy);
            IIIIIlIlIlIlIIIl rmt = ClusterMemoryTable.newRemoteMemoryTable(proxy.getProxyId(), mt);
            return new Response(rmt);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    private int _$1() {
        return this._$8[0].getKeyCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence[] _$1(Sequence[] keyValues, String[] fieldExps, String[] fieldNames) {
        IIIIIlIlIlIlIIIl[] sortedTables = this._$3;
        int count = sortedTables.length;
        Sequence[] result = new Sequence[count];
        for (int i = 0; i < count; ++i) {
            IIIIIlIlIlIlIIIl rmt = sortedTables[i];
            UnitClient client = new UnitClient(rmt.getHost(), rmt.getPort());
            try {
                UnitCommand command = new UnitCommand(17);
                command.setAttribute("jobSpaceId", this._$9.getJobSpaceId());
                command.setAttribute("proxyId", rmt.getProxyId());
                command.setAttribute("keyValues", keyValues[i]);
                command.setAttribute("fieldExps", fieldExps);
                command.setAttribute("fieldNames", fieldNames);
                Response response = client.send(command);
                result[i] = (Sequence)response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return result;
    }

    public static Response executeGetRows(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        Sequence keyValues = (Sequence)attributes.get("keyValues");
        String[] fieldExps = (String[])attributes.get("fieldExps");
        String[] fieldNames = (String[])attributes.get("fieldNames");
        JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
        Context ctx = IIlllIlIIIIIlllI.createContext(js);
        Expression[] newExps = null;
        if (fieldExps != null) {
            int count = fieldExps.length;
            newExps = new Expression[count];
            for (int i = 0; i < count; ++i) {
                newExps[i] = new Expression(ctx, fieldExps[i]);
            }
        }
        try {
            ResourceManager rm = js.getResourceManager();
            TableProxy tableProxy = (TableProxy)rm.getProxy(proxyId);
            Table table = tableProxy.getTable();
            Sequence result = ClusterMemoryTable._$1(table, keyValues, newExps, fieldNames, ctx);
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Sequence _$1(Table table, Sequence keySeq, Expression[] newExps, String[] newNames, Context ctx) {
        BaseRecord r;
        int i;
        if (keySeq == null || keySeq.length() == 0) {
            return new Sequence(0);
        }
        String[] pkNames = table.getPrimary();
        int pkCount = pkNames.length;
        IndexTable indexTable = table.getIndexTable();
        if (indexTable == null) {
            table.createIndexTable(null);
            indexTable = table.getIndexTable();
        }
        int len = keySeq.length();
        Sequence result = new Sequence(len);
        if (pkCount == 1) {
            for (i = 1; i <= len; ++i) {
                Object pk = keySeq.getMem(i);
                r = (BaseRecord)indexTable.find(pk);
                result.add(r);
            }
        } else {
            for (i = 1; i <= len; ++i) {
                Object[] pks = (Object[])keySeq.getMem(i);
                r = (BaseRecord)indexTable.find(pks);
                result.add(r);
            }
        }
        if (newExps == null || newExps.length == 0) {
            return result;
        }
        IArray mems = result.getMems();
        int colCount = newExps.length;
        DataStruct ds = new DataStruct(newNames);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(result);
        stack.push(current);
        try {
            for (int i2 = 1; i2 <= len; ++i2) {
                if (mems.get(i2) != null) {
                    current.setCurrent(i2);
                    Record r2 = new Record(ds);
                    for (int c = 0; c < colCount; ++c) {
                        r2.setNormalFieldValue(c, newExps[c].calculate(ctx));
                    }
                    mems.set(i2, r2);
                    continue;
                }
                mems.set(i2, null);
            }
        }
        finally {
            stack.pop();
        }
        return result;
    }

    public Sequence getRows(Sequence keySeq, String[] newExps, String[] newNames, Context ctx) {
        Object[] objs;
        int i;
        this._$1(ctx);
        IArray mems = keySeq.getMems();
        int srcLen = mems.size();
        HashUtil hashUtil = new HashUtil(srcLen);
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        Sequence ids = new Sequence(hashUtil.getCapacity());
        int keyCount = this._$1();
        if (keyCount == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        if (keyCount == 1) {
            for (int i2 = 1; i2 <= srcLen; ++i2) {
                Object mem = mems.get(i2);
                int hash = hashUtil.hashCode(mem);
                if (groups[hash] == null) {
                    Object[] objs2 = new Object[2];
                    objs2[0] = mem;
                    ids.add(objs2);
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(objs2);
                    continue;
                }
                int index = HashUtil.bsearch_a(groups[hash], mem);
                if (index >= 1) continue;
                Object[] objs3 = new Object[2];
                objs3[0] = mem;
                ids.add(objs3);
                groups[hash].add(-index, objs3);
            }
        } else {
            int count = keyCount + 1;
            for (int i3 = 1; i3 <= srcLen; ++i3) {
                Object[] mem = (Object[])mems.get(i3);
                int hash = hashUtil.hashCode(mem);
                if (groups[hash] == null) {
                    Object[] objs4 = new Object[count];
                    System.arraycopy(mem, 0, objs4, 0, keyCount);
                    objs4[keyCount] = mem;
                    ids.add(objs4);
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(objs4);
                    continue;
                }
                int index = HashUtil.bsearch_a(groups[hash], mem, keyCount);
                if (index >= 1) continue;
                Object[] objs5 = new Object[count];
                System.arraycopy(mem, 0, objs5, 0, keyCount);
                objs5[keyCount] = mem;
                ids.add(objs5);
                groups[hash].add(-index, objs5);
            }
        }
        Sequence[] seqs = this._$1(ids, ctx);
        int gcount = seqs.length;
        Sequence[] keySeqs = new Sequence[gcount];
        for (int g = 0; g < gcount; ++g) {
            Sequence tmp;
            Sequence seq = seqs[g];
            IArray curMems = seq.getMems();
            int len = curMems.size();
            keySeqs[g] = tmp = new Sequence(len);
            int keyIndex = keyCount == 1 ? 0 : keyCount;
            for (i = 1; i <= len; ++i) {
                objs = (Object[])curMems.get(i);
                tmp.add(objs[keyIndex]);
            }
        }
        Sequence[] tables = this._$1(keySeqs, newExps, newNames);
        for (int g = 0; g < gcount; ++g) {
            Sequence seq = seqs[g];
            IArray curMems = seq.getMems();
            int len = curMems.size();
            Sequence curTable = tables[g];
            for (i = 1; i <= len; ++i) {
                objs = (Object[])curMems.get(i);
                BaseRecord r = (BaseRecord)curTable.get(i);
                objs[keyCount] = r;
            }
        }
        Sequence result = new Sequence(srcLen);
        if (keyCount == 1) {
            for (int i4 = 1; i4 <= srcLen; ++i4) {
                Object mem = mems.get(i4);
                int hash = hashUtil.hashCode(mem);
                int index = HashUtil.bsearch_a(groups[hash], mem);
                Object[] objs6 = (Object[])groups[hash].get(index);
                result.add(objs6[1]);
            }
        } else {
            for (int i5 = 1; i5 <= srcLen; ++i5) {
                Object[] mem = (Object[])mems.get(i5);
                int hash = hashUtil.hashCode(mem);
                int index = HashUtil.bsearch_a(groups[hash], mem, keyCount);
                Object[] objs7 = (Object[])groups[hash].get(index);
                result.add(objs7[keyCount]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence[] _$1(Sequence result, Context ctx) {
        IIIIIlIlIlIlIIIl[] tables = this._$3;
        int groupCount = tables.length;
        if (!this._$7) {
            Sequence[] seqs = new Sequence[groupCount];
            seqs[0] = new Sequence(result);
            for (int i = 1; i < groupCount; ++i) {
                seqs[i] = new Sequence(0);
            }
            return seqs;
        }
        IArray mems = result.getMems();
        int len = mems.size();
        Sequence[] seqs = new Sequence[groupCount];
        int initCount = len / groupCount + 10;
        for (int i = 0; i < groupCount; ++i) {
            seqs[i] = new Sequence(initCount);
        }
        if (this._$4 == null) {
            int keyCount = this._$1();
            int last = groupCount - 1;
            if (keyCount == 1) {
                int i;
                Object[] startVals = new Object[groupCount];
                for (i = 0; i < groupCount; ++i) {
                    startVals[i] = tables[i].getStartKeyValue();
                }
                block6: for (i = 1; i <= len; ++i) {
                    Object[] objs = (Object[])mems.get(i);
                    for (int g = 1; g < groupCount; ++g) {
                        int cmp = Variant.compare(startVals[g], objs[0]);
                        if (cmp > 0) {
                            seqs[g - 1].add(objs);
                            continue block6;
                        }
                        if (cmp != 0) continue;
                        seqs[g].add(objs);
                        continue block6;
                    }
                    seqs[last].add(objs);
                }
            } else {
                int i;
                Object[][] startVals = new Object[groupCount][];
                for (i = 0; i < groupCount; ++i) {
                    startVals[i] = (Object[])tables[i].getStartKeyValue();
                }
                block9: for (i = 1; i <= len; ++i) {
                    Object[] objs = (Object[])mems.get(i);
                    for (int g = 1; g < groupCount; ++g) {
                        int cmp = Variant.compareArrays(startVals[g], objs, keyCount);
                        if (cmp > 0) {
                            seqs[g - 1].add(objs);
                            continue block9;
                        }
                        if (cmp != 0) continue;
                        seqs[g].add(objs);
                        continue block9;
                    }
                    seqs[last].add(objs);
                }
            }
        } else {
            int partCount = this._$2;
            int[] partIndex = this._$1;
            Expression distribute = this._$6;
            int keyCount = this._$4.getFieldCount();
            Record r = new Record(this._$4);
            ComputeStack stack = ctx.getComputeStack();
            stack.push(r);
            try {
                for (int i = 1; i <= len; ++i) {
                    int n;
                    Object[] objs = (Object[])mems.get(i);
                    for (int k = 0; k < keyCount; ++k) {
                        r.setNormalFieldValue(k, objs[k]);
                    }
                    Object obj = distribute.calculate(ctx);
                    if (!(obj instanceof Number) || (n = ((Number)obj).intValue()) <= 0 || n > partCount) continue;
                    seqs[partIndex[n]].add(objs);
                }
            }
            finally {
                stack.pop();
            }
        }
        return seqs;
    }

    public static IIIIIlIlIlIlIIIl newRemoteMemoryTable(int proxy, Table table) {
        int recordCount = table.length();
        int[] seqs = table.dataStruct().getPKIndex();
        int keyCount = seqs == null ? 0 : seqs.length;
        Object keyValue = null;
        if (keyCount == 1) {
            if (recordCount > 0) {
                BaseRecord r = table.getRecord(1);
                keyValue = r.getNormalFieldValue(seqs[0]);
            }
        } else if (keyCount > 1) {
            Object[] vals;
            keyValue = vals = new Object[keyCount];
            if (recordCount > 0) {
                BaseRecord r = table.getRecord(1);
                for (int i = 0; i < keyCount; ++i) {
                    vals[i] = r.getNormalFieldValue(seqs[i]);
                }
            }
        }
        HostManager hm = HostManager.instance();
        String host = hm.getHost();
        int port = hm.getPort();
        IIIIIlIlIlIlIIIl rmt = new IIIIIlIlIlIlIIIl(host, port, proxy, recordCount);
        if (keyCount > 0) {
            rmt.setStartKeyValue(keyValue, keyCount);
        }
        if (table instanceof MemoryTable) {
            MemoryTable mt = (MemoryTable)table;
            rmt.setDistribute(mt.getDistribute(), mt.getPart());
        }
        return rmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operable addOperation(Operation op, Context ctx) {
        Cluster cluster = this.getCluster();
        int count = cluster.getUnitCount();
        Function function = op.getFunction();
        String functionName = function.getFunctionName();
        String option = function.getOption();
        String param = function.getParamString();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(18);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", new Integer(this.getProxyId(i)));
                command.setAttribute("functionName", functionName);
                command.setAttribute("option", option);
                command.setAttribute("param", param);
                IIlllIlIIIIIlllI.setParams(command, function, ctx);
                Response response = client.send(command);
                response.checkResult();
                continue;
            }
            finally {
                client.close();
            }
        }
        return this;
    }

    public static Response executeAddOperation(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        String functionName = (String)attributes.get("functionName");
        String option = (String)attributes.get("option");
        String param = (String)attributes.get("param");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = IIlllIlIIIIIlllI.createContext(js, attributes, functionName, option);
            ResourceManager rm = js.getResourceManager();
            TableProxy table = (TableProxy)rm.getProxy(proxyId);
            Object obj = FunctionLib.executeMemberFunction(table.getTable(), functionName, param, option, ctx);
            if (obj instanceof Table) {
                table.setTable((Table)obj);
            }
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Cluster cluster = this._$9;
        int count = cluster.getUnitCount();
        for (int i = 0; i < count; ++i) {
            UnitClient client = new UnitClient(cluster.getHost(i), cluster.getPort(i));
            try {
                UnitCommand command = new UnitCommand(19);
                command.setAttribute("jobSpaceId", cluster.getJobSpaceId());
                command.setAttribute("proxyId", this.getProxyId(i));
                client.send(command);
                continue;
            }
            finally {
                client.close();
            }
        }
    }

    public static Response executeClose(HashMap<String, Object> attributes) {
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        Integer proxyId = (Integer)attributes.get("proxyId");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            ResourceManager rm = js.getResourceManager();
            boolean b = rm.closeProxy(proxyId);
            return new Response(b);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }
}

