/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.cellset.INormalCell;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.LocalFile;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.ResourceManager;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.parallel.Response;
import com.scudata.parallel.TableProxy;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class ClusterUtil {
    ClusterUtil() {
    }

    public static Context createContext(JobSpace js) {
        Context ctx = new Context();
        ctx.setJobSpace(js);
        return ctx;
    }

    public static Context createContext(JobSpace js, HashMap<String, Object> attributes) {
        if (attributes == null) {
            return ClusterUtil.createContext(js);
        }
        Context ctx = new Context();
        ctx.setJobSpace(js);
        String[] paramNames = (String[])attributes.get("paramNames");
        if (paramNames != null) {
            Object[] paramValues = (Object[])attributes.get("paramValues");
            int count = paramNames.length;
            int i = 0;
            while (i < count) {
                ctx.setParamValue(paramNames[i], paramValues[i]);
                ++i;
            }
        }
        return ctx;
    }

    private static boolean isCurrentOnly(ClusterMemoryTable cmt, String func, String opt) {
        if (cmt.isDistributed()) {
            if (opt == null || opt.indexOf(99) == -1) {
                return false;
            }
            if (!func.equals("switch") && !func.equals("join")) {
                return false;
            }
        }
        return true;
    }

    public static Context createContext(JobSpace js, HashMap<String, Object> attributes, String func, String opt) {
        if (attributes == null) {
            return ClusterUtil.createContext(js);
        }
        Context ctx = new Context();
        ctx.setJobSpace(js);
        String[] paramNames = (String[])attributes.get("paramNames");
        if (paramNames != null) {
            Object[] paramValues = (Object[])attributes.get("paramValues");
            int count = paramNames.length;
            int i = 0;
            while (i < count) {
                ClusterMemoryTable cmt;
                Object val = paramValues[i];
                if (val instanceof ClusterMemoryTable && ClusterUtil.isCurrentOnly(cmt = (ClusterMemoryTable)val, func, opt)) {
                    int id = cmt.getCurrentClusterProxyId();
                    ResourceManager rm = js.getResourceManager();
                    TableProxy table = (TableProxy)rm.getProxy(id);
                    if (table == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(func) + mm.getMessage("function.invalidParam"));
                    }
                    val = table.getTable();
                }
                ctx.setParamValue(paramNames[i], val);
                ++i;
            }
        }
        return ctx;
    }

    public static void setParams(UnitCommand command, Expression exp, Context ctx) {
        if (exp != null) {
            ParamList paramList = new ParamList();
            ArrayList<INormalCell> cellList = new ArrayList<INormalCell>();
            exp.getUsedParams(ctx, paramList);
            exp.getUsedCells(cellList);
            ClusterUtil.setParams(command, paramList, cellList);
        }
    }

    public static void setParams(UnitCommand command, Expression[] exps, Context ctx) {
        if (exps != null) {
            ParamList paramList = new ParamList();
            ArrayList<INormalCell> cellList = new ArrayList<INormalCell>();
            Expression[] expressionArray = exps;
            int n = exps.length;
            int n2 = 0;
            while (n2 < n) {
                Expression exp = expressionArray[n2];
                exp.getUsedParams(ctx, paramList);
                exp.getUsedCells(cellList);
                ++n2;
            }
            ClusterUtil.setParams(command, paramList, cellList);
        }
    }

    public static void setParams(UnitCommand command, Function function, Context ctx) {
        IParam param = function.getParam();
        if (param != null) {
            ParamList paramList = new ParamList();
            ArrayList<INormalCell> cellList = new ArrayList<INormalCell>();
            param.getUsedParams(ctx, paramList);
            param.getUsedCells(cellList);
            ClusterUtil.setParams(command, paramList, cellList);
        }
    }

    private static void setParams(UnitCommand command, ParamList paramList, List<INormalCell> cellList) {
        int cellCount;
        int paramCount = paramList.count();
        int total = paramCount + (cellCount = cellList.size());
        if (total == 0) {
            return;
        }
        String[] paramNames = new String[total];
        Object[] paramValues = new Object[total];
        int i = 0;
        while (i < paramCount) {
            Param param = paramList.get(i);
            paramNames[i] = param.getName();
            paramValues[i] = param.getValue();
            ++i;
        }
        int c = 0;
        int i2 = paramCount;
        while (c < cellCount) {
            INormalCell cell = cellList.get(c);
            paramNames[i2] = cell.getCellId();
            paramValues[i2] = cell.getValue(true);
            ++c;
            ++i2;
        }
        command.setAttribute("paramNames", paramNames);
        command.setAttribute("paramValues", paramValues);
    }

    public static int[] listFileParts(String host, int port, String fileName, int[] parts) {
        try (UnitClient client = new UnitClient(host, port);){
            UnitCommand command = new UnitCommand(6);
            command.setAttribute("fileName", fileName);
            command.setAttribute("parts", parts);
            Response response = client.send(command);
            int[] nArray = (int[])response.checkResult();
            return nArray;
        }
    }

    public static Response executeListFileParts(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        IntArrayList list = new IntArrayList(parts.length);
        try {
            int[] nArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                int part = nArray[n2];
                LocalFile localFile = new LocalFile(fileName, null, part);
                if (localFile.exists()) {
                    list.addInt(part);
                }
                ++n2;
            }
            if (list.size() > 0) {
                return new Response(list.toIntArray());
            }
            return new Response();
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }
}

