/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileGroup;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ComTable;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.RowComTable;
import com.scudata.parallel.ClusterFile;
import com.scudata.parallel.ClusterUtil;
import com.scudata.parallel.CursorProxy;
import com.scudata.parallel.PhyTableProxy;
import com.scudata.parallel.Response;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitCommand;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

class PartitionFile {
    private ClusterFile clusterFile;
    private String host;
    private int port;
    private int[] parts;

    public PartitionFile(ClusterFile clusterFile, String host, int port, int partition) {
        this.clusterFile = clusterFile;
        this.host = host;
        this.port = port;
        if (partition != -1) {
            this.parts = new int[]{partition};
        }
    }

    public PartitionFile(ClusterFile clusterFile, String host, int port, int[] parts) {
        this.clusterFile = clusterFile;
        this.host = host;
        this.port = port;
        this.parts = parts;
    }

    public PartitionFile dup(ClusterFile clusterFile) {
        return new PartitionFile(clusterFile, this.host, this.port, this.parts);
    }

    public int createGroupTable(String[] colNames, String distribute, String opt) {
        String fileName = this.clusterFile.getFileName();
        try (UnitClient client = new UnitClient(this.host, this.port);){
            UnitCommand command = new UnitCommand(1);
            command.setAttribute("fileName", fileName);
            command.setAttribute("parts", this.parts);
            command.setAttribute("jobSpaceId", this.clusterFile.getJobSpaceId());
            command.setAttribute("colNames", colNames);
            command.setAttribute("distribute", distribute);
            command.setAttribute("opt", opt);
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
    }

    public static Response executeCreateGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String[] colNames = (String[])attributes.get("colNames");
        String distribute = (String)attributes.get("distribute");
        String opt = (String)attributes.get("opt");
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = ClusterUtil.createContext(js);
            FileObject fo = new FileObject(fileName);
            if (parts != null && parts.length == 1) {
                fo.setPartition(parts[0]);
            }
            File file = fo.getLocalFile().file();
            if ((opt == null || opt.indexOf(121) == -1) && file.exists()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileAlreadyExist", fo.getFileName()));
            }
            if (opt != null && opt.indexOf(121) != -1 && file.exists()) {
                try {
                    ComTable table = ComTable.open(file, ctx);
                    table.delete();
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            ComTable gt = opt != null && opt.indexOf(114) != -1 ? new RowComTable(file, colNames, distribute, opt, ctx) : new ColComTable(file, colNames, distribute, opt, ctx);
            if (parts != null && parts.length == 1) {
                gt.setPartition(parts[0]);
            }
            PhyTable table = gt.getBaseTable();
            PhyTableProxy proxy = new PhyTableProxy(table);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public int openGroupTable() {
        try (UnitClient client = new UnitClient(this.host, this.port);){
            UnitCommand command = new UnitCommand(5);
            command.setAttribute("fileName", this.clusterFile.getFileName());
            command.setAttribute("parts", this.parts);
            command.setAttribute("jobSpaceId", this.clusterFile.getJobSpaceId());
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
    }

    public static Response executeOpenGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        try {
            IPhyTable table;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = ClusterUtil.createContext(js);
            if (parts == null || parts.length <= 1) {
                FileObject fo = new FileObject(fileName);
                if (parts != null && parts.length == 1) {
                    fo.setPartition(parts[0]);
                }
                File file = fo.getLocalFile().file();
                PhyTable tmd = ComTable.openBaseTable(file, ctx);
                table = tmd;
                if (parts != null && parts.length == 1) {
                    tmd.getGroupTable().setPartition(parts[0]);
                }
            } else {
                FileGroup fileGroup = new FileGroup(fileName, parts);
                table = fileGroup.open(null, ctx);
            }
            PhyTableProxy proxy = new PhyTableProxy(table);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public int createBinaryCursor(String[] fields, String opt, int segSeq, int segCount, int unit) {
        String fileName = this.clusterFile.getFileName();
        try (UnitClient client = new UnitClient(this.host, this.port);){
            UnitCommand command = new UnitCommand(20);
            command.setAttribute("fileName", fileName);
            command.setAttribute("segSeq", new Integer(segSeq));
            command.setAttribute("segCount", new Integer(segCount));
            command.setAttribute("unit", new Integer(unit));
            command.setAttribute("jobSpaceId", this.clusterFile.getJobSpaceId());
            command.setAttribute("fields", fields);
            command.setAttribute("opt", opt);
            Response response = client.send(command);
            Integer id = (Integer)response.checkResult();
            int n = id;
            return n;
        }
    }

    public static Response executeCreateBinaryCursor(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        Integer segSeq = (Integer)attributes.get("segSeq");
        Integer segCount = (Integer)attributes.get("segCount");
        Integer unit = (Integer)attributes.get("unit");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String[] fields = (String[])attributes.get("fields");
        String opt = (String)attributes.get("opt");
        FileObject fo = new FileObject(fileName);
        try {
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = ClusterUtil.createContext(js, attributes);
            BFileCursor cursor = segCount > 1 ? new BFileCursor(fo, fields, segSeq, segCount, opt, ctx) : new BFileCursor(fo, fields, opt, ctx);
            CursorProxy proxy = new CursorProxy(cursor, unit);
            js.getResourceManager().addProxy(proxy);
            return new Response(new Integer(proxy.getProxyId()));
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public boolean resetGroupTable(String file, String option, String distribute, Integer blockSize) {
        try (UnitClient client = new UnitClient(this.host, this.port);){
            UnitCommand command = new UnitCommand(87);
            command.setAttribute("fileName", this.clusterFile.getFileName());
            command.setAttribute("parts", this.parts);
            command.setAttribute("file", file);
            command.setAttribute("option", option);
            command.setAttribute("jobSpaceId", this.clusterFile.getJobSpaceId());
            command.setAttribute("distribute", distribute);
            command.setAttribute("blockSize", blockSize);
            Response response = client.send(command);
            Boolean result = (Boolean)response.checkResult();
            boolean bl = result;
            return bl;
        }
    }

    public static Response executeResetGroupTable(HashMap<String, Object> attributes) {
        String fileName = (String)attributes.get("fileName");
        int[] parts = (int[])attributes.get("parts");
        String file = (String)attributes.get("file");
        String option = (String)attributes.get("option");
        String jobSpaceID = (String)attributes.get("jobSpaceId");
        String distribute = (String)attributes.get("distribute");
        Integer blockSize = (Integer)attributes.get("blockSize");
        try {
            boolean result;
            JobSpace js = JobSpaceManager.getSpace(jobSpaceID);
            Context ctx = ClusterUtil.createContext(js);
            if (parts == null || parts.length <= 1) {
                FileObject fo = new FileObject(fileName);
                if (parts != null && parts.length == 1) {
                    fo.setPartition(parts[0]);
                }
                ComTable table = ComTable.open(fo.getLocalFile().file(), ctx);
                if (file == null) {
                    result = table.reset(null, option, ctx, distribute);
                } else {
                    FileObject newFile = new FileObject(file);
                    if (parts != null && parts.length == 1) {
                        newFile.setPartition(parts[0]);
                    }
                    result = table.reset(newFile.getLocalFile().file(), option, ctx, distribute);
                }
            } else {
                FileGroup fileGroup = new FileGroup(fileName, parts);
                if (file == null) {
                    result = fileGroup.resetGroupTable(option, blockSize, null, ctx);
                } else {
                    FileGroup newFileGroup = new FileGroup(file, parts);
                    result = fileGroup.resetGroupTable(newFileGroup, option, distribute, blockSize, null, ctx);
                }
            }
            return new Response(result);
        }
        catch (Exception e) {
            Response response = new Response();
            response.setException(e);
            return response;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPartition() {
        if (this.parts != null && this.parts.length > 0) {
            return this.parts[0];
        }
        return -1;
    }

    public int[] getParts() {
        return this.parts;
    }
}

