/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.dm.Machines;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ComTable;
import com.scudata.parallel.FileInfo;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.PartitionUtil;
import com.scudata.parallel.RemoteFileProxyManager;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.SocketData;
import com.scudata.resources.EngineMessage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionManager {
    static HostManager _$1 = HostManager.instance();

    public static Response execute(Request req, SocketData sd) {
        int cmd = req.getAction();
        Response res = new Response();
        try {
            switch (cmd) {
                case 40014: {
                    String fileName = (String)req.getAttr("file name");
                    Integer partition = (Integer)req.getAttr("Partition");
                    Machines machines = (Machines)req.getAttr("machines");
                    String dstPath = (String)req.getAttr("Dest path");
                    String option = (String)req.getAttr("Option");
                    PartitionUtil.moveFile(fileName, partition, machines, dstPath, option);
                    res.setResult(Boolean.TRUE);
                    break;
                }
                case 40002: {
                    String path = (String)req.getAttr("path");
                    res.setResult(PartitionManager.listPathFiles(path, false));
                    break;
                }
                case 40003: {
                    String dstPath = (String)req.getAttr("File name");
                    String option = (String)req.getAttr("Option");
                    PartitionManager._$1(dstPath, option);
                    break;
                }
                case 40008: {
                    String dstPath = (String)req.getAttr("Dest path");
                    long lastModified = ((Number)req.getAttr("Last Modified")).longValue();
                    boolean isMove = (Boolean)req.getAttr("Is move");
                    boolean isY = (Boolean)req.getAttr("Is y");
                    if (isMove) {
                        boolean isNeedMove = PartitionManager._$1(dstPath, isY);
                        if (isNeedMove) {
                            res.setResult(isNeedMove);
                            sd.write(res);
                            PartitionManager._$1(dstPath, sd, lastModified);
                            res.setResult(Boolean.TRUE);
                            break;
                        }
                        res.setException(new Exception("Move file failed for " + dstPath + " is exist, please use @y force move."));
                        sd.write(res);
                        break;
                    }
                    boolean isNeedUpdate = PartitionManager._$1(dstPath, lastModified);
                    res.setResult(isNeedUpdate);
                    if (isNeedUpdate) {
                        sd.write(res);
                        PartitionManager._$1(dstPath, sd, lastModified);
                        res.setResult(Boolean.TRUE);
                    }
                    break;
                }
                case 40020: {
                    String dstPath = (String)req.getAttr("Relative Path");
                    long lastModified2 = ((Number)req.getAttr("Last Modified")).longValue();
                    break;
                }
                case 40030: {
                    String dstPath = (String)req.getAttr("Dest path");
                    long lastModified3 = ((Number)req.getAttr("Last Modified")).longValue();
                    Long fileSize = (Long)req.getAttr("File size");
                    long[] blockLinkInfo = (long[])req.getAttr("Block link info");
                    Integer fileType = (Integer)req.getAttr("File_type");
                    boolean hasExtFile = (Boolean)req.getAttr("Has Ext File");
                    Long extFileLastModified = (Long)req.getAttr("Ext File Last Modified");
                    if (fileType == 3) {
                        PartitionManager._$1(dstPath, sd, lastModified3, blockLinkInfo, fileSize);
                    } else {
                        PartitionManager._$1(dstPath, sd, lastModified3, blockLinkInfo, fileSize, hasExtFile, extFileLastModified);
                    }
                    res.setResult(Boolean.TRUE);
                    break;
                }
                case 40011: {
                    Machines machines = (Machines)req.getAttr("Machines");
                    String path = (String)req.getAttr("Path");
                    PartitionUtil.syncTo(machines, path);
                    res.setResult(Boolean.TRUE);
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }

    public static List<FileInfo> listPathFiles(String path, boolean isListSrc) {
        if (path == null) {
            throw new RQException("Path can not be empty.");
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        String parent = PartitionManager.getAbsolutePath(path);
        File f = new File(parent);
        if (!f.exists()) {
            if (isListSrc) {
                MessageManager mm = EngineMessage.get();
                String node = _$1.toString();
                throw new RQException(mm.getMessage("partitionmanager.lackfile", node, f.getAbsolutePath()));
            }
            return fileInfos;
        }
        FileInfo fi = new FileInfo(parent, f.isDirectory());
        if (fi.isDir()) {
            fi.setDirEmpty(f.listFiles() == null);
        }
        fi.setLastModified(f.lastModified());
        fileInfos.add(fi);
        if (!f.isDirectory()) {
            return fileInfos;
        }
        File[] subFiles = f.listFiles();
        if (subFiles == null) {
            return fileInfos;
        }
        int beginIndex = parent.endsWith("/") || parent.endsWith("\\") ? parent.length() : parent.length() + 1;
        for (int i = 0; i < subFiles.length; ++i) {
            File tmp = subFiles[i];
            String absPath = tmp.getAbsolutePath();
            String tmpPath = absPath.substring(beginIndex);
            fileInfos.addAll(PartitionManager._$2(parent, tmpPath));
        }
        Collections.sort(fileInfos);
        return fileInfos;
    }

    private static List<FileInfo> _$2(String root, String relativePath) {
        File f;
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        if (relativePath == null) {
            f = new File(root);
        } else {
            f = new File(root, relativePath);
            if (!f.exists()) {
                return fileInfos;
            }
            FileInfo fi = new FileInfo(relativePath, f.isDirectory());
            fi.setLastModified(f.lastModified());
            fileInfos.add(fi);
        }
        if (!f.isDirectory()) {
            return fileInfos;
        }
        File[] subFiles = f.listFiles();
        int beginIndex = root.length() + 1;
        for (int i = 0; i < subFiles.length; ++i) {
            File tmp = subFiles[i];
            String absPath = tmp.getAbsolutePath();
            String tmpPath = absPath.substring(beginIndex);
            fileInfos.addAll(PartitionManager._$2(root, tmpPath));
        }
        Collections.sort(fileInfos);
        return fileInfos;
    }

    private static void _$1(String path, String option) {
        String absolute = PartitionManager.getAbsolutePath(path);
        File file = new File(absolute);
        if (!file.exists()) {
            throw new RQException(file + " is not exist.");
        }
        PartitionManager._$1(file, option);
    }

    private static boolean _$1(File file) {
        return PartitionManager._$1(file, null);
    }

    private static boolean _$1(File file, String option) {
        if (!file.isDirectory()) {
            boolean b = file.delete();
            Logger.debug("Delete file:" + file.getAbsolutePath() + " " + b);
            return b;
        }
        File[] subFiles = file.listFiles();
        for (int i = 0; i < subFiles.length; ++i) {
            PartitionManager._$1(subFiles[i], option);
        }
        return file.delete();
    }

    static File _$2(String tarPathName, boolean autoRename) {
        String n;
        File f = new File(tarPathName);
        if (!f.exists()) {
            return f;
        }
        if (!autoRename) {
            f.delete();
            return f;
        }
        int c = 1;
        String p = f.getParent();
        String tmp = f.getName();
        int dot = tmp.lastIndexOf(46);
        String ext = "";
        if (dot > 0) {
            n = tmp.substring(0, dot);
            ext = tmp.substring(dot + 1);
            if (!ext.isEmpty()) {
                ext = "." + ext;
            }
        } else {
            n = tmp;
        }
        File tmpf = new File(p, n + "(" + c + ")" + ext);
        while (tmpf.exists()) {
            tmpf = new File(p, n + "(" + ++c + ")" + ext);
        }
        return tmpf;
    }

    public static String getAbsolutePath(String relativeOrAbsolute) {
        File f = new File(relativeOrAbsolute);
        if (!f.isAbsolute()) {
            String main = Env.getMainPath();
            f = new File(main, relativeOrAbsolute);
        }
        return f.getAbsolutePath();
    }

    private static boolean _$1(String dstPath, boolean isY) {
        String absolutePath = PartitionManager.getAbsolutePath(dstPath);
        File f = new File(absolutePath);
        if (!f.exists()) {
            return true;
        }
        return isY;
    }

    private static boolean _$1(String dstPath, long lastModified) {
        String absolutePath = PartitionManager.getAbsolutePath(dstPath);
        File f = new File(absolutePath);
        if (!f.exists()) {
            return true;
        }
        boolean isNeed = f.lastModified() < lastModified;
        return isNeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1(String dstPath, SocketData sd, long lastModified) throws Exception {
        String absolutePath = PartitionManager.getAbsolutePath(dstPath);
        File f = new File(absolutePath);
        File uploadFile = PartitionManager._$2(absolutePath, false);
        File p = uploadFile.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        BufferedOutputStream outBuff = null;
        outBuff = new BufferedOutputStream(new FileOutputStream(uploadFile));
        try {
            byte[] data = (byte[])sd.read();
            while (data != null) {
                outBuff.write(data);
                data = (byte[])sd.read();
            }
            outBuff.flush();
        }
        finally {
            if (outBuff != null) {
                outBuff.close();
            }
            uploadFile.setLastModified(lastModified);
        }
        Logger.debug("Receive file:" + f.getAbsolutePath() + " OK.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1(String dstPath, SocketData sd, Long lastModified, long[] blockLinkInfo, Long fileSize, Boolean hasExtFile, Long extFileLastModified) throws Exception {
        String absolutePath = PartitionManager.getAbsolutePath(dstPath);
        File f = new File(absolutePath);
        File uploadFile = PartitionManager._$2(absolutePath, false);
        File p = uploadFile.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        long uploadFileSize = uploadFile.length();
        if (fileSize < uploadFileSize) {
            uploadFileSize = 0L;
        }
        if (uploadFileSize == 0L) {
            byte[] data;
            sd.write(new long[0]);
            sd.write(uploadFileSize);
            RandomAccessFile raf = new RandomAccessFile(uploadFile, "rw");
            raf.setLength(fileSize);
            raf.seek(0L);
            try {
                data = (byte[])sd.read();
                while (data != null) {
                    raf.write(data);
                    data = (byte[])sd.read();
                }
                raf.getChannel().force(false);
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                uploadFile.setLastModified(lastModified);
            }
            if (hasExtFile.booleanValue()) {
                uploadFile = PartitionManager._$2(absolutePath + ".ext", false);
                raf = new RandomAccessFile(uploadFile, "rw");
                raf.setLength(fileSize);
                raf.seek(0L);
                try {
                    data = (byte[])sd.read();
                    while (data != null) {
                        raf.write(data);
                        data = (byte[])sd.read();
                    }
                    raf.getChannel().force(false);
                }
                finally {
                    if (raf != null) {
                        raf.close();
                    }
                    uploadFile.setLastModified(extFileLastModified);
                }
                Logger.debug("Receive file:" + uploadFile.getAbsolutePath() + " OK.");
            } else {
                uploadFile = PartitionManager._$2(absolutePath + ".ext", false);
                if (uploadFile.exists()) {
                    PartitionManager._$1(uploadFile);
                }
            }
            Logger.debug("Receive file:" + f.getAbsolutePath() + " OK.");
            return;
        }
        ComTable table = ComTable.open(uploadFile, null);
        long[] positions = table.cmpBlockLinkInfo(blockLinkInfo);
        sd.write(positions);
        sd.write(uploadFile.length());
        RandomAccessFile raf = new RandomAccessFile(uploadFile, "rw");
        raf.setLength(fileSize);
        int blockSize = table.getBlockSize();
        byte[] buf = new byte[blockSize];
        try {
            String type = (String)sd.read();
            while (type != null) {
                char ch = type.charAt(0);
                long pos = (Long)sd.read();
                byte[] data = (byte[])sd.read();
                raf.seek(pos);
                switch (ch) {
                    case 'a': {
                        raf.write(data);
                        break;
                    }
                    case 'h': {
                        raf.write(data);
                        break;
                    }
                    case 'm': {
                        raf.read(buf);
                        if (Arrays.equals(buf, data)) break;
                        raf.seek(pos);
                        raf.write(data);
                        break;
                    }
                    case 'n': {
                        raf.write(data);
                    }
                }
                type = (String)sd.read();
            }
            raf.getChannel().force(false);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
            table.close();
            uploadFile.setLastModified(lastModified);
        }
        if (hasExtFile.booleanValue()) {
            uploadFile = PartitionManager._$2(absolutePath + ".ext", false);
            raf = new RandomAccessFile(uploadFile, "rw");
            raf.setLength(fileSize);
            raf.seek(0L);
            try {
                byte[] data = (byte[])sd.read();
                while (data != null) {
                    raf.write(data);
                    data = (byte[])sd.read();
                }
                raf.getChannel().force(false);
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                uploadFile.setLastModified(extFileLastModified);
            }
            Logger.debug("Receive file:" + uploadFile.getAbsolutePath() + " OK.");
        } else {
            uploadFile = PartitionManager._$2(absolutePath + ".ext", false);
            if (uploadFile.exists()) {
                PartitionManager._$1(uploadFile);
            }
        }
        Logger.debug("Receive file:" + f.getAbsolutePath() + " OK.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1(String dstPath, SocketData sd, long lastModified, long[] blockLinkInfo, long fileSize) throws Exception {
        byte[] header;
        String absolutePath = PartitionManager.getAbsolutePath(dstPath);
        File f = new File(absolutePath);
        File uploadFile = PartitionManager._$2(absolutePath, false);
        File p = uploadFile.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        long indexPos1 = 0L;
        long indexPos2 = 0L;
        long index1EndPos = 0L;
        long uploadFileSize = uploadFile.length();
        if (uploadFileSize > 0L) {
            FileInputStream fis = new FileInputStream(uploadFile);
            header = RemoteFileProxyManager.read(fis, 1024);
            BufferReader reader = new BufferReader(null, header, 39, 1024);
            reader.readLong64();
            index1EndPos = reader.readLong64();
            reader.readLong64();
            reader.readLong64();
            reader.readLong64();
            indexPos1 = reader.readLong64();
            indexPos2 = reader.readLong64();
            fis.close();
        }
        if (blockLinkInfo[0] != indexPos1 || blockLinkInfo[1] != indexPos2 || blockLinkInfo[2] != index1EndPos || fileSize < uploadFileSize || 0L == uploadFileSize) {
            sd.write(new Integer(0));
            BufferedOutputStream outBuff = null;
            outBuff = new BufferedOutputStream(new FileOutputStream(uploadFile));
            try {
                byte[] data = (byte[])sd.read();
                while (data != null) {
                    outBuff.write(data);
                    data = (byte[])sd.read();
                }
                outBuff.flush();
            }
            finally {
                if (outBuff != null) {
                    outBuff.close();
                }
                uploadFile.setLastModified(lastModified);
            }
        }
        sd.write(new Integer(1));
        RandomAccessFile raf = new RandomAccessFile(uploadFile, "rw");
        raf.setLength(fileSize);
        try {
            header = (byte[])sd.read();
            raf.seek(indexPos2);
            byte[] data = (byte[])sd.read();
            while (data != null) {
                raf.write(data);
                data = (byte[])sd.read();
            }
            raf.seek(0L);
            raf.write(header);
            raf.getChannel().force(false);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
            uploadFile.setLastModified(lastModified);
        }
        Logger.debug("Receive file:" + uploadFile.getAbsolutePath() + " OK.");
    }
}

