/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Machines;
import com.scudata.dm.RemoteFile;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ComTable;
import com.scudata.parallel.FileInfo;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.PartitionManager;
import com.scudata.parallel.RemoteFileProxyManager;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.UnitClient;
import com.scudata.resources.EngineMessage;
import com.scudata.resources.ParallelMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionUtil {
    static HostManager _$2 = HostManager.instance();
    static MessageManager _$1 = ParallelMessage.get();

    private static Object _$1(String host, int port, Request req) {
        UnitClient uc = null;
        Response res = null;
        try {
            uc = new UnitClient(host, port);
            uc.connect();
            res = uc.send(req);
            if (res.getError() != null) {
                Error e = res.getError();
                throw new RQException("[" + uc + "] " + e.getMessage(), e);
            }
            if (res.getException() != null) {
                Exception x = res.getException();
                throw new RQException("[" + uc + "] " + x.getMessage(), x);
            }
            Object x = res.getResult();
            return x;
        }
        catch (RQException rq) {
            throw rq;
        }
        catch (Exception x) {
            throw new RQException(_$1.getMessage("PartitionUtil.askerror", host + ":" + port), x);
        }
        finally {
            if (uc != null) {
                uc.close();
            }
        }
    }

    public static FileObject locate(Machines mcs, String file) {
        return PartitionUtil.locate(mcs, file, null);
    }

    public static FileObject locate(Machines mcs, String file, Integer z) {
        if (mcs == null) {
            throw new RQException("hosts is null");
        }
        FileObject fo = new FileObject(file);
        fo.setPartition(z);
        if (mcs.size() == 1) {
            String host = mcs.getHost(0);
            int port = mcs.getPort(0);
            fo = new FileObject(file, host, port);
            fo.setPartition(z);
            fo.setRemoteFileWritable();
            return fo;
        }
        if (fo.isExists()) {
            return fo;
        }
        HashMap<UnitClient, FileObject> existFileNodes = new HashMap<UnitClient, FileObject>();
        for (int i = 0; i < mcs.size(); ++i) {
            String host = mcs.getHost(i);
            int port = mcs.getPort(i);
            try {
                RemoteFile rf = new RemoteFile(host, port, file, z);
                if (!rf.exists()) continue;
                fo = new FileObject(file, host, port);
                fo.setPartition(z);
                existFileNodes.put(new UnitClient(host, port), fo);
                continue;
            }
            catch (RQException rx) {
                // empty catch block
            }
        }
        if (existFileNodes.isEmpty()) {
            throw new RQException(file + " is not exists in node machines.");
        }
        int taskCount = 0;
        UnitClient targetUC = null;
        for (UnitClient uc : existFileNodes.keySet()) {
            int c = uc.getCurrentTasks();
            if (taskCount != 0 && c >= taskCount) continue;
            taskCount = c;
            targetUC = uc;
        }
        return (FileObject)existFileNodes.get(targetUC);
    }

    public static List<FileInfo> listFiles(String host, int port, String path) {
        Request req = new Request(40002);
        req.setAttr("path", path);
        return (List)PartitionUtil._$1(host, port, req);
    }

    public static void moveFile(String fileName, int partition, Machines hs, String dstPath, String option) {
        PartitionUtil.moveFile(null, 0, fileName, partition, hs, dstPath, option);
    }

    public static boolean isCOption(String option) {
        return option != null && option.indexOf("c") > -1;
    }

    public static boolean isYOption(String option) {
        return option != null && option.indexOf("y") > -1;
    }

    public static boolean moveFile(String host, int port, String fileName, int partition, Machines hs, String dstPath, String option) {
        if (host != null) {
            boolean isLocal;
            boolean bl = isLocal = host.equals(_$2.getHost()) && port == _$2.getPort();
            if (!isLocal) {
                Request req = new Request(40014);
                req.setAttr("machines", hs);
                req.setAttr("file name", fileName);
                req.setAttr("Partition", partition);
                req.setAttr("Dest path", dstPath);
                req.setAttr("Option", option);
                PartitionUtil._$1(host, port, req);
                return true;
            }
        }
        String absolute = PartitionManager.getAbsolutePath(fileName);
        File file = new File(absolute);
        if (hs == null) {
            if (!file.exists()) {
                throw new RQException(absolute + " is not exist.");
            }
            if (!StringUtils.isValidString(dstPath)) {
                file.delete();
            } else if (file.exists()) {
                File newFile = new File(file.getParent(), dstPath);
                file.renameTo(newFile);
            }
            return true;
        }
        if (!StringUtils.isValidString(dstPath)) {
            for (int n = 0; n < hs.size(); ++n) {
                String tmpHost = hs.getHost(n);
                int tmpPort = hs.getPort(n);
                Request req = new Request(40003);
                req.setAttr("File name", fileName);
                req.setAttr("Option", option);
                try {
                    PartitionUtil._$1(tmpHost, tmpPort, req);
                    continue;
                }
                catch (Exception x) {
                    Logger.warn(x);
                }
            }
            return true;
        }
        if (file.isDirectory()) {
            throw new RQException(absolute + " is not a file.");
        }
        if (!file.exists()) {
            throw new RQException(absolute + " is not exist.");
        }
        File dstFile = new File(dstPath);
        boolean isDstAbsolute = dstFile.isAbsolute();
        for (int n = 0; n < hs.size(); ++n) {
            ArrayList<String> tmpUpFiles = new ArrayList<String>();
            tmpUpFiles.add(absolute);
            String targetPath = isDstAbsolute ? new File(dstPath, file.getName()).getAbsolutePath() : new File(dstPath, file.getName()).getPath();
            PartitionUtil.upload(hs.getHost(n), hs.getPort(n), tmpUpFiles, targetPath, true, PartitionUtil.isYOption(option));
        }
        if (!PartitionUtil.isCOption(option)) {
            file.delete();
        }
        return true;
    }

    private static void _$1(UnitClient uc, File file, String dstPathName, boolean isMove, boolean isY) throws Exception {
        int type = PartitionUtil._$1(file);
        if (type > 0) {
            PartitionUtil._$2(uc, file, dstPathName);
            return;
        }
        Request req = new Request(40008);
        req.setAttr("Dest path", dstPathName);
        req.setAttr("Last Modified", new Long(file.lastModified()));
        req.setAttr("Is move", isMove);
        req.setAttr("Is y", isY);
        uc.write(req);
        Response res = (Response)uc.read();
        if (res.getException() != null) {
            throw res.getException();
        }
        boolean isNeedUpdate = (Boolean)res.getResult();
        if (!isNeedUpdate) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] fileBuf = RemoteFileProxyManager.read(fis, Env.FILE_BUFSIZE);
        uc.write(fileBuf);
        while (fileBuf != null) {
            fileBuf = RemoteFileProxyManager.read(fis, Env.FILE_BUFSIZE);
            uc.write(fileBuf);
        }
        fis.close();
        res = (Response)uc.read();
        if (res.getException() != null) {
            throw res.getException();
        }
        Logger.debug("upload: " + file.getAbsolutePath() + " OK.");
    }

    public static void upload(String host, int port, List localFiles, String dstPath) {
        PartitionUtil.upload(host, port, localFiles, dstPath, false, false);
    }

    public static void upload(String host, int port, List localFiles, String dstPath, boolean isMove, boolean isY) {
        MessageManager mm = EngineMessage.get();
        UnitClient uc = new UnitClient(host, port);
        try {
            uc.connect();
            for (int i = 0; i < localFiles.size(); ++i) {
                String localFile = (String)localFiles.get(i);
                File f = new File(localFile);
                if (!f.exists()) {
                    Logger.warning(mm.getMessage("partitionutil.filenotexist", localFile));
                    continue;
                }
                PartitionUtil._$1(uc, f, dstPath, isMove, isY);
            }
        }
        catch (Exception x) {
            throw new RQException("[" + uc + "] " + x.getMessage(), x);
        }
        finally {
            if (uc != null) {
                uc.close();
            }
        }
    }

    public static void syncTo(Machines machines, String path) {
        PartitionUtil.syncTo(null, 0, machines, path);
    }

    public static void syncTo(String host, int port, Machines machines, String path) {
        MessageManager mm = EngineMessage.get();
        if (machines == null || machines.size() == 0) {
            throw new RQException(mm.getMessage("partitionutil.notarget"));
        }
        if (path == null) {
            throw new RQException("Path can not be empty.");
        }
        String absPath = PartitionManager.getAbsolutePath(path);
        File file = new File(absPath);
        if (!file.isDirectory()) {
            throw new RQException(absPath + " is not a directory!");
        }
        if (host != null) {
            boolean isLocal;
            boolean bl = isLocal = host.equals(_$2.getHost()) && port == _$2.getPort();
            if (!isLocal) {
                Request req = new Request(40011);
                req.setAttr("Machines", machines);
                req.setAttr("Path", path);
                PartitionUtil._$1(host, port, req);
                return;
            }
        }
        List[] machineFileList = new List[machines.size()];
        for (int i = 0; i < machines.size(); ++i) {
            List<FileInfo> fileInfosN;
            machineFileList[i] = fileInfosN = PartitionUtil.listFiles(machines.getHost(i), machines.getPort(i), path);
        }
        List<FileInfo> localFiles = PartitionManager.listPathFiles(path, true);
        for (int i = 0; i < localFiles.size(); ++i) {
            FileInfo syncFi = localFiles.get(i);
            if (syncFi.isDir()) continue;
            for (int n = 0; n < machineFileList.length; ++n) {
                FileInfo fiN;
                List fileInfosN = machineFileList[n];
                int index = fileInfosN.indexOf(syncFi);
                if (index >= 0 && (fiN = (FileInfo)fileInfosN.get(index)).lastModified() > syncFi.lastModified()) continue;
                ArrayList<String> tmpUpFiles = new ArrayList<String>();
                File absFile = syncFi.getFile(path);
                tmpUpFiles.add(absFile.getAbsolutePath());
                String dstPath = syncFi.getDestPath(path);
                PartitionUtil.upload(machines.getHost(n), machines.getPort(n), tmpUpFiles, dstPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$2(UnitClient uc, File file, String dstPathName) throws Exception {
        Response res;
        if (!file.exists()) {
            return;
        }
        if (file.getName().indexOf(".ext") != -1) {
            return;
        }
        ComTable table = ComTable.open(file, null);
        File extFile = ComTable.getSupplementFile(file);
        Request req = new Request(40030);
        req.setAttr("Dest path", dstPathName);
        req.setAttr("Last Modified", file.lastModified());
        req.setAttr("Block link info", table.getBlockLinkInfo());
        req.setAttr("File size", file.length());
        req.setAttr("File_type", 1);
        if (extFile.exists()) {
            req.setAttr("Has Ext File", Boolean.TRUE);
            req.setAttr("Ext File Last Modified", extFile.lastModified());
        } else {
            req.setAttr("Has Ext File", Boolean.FALSE);
        }
        uc.write(req);
        long[] modifyPositions = table.getModifyPosition();
        long[] positions = (long[])uc.read();
        long remoteFileSize = (Long)uc.read();
        int blockSize = table.getBlockSize();
        byte[] buf = new byte[blockSize];
        if (remoteFileSize == 0L) {
            Response res2;
            int size;
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            try {
                raf.seek(0L);
                size = raf.read(buf);
                while (size != -1) {
                    uc.write(buf);
                    size = raf.read(buf);
                }
                uc.write(null);
            }
            finally {
                raf.close();
                table.close();
            }
            if (extFile.exists()) {
                raf = new RandomAccessFile(extFile, "rw");
                try {
                    raf.seek(0L);
                    size = raf.read(buf);
                    while (size != -1) {
                        uc.write(buf);
                        size = raf.read(buf);
                    }
                    uc.write(null);
                }
                finally {
                    raf.close();
                }
            }
            if ((res2 = (Response)uc.read()).getException() != null) {
                throw res2.getException();
            }
            Logger.debug("upload: " + file.getAbsolutePath() + " OK.");
            return;
        }
        if (positions != null && positions.length > 0) {
            positions = table.getSyncPosition(positions);
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            if (modifyPositions != null) {
                for (long pos : modifyPositions) {
                    if (pos >= remoteFileSize) continue;
                    raf.seek(pos);
                    raf.read(buf);
                    uc.write("m");
                    uc.write(pos);
                    uc.write(buf);
                }
            }
            if (positions != null) {
                for (long pos : positions) {
                    if (pos >= remoteFileSize) continue;
                    raf.seek(pos);
                    raf.read(buf);
                    uc.write("n");
                    uc.write(pos);
                    uc.write(buf);
                }
            }
            long fileSize = file.length();
            while (remoteFileSize < fileSize) {
                raf.seek(remoteFileSize);
                raf.read(buf);
                uc.write("a");
                uc.write(remoteFileSize);
                uc.write(buf);
                remoteFileSize += (long)blockSize;
            }
            for (long pos : positions = table.getHeaderPosition()) {
                if (pos >= remoteFileSize) continue;
                raf.seek(pos);
                raf.read(buf);
                uc.write("h");
                uc.write(pos);
                uc.write(buf);
            }
            uc.write(null);
        }
        finally {
            table.close();
            raf.close();
        }
        if (extFile.exists()) {
            raf = new RandomAccessFile(extFile, "rw");
            try {
                raf.seek(0L);
                int size = raf.read(buf);
                while (size != -1) {
                    uc.write(buf);
                    size = raf.read(buf);
                }
                uc.write(null);
            }
            finally {
                raf.close();
            }
        }
        if ((res = (Response)uc.read()).getException() != null) {
            throw res.getException();
        }
        Logger.debug("upload: " + file.getAbsolutePath() + " OK.");
    }

    private static void _$1(UnitClient uc, File file, String dstPathName) throws Exception {
        byte[] fileBuf;
        if (!file.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] header = RemoteFileProxyManager.read(fis, 1024);
        BufferReader reader = new BufferReader(null, header, 39, 1024);
        reader.readLong64();
        long index1EndPos = reader.readLong64();
        reader.readLong64();
        reader.readLong64();
        reader.readLong64();
        long indexPos1 = reader.readLong64();
        long indexPos2 = reader.readLong64();
        fis.close();
        long[] pos = new long[]{indexPos1, indexPos2, index1EndPos};
        Request req = new Request(40030);
        req.setAttr("Dest path", dstPathName);
        req.setAttr("Last Modified", new Long(file.lastModified()));
        req.setAttr("File size", file.length());
        req.setAttr("Block link info", pos);
        req.setAttr("File_type", new Integer(3));
        uc.write(req);
        int syncType = (Integer)uc.read();
        if (syncType == 0) {
            fis = new FileInputStream(file);
            fileBuf = RemoteFileProxyManager.read(fis, Env.FILE_BUFSIZE);
            uc.write(fileBuf);
            while (fileBuf != null) {
                fileBuf = RemoteFileProxyManager.read(fis, Env.FILE_BUFSIZE);
                uc.write(fileBuf);
            }
            fis.close();
        } else {
            fis = new FileInputStream(file);
            fileBuf = RemoteFileProxyManager.read(fis, (int)indexPos1);
            uc.write(fileBuf);
            fis.skip(indexPos2 - indexPos1);
            while (fileBuf != null) {
                fileBuf = RemoteFileProxyManager.read(fis, Env.FILE_BUFSIZE);
                uc.write(fileBuf);
            }
            fis.close();
        }
        Response res = (Response)uc.read();
        if (res.getException() != null) {
            throw res.getException();
        }
        Logger.debug("upload: " + file.getAbsolutePath() + " OK.");
    }

    private static int _$1(File file) {
        RandomAccessFile raf = null;
        if (!file.exists()) {
            return 0;
        }
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.seek(0L);
            byte[] bytes = new byte[32];
            raf.read(bytes);
            if (bytes[0] != 114 || bytes[1] != 113 || bytes[2] != 100 || bytes[3] != 119) {
                int n = 0;
                return n;
            }
            if (bytes[4] == 103 && bytes[5] == 116) {
                if (bytes[6] == 99) {
                    int n = 1;
                    return n;
                }
                if (bytes[6] == 114) {
                    int n = 2;
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }
}

