/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.RQException;
import com.scudata.dm.cursor.ICursor;
import com.scudata.parallel.ITask;
import com.scudata.parallel.RemoteCursorProxy;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.TaskManager;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCursorProxyManager {
    private static RemoteCursorProxyManager _$3 = null;
    ITask _$2;
    ArrayList<RemoteCursorProxy> _$1 = new ArrayList();

    public static RemoteCursorProxyManager getInstance() {
        if (_$3 == null) {
            _$3 = new RemoteCursorProxyManager(null);
        }
        return _$3;
    }

    public static int addCursor(ICursor c) {
        RemoteCursorProxyManager rcpm = RemoteCursorProxyManager.getInstance();
        RemoteCursorProxy rcp = new RemoteCursorProxy(c);
        rcpm.addProxy(rcp);
        return rcp._$2();
    }

    public RemoteCursorProxyManager(ITask t) {
        this._$2 = t;
    }

    public ArrayList<RemoteCursorProxy> getProxys() {
        return this._$1;
    }

    public void destroy() {
        for (int i = 0; i < this._$1.size(); ++i) {
            RemoteCursorProxy rcp = this._$1.get(i);
            rcp.destroy();
        }
        this._$1.clear();
    }

    public ITask getTask() {
        return this._$2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request req) {
        if (this._$2 != null) {
            this._$2.resetAccess();
        }
        Response res = new Response();
        try {
            int proxyId = ((Number)req.getAttr("Proxy id")).intValue();
            RemoteCursorProxy rcp = this.getProxy(proxyId);
            String methodName = (String)req.getAttr("Method name");
            if (methodName.equals("close") && rcp == null) {
                Response response = res;
                return response;
            }
            Object[] args = (Object[])req.getAttr("Arg values");
            try {
                Object result = RemoteCursorProxyManager.invokeMethod(rcp, methodName, args);
                res.setResult(result);
            }
            catch (Exception x) {
                x.printStackTrace();
                res.setException(new RQException(x.getCause().getMessage(), x.getCause()));
            }
            catch (Error er) {
                er.printStackTrace();
                res.setError(er);
            }
        }
        finally {
            if (this._$2 != null) {
                this._$2.access();
            }
        }
        return res;
    }

    public synchronized void addProxy(RemoteCursorProxy rcp) {
        this._$1.add(rcp);
    }

    public synchronized void delProxy(int proxyID) {
        for (int i = 0; i < this._$1.size(); ++i) {
            RemoteCursorProxy rcp = this._$1.get(i);
            if (rcp._$2() != proxyID) continue;
            this._$1.remove(i);
            break;
        }
        if (this._$1.isEmpty() && this._$2 != null) {
            TaskManager.delTask(this._$2.getTaskID());
        }
    }

    public synchronized RemoteCursorProxy getProxy(int proxyID) {
        for (int i = 0; i < this._$1.size(); ++i) {
            RemoteCursorProxy rcp = this._$1.get(i);
            if (rcp._$2() != proxyID) continue;
            return rcp;
        }
        return null;
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Method[] ms = ownerClass.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            if (!m.getName().equals(methodName) || !RemoteCursorProxyManager._$1(m, args)) continue;
            return m.invoke(owner, args);
        }
        StringBuffer argNames = new StringBuffer();
        argNames.append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                argNames.append(",");
            }
            if (args[i] == null) {
                argNames.append("null");
                continue;
            }
            argNames.append(args[i].getClass().getName());
        }
        argNames.append(")");
        throw new Exception(methodName + argNames + " not found.");
    }

    private static boolean _$1(Method m, Object[] args) {
        Class<?>[] mArgs;
        if (args == null) {
            args = new Object[]{};
        }
        if ((mArgs = m.getParameterTypes()).length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (RemoteCursorProxyManager._$1(mArgs[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean _$1(Class c, Object o) {
        if (o == null) {
            return true;
        }
        String n1 = c.getName();
        if (n1.equals("boolean")) {
            return o instanceof Boolean;
        }
        if (n1.equals("byte")) {
            return o instanceof Byte;
        }
        if (n1.equals("short")) {
            return o instanceof Short;
        }
        if (n1.equals("int")) {
            return o instanceof Integer;
        }
        if (n1.equals("long")) {
            return o instanceof Long;
        }
        if (n1.equals("float")) {
            return o instanceof Float;
        }
        if (n1.equals("double")) {
            return o instanceof Double;
        }
        return c.isInstance(o);
    }

    public static synchronized void checkTimeOut(int proxyTimeOut) {
        RemoteCursorProxyManager instance = RemoteCursorProxyManager.getInstance();
        ArrayList<RemoteCursorProxy> proxys = instance.getProxys();
        for (int i = proxys.size() - 1; i >= 0; --i) {
            RemoteCursorProxy rcp = proxys.get(i);
            if (!rcp.checkTimeOut(proxyTimeOut)) continue;
            proxys.remove(rcp);
        }
    }
}

