/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.CellLocation;
import com.scudata.dm.ParallelProcess;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.ITask;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.Task;
import com.scudata.server.unit.UnitServer;
import com.scudata.thread.ThreadPool;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager {
    static ArrayList<ITask> _$2 = new ArrayList();
    static ThreadPool _$1 = null;

    public static ThreadPool getPool() {
        if (_$1 == null) {
            HostManager hostManager = HostManager.instance();
            int size = hostManager.getMaxTaskNum();
            _$1 = ThreadPool.newSpecifiedInstance(size);
        }
        return _$1;
    }

    public static Response execute(Request req) {
        int cmd = req.getAction();
        Response res = new Response();
        try {
            switch (cmd) {
                case 10001: {
                    Object dfx = req.getAttr("Dfx name");
                    List args = (List)req.getAttr("Arg list");
                    String spaceId = (String)req.getAttr("Space id");
                    boolean isProcessCaller = false;
                    Boolean B = (Boolean)req.getAttr("TASK_IsProcessCaller");
                    if (B != null) {
                        isProcessCaller = B;
                    }
                    Object reduce = req.getAttr("Reduce");
                    CellLocation accumulateLocation = (CellLocation)req.getAttr("AccumulateLocation");
                    CellLocation currentLocation = (CellLocation)req.getAttr("CurrentLocation");
                    int taskId = UnitServer.nextId();
                    Task task = new Task(dfx, args, taskId, spaceId, isProcessCaller, reduce, accumulateLocation, currentLocation);
                    Integer processTaskId = (Integer)req.getAttr("Process task id");
                    if (processTaskId != null) {
                        task.setProcessTaskId(processTaskId);
                    }
                    TaskManager.addTask(task);
                    res.setResult(new Integer(taskId));
                    break;
                }
                case 10002: {
                    int taskId = ((Number)req.getAttr("Task id")).intValue();
                    Task task = (Task)TaskManager.getTask(taskId);
                    TaskManager.getPool().submit(task);
                    task.join();
                    res = task.getResponse();
                    break;
                }
                case 10003: {
                    int taskId = ((Number)req.getAttr("Task id")).intValue();
                    String cancelReason = (String)req.getAttr("Task reason");
                    Task task = (Task)TaskManager.getTask(taskId);
                    res = task.cancel(cancelReason);
                    break;
                }
                case 10004: {
                    String spaceId = (String)req.getAttr("Space id");
                    res.setResult(ParallelProcess.getReduceResult(spaceId));
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }

    public static synchronized void addTask(ITask t) {
        _$2.add(t);
    }

    public static synchronized void delTask(int taskId) {
        for (int i = 0; i < _$2.size(); ++i) {
            ITask t = _$2.get(i);
            if (t.getTaskID() != taskId) continue;
            _$2.remove(i);
            break;
        }
    }

    public static synchronized ITask getTask(int taskId) throws Exception {
        for (int i = 0; i < _$2.size(); ++i) {
            ITask t = _$2.get(i);
            if (t.getTaskID() != taskId) continue;
            return t;
        }
        throw new Exception("Task:" + taskId + " is timeout.");
    }

    public static synchronized List<ITask> getTaskList() {
        ArrayList<ITask> al = new ArrayList<ITask>();
        al.addAll(_$2);
        return al;
    }

    public static synchronized void checkTimeOut(int proxyTimeOut) {
        for (int i = _$2.size() - 1; i >= 0; --i) {
            ITask t = _$2.get(i);
            if (!t.checkTimeOut(proxyTimeOut)) continue;
            t.close();
            _$2.remove(t);
        }
    }
}

