/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.common.Logger;
import com.scudata.common.RQException;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.parallel.HostManager;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.SocketData;
import com.scudata.parallel.UnitCommand;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    String _$7 = null;
    int _$6 = 0;
    boolean _$5 = false;
    transient SocketData _$4 = null;
    private int _$3 = 5000;
    private transient Request _$2 = null;
    private transient String _$1 = null;

    public UnitClient(String host, int port) {
        this._$7 = host;
        this._$6 = port;
    }

    public UnitClient(String add) {
        int index;
        if (add != null && (index = add.lastIndexOf(58)) > 0) {
            this._$7 = add.substring(0, index).trim();
            this._$6 = Integer.parseInt(add.substring(index + 1).trim());
        }
    }

    public void setDispatchable() {
        this._$5 = true;
    }

    public boolean isDispatchable() {
        return this._$5;
    }

    public String getHost() {
        return this._$7;
    }

    public int getPort() {
        return this._$6;
    }

    public UnitClient clone() {
        UnitClient uc = new UnitClient(this._$7, this._$6);
        return uc;
    }

    public boolean equals(String nodeHost, int nodePort) {
        return this._$7.equalsIgnoreCase(nodeHost) && this._$6 == nodePort;
    }

    public boolean isReachable() {
        try {
            InetAddress address = InetAddress.getByName(this._$7);
            boolean isArrived = address.isReachable(2000);
            return isArrived;
        }
        catch (Exception x) {
            Logger.debug("Ping " + this._$7 + " failure.", x);
            return false;
        }
    }

    public boolean isAlive() {
        return this.isAlive(null);
    }

    public boolean isEqualToLocal() {
        if (this._$7 == null) {
            return true;
        }
        HostManager hostManager = HostManager.instance();
        return this._$7.equals(hostManager.getHost()) && this._$6 == hostManager.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(StringBuffer reason) {
        if (this.isEqualToLocal()) {
            return true;
        }
        SocketData sd = null;
        try {
            sd = this.newSocketData();
        }
        catch (Exception x) {
            if (reason != null) {
                if (!this.isReachable()) {
                    reason.append(this + " is not exist.\n");
                } else {
                    reason.append("UnitServer or UnitServerConsole is not started on " + this + "\n");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (sd != null) {
                try {
                    sd.clientClose();
                }
                catch (Exception x) {}
                sd = null;
            }
        }
        return true;
    }

    public void connect() throws Exception {
        if (!this.isEqualToLocal()) {
            this._$4 = this.newSocketData();
        }
    }

    public boolean isConnected() {
        return !this.isClosed() || this.isEqualToLocal();
    }

    public void write(Object obj) throws Exception {
        this._$4.write(obj);
    }

    public Object read() throws Exception {
        return this._$4.read();
    }

    public void setConnectTimeout(int timeout) {
        this._$3 = timeout;
    }

    public SocketData newSocketData() throws Exception {
        Socket s = new Socket();
        SocketData sd = new SocketData(s);
        InetSocketAddress isa = new InetSocketAddress(this._$7, this._$6);
        sd.connect(isa, this._$3);
        return sd;
    }

    public void cancel(Integer taskId, String reason) {
        Request req = new Request(10003);
        req.setAttr("Task id", taskId);
        req.setAttr("Task reason", reason);
        try {
            this.sendByNewSocket(req);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void shutDown() {
        Request req = new Request(1);
        try {
            this.sendByNewSocket(req);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getUnitMaxNum() {
        if (this.isEqualToLocal()) {
            return HostManager._$2;
        }
        Request req = new Request(50);
        try {
            Response res = this.send(req);
            return (Integer)res.getResult();
        }
        catch (Exception x) {
            throw new RQException(x);
        }
    }

    public Integer getAreaNo(String J) {
        Request req = new Request(54);
        req.setAttr("Task name", J);
        try {
            Response res = this.sendByNewSocket(req);
            return (Integer)res.getResult();
        }
        catch (Exception x) {
            throw new RQException(x);
        }
    }

    public Table getEnvParamList() {
        Request req = new Request(5);
        try {
            Response res = this.sendByNewSocket(req);
            if (res.getException() != null) {
                throw res.getException();
            }
            return (Table)res.getResult();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public Table getTaskList() {
        Request req = new Request(2);
        try {
            Response res = this.sendByNewSocket(req);
            if (res.getException() != null) {
                throw res.getException();
            }
            return (Table)res.getResult();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public void closeSpace(String spaceId) {
        if (!this.isAlive()) {
            return;
        }
        Request req = new Request(10);
        req.setAttr("Space id", spaceId);
        try {
            Response res = this.sendByNewSocket(req);
            if (res.getException() != null) {
                throw res.getException();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void initNode(int i, int N, String j) throws Exception {
        Logger.debug("Before init zone: " + i + " on " + this);
        Request req = new Request(50002);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(i);
        args.add(N);
        args.add(j);
        req.setAttr("Arg list", args);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        Logger.debug("Init zone: " + i + " on " + this + " OK.");
    }

    public int getMemoryTableLength(String spaceId, String table) throws Exception {
        Request req = new Request(22);
        req.setAttr("Space id", spaceId);
        req.setAttr("Table name", table);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Integer)res.getResult();
    }

    public Object getReduceResult(String spaceId) throws Exception {
        Request req = new Request(10004);
        req.setAttr("Space id", spaceId);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return res.getResult();
    }

    public int[] getTaskNums() throws Exception {
        if (this._$2 == null) {
            this._$2 = new Request(4);
        } else {
            this._$2.setAction(4);
        }
        Response res = this.send(this._$2);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (int[])res.getResult();
    }

    public static Sequence getMemoryTable(String spaceId, String tableName, String nodeDesc) throws Exception {
        JobSpace space = JobSpaceManager.getSpace(spaceId);
        Param param = space.getParam(tableName);
        if (param == null) {
            param = Env.getParam(tableName);
        }
        if (param == null) {
            throw new Exception("Table:" + tableName + " is not exist in space:" + spaceId + " or Env of machine:" + nodeDesc);
        }
        Sequence dimTable = (Sequence)param.getValue();
        if (dimTable == null) {
            throw new Exception("Table:" + tableName + " can not be null in space:" + spaceId + " or Env of machine:" + nodeDesc);
        }
        return dimTable;
    }

    public int getCurrentTasks() {
        Request req = new Request(6);
        try {
            Response res = this.sendByNewSocket(req);
            if (res.getException() != null) {
                throw res.getException();
            }
            return (Integer)res.getResult();
        }
        catch (Exception x) {
            throw new RQException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response sendByNewSocket(Request req) throws Exception {
        SocketData tmp = null;
        try {
            tmp = this.newSocketData();
            tmp.write(req);
            Response res = (Response)tmp.read();
            res.setFromHost(this.toString());
            Response response = res;
            return response;
        }
        finally {
            if (tmp != null) {
                tmp.clientClose();
            }
        }
    }

    public Response send(Request req) throws Exception {
        if (this._$4 == null) {
            this.connect();
        }
        this._$4.write(req);
        Response res = (Response)this._$4.read();
        res.setFromHost(this.toString());
        return res;
    }

    public Response send(UnitCommand command) {
        try {
            Request req = new Request(60001);
            req.setAttr("Command Object", command);
            Response res = this.sendByNewSocket(req);
            return res;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public boolean isClosed() {
        return this._$4 == null || this._$4.isClosed();
    }

    public void close() {
        if (this._$4 != null) {
            try {
                this._$4.clientClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._$4 = null;
        }
    }

    public static String parseHost(String hostDesc) {
        boolean isIp4 = hostDesc.indexOf(".") > 0;
        int colon = isIp4 ? hostDesc.indexOf(":") : hostDesc.lastIndexOf(":");
        if (colon < 0) {
            return null;
        }
        return hostDesc.substring(0, colon);
    }

    public static int parsePort(String hostDesc) {
        boolean isIp4 = hostDesc.indexOf(".") > 0;
        int colon = isIp4 ? hostDesc.indexOf(":") : hostDesc.lastIndexOf(":");
        if (colon < 0) {
            return -1;
        }
        int cPort = Integer.parseInt(hostDesc.substring(colon + 1));
        return cPort;
    }

    public String toString() {
        if (this._$7 == null) {
            return "Local";
        }
        if (this._$1 == null) {
            this._$1 = this._$7 + ":" + this._$6;
        }
        return this._$1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UnitClient)) {
            return false;
        }
        UnitClient otherUc = (UnitClient)other;
        if (otherUc.getHost() == null) {
            return this._$7 == null;
        }
        return otherUc.getHost().equalsIgnoreCase(this._$7) && otherUc.getPort() == this._$6;
    }

    public int JDBCConnect() throws Exception {
        Request req = new Request(70001);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Integer)res.getResult();
    }

    public Table JDBCGetTables(int connId, String tableNamePattern, boolean isPlus) throws Exception {
        Request req = new Request(70005);
        req.setAttr("getTables connId", connId);
        req.setAttr("tableNamePattern", tableNamePattern);
        req.setAttr("isplus", isPlus);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Table)res.getResult();
    }

    public Table JDBCGetColumns(int connId, String tableNamePattern, String columnNamePattern, boolean isPlus) throws Exception {
        Request req = new Request(70006);
        req.setAttr("getTableColumns connId", connId);
        req.setAttr("tableNamePattern", tableNamePattern);
        req.setAttr("columnNamePattern", columnNamePattern);
        req.setAttr("isplus", isPlus);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Table)res.getResult();
    }

    public Table JDBCGetProcedures(int connId, String procedureNamePattern, boolean isPlus) throws Exception {
        Request req = new Request(70007);
        req.setAttr("getProcedures connId", connId);
        req.setAttr("procedureNamePattern", procedureNamePattern);
        req.setAttr("isplus", isPlus);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Table)res.getResult();
    }

    public Table JDBCGetProcedureColumns(int connId, String procedureNamePattern, String columnNamePattern, boolean isPlus) throws Exception {
        Request req = new Request(70008);
        req.setAttr("getProcedureColumns connId", connId);
        req.setAttr("procedureNamePattern", procedureNamePattern);
        req.setAttr("procedureColumnNamePattern", columnNamePattern);
        req.setAttr("isplus", isPlus);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Table)res.getResult();
    }

    public Table JDBCGetSplParams(int connId, String procedureNamePattern, boolean isPlus) throws Exception {
        Request req = new Request(70009);
        req.setAttr("getProcedureColumns connId", connId);
        req.setAttr("splPath", procedureNamePattern);
        req.setAttr("isplus", isPlus);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Table)res.getResult();
    }

    public int JDBCPrepare(int connId, String cmd, Object[] args, Map<String, Object> envParams) throws Exception {
        Request req = new Request(70002);
        req.setAttr("prepare connId", connId);
        req.setAttr("prepare cmd", cmd);
        req.setAttr("prepare args", args);
        req.setAttr("prepare env", envParams);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Integer)res.getResult();
    }

    public Sequence JDBCExecute(int connId, int stateId) throws Exception {
        Request req = new Request(70003);
        req.setAttr("execute connId", connId);
        req.setAttr("execute stateId", stateId);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        Sequence results = (Sequence)res.getResult();
        return results;
    }

    public boolean JDBCCancel(int connId, int stateId) throws Exception {
        Request req = new Request(70004);
        req.setAttr("execute connId", connId);
        req.setAttr("execute stateId", stateId);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Boolean)res.getResult();
    }

    public boolean JDBCCloseStatement(int connId, int stateId) throws Exception {
        Request req = new Request(70011);
        req.setAttr("execute connId", connId);
        req.setAttr("execute stateId", stateId);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Boolean)res.getResult();
    }

    public boolean JDBCCloseConnection(int connId) throws Exception {
        Request req = new Request(70012);
        req.setAttr("execute connId", connId);
        Response res = this.sendByNewSocket(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return (Boolean)res.getResult();
    }

    public static String getHostPath(String host) {
        String path = host.replaceAll("::", ".");
        path = path.replaceAll(":", ".");
        return path;
    }
}

