/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.parallel;

import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.ConfigWriter;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.parallel.UnitContext;
import com.scudata.parallel.XmlUtil;
import com.scudata.resources.ParallelMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitConfig
extends ConfigWriter {
    private int _$10 = 12;
    private int _$9 = 12;
    private int _$8 = 1800;
    private int _$7 = 10;
    boolean _$6 = false;
    private List<Host> _$5 = null;
    private boolean _$4 = false;
    private List<String> _$3 = null;
    private List<String> _$2 = null;
    MessageManager _$1 = ParallelMessage.get();

    public void load(InputStream is) throws Exception {
        this.load(is, true);
    }

    public void load(byte[] buf) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        this.load(bais, true);
        bais.close();
    }

    public static Host getHost(List<Host> hosts, String ip, int port) {
        Host h = null;
        int size = hosts.size();
        for (int i = 0; i < size; ++i) {
            h = hosts.get(i);
            if (!h.getIp().equals(ip) || h.getPort() != port) continue;
            return h;
        }
        h = new Host(ip, port);
        hosts.add(h);
        return h;
    }

    public void load(InputStream is, boolean showDebug) throws Exception {
        int t;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase("Server")) continue;
            root = n;
        }
        if (root == null) {
            throw new Exception(this._$1.getMessage("UnitConfig.errorxml"));
        }
        String ver = XmlUtil.getAttribute(root, "Version");
        if (ver == null || Integer.parseInt(ver) < 3) {
            throw new RuntimeException(this._$1.getMessage("UnitConfig.updateversion", UnitContext.UNIT_XML));
        }
        Node subNode = XmlUtil.findSonNode(root, "tempTimeout");
        String buf = XmlUtil.getNodeValue(subNode);
        if (StringUtils.isValidString(buf)) {
            this._$10 = Integer.parseInt(buf);
            if (this._$10 > 0 && showDebug) {
                Logger.debug("Using TempTimeOut=" + this._$10 + " hour(s).");
            }
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(root, "interval"))) && (t = Integer.parseInt(buf)) > 0) {
            this._$8 = t;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(root, "backlog"))) && (t = Integer.parseInt(buf)) > 0) {
            this._$7 = t;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(root, "autostart")))) {
            this._$6 = new Boolean(buf);
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(root, "proxyTimeout")))) {
            this._$9 = Integer.parseInt(buf);
            if (this._$9 > 0 && showDebug) {
                Logger.debug("Using ProxyTimeOut=" + this._$9 + " hour(s).");
            }
        }
        Node nodeHosts = XmlUtil.findSonNode(root, "Hosts");
        NodeList hostsList = nodeHosts.getChildNodes();
        this._$5 = new ArrayList<Host>();
        for (int i = 0; i < hostsList.getLength(); ++i) {
            Node xmlNode = hostsList.item(i);
            if (!xmlNode.getNodeName().equalsIgnoreCase("Host")) continue;
            buf = XmlUtil.getAttribute(xmlNode, "ip");
            String sPort = XmlUtil.getAttribute(xmlNode, "port");
            Host host = new Host(buf, Integer.parseInt(sPort));
            buf = XmlUtil.getAttribute(xmlNode, "maxTaskNum");
            if (StringUtils.isValidString(buf)) {
                host.setMaxTaskNum(Integer.parseInt(buf));
            }
            if (StringUtils.isValidString(buf = XmlUtil.getAttribute(xmlNode, "preferredTaskNum"))) {
                host.setPreferredTaskNum(Integer.parseInt(buf));
            }
            this._$5.add(host);
        }
        Node nodeECs = XmlUtil.findSonNode(root, "EnabledClients");
        buf = XmlUtil.getAttribute(nodeECs, "check");
        if (StringUtils.isValidString(buf)) {
            this._$4 = new Boolean(buf);
        }
        NodeList ecList = nodeECs.getChildNodes();
        this._$3 = new ArrayList<String>();
        this._$2 = new ArrayList<String>();
        for (int i = 0; i < ecList.getLength(); ++i) {
            Node xmlNode = ecList.item(i);
            if (!xmlNode.getNodeName().equalsIgnoreCase("Host") || !StringUtils.isValidString(buf = XmlUtil.getAttribute(xmlNode, "start"))) continue;
            this._$3.add(buf);
            buf = XmlUtil.getAttribute(xmlNode, "end");
            this._$2.add(buf);
        }
    }

    public byte[] toFileBytes() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.save(baos);
        return baos.toByteArray();
    }

    public void save(OutputStream out) throws SAXException {
        int i;
        int size;
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        this.handler.startElement("", "", "SERVER", this.getAttributesImpl(new String[]{ConfigConsts.VERSION, "3"}));
        this.level = 1;
        this.writeAttribute("TempTimeOut", this._$10 + "");
        this.writeAttribute("Interval", this._$8 + "");
        this.writeAttribute("Backlog", this._$7 + "");
        this.writeAttribute("AutoStart", this._$6 + "");
        this.writeAttribute("ProxyTimeOut", this._$9 + "");
        this.startElement("Hosts", null);
        if (this._$5 != null) {
            size = this._$5.size();
            for (i = 0; i < size; ++i) {
                this.level = 2;
                Host h = this._$5.get(i);
                this.startElement("Host", this.getAttributesImpl(new String[]{"ip", h._$2, "port", h._$1 + "", "maxTaskNum", h._$3 + "", "preferredTaskNum", h._$4 + ""}));
                this.endElement("Host");
            }
            this.level = 1;
            this.endElement("Hosts");
        } else {
            this.endEmptyElement("Hosts");
        }
        this.level = 1;
        this.startElement("EnabledClients", this.getAttributesImpl(new String[]{"check", this._$4 + ""}));
        if (this._$3 != null) {
            this.level = 2;
            size = this._$3.size();
            for (i = 0; i < size; ++i) {
                String start = this._$3.get(i);
                String end = this._$2.get(i);
                this.startElement("Host", this.getAttributesImpl(new String[]{"start", start, "end", end}));
                this.endElement("Host");
            }
            this.level = 1;
            this.endElement("EnabledClients");
        } else {
            this.endEmptyElement("EnabledClients");
        }
        this.handler.endElement("", "", "SERVER");
        this.handler.endDocument();
    }

    public int getTempTimeOut() {
        return this._$10;
    }

    public int getTempTimeOutHour() {
        return this._$10;
    }

    public void setTempTimeOut(int tempTimeOut) {
        this._$10 = tempTimeOut;
    }

    public void setTempTimeOutHour(int tempTimeOutHour) {
        this._$10 = tempTimeOutHour;
    }

    public int getProxyTimeOut() {
        return this._$9;
    }

    public boolean isAutoStart() {
        return this._$6;
    }

    public void setAutoStart(boolean as) {
        this._$6 = as;
    }

    public int getProxyTimeOutHour() {
        return this._$9;
    }

    public void setProxyTimeOut(int proxyTimeOut) {
        this._$9 = proxyTimeOut;
    }

    public void setProxyTimeOutHour(int proxyTimeOutHour) {
        this._$9 = proxyTimeOutHour;
    }

    public int getInterval() {
        return this._$8;
    }

    public void setInterval(int interval) {
        this._$8 = interval;
    }

    public int getBacklog() {
        return this._$7;
    }

    public void setBacklog(int backlog) {
        this._$7 = backlog;
    }

    public List<Host> getHosts() {
        return this._$5;
    }

    public void setHosts(List<Host> hosts) {
        this._$5 = hosts;
    }

    public boolean isCheckClients() {
        return this._$4;
    }

    public void setCheckClients(boolean b) {
        this._$4 = b;
    }

    public List<String> getEnabledClientsStart() {
        return this._$3;
    }

    public void setEnabledClientsStart(List<String> enHosts) {
        this._$3 = enHosts;
    }

    public List<String> getEnabledClientsEnd() {
        return this._$2;
    }

    public void setEnabledClientsEnd(List<String> enHosts) {
        this._$2 = enHosts;
    }

    public static class Host {
        int _$4 = Runtime.getRuntime().availableProcessors();
        int _$3 = this._$4 * 2;
        String _$2;
        int _$1;

        public Host(String ip, int port) {
            this._$2 = ip;
            this._$1 = port;
        }

        public String getIp() {
            return this._$2;
        }

        public int getPort() {
            return this._$1;
        }

        public int getMaxTaskNum() {
            return this._$3;
        }

        public void setMaxTaskNum(int max) {
            this._$3 = max;
        }

        public int getPreferredTaskNum() {
            return this._$4;
        }

        public void setPreferredTaskNum(int num) {
            this._$4 = num;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._$2);
            sb.append(":[");
            sb.append(this._$1);
            sb.append("]");
            return sb.toString();
        }
    }
}

