/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server;

import com.scudata.common.Logger;
import java.util.ArrayList;

public abstract class IProxy {
    int _$3 = -1;
    IProxy _$2 = null;
    public ArrayList<IProxy> subProxies = null;
    long _$1 = -1L;

    public IProxy(IProxy parent, int id) {
        this._$2 = parent;
        this._$3 = id;
    }

    public void access() {
        this._$1 = System.currentTimeMillis();
        if (this._$2 != null) {
            this._$2.access();
        }
    }

    public void resetAccess() {
        this._$1 = -1L;
    }

    public synchronized void destroy() {
        if (this.subProxies != null) {
            for (int i = 0; i < this.subProxies.size(); ++i) {
                IProxy p = this.subProxies.get(i);
                p.destroy();
            }
            this.subProxies.clear();
        }
        this.close();
        if (this._$2 != null) {
            this._$2.removeProxy(this);
        }
    }

    public synchronized void addProxy(IProxy proxy) {
        if (this.subProxies == null) {
            this.subProxies = new ArrayList();
        }
        this.subProxies.add(proxy);
    }

    public synchronized void removeProxy(IProxy proxy) {
        if (this.subProxies != null) {
            this.subProxies.remove(proxy);
        }
    }

    public synchronized IProxy getProxy(int id) {
        if (this.subProxies == null) {
            return null;
        }
        for (int i = 0; i < this.subProxies.size(); ++i) {
            IProxy sub = this.subProxies.get(i);
            if (sub.getId() != id) continue;
            return sub;
        }
        return null;
    }

    public boolean checkTimeOut(int timeOut) {
        if (this.subProxies != null) {
            for (int i = 0; i < this.subProxies.size(); ++i) {
                try {
                    IProxy sub = this.subProxies.get(i);
                    sub.checkTimeOut(timeOut);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this._$1 < 0L) {
            return false;
        }
        long unvisit = (System.currentTimeMillis() - this._$1) / 1000L;
        if (unvisit > (long)timeOut) {
            Logger.debug(this + " is timeout.");
            this.destroy();
            return true;
        }
        return false;
    }

    public int getId() {
        return this._$3;
    }

    public IProxy getParent() {
        return this._$2;
    }

    public synchronized int size() {
        if (this.subProxies == null) {
            return 0;
        }
        return this.subProxies.size();
    }

    public abstract void close();

    public abstract String toString();
}

