/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.scudata.app.config.ConfigConsts;
import com.scudata.app.config.ConfigWriter;
import com.scudata.common.ScudataLogger;
import com.scudata.common.StringUtils;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitContext;
import com.scudata.parallel.XmlUtil;
import com.scudata.resources.ParallelMessage;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.unit.UnitServer;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdbcContext
extends ConfigWriter {
    public static final String ODBC_CONFIG_FILE = "OdbcServer.xml";
    private String _$8 = UnitContext.getDefaultHost();
    private int _$7 = 8501;
    private int _$6 = 2;
    private int _$5 = 10;
    private int _$4 = 2;
    private int _$3 = 5;
    private boolean _$2 = false;
    private List<User> _$1 = null;

    public OdbcContext() {
        try {
            InputStream inputStream = UnitContext.getUnitInputStream(ODBC_CONFIG_FILE);
            if (inputStream != null) {
                this.load(inputStream);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void load(InputStream is) throws Exception {
        int t;
        Node conNode;
        Node subNode;
        String file;
        String home;
        File f;
        File fp;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase("Server")) continue;
            root = n;
        }
        if (root == null) {
            throw new Exception(ParallelMessage.get().getMessage("UnitConfig.errorxml"));
        }
        String buf = XmlUtil.getAttribute(root, "host");
        if (StringUtils.isValidString(buf)) {
            this._$8 = buf;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getAttribute(root, "port"))) {
            this._$7 = Integer.parseInt(buf);
        }
        if (StringUtils.isValidString(buf = XmlUtil.getAttribute(root, "autostart"))) {
            this._$2 = Boolean.parseBoolean(buf);
        }
        if (!(fp = (f = new File(home = UnitServer.getHome(), file = "odbc/" + UnitClient.getHostPath(this._$8) + "_" + this._$7 + "/log/log.txt")).getParentFile()).exists()) {
            fp.mkdirs();
        }
        String logFile = f.getAbsolutePath();
        ScudataLogger.FileHandler lfh = ScudataLogger.newFileHandler(logFile);
        ScudataLogger.addFileHandler(lfh);
        buf = XmlUtil.getAttribute(root, "timeout");
        if (StringUtils.isValidString(buf)) {
            this._$6 = Integer.parseInt(buf);
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(conNode = XmlUtil.findSonNode(root, "Connection"), "Max"))) && (t = Integer.parseInt(buf)) > 0) {
            this._$5 = t;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(conNode, "Timeout"))) && (t = Integer.parseInt(buf)) > 0) {
            this._$4 = t;
        }
        if (StringUtils.isValidString(buf = XmlUtil.getNodeValue(subNode = XmlUtil.findSonNode(conNode, "Period"))) && (t = Integer.parseInt(buf)) > 0) {
            this._$3 = t;
        }
        Node usersNode = XmlUtil.findSonNode(root, "Users");
        NodeList userList = usersNode.getChildNodes();
        this._$1 = new ArrayList<User>();
        int size = userList.getLength();
        for (int i = 0; i < size; ++i) {
            Node xmlNode = userList.item(i);
            if (!xmlNode.getNodeName().equalsIgnoreCase("User")) continue;
            User user = new User();
            buf = XmlUtil.getAttribute(xmlNode, "name");
            user._$3 = buf;
            buf = XmlUtil.getAttribute(xmlNode, "password");
            user._$2 = buf;
            buf = XmlUtil.getAttribute(xmlNode, "admin");
            if (StringUtils.isValidString(buf)) {
                user._$1 = Boolean.parseBoolean(buf);
            }
            this._$1.add(user);
        }
    }

    public void save(OutputStream out) throws SAXException {
        StreamResult resultxml = new StreamResult(out);
        this.handler.setResult(resultxml);
        this.level = 0;
        this.handler.startDocument();
        this.handler.startElement("", "", "Server", this.getAttributesImpl(new String[]{ConfigConsts.VERSION, "1", "host", this._$8, "port", this._$7 + "", "autostart", this._$2 + "", "timeout", this._$6 + ""}));
        this.level = 1;
        this.startElement("Connection", null);
        this.level = 2;
        this.writeAttribute("Max", this._$5 + "");
        this.writeAttribute("Timeout", this._$4 + "");
        this.writeAttribute("Period", this._$3 + "");
        this.level = 1;
        this.endElement("Connection");
        this.startElement("Users", null);
        if (this._$1 != null) {
            int size = this._$1.size();
            for (int i = 0; i < size; ++i) {
                this.level = 2;
                User u = this._$1.get(i);
                this.startElement("User", this.getAttributesImpl(new String[]{"name", u._$3, "password", u._$2, "admin", u._$1 + ""}));
                this.endElement("User");
            }
            this.level = 1;
            this.endElement("Users");
        } else {
            this.endEmptyElement("Users");
        }
        this.handler.endElement("", "", "Server");
        this.handler.endDocument();
    }

    public String getHost() {
        return this._$8;
    }

    public int getPort() {
        return this._$7;
    }

    public void setHost(String host) {
        this._$8 = host;
    }

    public void setPort(int port) {
        this._$7 = port;
    }

    public void setAutoStart(boolean as) {
        this._$2 = as;
    }

    public boolean isAutoStart() {
        return this._$2;
    }

    public int getTimeOut() {
        return this._$6;
    }

    public void setTimeOut(int timeout) {
        this._$6 = timeout;
    }

    public int getConMax() {
        return this._$5;
    }

    public void setConMax(int max) {
        this._$5 = max;
    }

    public int getConTimeOut() {
        return this._$4;
    }

    public void setConTimeOut(int cto) {
        this._$4 = cto;
    }

    public int getConPeriod() {
        return this._$3;
    }

    public void setConPeriod(int period) {
        this._$3 = period;
    }

    public List<User> getUserList() {
        return this._$1;
    }

    public void setUserList(List<User> users) {
        this._$1 = users;
    }

    public String toString() {
        return this._$8 + ":" + this._$7;
    }

    public boolean isUserExist(String user) {
        if (this._$1 == null) {
            return true;
        }
        for (User u : this._$1) {
            if (!u.getName().equalsIgnoreCase(user)) continue;
            return true;
        }
        return false;
    }

    public boolean checkUser(String user, String password) throws Exception {
        ConnectionProxyManager cpm = ConnectionProxyManager.getInstance();
        if (cpm.size() >= this._$5) {
            throw new Exception("Exceed server's max connections, login user:" + user);
        }
        int size = this._$1.size();
        for (int i = 0; i < size; ++i) {
            User u = this._$1.get(i);
            if (!u.getName().equalsIgnoreCase(user)) continue;
            if (u.getPassword().equals(password)) {
                return true;
            }
            throw new Exception("Invalid password.");
        }
        throw new Exception("Invalid user name.");
    }

    public static class User {
        private String _$3 = null;
        private String _$2 = null;
        private boolean _$1 = false;

        public String getName() {
            return this._$3;
        }

        public void setName(String name) {
            this._$3 = name;
        }

        public String getPassword() {
            return this._$2;
        }

        public void setPassword(String password) {
            this._$2 = password;
        }

        public boolean isAdmin() {
            return this._$1;
        }

        public void setAdmin(boolean admin) {
            this._$1 = admin;
        }
    }
}

