/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.odbc;

import com.esproc.jdbc.JDBCUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.dm.Table;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.odbc.ConnectionProxy;
import com.scudata.server.odbc.DataTypes;
import com.scudata.server.odbc.OdbcServer;
import com.scudata.server.odbc.StatementProxy;
import com.scudata.util.CellSetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

class OdbcWorker
extends Thread {
    static final int Buffer_Size = 65536;
    private Socket sckt;
    private volatile boolean stop = false;
    OutputStream out;
    InputStream in;

    public OdbcWorker(ThreadGroup tg, String name) {
        super(tg, name);
    }

    public void setSocket(Socket socket) throws Exception {
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(65536);
        socket.setSendBufferSize(65536);
        socket.setSoLinger(true, 1);
        socket.setReuseAddress(true);
        socket.setSoTimeout(3000);
        this.sckt = socket;
        this.holdBufferStream();
    }

    private void holdBufferStream() throws IOException {
        OutputStream os = this.sckt.getOutputStream();
        this.out = new BufferedOutputStream(os);
        this.out.flush();
        InputStream is = this.sckt.getInputStream();
        this.in = new BufferedInputStream(is);
    }

    private void writeOdbcResponse(OutputStream os, int code, String returnMsg) throws Exception {
        DataTypes.writeInt(os, code);
        if (returnMsg == null) {
            return;
        }
        if (code < 0) {
            DataTypes.writeString(os, returnMsg);
        }
    }

    private ConnectionProxy getConnectionProxy(ConnectionProxyManager cpm, int connId) throws Exception {
        return (ConnectionProxy)cpm.getConnectionProxy(connId);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean serveODBC(int reqType, InputStream is, OutputStream os) {
        try {
            server = OdbcServer.getInstance();
            context = server.getContext();
            cpm = ConnectionProxyManager.getInstance();
            switch (reqType) {
                case 1000: {
                    user = DataTypes.readString(is);
                    password = DataTypes.readString(is);
                    if (!context.isUserExist(user)) {
                        this.writeOdbcResponse(os, -1, "Login error: invalid user " + user);
                        return true;
                    }
                    try {
                        success = context.checkUser(user, password);
                        if (success == false) return true;
                        connId = OdbcServer.nextId();
                        connProxy = new ConnectionProxy(cpm, connId, user);
                        cpm.addProxy(connProxy);
                        this.writeOdbcResponse(os, connId, "Login OK, current odbc user: " + user);
                        System.setProperty("_userName", user);
                        return true;
                    }
                    catch (Exception x) {
                        this.writeOdbcResponse(os, -1, x.getMessage());
                        return true;
                    }
                }
                case 1001: {
                    connId = DataTypes.readInt(is);
                    dfx = DataTypes.readString(is);
                    args = DataTypes.readRowData(is);
                    argList = new ArrayList<Object>();
                    if (args != null) {
                        i = 0;
                        while (i < args.length) {
                            argList.add(args[i]);
                            ++i;
                        }
                    }
                    connProxy = this.getConnectionProxy(cpm, connId);
                    stateId = OdbcServer.nextId();
                    sp = new StatementProxy(connProxy, stateId, dfx, argList);
                    connProxy.addProxy(sp);
                    this.writeOdbcResponse(os, stateId, null);
                    return true;
                }
                case 1002: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    resultIds = sp.execute();
                    DataTypes.writeInt(os, resultIds.length);
                    i = 0;
                    while (true) {
                        if (i >= resultIds.length) {
                            this.doTracer("odbc", sp);
                            return true;
                        }
                        DataTypes.writeInt(os, resultIds[i]);
                        ++i;
                    }
                }
                case 1003: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    sp.cancel();
                    DataTypes.writeInt(os, 0);
                    return true;
                }
                case 1010: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    resultId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    rsp = sp.getResultSetProxy(resultId);
                    columns = rsp.getColumns();
                    if (columns == null) {
                        DataTypes.writeInt(os, 0);
                        return true;
                    }
                    size = columns.length;
                    DataTypes.writeInt(os, size);
                    i = 0;
                    while (true) {
                        if (i >= size) {
                            return true;
                        }
                        DataTypes.writeString(os, columns[i]);
                        ++i;
                    }
                }
                case 1011: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    resultId = DataTypes.readInt(is);
                    n = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    rsp = sp.getResultSetProxy(resultId);
                    data = rsp.fetch(n);
                    DataTypes.checkTable(data);
                    DataTypes.writeInt(os, 0);
                    DataTypes.writeTable(os, data);
                    return true;
                }
                case 1012: {
                    properties = DataTypes.readString(is);
                    DataTypes.writeInt(os, 0);
                    return true;
                }
                case 1018: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    sp.destroy();
                    this.writeOdbcResponse(os, 0, "Statement:" + stateId + " is closed.");
                    return true;
                }
                case 1020: {
                    connId = DataTypes.readInt(is);
                    stateId = DataTypes.readInt(is);
                    resultId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    sp = connProxy.getStatementProxy(stateId);
                    rsp = sp.getResultSetProxy(resultId);
                    rsp.destroy();
                    this.writeOdbcResponse(os, 0, "ResultSet:" + resultId + " is closed.");
                    return true;
                }
                case 1050: {
                    connId = DataTypes.readInt(is);
                    filter = DataTypes.readString(is);
                    m = JDBCUtil.getSplList(filter);
                    spCols = "PROCEDURE_CAT,PROCEDURE_SCHEM,PROCEDURE_NAME,NUM_INPUT_PARAMS,NUM_OUTPUT_PARAMS,NUM_RESULT_SETS,REMARKS,PROCEDURE_TYPE";
                    st = new StringTokenizer(spCols, ",");
                    cols = new ArrayList<String>();
                    while (true) {
                        if (st.hasMoreTokens()) ** GOTO lbl134
                        storeInfos = new Table(StringUtils.toStringArray(cols));
                        files = m.keySet().iterator();
                        ** GOTO lbl164
lbl134:
                        // 1 sources

                        name = st.nextToken();
                        cols.add(name);
                    }
                }
                case 1060: {
                    connId = DataTypes.readInt(is);
                    tableName = DataTypes.readString(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    table = JDBCUtil.getTables(tableName);
                    DataTypes.writeDatastructAndData(os, table);
                    return true;
                }
                case 1061: {
                    connId = DataTypes.readInt(is);
                    tableName = DataTypes.readString(is);
                    columnName = DataTypes.readString(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    table = JDBCUtil.getColumns(tableName, columnName, new Context());
                    DataTypes.writeDatastructAndData(os, table);
                    return true;
                }
                case 1111: {
                    connId = DataTypes.readInt(is);
                    connProxy = this.getConnectionProxy(cpm, connId);
                    this.writeOdbcResponse(os, 0, null);
                    os.flush();
                    connProxy.destroy();
                    return false;
                }
                case 2222: {
                    return false;
                }
                default: {
                    return true;
lbl164:
                    // 1 sources

                    if (true) ** GOTO lbl174
                }
            }
        }
        catch (Throwable x) {
            msg = x.getMessage();
            if (true) ** GOTO lbl181
        }
        do {
            path = files.next();
            dfxName = m.get(path);
            paramCount = this.getParamCount(path);
            storeInfos.newLast(new Object[]{"", "", dfxName, paramCount, -1, -1, "", 2});
lbl174:
            // 2 sources

        } while (files.hasNext());
        DataTypes.writeInt(os, 0);
        DataTypes.writeTable(os, storeInfos);
        return true;
        do {
            x = x.getCause();
            msg = x.getMessage();
lbl181:
            // 2 sources

        } while (msg == null && x.getCause() != null);
        try {
            this.writeOdbcResponse(os, -1, msg);
        }
        catch (Exception var6_10) {
            // empty catch block
        }
        x.printStackTrace();
        Logger.debug("Service exception:" + msg);
        return true;
    }

    private int getParamCount(String dfx) throws Exception {
        int c = -1;
        try (FileInputStream in = null;){
            in = new FileInputStream(dfx);
            PgmCellSet cs = CellSetUtil.readPgmCellSet(in);
            ParamList pl = cs.getParamList();
            if (pl != null) {
                c = pl.count();
            }
        }
        return c;
    }

    public void shutDown() {
        this.stop = true;
    }

    @Override
    public void run() {
        try {
            InputStream is = this.in;
            OutputStream os = this.out;
            while (!this.stop) {
                int reqType = 0;
                try {
                    reqType = DataTypes.readInt(is);
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                if (reqType == -1) {
                    OdbcServer.getInstance().shutDown();
                    return;
                }
                if (reqType != -2 && reqType > 0 && this.serveODBC(reqType, is, os)) {
                    os.flush();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.in.close();
            this.out.close();
            this.sckt.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doTracer(String typeName, StatementProxy sp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cmd", sp.getCmd());
        map.put("id", sp.getId());
        map.put("size", sp.size());
        map.put("params", sp.getParams().toString());
        String user = System.getProperty("_userName");
        if (user != null) {
            map.put("userName", user);
            System.clearProperty("_userName");
        }
        this.collectData(typeName, map);
    }

    public void collectData(String typeName, Map<String, Object> map) {
    }
}

