/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.unit;

import com.scudata.app.common.AppUtil;
import com.scudata.app.common.Section;
import com.scudata.common.StringUtils;
import com.scudata.parallel.UnitClient;
import com.scudata.parallel.UnitContext;
import java.util.ArrayList;

public class ShutdownUnitServer {
    static String[] _$1 = AppUtil.getLocalIps();

    public static boolean autoClose() throws Exception {
        String home = System.getProperty("start.home");
        if (!StringUtils.isValidString(home)) {
            throw new Exception("start.home is not specified!");
        }
        ArrayList<UnitContext.UnitInfo> hosts = UnitContext.listNodes();
        if (hosts == null || hosts.isEmpty()) {
            System.out.println("No node server found under: " + home);
            return false;
        }
        for (int i = 0; i < hosts.size(); ++i) {
            int port;
            UnitContext.UnitInfo ui = (UnitContext.UnitInfo)hosts.get(i);
            String host = ui.getHost();
            if (AppUtil.isLocalIP(host) && !ShutdownUnitServer.close(host, port = ui.getPort())) continue;
        }
        return true;
    }

    public static boolean close(String host, int port) {
        UnitClient uc;
        if (!StringUtils.isValidString(host)) {
            host = UnitContext.getDefaultHost();
        }
        if ((uc = new UnitClient(host, port)).isAlive()) {
            uc.shutDown();
            System.out.println(uc + " is shut downed.");
            return true;
        }
        System.out.println(uc + " is not alive.");
        return false;
    }

    public static void main(String[] args) {
        String arg;
        String host = null;
        int port = 0;
        if (args.length == 1 && (arg = args[0].trim()).trim().indexOf(" ") > 0) {
            Section st = new Section(arg, ' ');
            args = st.toStringArray();
        }
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i].toLowerCase();
                if (arg.equals("com.scudata.server.unit.shutdownunitserver")) continue;
                if (host == null) {
                    host = arg;
                    continue;
                }
                if (port != 0) break;
                port = Integer.parseInt(arg);
            }
        }
        try {
            if (host == null) {
                ShutdownUnitServer.autoClose();
                Thread.sleep(3000L);
            } else if (!ShutdownUnitServer.close(host, port)) {
                System.out.println(host + ":" + port + " does not on running.");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.exit(0);
    }
}

