/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.unit;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.parallel.ITask;
import com.scudata.parallel.RemoteCursor;
import com.scudata.parallel.RemoteCursorProxy;
import com.scudata.parallel.RemoteCursorProxyManager;
import com.scudata.parallel.TaskManager;
import com.scudata.parallel.UnitContext;
import com.scudata.server.IProxy;
import com.scudata.server.unit.ConnectionProxy;
import com.scudata.server.unit.JdbcTask;
import com.scudata.server.unit.UnitServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProxy
extends IProxy
implements ITask {
    String _$9;
    String _$8 = null;
    ArrayList _$7 = null;
    JdbcTask _$6 = null;
    Context _$5;
    RemoteCursorProxyManager _$4 = null;

    public StatementProxy(ConnectionProxy cp, int id, String cmd, ArrayList<Object> params, Map<String, Object> envParams) throws Exception {
        super(cp, id);
        this._$8 = cmd;
        if (!StringUtils.isValidString(cmd)) {
            throw new Exception("Prepare statement cmd is empty!");
        }
        Logger.debug("StatementProxy cmd:\r\n" + cmd);
        this._$7 = params;
        this._$5 = new Context(cp.getContext());
        this._$9 = cp.getSpaceId();
        this._$6 = new JdbcTask(cmd, params, this._$5, envParams);
        this.access();
    }

    public ConnectionProxy getConnectionProxy() {
        return (ConnectionProxy)this.getParent();
    }

    public String getCmd() {
        return this._$8;
    }

    public List<String> getParams() {
        return this._$7;
    }

    @Override
    public RemoteCursorProxyManager getCursorManager() {
        if (this._$4 == null) {
            this._$4 = new RemoteCursorProxyManager(this);
        }
        return this._$4;
    }

    public Sequence execute() throws Exception {
        Sequence seq = this._$6.execute();
        if (seq == null) {
            return null;
        }
        Sequence results = new Sequence();
        UnitServer server = UnitServer.instance;
        UnitContext uc = server.getUnitContext();
        for (int i = 1; i <= seq.length(); ++i) {
            Object tmp = seq.get(i);
            if (tmp instanceof ICursor) {
                int proxyId = UnitServer.nextId();
                this._$4 = this.getCursorManager();
                RemoteCursorProxy rcp = new RemoteCursorProxy(this._$4, (ICursor)tmp, proxyId);
                this._$4.addProxy(rcp);
                RemoteCursor rc = new RemoteCursor(uc.getLocalHost(), uc.getLocalPort(), this.getId(), proxyId);
                this._$5.addResource(rc);
                results.add(rc);
                continue;
            }
            results.add(tmp);
        }
        return results;
    }

    public boolean cancel() throws Exception {
        this._$6.cancel();
        return true;
    }

    @Override
    public void close() {
        JobSpaceManager.getSpace(this._$9).closeResource();
        TaskManager.delTask(this.getId());
        this._$5 = null;
    }

    @Override
    public String toString() {
        return "Statement " + this.getId();
    }

    @Override
    public int getTaskID() {
        return this.getId();
    }
}

